/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game;

import dk.progressivemedia.rflib.graphics.PMFont;
import dk.progressivemedia.rflib.graphics.PMImageManager;
import dk.progressivemedia.rflib.platform.PMCanvas;
import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.rflib.util.PMText;
import dk.progressivemedia.skeleton.ButtonPulser;
import dk.progressivemedia.skeleton.Dialog;
import dk.progressivemedia.skeleton.InputProxy;
import dk.progressivemedia.skeleton.MusicBuffer;
import dk.progressivemedia.skeleton.SoundBuffer;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.Touch;
import dk.progressivemedia.skeleton.game.StateGame;
import dk.progressivemedia.skeleton.math.Interpolator;
import dk.progressivemedia.skeleton.math.InterpolatorLinear;
import dk.progressivemedia.skeleton.math.InterpolatorSpring;
import dk.progressivemedia.skeleton.math.TouchInertia;

public class PauseMenu {
    private static final int BOX_SIZE_X = 0x430000;
    private static final int BOX_SIZE_Y = 0x4C0000;
    private static final int BOX_SIZE_HELP_X = 0x5E0000;
    private static final int BOX_SIZE_HELP_Y = 0x4D0000;
    private static final int NUM_BUTTONS = 5;
    private static final int NUM_BUTTONS_HELP = 1;
    private static final int PRESSED_OFFSET = 2;
    private static final int STATE_ENTERING = 0;
    private static final int STATE_OPEN = 1;
    private static final int STATE_ENTERING_HELP = 2;
    private static final int STATE_HELP = 3;
    private static final int STATE_EXITING_HELP = 4;
    private static final int STATE_EXITING = 5;
    private static int mState;
    private static final int CLOSE_ACTION_RESUME = 0;
    private static final int CLOSE_ACTION_RESET = 1;
    private static final int CLOSE_ACTION_EXIT = 2;
    private static int mCloseAction;
    private static String[] mText;
    private static String mTextMusicOn;
    private static String mTextMusicOff;
    private static int[] mPositionX;
    private static int[] mPositionY;
    private static int[] mTextWidths;
    private static int[] mButtonWidths;
    private static int mBoxExitTarget;
    private static int mBoxEnterTarget;
    private static int[] mButtonExitTarget;
    private static int[] mButtonEnterTarget;
    private static InterpolatorLinear mBoxLinear;
    private static InterpolatorSpring mBoxSpring;
    private static Interpolator mBoxInterp;
    private static InterpolatorLinear[] mButtonLinear;
    private static InterpolatorSpring[] mButtonSprings;
    private static int[] mEnterTimer;
    private static int mButtonSpacing;
    private static InterpolatorSpring mBoxSizeSpring;
    private static String mHelpText;
    private static int mHelpTextHeight;
    private static TouchInertia mTextScroller;
    private static final int BUTTON_RESUME = 0;
    private static final int BUTTON_RESTART = 1;
    private static final int BUTTON_MUSIC_TOGGLE = 2;
    private static final int BUTTON_HELP = 3;
    private static final int BUTTON_EXIT = 4;
    private static final int BUTTON_BACK = 0;
    private static boolean[] mButtonDown;
    private static boolean[] mButtonDownHelp;
    private static int mSelectedButton;
    private static ButtonPulser mButtonPulser;
    private static int[] button9patch;
    private static int[] button9patchSelected;

    public static void init() {
        mTextMusicOff = PMText.getText(65538);
        mTextMusicOn = PMText.getText(65537);
        PauseMenu.mText[0] = PMText.getText(65536);
        PauseMenu.mText[1] = PMText.getText(65540);
        PauseMenu.mText[2] = MusicBuffer.isMuted() ? mTextMusicOn : mTextMusicOff;
        PauseMenu.mText[3] = PMText.getText(65539);
        PauseMenu.mText[4] = PMText.getText(65541);
        mHelpText = PMText.getText(65542);
        mButtonSpacing = 12;
        PauseMenu.setupButtons();
        mBoxEnterTarget = 0xA00000;
        mBoxExitTarget = -4390912;
        for (int i = 0; i < 5; ++i) {
            PauseMenu.mButtonDown[i] = false;
            PauseMenu.mButtonLinear[i] = new InterpolatorLinear();
            PauseMenu.mButtonSprings[i] = new InterpolatorSpring();
            PauseMenu.mButtonEnterTarget[i] = mPositionX[i] << 16;
            PauseMenu.mButtonExitTarget[i] = -(mButtonWidths[i] << 16);
        }
        mBoxSizeSpring.set(0x430000, 0x4C0000, 0x430000, 0x4C0000);
        int[] nArray = PMFont.stringBoxLines(94, mHelpText, 1);
        mHelpTextHeight = nArray.length * 12;
        mTextScroller = new TouchInertia(mHelpTextHeight + 24 - 77 << 16);
        mSelectedButton = 0;
    }

    public static void openMenu(boolean bl) {
        mState = 0;
        mBoxInterp = mBoxSpring;
        mBoxInterp.set(mBoxExitTarget, 0x780000, mBoxEnterTarget, 0x780000);
        for (int i = 0; i < 5; ++i) {
            mButtonSprings[i].set(mButtonExitTarget[i], mPositionY[i] << 16, mButtonEnterTarget[i], mPositionY[i] << 16);
            PauseMenu.mEnterTimer[i] = (i + 1) * 100;
        }
        SoundBuffer.play(3, 200);
        mButtonPulser.reset();
        mSelectedButton = 0;
        MusicBuffer.setVolume(0);
    }

    public static void closeMenu() {
        if (mState == 1) {
            mState = 5;
            mBoxInterp = mBoxLinear;
            mBoxInterp.set(mBoxEnterTarget, 0x780000, mBoxExitTarget, 0x780000);
            for (int i = 0; i < 5; ++i) {
                mButtonLinear[i].set(mButtonEnterTarget[i], mPositionY[i] << 16, mButtonExitTarget[i], mPositionY[i] << 16);
                PauseMenu.mEnterTimer[i] = 0;
            }
            SoundBuffer.play(3, 200);
        }
    }

    public static boolean update() {
        block0 : switch (mState) {
            case 0: {
                mBoxInterp.update(Timer.mDt);
                boolean bl = true;
                for (int i = 0; i < 5; ++i) {
                    if (mEnterTimer[i] <= 0) {
                        mButtonSprings[i].update(Timer.mDt);
                        if (mButtonSprings[i].isDone()) continue;
                        bl = false;
                        continue;
                    }
                    int n = i;
                    mEnterTimer[n] = mEnterTimer[n] - Timer.mDt;
                    bl = false;
                }
                if (!mBoxInterp.isDone() || !bl) break;
                mState = 1;
                break;
            }
            case 1: {
                int n;
                if (Dialog.isActive()) break;
                mButtonPulser.update(Timer.mDt);
                for (n = 0; n < 5; ++n) {
                    PauseMenu.mButtonDown[n] = mSelectedButton == n && (InputProxy.isHeldFire() || InputProxy.isHeldOK());
                }
                n = 0;
                boolean bl = false;
                boolean bl2 = false;
                if (InputProxy.isReleasedFire() || InputProxy.isReleasedOK()) {
                    SoundBuffer.play(18, 500);
                    switch (mSelectedButton) {
                        case 0: {
                            mCloseAction = 0;
                            n = 1;
                            break;
                        }
                        case 1: {
                            mCloseAction = 1;
                            n = 1;
                            break;
                        }
                        case 2: {
                            bl = true;
                            break;
                        }
                        case 3: {
                            bl2 = true;
                            break;
                        }
                        case 4: {
                            mCloseAction = 2;
                            n = 1;
                        }
                    }
                } else if (InputProxy.isPressedUp()) {
                    if (--mSelectedButton < 0) {
                        mSelectedButton = 4;
                    }
                    mButtonPulser.reset();
                } else if (InputProxy.isPressedDown()) {
                    if (++mSelectedButton >= 5) {
                        mSelectedButton = 0;
                    }
                    mButtonPulser.reset();
                }
                if (n != 0) {
                    PauseMenu.closeMenu();
                    break;
                }
                if (bl) {
                    if (MusicBuffer.isMuted()) {
                        PauseMenu.mText[2] = mTextMusicOff;
                        MusicBuffer.setMuted(false);
                    } else {
                        PauseMenu.mText[2] = mTextMusicOn;
                        MusicBuffer.setMuted(true);
                    }
                    PauseMenu.setupButtons();
                    break;
                }
                if (!bl2) break;
                mState = 2;
                mBoxSizeSpring.set(0x430000, 0x4C0000, 0x5E0000, 0x4D0000);
                break;
            }
            case 2: {
                mBoxSizeSpring.update(Timer.mDt);
                if (!mBoxSizeSpring.isDone()) break;
                mHelpText = PMText.getText(65542);
                mState = 3;
                mSelectedButton = 0;
                mTextScroller.reset();
                break;
            }
            case 3: {
                int n;
                mTextScroller.update(Timer.mDt);
                for (n = 0; n < 1; ++n) {
                    PauseMenu.mButtonDownHelp[n] = Touch.isDown(n) || mSelectedButton == n && (InputProxy.isHeldFire() || InputProxy.isHeldOK());
                }
                mButtonPulser.update(Timer.mDt);
                n = 0;
                if (InputProxy.isReleasedCancel() || InputProxy.isReleasedOK() || InputProxy.isReleasedFire() || InputProxy.isReleasedBack() || InputProxy.isReleasedFire2()) {
                    SoundBuffer.play(18, 500);
                    switch (mSelectedButton) {
                        case 0: {
                            n = 1;
                        }
                    }
                } else if (InputProxy.isHeldDown()) {
                    mTextScroller.applyMovement(false);
                } else if (InputProxy.isHeldUp()) {
                    mTextScroller.applyMovement(true);
                }
                if (n == 0) break;
                mState = 4;
                mBoxSizeSpring.set(0x5E0000, 0x4D0000, 0x430000, 0x4C0000);
                break;
            }
            case 4: {
                mBoxSizeSpring.update(Timer.mDt);
                if (!mBoxSizeSpring.isDone()) break;
                mState = 1;
                mSelectedButton = 3;
                break;
            }
            case 5: {
                mBoxInterp.update(Timer.mDt);
                boolean bl = true;
                for (int i = 0; i < 5; ++i) {
                    if (mEnterTimer[i] <= 0) {
                        mButtonLinear[i].update(Timer.mDt);
                        if (mButtonLinear[i].isDone()) continue;
                        bl = false;
                        continue;
                    }
                    int n = i;
                    mEnterTimer[n] = mEnterTimer[n] - Timer.mDt;
                    bl = false;
                }
                if (!mBoxInterp.isDone() || !bl) break;
                if (mCloseAction == 0) {
                    MusicBuffer.setVolume(MusicBuffer.DEFAULT_MUSIC_VOLUMEN);
                }
                switch (mCloseAction) {
                    case 0: {
                        return true;
                    }
                    case 1: {
                        StateGame.restartLevel();
                        break block0;
                    }
                    case 2: {
                        StateGame.transitionToMenuPauseMenu();
                    }
                }
            }
        }
        return false;
    }

    private static void drawBox(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = n3 + 917504;
        int n8 = n4 + 917504;
        int n9 = PMMath.DIV(n7, 0x140000);
        int n10 = PMMath.DIV(n8, 0x140000);
        int n11 = PMMath.DIV(n3, 0x110000);
        int n12 = PMMath.DIV(n4, 917504);
        n11 = (n11 >> 16) + 1;
        n12 = (n12 >> 16) + 1;
        int n13 = (n >>= 16) - ((n3 >>= 16) >> 1);
        int n14 = (n2 >>= 16) - ((n4 >>= 16) >> 1);
        PMCanvas.PMGraphics_setColor(208, 139, 25);
        PMCanvas.PMGraphics_fillRect(n13, n14, n3, n4);
        PMImageManager.draw(501, n13, n14);
        PMCanvas.PMGraphics_setClip(n13, 0, n3, 240);
        if (n13 + n3 > 0) {
            for (n6 = 0; n6 < n11; ++n6) {
                n5 = n13 + n6 * 17;
                PMImageManager.draw(502, n5, n2 - (n4 >> 1));
                PMImageManager.draw(506, n5, n2 + (n4 >> 1));
            }
        }
        PMCanvas.PMGraphics_setClip(0, n14, 320, n4);
        for (n6 = 0; n6 < n12; ++n6) {
            n5 = n14 + n6 * 17;
            PMImageManager.draw(507, n - (n3 >> 1), n5);
            PMImageManager.draw(504, n + (n3 >> 1), n5);
        }
        PMCanvas.PMGraphics_setClip(0, 0, 320, 240);
        n13 = n + (n3 >> 1);
        n14 = n2 - (n4 >> 1);
        PMImageManager.draw(503, n13, n14);
        n13 = n + (n3 >> 1);
        n14 = n2 + (n4 >> 1);
        PMImageManager.draw(505, n13, n14);
        n13 = n - (n3 >> 1);
        n14 = n2 + (n4 >> 1);
        PMImageManager.draw(508, n13, n14);
    }

    public static void drawButton(int[] nArray, int n, int n2, int n3, int n4) {
    }

    public static void draw() {
        int n = mBoxInterp.getX();
        int n2 = mBoxInterp.getY();
        int n3 = mBoxSizeSpring.getX();
        int n4 = mBoxSizeSpring.getY();
        PauseMenu.drawBox(n, n2, n3, n4);
        int n5 = n >> 16;
        int n6 = n2 >> 16;
        int n7 = n3 >> 16;
        int n8 = n4 >> 16;
        switch (mState) {
            case 0: 
            case 1: 
            case 5: {
                for (int i = 0; i < 5; ++i) {
                    int n9 = mButtonWidths[i];
                    int n10 = 9;
                    int n11 = 65536;
                    int[] nArray = button9patch;
                    n9 = PMMath.MUL(n11, n9 << 16) >> 16;
                    n10 = PMMath.MUL(n11, n10 << 16) >> 16;
                    if (mState == 5) {
                        n5 = (mButtonLinear[i].getX() >> 16) - (n9 >> 1);
                        n6 = (mButtonLinear[i].getY() >> 16) - (n10 >> 1);
                    } else {
                        n5 = (mButtonSprings[i].getX() >> 16) - (n9 >> 1);
                        n6 = (mButtonSprings[i].getY() >> 16) - (n10 >> 1);
                    }
                    PauseMenu.drawButton(nArray, n5 += mButtonDown[i] ? 2 : 0, n6 += mButtonDown[i] ? 2 : 0, n9, n10);
                    n9 = mTextWidths[i] >> 1;
                    n10 = 9;
                    if (mState == 5) {
                        n5 = (mButtonLinear[i].getX() >> 16) - n9;
                        n6 = (mButtonLinear[i].getY() >> 16) - n10;
                    } else {
                        n5 = (mButtonSprings[i].getX() >> 16) - n9;
                        n6 = (mButtonSprings[i].getY() >> 16) - n10;
                    }
                    int n12 = 0;
                    n12 = mSelectedButton == i ? 5 : 0;
                    PMCanvas.PMGraphics_drawString((n5 += mButtonDown[i] ? 2 : 0) + n12, n6 += mButtonDown[i] ? 2 : 0, mText[i], 0);
                }
                break;
            }
            case 3: {
                int n13 = n5 - 47 + 5;
                int n14 = n6 - 38 + 5;
                int n15 = 84;
                int n16 = 67;
                PMCanvas.PMGraphics_setClip(n13, n14, n15, n16);
                PMCanvas.PMGraphics_drawStringBox(n13, n14 - mTextScroller.getOffset(), n15, mHelpTextHeight, mHelpText, 2, 0, mHelpText.length(), false);
                int n17 = 65536;
                n5 = 294 + (mButtonDownHelp[0] ? 2 : 0);
                n6 = 214 + (mButtonDownHelp[0] ? 2 : 0);
                PMCanvas.PMGraphics_setClip(n5 - 23, n6 - 23, 46, 46);
                PMImageManager.draw(496, n5, n6, n17);
                PMCanvas.PMGraphics_setClip(n13, n14, n15, n16);
            }
        }
        Dialog.draw();
    }

    private static void setupButtons() {
        for (int i = 0; i < 5; ++i) {
            PauseMenu.mTextWidths[i] = PMFont.stringWidth(mText[i], 0);
            PauseMenu.mButtonWidths[i] = mTextWidths[i] + 3;
            PauseMenu.mPositionX[i] = 160;
            PauseMenu.mPositionY[i] = 82 + (i + 1) * mButtonSpacing;
        }
    }

    private static void calculateOverlay() {
    }

    public static void touchDown(int n, int n2) {
        if (mState == 3) {
            mTextScroller.touchDown(n, n2);
        }
    }

    public static void touchMove(int n, int n2) {
        if (mState == 3) {
            mTextScroller.touchMove(n, n2);
        }
    }

    public static void touchUp(int n, int n2) {
        if (mState == 3) {
            mTextScroller.touchUp(n, n2);
        }
    }

    static {
        mText = new String[5];
        mPositionX = new int[5];
        mPositionY = new int[5];
        mTextWidths = new int[5];
        mButtonWidths = new int[5];
        mButtonExitTarget = new int[5];
        mButtonEnterTarget = new int[5];
        mBoxLinear = new InterpolatorLinear();
        mBoxSpring = new InterpolatorSpring();
        mBoxInterp = null;
        mButtonLinear = new InterpolatorLinear[5];
        mButtonSprings = new InterpolatorSpring[5];
        mEnterTimer = new int[5];
        mButtonSpacing = 0;
        mBoxSizeSpring = new InterpolatorSpring();
        mButtonDown = new boolean[5];
        mButtonDownHelp = new boolean[1];
        mSelectedButton = 0;
        mButtonPulser = new ButtonPulser();
        button9patch = new int[]{510, 511, 512, 516, 518, 513, 517, 515, 514};
        button9patchSelected = new int[]{519, 520, 521, 525, 527, 522, 526, 524, 523};
    }
}

