/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game;

import dk.progressivemedia.rflib.graphics.PMImageManager;
import dk.progressivemedia.rflib.io.PMFile;
import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.skeleton.Defines;
import dk.progressivemedia.skeleton.GameState;
import dk.progressivemedia.skeleton.game.GameTileMapping;
import dk.progressivemedia.skeleton.math.AABB;
import dk.progressivemedia.skeleton.math.MathUtil;
import dk.progressivemedia.skeleton.math.Vector2;

public class TileManager {
    public static final int TILES_X_MAX = 17;
    public static final int TILES_Y_MAX = 13;
    public static final int TILES_BG_X_MAX = 5;
    public static final int TILES_BG_Y_MAX = 4;
    public static final int BG1_PARALLAX_RATIO = 32768;
    public static final int BG2_PARALLAX_RATIO = 16384;
    private int mWidth;
    private int mHeight;
    private boolean[][] mCollisionTilemap;
    private byte[][] mPrimaryTilemap;
    private byte[][] mOverlayTilemap;
    private short mWidthBG1;
    private short mHeightBG1;
    private short mWidthBG2;
    private short mHeightBG2;
    private byte[][] mPrimaryTilemapBG1;
    private byte[][] mPrimaryTilemapBG2;
    private int mBG1YOffset;
    private int mBG2YOffset;
    private int mCameraMaxHeight;
    private int mRayX;
    private int mRayY;
    private int mRayEndX;
    private int mRayEndY;
    private int mRayDirX;
    private int mRayDirY;
    private int mRayStepX;
    private int mRayStepY;
    private int mRayTMaxX;
    private int mRayTMaxY;
    private int mRayTDeltaX;
    private int mRayTDeltaY;
    private boolean mRayReachedX;
    private boolean mRayReachedY;
    private boolean mFirstStep;

    public TileManager(int n, int n2, boolean[][] blArray, byte[][] byArray, byte[][] byArray2) {
        int n3;
        int n4;
        this.mWidth = n;
        this.mHeight = n2;
        this.mCollisionTilemap = blArray;
        this.mPrimaryTilemap = byArray;
        this.mOverlayTilemap = byArray2;
        this.mCameraMaxHeight = this.mHeight * 20 - 240 << 16;
        PMFile.openFile(GameTileMapping.BG_TILE_MAPS[Defines.mWorldLookup[GameState.mLevel]][1]);
        this.mWidthBG2 = PMFile.readShort();
        this.mHeightBG2 = PMFile.readShort();
        this.mPrimaryTilemapBG2 = new byte[this.mWidthBG2][this.mHeightBG2];
        for (n4 = 0; n4 < this.mHeightBG2; ++n4) {
            for (n3 = 0; n3 < this.mWidthBG2; ++n3) {
                this.mPrimaryTilemapBG2[n3][n4] = (byte)PMFile.readShort();
            }
        }
        PMFile.closeFile();
        this.mBG2YOffset = this.mHeightBG2 * 80 - 240 << 16;
        PMFile.openFile(GameTileMapping.BG_TILE_MAPS[Defines.mWorldLookup[GameState.mLevel]][0]);
        this.mWidthBG1 = PMFile.readShort();
        this.mHeightBG1 = PMFile.readShort();
        this.mPrimaryTilemapBG1 = new byte[this.mWidthBG1][this.mHeightBG1];
        for (n4 = 0; n4 < this.mHeightBG1; ++n4) {
            for (n3 = 0; n3 < this.mWidthBG1; ++n3) {
                this.mPrimaryTilemapBG1[n3][n4] = (byte)PMFile.readShort();
            }
        }
        PMFile.closeFile();
        this.mBG1YOffset = this.mHeightBG1 * 80 - 240 << 16;
    }

    public boolean getCollisionInfo(int n, int n2, AABB aABB) {
        int n3 = (n >> 16) / 16;
        int n4 = (n2 >> 16) / 16;
        if (n3 < 0 || n4 < 0 || n3 >= this.mWidth || n4 >= this.mHeight) {
            return false;
        }
        if (this.mCollisionTilemap[n3][n4]) {
            aABB.mMinX = n3 * 16 << 16;
            aABB.mMinY = n4 * 16 << 16;
            aABB.mMaxX = aABB.mMinX + 0x100000;
            aABB.mMaxY = aABB.mMinY + 0x100000;
            return true;
        }
        return false;
    }

    public void drawBackground(Vector2 vector2) {
        int n;
        int n2;
        int n3;
        long l;
        long l2;
        int n4;
        int n5;
        int n6;
        int n7;
        long l3 = (long)vector2.mX * 5L >> 2;
        long l4 = (long)vector2.mY * 5L >> 2;
        long l5 = l3 * 16384L >> 16;
        long l6 = (long)this.mBG2YOffset - (((long)this.mCameraMaxHeight - l4) * 16384L >> 16);
        int n8 = (int)((l5 >> 16) / 80L);
        short[] sArray = GameTileMapping.BG2_TILE_IMAGE_MAP[Defines.mWorldLookup[GameState.mLevel]];
        for (n7 = 0; n7 < 4; ++n7) {
            for (n6 = 0; n6 < 6; ++n6) {
                n5 = n8 + n6;
                n4 = n5 % 6;
                l2 = (long)(n5 * 0x400000 + 0x200000) * 5L >> 2;
                l = (long)(n7 * 0x400000) * 5L >> 2;
                n3 = (int)((l2 >> 16) - (l5 >> 16));
                n2 = (int)((l >> 16) - (l6 >> 16));
                n = this.mPrimaryTilemapBG2[n4][n7];
                if (n == 0) continue;
                PMImageManager.draw(sArray[--n], n3, n2);
            }
        }
        l5 = l3 * 32768L >> 16;
        l6 = (long)this.mBG1YOffset - (((long)this.mCameraMaxHeight - l4) * 32768L >> 16);
        n8 = (int)((l5 >> 16) / 80L);
        sArray = GameTileMapping.BG1_TILE_IMAGE_MAP[Defines.mWorldLookup[GameState.mLevel]];
        for (n7 = 0; n7 < 4; ++n7) {
            for (n6 = 0; n6 < 6; ++n6) {
                n5 = n8 + n6;
                n4 = n5 % 6;
                l2 = (long)(n5 * 0x400000 + 0x200000) * 5L >> 2;
                l = (long)(n7 * 0x400000) * 5L >> 2;
                n3 = (int)((l2 >> 16) - (l5 >> 16));
                n2 = (int)((l >> 16) - (l6 >> 16));
                n = this.mPrimaryTilemapBG1[n4][n7];
                if (n == 0) continue;
                PMImageManager.draw(sArray[--n], n3, n2);
            }
        }
    }

    public void draw(Vector2 vector2) {
        int n = (vector2.mX >> 16) / 16;
        int n2 = n + 17 + 1;
        int n3 = (vector2.mY >> 16) / 16;
        int n4 = n3 + 13 + 1;
        if (n < 0) {
            n = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n2 > this.mWidth) {
            n2 = this.mWidth;
        }
        if (n4 > this.mHeight) {
            n4 = this.mHeight;
        }
        short[] sArray = GameTileMapping.TILE_IMAGE_MAP[Defines.mWorldLookup[GameState.mLevel]];
        for (int i = n3; i < n4; ++i) {
            for (int j = n; j < n2; ++j) {
                long l = (long)(j * 0x100000 + 524288) * 5L >> 2;
                long l2 = (long)(i * 0x100000) * 5L >> 2;
                long l3 = (long)vector2.mX * 5L >> 2;
                long l4 = (long)vector2.mY * 5L >> 2;
                int n5 = (int)((l >> 16) - (l3 >> 16));
                int n6 = (int)((l2 >> 16) - (l4 >> 16));
                int n7 = this.mPrimaryTilemap[j][i];
                if (n7 != 0) {
                    PMImageManager.draw(sArray[n7 -= 9], n5, n6);
                }
                if (this.mOverlayTilemap == null || (n7 = this.mOverlayTilemap[j][i]) == 0) continue;
                PMImageManager.draw(sArray[n7 -= 9], n5, n6);
            }
        }
    }

    public void startRaycast(int n, int n2, int n3, int n4) {
        this.mRayDirX = n3 - n;
        this.mRayDirY = n4 - n2;
        long l = (long)this.mRayDirX * (long)this.mRayDirX >> 16;
        long l2 = (long)this.mRayDirY * (long)this.mRayDirY >> 16;
        int n5 = (int)PMMath.SQRT(l + l2);
        if (n5 == 0) {
            n5 = 1;
        }
        this.mRayDirX = PMMath.DIV(this.mRayDirX, n5);
        this.mRayDirY = PMMath.DIV(this.mRayDirY, n5);
        if (this.mRayDirX != 0) {
            this.mRayTDeltaX = PMMath.DIV(0x100000, MathUtil.abs(this.mRayDirX));
        }
        if (this.mRayDirY != 0) {
            this.mRayTDeltaY = PMMath.DIV(0x100000, MathUtil.abs(this.mRayDirY));
        }
        this.mRayX = (n >> 16) / 16;
        this.mRayY = (n2 >> 16) / 16;
        this.mRayEndX = (n3 >> 16) / 16;
        this.mRayEndY = (n4 >> 16) / 16;
        this.mRayStepX = this.mRayDirX < 0 ? -1 : 1;
        int n6 = this.mRayStepY = this.mRayDirY < 0 ? -1 : 1;
        this.mRayTMaxX = this.mRayDirX != 0 ? (this.mRayDirX < 0 ? PMMath.DIV(this.mRayX * 0x100000 - n, this.mRayDirX) : PMMath.DIV((this.mRayX + 1) * 0x100000 - n, this.mRayDirX)) : Integer.MAX_VALUE;
        this.mRayTMaxY = this.mRayDirY != 0 ? (this.mRayDirY < 0 ? PMMath.DIV(this.mRayY * 0x100000 - n2, this.mRayDirY) : PMMath.DIV((this.mRayY + 1) * 0x100000 - n2, this.mRayDirY)) : Integer.MAX_VALUE;
        this.mRayReachedX = this.mRayX == this.mRayEndX;
        this.mRayReachedY = this.mRayY == this.mRayEndY;
        this.mFirstStep = true;
    }

    public boolean nextRayStepValid() {
        if (this.mFirstStep) {
            return true;
        }
        if (this.mRayReachedX && this.mRayReachedY) {
            return false;
        }
        return this.mRayX >= 0 && this.mRayY >= 0 && this.mRayX < this.mWidth && this.mRayY < this.mHeight;
    }

    public boolean rayStep(AABB aABB) {
        do {
            if (!this.mFirstStep) {
                if (this.mRayTMaxX < this.mRayTMaxY) {
                    this.mRayTMaxX += this.mRayTDeltaX;
                    this.mRayX += this.mRayStepX;
                } else {
                    this.mRayTMaxY += this.mRayTDeltaY;
                    this.mRayY += this.mRayStepY;
                }
                if (this.mRayStepX > 0) {
                    if (this.mRayX >= this.mRayEndX) {
                        this.mRayReachedX = true;
                    }
                } else if (this.mRayX <= this.mRayEndX) {
                    this.mRayReachedX = true;
                }
                if (this.mRayStepY > 0) {
                    if (this.mRayY >= this.mRayEndY) {
                        this.mRayReachedY = true;
                    }
                } else if (this.mRayY <= this.mRayEndY) {
                    this.mRayReachedY = true;
                }
            }
            this.mFirstStep = false;
            if (this.mRayX < 0 || this.mRayY < 0 || this.mRayX >= this.mWidth || this.mRayY >= this.mHeight) {
                return false;
            }
            if (!this.mCollisionTilemap[this.mRayX][this.mRayY]) continue;
            aABB.mMinX = this.mRayX * 16 << 16;
            aABB.mMinY = this.mRayY * 16 << 16;
            aABB.mMaxX = aABB.mMinX + 0x100000;
            aABB.mMaxY = aABB.mMinY + 0x100000;
            return true;
        } while (this.nextRayStepValid());
        return false;
    }

    public int getMinX() {
        return 0;
    }

    public int getMaxX() {
        return this.mWidth * 0x100000;
    }

    public int getMaxY() {
        return this.mHeight * 0x100000;
    }
}

