/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.enemies;

import dk.progressivemedia.skeleton.game.enemies.Enemy6Data;
import dk.progressivemedia.skeleton.game.enemies.Enemy6State;
import dk.progressivemedia.skeleton.game.enemies.Enemy6StateDieing;
import dk.progressivemedia.skeleton.game.enemies.Enemy6StateIdling;
import dk.progressivemedia.skeleton.game.enemies.Enemy6StateSpiked;
import dk.progressivemedia.skeleton.game.enemies.Enemy6View;

public class Enemy6StateController {
    private Enemy6Data mData;
    private Enemy6View mView;
    public static final int STATE_IDLING = 0;
    public static final int STATE_SPIKED = 1;
    public static final int STATE_DIEING = 2;
    private int mActiveStateID;
    private Enemy6State mActiveState;
    private Enemy6StateIdling mStateIdling;
    private Enemy6StateSpiked mStateSpiked;
    private Enemy6StateDieing mStateDieing;

    public Enemy6StateController(Enemy6Data enemy6Data, Enemy6View enemy6View) {
        this.mData = enemy6Data;
        this.mView = enemy6View;
        this.mStateIdling = new Enemy6StateIdling(enemy6Data, enemy6View, this);
        this.mStateSpiked = new Enemy6StateSpiked(enemy6Data, enemy6View, this);
        this.mStateDieing = new Enemy6StateDieing(enemy6Data, enemy6View, this);
        this.mActiveStateID = 0;
        this.mActiveState = this.mStateIdling;
        this.mActiveState.enter();
    }

    public void update() {
        this.mActiveState.update();
    }

    public void requestStateChange(int n) {
        this.mActiveState.exit();
        this.mActiveStateID = n;
        switch (n) {
            case 0: {
                this.mActiveState = this.mStateIdling;
                break;
            }
            case 1: {
                this.mActiveState = this.mStateSpiked;
                break;
            }
            case 2: {
                this.mActiveState = this.mStateDieing;
            }
        }
        this.mActiveState.enter();
    }
}

