/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.enemies;

import dk.progressivemedia.rflib.graphics.PMImageManager;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.game.Camera;
import dk.progressivemedia.skeleton.math.MathUtil;
import dk.progressivemedia.skeleton.math.Vector2;

public class FruitBomb {
    private static final int STATE_VOID = 0;
    private static final int STATE_ACTIVE = 1;
    private static final int FULL_SIZE = 4;
    private int mState = 0;
    private Vector2 mPosition = new Vector2();
    private int mVelocityX;
    private int mLifeTimer;
    private int mFireRange;

    public void fire(int n, int n2, int n3) {
        this.mState = 1;
        this.mPosition.set(n2, n3);
        this.mVelocityX = 131072 * n;
        this.mLifeTimer = this.mFireRange / MathUtil.abs(this.mVelocityX) * Timer.mDt;
    }

    public void update() {
        switch (this.mState) {
            case 1: {
                this.mPosition.mX += this.mVelocityX;
                this.mLifeTimer -= Timer.mDt;
                if (this.mLifeTimer > 0) break;
                this.mState = 0;
            }
        }
    }

    public void draw(Vector2 vector2) {
        switch (this.mState) {
            case 1: {
                long l = (long)this.mPosition.mX * 5L >> 2;
                long l2 = (long)this.mPosition.mY * 5L >> 2;
                long l3 = (long)vector2.mX * 5L >> 2;
                long l4 = (long)vector2.mY * 5L >> 2;
                int n = (int)((l >> 16) - (l3 >> 16));
                int n2 = (int)((l2 >> 16) - (l4 >> 16));
                int n3 = 5;
                int n4 = 5;
                if (!Camera.isInside(n - (n3 >> 1), n2 - (n4 >> 1), n3, n4)) break;
                PMImageManager.draw(41, n, n2);
            }
        }
    }

    public void destroy() {
        this.mState = 0;
    }

    public boolean getActive() {
        return this.mState == 1;
    }

    public Vector2 getPositionRef() {
        return this.mPosition;
    }

    public void setFireRange(int n) {
        this.mFireRange = n;
    }
}

