/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.math;

public class TouchInertia {
    private static final int INTERP_SPEED = 10;
    private static final int DAMPING = 5;
    private static final int APPLIED_VELOCTIY = 327680;
    private static final int STATE_FREE = 0;
    private static final int STATE_LOCKED = 1;
    private static final int STATE_OUTSIDE = 2;
    private int mState = 0;
    private int mOffset = 0;
    private int mVelocity = 0;
    private int mOffsetBounds;
    private int mInitialPos;
    private int mTargetPos;

    public TouchInertia(int n) {
        this.mOffsetBounds = n;
        this.mInitialPos = -1;
        this.mTargetPos = -1;
    }

    public void update(int n) {
        switch (this.mState) {
            case 0: {
                this.mVelocity -= this.mVelocity * 5 * n >> 10;
                this.mOffset -= this.mVelocity;
                if (this.mOffset < 0) {
                    this.mOffset = 0;
                    this.mVelocity = 0;
                    break;
                }
                if (this.mOffset <= this.mOffsetBounds) break;
                this.mOffset = this.mOffsetBounds;
                this.mVelocity = 0;
                break;
            }
            case 1: {
                this.mVelocity = (this.mTargetPos - this.mInitialPos >> 8) * 10 * n >> 2;
                this.mInitialPos += this.mVelocity;
                if (this.mOffset < 0 || this.mOffset > this.mOffsetBounds) {
                    this.mOffset -= this.mVelocity >> 1;
                    break;
                }
                this.mOffset -= this.mVelocity;
                break;
            }
            case 2: {
                this.mVelocity = (this.mTargetPos - this.mInitialPos >> 8) * 10 * n >> 2;
                this.mInitialPos += this.mVelocity;
                this.mOffset += this.mVelocity;
                if (this.mOffset <= 0 || this.mOffset >= this.mOffsetBounds) break;
                this.mVelocity = 0;
                this.mState = 0;
            }
        }
    }

    public void touchDown(int n, int n2) {
        this.mState = 1;
        this.mTargetPos = this.mInitialPos = n2 * 240;
    }

    public void touchMove(int n, int n2) {
        this.mTargetPos = n2 * 240;
    }

    public void touchUp(int n, int n2) {
        if (this.mOffset < 0 || this.mOffset > this.mOffsetBounds) {
            this.mState = 2;
            if (this.mOffset < 0) {
                this.mInitialPos = this.mOffset;
                this.mTargetPos = 0;
            } else if (this.mOffset > this.mOffsetBounds) {
                this.mInitialPos = this.mOffset;
                this.mTargetPos = this.mOffsetBounds;
            }
        } else {
            this.mState = 0;
        }
    }

    public void applyMovement(boolean bl) {
        this.mVelocity = bl ? 327680 : -327680;
    }

    public int getOffset() {
        return this.mOffset >> 16;
    }

    public void reset() {
        this.mOffset = 0;
        this.mVelocity = 0;
        this.mInitialPos = -1;
        this.mTargetPos = -1;
        this.mState = 0;
    }
}

