/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.movieplayer;

import dk.progressivemedia.rflib.graphics.PMImageManager;
import dk.progressivemedia.rflib.io.PMFile;
import dk.progressivemedia.skeleton.Interpolation;
import dk.progressivemedia.skeleton.movieplayer.MovieItem;

public class Movie {
    public static final int SCALE = 0x1400000;
    public static final int TRACK_SIZE_FULL = 5;
    public static final int TRACK_SIZE_SHORT = 3;
    public static final int ID_ATTRIB = 0;
    public static final int FROM_TIMESTAMP = 1;
    public static final int FROM_VALUE = 2;
    public static final int TO_TIMESTAMP = 3;
    public static final int TO_VALUE = 4;
    public static final int ID_ATTRIB_ID_MASK = 65280;
    public static final int ID_ATTRIB_ID_SHIFT = 8;
    public static final int ID_ATTRIB_INTERPOLATE_MASK = 240;
    public static final int ID_ATTRIB_INTERPOLATE_SHIFT = 4;
    public static final int ID_ATTRIB_ATTRIB_MASK = 15;
    public static final int ID_ATTRIB_ATTRIB_SHIFT = 0;
    public static final int ID_EVENT_TAG = 255;
    public static final int ID_SPECIAL_TAG = 254;
    public static final int SPECIAL_SCENE_START = 1;
    public static final int SPECIAL_LOOP_POINT = 2;
    public static final int SPECIAL_KEYFRAME = 3;
    public static final int EVENT_VIBRATION = 1;
    public static final int EVENT_AUDIO = 2;
    public static final int EVENT_TEXT = 3;
    public static final int INTERPOLATE_LINEAR = 0;
    public static final int INTERPOLATE_SMOOTH_START = 1;
    public static final int INTERPOLATE_SMOOTH_END = 2;
    public static final int INTERPOLATE_SMOOTH_MIDDLE = 3;
    public static final int INTERPOLATE_SMOOTH_START_AND_END = 4;
    public static final int INTERPOLATE_SHORT_TRACK = 15;
    private short[] timeline;
    private short[] active;
    private int position;
    private int tick;
    private int time;
    private int length;
    private int lengthMs;
    private boolean fastforward;
    private MovieItem[] items;
    private short[] modelId;
    private short[] order;
    private boolean loop;
    private int playTimes;
    private int loopMark;
    private boolean isLoaded;
    private int[] sortedOrder;
    private static byte[] mFile;
    private static int mFileIdx;

    public static void event(int n, int n2) {
    }

    public void draw(int n, int n2) {
        int n3;
        for (n3 = 0; n3 < this.sortedOrder.length; ++n3) {
            this.sortedOrder[this.order[n3]] = n3;
        }
        for (n3 = 0; n3 < this.order.length; ++n3) {
            this.items[this.sortedOrder[n3]].draw(n, n2, 0x1400000);
        }
    }

    public void draw(int n, int n2, boolean bl) {
        int n3;
        for (n3 = 0; n3 < this.sortedOrder.length; ++n3) {
            this.sortedOrder[this.order[n3]] = n3;
        }
        for (n3 = 0; n3 < this.order.length; ++n3) {
            this.items[this.sortedOrder[n3]].draw(n, n2, 0x1400000, bl);
        }
    }

    public void draw(int n, int n2, int n3) {
        int n4;
        for (n4 = 0; n4 < this.sortedOrder.length; ++n4) {
            this.sortedOrder[this.order[n4]] = n4;
        }
        for (n4 = 0; n4 < this.order.length; ++n4) {
            this.items[this.sortedOrder[n4]].draw(n, n2, 0x1400000, n3);
        }
    }

    public void drawAlpha(int n, int n2, int n3) {
        int n4;
        for (n4 = 0; n4 < this.sortedOrder.length; ++n4) {
            this.sortedOrder[this.order[n4]] = n4;
        }
        for (n4 = 0; n4 < this.order.length; ++n4) {
            this.items[this.sortedOrder[n4]].drawAlpha(n, n2, 0x1400000, n3);
        }
    }

    public boolean isDone() {
        return this.time >= this.length;
    }

    public boolean update(int n) {
        int n2;
        if (this.time >= this.length) {
            return true;
        }
        this.tick += n;
        this.time = (this.tick + 5) / 10;
        if (this.time >= this.length) {
            if (this.playTimes > 1) {
                --this.playTimes;
                this.gotoTick(this.time - this.length);
            } else if (this.playTimes == 0) {
                this.gotoTick(this.time - this.length);
            } else if (this.loop) {
                this.gotoTick(this.loopMark + this.tick - this.lengthMs);
            }
        }
        for (n2 = 0; n2 < this.active.length; ++n2) {
            if (this.active[n2] < 0) continue;
            this.updateItem(this.active[n2]);
            if (this.time < this.timeline[this.active[n2] + 3]) continue;
            this.active[n2] = -1;
        }
        while (this.position < this.timeline.length && this.time >= this.timeline[this.position + 1]) {
            if (this.updateItem(this.position)) {
                if (this.time < this.timeline[this.position + 3]) {
                    for (n2 = 0; n2 < this.active.length; ++n2) {
                        if (this.active[n2] != -1) continue;
                        this.active[n2] = (short)this.position;
                        break;
                    }
                }
                this.position += 5;
                continue;
            }
            this.position += 3;
        }
        return this.time >= this.length;
    }

    public void gotoTick(int n) {
        int n2;
        this.tick = 0;
        this.time = 0;
        this.position = 0;
        for (n2 = 0; n2 < this.items.length; ++n2) {
            this.items[n2].reset();
            this.order[n2] = (short)n2;
        }
        for (n2 = 0; n2 < this.active.length; ++n2) {
            this.active[n2] = -1;
        }
        this.fastforward = true;
        this.update(n % this.lengthMs);
        this.fastforward = false;
    }

    public boolean updateItem(int n) {
        int n2 = (this.timeline[n + 0] & 0xFF00) >> 8;
        int n3 = (this.timeline[n + 0] & 0xF0) >> 4;
        int n4 = (this.timeline[n + 0] & 0xF) >> 0;
        if (n3 == 15) {
            if (n2 == 255) {
                Movie.event(n4, this.timeline[n + 2]);
            } else if (n2 != 254) {
                if (n4 == 7) {
                    this.modifyOrder(n2, this.timeline[n + 2]);
                } else {
                    this.items[n2].setValue(n4, this.timeline[n + 2]);
                }
            }
            return false;
        }
        int n5 = this.time - this.timeline[n + 1];
        int n6 = this.timeline[n + 3] - this.timeline[n + 1];
        int n7 = this.timeline[n + 2];
        int n8 = this.timeline[n + 4];
        if (n4 == 3 || n4 == 9 || n4 == 10) {
            n7 &= 0xFFFF;
            n8 &= 0xFFFF;
        }
        int n9 = Interpolation.interpolate(n3, n7, n8, n5, n6);
        if (n2 == 255) {
            Movie.event(n4, n9);
        } else if (n2 != 254) {
            this.items[n2].setValue(n4, (short)n9);
        }
        return true;
    }

    public void modifyOrder(int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        for (n4 = 0; n4 < this.order.length; ++n4) {
            if (this.order[n4] != n) continue;
            n5 = n4;
            break;
        }
        n4 = n5 + n2;
        if (n2 < 0) {
            for (n3 = n5; n3 > n4; --n3) {
                this.order[n3] = this.order[n3 - 1];
            }
        }
        if (n2 > 0) {
            for (n3 = n5; n3 < n4; ++n3) {
                this.order[n3] = this.order[n3 + 1];
            }
        }
        this.order[n4] = (short)n;
    }

    public static Movie load(String string) {
        return Movie.load(PMFile.calcCRC(string));
    }

    public static Movie load(short s) {
        int n;
        Movie movie = new Movie();
        mFileIdx = 0;
        mFile = PMFile.fileToByteArray(s);
        movie.length = Movie.readShort();
        movie.lengthMs = 10 * movie.length;
        int n2 = Movie.readUnsignedByte();
        movie.loop = (n2 & 1) > 0;
        int n3 = Movie.readUnsignedByte();
        movie.order = new short[n3];
        movie.items = new MovieItem[n3];
        for (n = 0; n < n3; ++n) {
            movie.items[n] = new MovieItem();
            movie.order[n] = (short)n;
        }
        if (movie.loop) {
            movie.loopMark = 10 * (short)Movie.readUnsignedShort();
        }
        movie.active = new short[Movie.readShort()];
        movie.timeline = new short[Movie.readShort()];
        for (n = 0; n < movie.timeline.length; ++n) {
            movie.timeline[n] = Movie.readShort();
        }
        PMFile.closeFile();
        movie.tick = 0;
        movie.time = 0;
        movie.position = 0;
        movie.fastforward = false;
        movie.playTimes = 1;
        for (n = 0; n < movie.active.length; ++n) {
            movie.active[n] = -1;
        }
        movie.sortedOrder = new int[n3];
        return movie;
    }

    public void unloadGfx() {
        this.loadGfx(true);
    }

    public void loadGfx() {
        this.loadGfx(false);
    }

    private void loadGfx(boolean bl) {
        int n = 0;
        while (n < this.timeline.length) {
            int n2 = (this.timeline[n + 0] & 0xF0) >> 4;
            if (n2 == 15) {
                int n3;
                int n4 = (this.timeline[n + 0] & 0xF) >> 0;
                if (n4 == 0 && (n3 = (this.timeline[n + 0] & 0xFF00) >> 8) != 255 && n3 != 254) {
                    if (this.isLoaded && bl) {
                        PMImageManager.unload(this.timeline[n + 2]);
                        this.isLoaded = false;
                    } else {
                        this.isLoaded = true;
                        PMImageManager.load(this.timeline[n + 2]);
                    }
                }
                n += 3;
                continue;
            }
            n += 5;
        }
    }

    public void unloadGfx(Movie movie) {
        int n = 0;
        while (n < this.timeline.length) {
            int n2 = (this.timeline[n + 0] & 0xF0) >> 4;
            if (n2 == 15) {
                short s;
                int n3;
                int n4 = (this.timeline[n + 0] & 0xF) >> 0;
                if (n4 == 0 && (n3 = (this.timeline[n + 0] & 0xFF00) >> 8) != 255 && n3 != 254 && this.isLoaded && !movie.isImagePresent(s = this.timeline[n + 2])) {
                    PMImageManager.unload(this.timeline[n + 2]);
                }
                n += 3;
                continue;
            }
            n += 5;
        }
        this.isLoaded = false;
    }

    private boolean isImagePresent(short s) {
        boolean bl = false;
        int n = 0;
        while (n < this.timeline.length) {
            int n2 = (this.timeline[n + 0] & 0xF0) >> 4;
            if (n2 == 15) {
                int n3;
                int n4 = (this.timeline[n + 0] & 0xF) >> 0;
                if (n4 == 0 && (n3 = (this.timeline[n + 0] & 0xFF00) >> 8) != 255 && n3 != 254) {
                    short s2 = this.timeline[n + 2];
                    if (this.isLoaded && s2 == s) {
                        bl = true;
                        break;
                    }
                }
                n += 3;
                continue;
            }
            n += 5;
        }
        return bl;
    }

    public Movie copy() {
        int n;
        Movie movie = new Movie();
        movie.length = this.length;
        movie.lengthMs = this.lengthMs;
        movie.loopMark = this.loopMark;
        int n2 = this.order.length;
        movie.order = new short[n2];
        movie.items = new MovieItem[n2];
        for (n = 0; n < n2; ++n) {
            movie.items[n] = new MovieItem();
            movie.order[n] = (short)n;
        }
        movie.active = new short[this.active.length];
        movie.timeline = this.timeline;
        movie.tick = 0;
        movie.time = 0;
        movie.position = 0;
        movie.fastforward = false;
        for (n = 0; n < movie.active.length; ++n) {
            movie.active[n] = -1;
        }
        return movie;
    }

    public void setPlayTimes(int n) {
        this.playTimes = n;
    }

    private static int readUnsignedByte() {
        int n = mFile[mFileIdx] & 0xFF;
        ++mFileIdx;
        return n;
    }

    private static byte readByte() {
        byte by = mFile[mFileIdx];
        ++mFileIdx;
        return by;
    }

    private static int readUnsignedShort() {
        int n = (mFile[mFileIdx] & 0xFF) << 8 | mFile[mFileIdx + 1] & 0xFF;
        mFileIdx += 2;
        return n;
    }

    private static short readShort() {
        short s = (short)(mFile[mFileIdx] << 8 | mFile[mFileIdx + 1] & 0xFF);
        mFileIdx += 2;
        return s;
    }

    private static int readInt() {
        int n = (mFile[mFileIdx] & 0xFF) << 24 | (mFile[mFileIdx + 1] & 0xFF) << 16 | (mFile[mFileIdx + 2] & 0xFF) << 8 | mFile[mFileIdx + 3] & 0xFF;
        mFileIdx += 4;
        return n;
    }
}

