/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton;

import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.rflib.util.PMTrigonometry;

public class ButtonPulser {
    private static final int PULSE_SCALE_SIZE = 3092;
    private static final int PULSE_SCALE_SPEED = 880000;
    private int mPulseScale;
    private int mPulseAngle;

    public ButtonPulser() {
        this.reset();
    }

    public void reset() {
        this.mPulseScale = 65536;
        this.mPulseAngle = 0;
    }

    public void update(int n) {
        this.mPulseAngle += 0x1A0AAA * n >> 6;
        while (this.mPulseAngle > 23527424) {
            this.mPulseAngle -= 23527424;
        }
        this.mPulseScale = PMMath.MUL(PMTrigonometry.sin(this.mPulseAngle >> 16), 3092) + 65536 + 3092;
    }

    public int getScale() {
        return this.mPulseScale;
    }
}

