/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton;

import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.rflib.util.PMTrigonometry;

public class MathHelper {
    public static final int PI = 205887;
    public static final int TWO_PI = 411774;
    public static int TO_DEGREE = PMMath.DIV(0xB40000, 205887);
    public static int DEGREE_FP = 1143;

    public static int smoothStep(int n, int n2) {
        int n3 = PMMath.MUL(PMMath.MUL(n, n), PMMath.FP(3) - PMMath.MUL(PMMath.FP(2), n));
        return PMMath.MUL(n3, n2);
    }

    public static int clamp(int n, int n2, int n3) {
        if (n < n2) {
            return n2;
        }
        if (n > n3) {
            return n3;
        }
        return n;
    }

    public static int aTan2Float(int n, int n2) {
        float f;
        float f2 = 0.785398f;
        float f3 = 3.0f * f2;
        float f4 = Math.abs(n);
        if (f4 == 0.0f) {
            f4 += 1.0E-10f;
        }
        if (n2 >= 0) {
            float f5 = ((float)n2 - f4) / ((float)n2 + f4);
            f = 0.1963f * (f5 * f5 * f5) - 0.9817f * f5 + f2;
        } else {
            float f6 = ((float)n2 + f4) / (f4 - (float)n2);
            f = 0.1963f * (f6 * f6 * f6) - 0.9817f * f6 + f3;
        }
        float f7 = n < 0 ? -f : f;
        return (int)(f7 * 65536.0f);
    }

    public static int aTan2(int n, int n2) {
        int n3;
        int n4 = 51471;
        int n5 = n4 * 3;
        int n6 = n;
        if (n < 0) {
            n6 = -n;
        }
        if (n6 == 0) {
            ++n6;
        }
        int n7 = 0;
        if (n2 >= 0) {
            n3 = PMMath.DIV(n2 - n6, n2 + n6);
            n7 = PMMath.MUL(12865, MathHelper.pow(n3, 3)) - PMMath.MUL(64337, n3) + n4;
        } else {
            n3 = PMMath.DIV(n2 + n6, n6 - n2);
            n7 = PMMath.MUL(12865, MathHelper.pow(n3, 3)) - PMMath.MUL(64337, n3) + n5;
        }
        n3 = n < 0 ? -n7 : n7;
        return n3;
    }

    public static int aTan2Fast(int n, int n2) {
        int n3;
        int n4 = 51471;
        int n5 = n4 * 3;
        int n6 = n;
        if (n < 0) {
            n6 = -n;
        }
        ++n6;
        int n7 = 0;
        if (n2 >= 0) {
            n3 = PMMath.DIV(n2 - n6, n2 + n6);
            n7 = n4 - PMMath.MUL(n4, n3);
        } else {
            n3 = PMMath.DIV(n2 + n6, n6 - n2);
            n7 = n5 - PMMath.MUL(n4, n3);
        }
        n3 = n < 0 ? -n7 : n7;
        return n3;
    }

    public static int sin(int n) {
        while (n < 0) {
            n += 23592960;
        }
        int n2 = n >> 16;
        int n3 = n2 + 1;
        int n4 = PMTrigonometry.sin(n2 % 360);
        int n5 = PMTrigonometry.sin(n3 % 360);
        int n6 = n % 65536;
        int n7 = 65536 - n6;
        return PMMath.MUL(n4, n7) + PMMath.MUL(n5, n6);
    }

    public static int cos(int n) {
        while (n < 0) {
            n += 23592960;
        }
        int n2 = n >> 16;
        int n3 = n2 + 1;
        int n4 = PMTrigonometry.cos(n2 % 360);
        int n5 = PMTrigonometry.cos(n3 % 360);
        int n6 = n % 65536;
        int n7 = 65536 - n6;
        return PMMath.MUL(n4, n7) + PMMath.MUL(n5, n6);
    }

    public static int pow(int n, int n2) {
        int n3 = n;
        while (n2 > 1) {
            n3 = PMMath.MUL(n3, n);
            --n2;
        }
        return n3;
    }
}

