/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton;

import dk.progressivemedia.rflib.util.PMTrigonometry;

public class TransitionTable {
    public static final int TRANSITIONTYPE_LINEAR = 1;
    public static final int TRANSITIONTYPE_SMOOTH = 2;

    public static int[] CreateTable(int n) {
        return TransitionTable.CreateTable(n, 2);
    }

    public static int[] CreateTable(int n, int n2) {
        int[] nArray;
        switch (n2) {
            case 1: {
                nArray = TransitionTable.CreateLinearTable(n);
                break;
            }
            case 2: {
                nArray = TransitionTable.CreateSmoothTable(n);
                break;
            }
            default: {
                nArray = TransitionTable.CreateSmoothTable(n);
            }
        }
        return nArray;
    }

    private static int[] CreateLinearTable(int n) {
        int[] nArray = new int[n];
        int n2 = 65536 / (n - 1);
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            nArray[i] = n3;
            n3 += n2;
        }
        nArray[n - 1] = 65536;
        return nArray;
    }

    private static int[] CreateSmoothTable(int n) {
        int[] nArray;
        if (n < 2) {
            nArray = new int[]{65536};
        } else {
            nArray = new int[n];
            int n2 = 0xB40000 / (n - 1);
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                nArray[i] = 65536 - PMTrigonometry.cos(n3 >> 16) >> 1;
                n3 += n2;
            }
            nArray[n - 1] = 65536;
        }
        return nArray;
    }
}

