/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.menu;

import dk.progressivemedia.rflib.graphics.PMImageManager;
import dk.progressivemedia.rflib.io.PMFile;
import dk.progressivemedia.rflib.platform.PMCanvas;
import dk.progressivemedia.rflib.system.PMStateManager;
import dk.progressivemedia.rflib.system.PMSystem;
import dk.progressivemedia.rflib.util.PMLocale;
import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.skeleton.Main;
import dk.progressivemedia.skeleton.MusicBuffer;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.Touch;
import dk.progressivemedia.skeleton.TransitionEffect;

public class StateSplash {
    private static final int HALF_SCREEN_WIDTH = 160;
    private static final int HALF_SCREEN_HEIGHT = 120;
    private static final int MUSIC_FADE_TIME = 800;
    private static final int FADE_TIME = 800;
    private static int[] mIdleTime = new int[]{1200, 1200, 1200, 1200};
    private static final int SCALE_SPEED = 100;
    private static final int STATE_SPLASH = 0;
    private static final int STATE_TRANSITION = 1;
    private static int mState;
    private static int mCurrent;
    private static int[] mLogoID;
    private static boolean[] mScaling;
    private static int mScale;
    private static final int FADE_IN = 0;
    private static final int FADE_IDLE = 1;
    private static final int FADE_OUT = 2;
    private static int mFadePhase;
    private static int mOpacity;
    private static int mFadeTimer;
    private static boolean mMusicStarted;
    private static int mMusicFadeTimer;
    private static int[] mSplashImgs;
    private static int[] mSplashImgsLogo;
    private static int[] mSplashImgsText;
    public static float screenWidthFrac;

    public static void init(int n) {
        PMFile.loadScreen = true;
        PMImageManager.load(1124, 21);
        Touch.init();
        Timer.initTimer();
        mState = 0;
        mFadePhase = 0;
        mScale = 65536;
        mOpacity = 0;
        mFadeTimer = 0;
        mMusicStarted = false;
        mMusicFadeTimer = 0;
        MusicBuffer.setVolume(MusicBuffer.DEFAULT_MUSIC_VOLUMEN);
        PMFile.loadScreen = false;
        Main.counter = 0;
    }

    public static void deinit() {
        PMCanvas.PMGraphics_setClip(0, 0, 320, 240);
        PMImageManager.unloadAll();
    }

    public static void update() {
        int n;
        if (PMCanvas.PMInput_isPressed(2)) {
            PMStateManager.set(1, 0);
        }
        Timer.updateTimer();
        PMCanvas.PMGraphics_setColor(0xFFFFFF);
        PMCanvas.PMGraphics_fillRect(0, 0, 320, 240);
        if (mMusicFadeTimer < 800 && mMusicStarted && (mMusicFadeTimer += Timer.mDt) > 800) {
            mMusicFadeTimer = 800;
        }
        if (mState == 0) {
            if (mScaling[mCurrent]) {
                mScale += 193 * Timer.mDt >> 6;
            }
            switch (mFadePhase) {
                case 0: {
                    if ((mFadeTimer += Timer.mDt) > 800) {
                        mFadePhase = 1;
                        mFadeTimer = 0;
                        mOpacity = 240;
                        break;
                    }
                    mOpacity = 240 * PMMath.DIV(mFadeTimer << 16, 0x3200000) >> 16;
                    break;
                }
                case 1: {
                    n = 0;
                    if (mCurrent < mLogoID.length - 1) {
                        if (!Touch.mScreenPressed && !PMCanvas.PMInput_isPressed(1) && !PMCanvas.PMInput_isReleased(1) && (mFadeTimer += Timer.mDt) <= mIdleTime[mCurrent]) break;
                        mFadePhase = 2;
                        mFadeTimer = 800;
                        PMCanvas.PMGraphics_setClip(0, 0, 320, 240);
                        break;
                    }
                    if (PMCanvas.PMInput_isReleased(4096) || !Touch.mScreenPressed && !PMCanvas.PMInput_isPressed(Integer.MAX_VALUE) && !PMCanvas.PMInput_isReleased(Integer.MAX_VALUE)) break;
                    TransitionEffect.setFadeMusic(false);
                    TransitionEffect.init(true);
                    mState = 1;
                    PMCanvas.PMGraphics_setClip(0, 0, 320, 240);
                    MusicBuffer.setVolume(MusicBuffer.DEFAULT_MUSIC_VOLUMEN);
                    break;
                }
                case 2: {
                    if ((mFadeTimer -= Timer.mDt) < 0) {
                        mFadePhase = 0;
                        mFadeTimer = 0;
                        mOpacity = 0;
                        mScale = 65536;
                        if (++mCurrent != mLogoID.length - 1) break;
                        mMusicStarted = true;
                        break;
                    }
                    mOpacity = 240 * PMMath.DIV(mFadeTimer << 16, 0x3200000) >> 16;
                }
            }
        } else if (TransitionEffect.update()) {
            PMStateManager.set(1, 0);
        }
        n = mScale;
        int n2 = mScale;
        if (mCurrent < mLogoID.length - 1) {
            int n3 = (int)(screenWidthFrac * (float)mOpacity) - 80;
            PMImageManager.draw(mLogoID[mCurrent], n3, 120, false, 0, 255, 65536);
        } else {
            int n4 = (int)(screenWidthFrac * (float)mOpacity) - 80;
            PMImageManager.draw(mSplashImgs[PMLocale.get()], 160, 120, false, 0, 255, 65536);
            if (mState != 1) {
                PMCanvas.PMGraphics_setClip(0, 120, 320, 120);
            }
            PMImageManager.draw(mSplashImgsLogo[PMLocale.get()], n4 + 40, 160, false, 0, 255, 65536);
            PMImageManager.draw(mSplashImgsText[PMLocale.get()], n4 + 40, 160 + PMImageManager.getHeight(mSplashImgsLogo[PMLocale.get()]), false, 0, 255, 65536, 65536);
        }
        if (mState == 1) {
            TransitionEffect.draw();
        }
        PMSystem.nextFrame();
    }

    static {
        mCurrent = 0;
        mLogoID = new int[]{1142, 1143, 1144, 1144};
        mScaling = new boolean[]{true, false, false, false};
        mFadePhase = 0;
        mSplashImgs = new int[]{1124, 1125, 1127, 1128, 1126, 1129};
        mSplashImgsLogo = new int[]{1130, 1131, 1133, 1134, 1132, 1135};
        mSplashImgsText = new int[]{1136, 1137, 1139, 1140, 1138, 1141};
        screenWidthFrac = 1.0f;
    }
}

