/*
 * Decompiled with CFR 0.152.
 */
package framework;

import framework.AppState;
import framework.MainGameCanvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class ErrorAppState
extends AppState {
    private String errorMessage = "Unknown error";
    private String[] errorMessageLines = null;
    private int fontHeight = 15;

    public ErrorAppState(String stateName, MainGameCanvas mainGameCanvas) {
        super(stateName, mainGameCanvas);
    }

    public boolean initialize(Object param) {
        if (param != null) {
            this.errorMessage = (String)param;
        }
        this.prepareErrorMessage();
        return true;
    }

    public void render(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, 240, 320);
        g.setColor(0);
        g.setFont(Font.getDefaultFont());
        for (int i = 0; i < this.errorMessageLines.length; ++i) {
            g.drawString(this.errorMessageLines[i], 5, 5 + this.fontHeight * i, 0);
        }
    }

    private void prepareErrorMessage() {
        this.fontHeight = Font.getDefaultFont().getHeight();
        int entersCount = 0;
        for (int i = 0; i < this.errorMessage.length(); ++i) {
            if (this.errorMessage.charAt(i) != '\n') continue;
            ++entersCount;
        }
        if (entersCount == 0 || this.errorMessage.charAt(this.errorMessage.length() - 1) != '\n') {
            this.errorMessage = this.errorMessage + '\n';
            ++entersCount;
        }
        this.errorMessageLines = new String[entersCount];
        int lineNumber = 0;
        int beginIndex = 0;
        for (int i = 0; i < this.errorMessage.length(); ++i) {
            if (this.errorMessage.charAt(i) != '\n') continue;
            this.errorMessageLines[lineNumber++] = this.errorMessage.substring(beginIndex, i);
            beginIndex = i + 1;
        }
    }
}

