/*
 * Decompiled with CFR 0.152.
 */
package framework.graphics;

import framework.Globals;
import framework.graphics.SimpleSprite;
import framework.utils.CharHashtable;
import framework.utils.resmgr.ResourcesManager;
import java.util.Enumeration;
import javax.microedition.lcdui.Graphics;

public final class TextRenderer {
    public static final byte DIRECTION_TOP_DOWN = 0;
    public static final byte DIRECTION_BOTTOM_UP = 1;
    private static TextRenderer instance;
    private static short resourcesPoolId;
    private static char[] languageCharacters;
    private SimpleSprite currentFont;
    private int xSpacing;
    private int ySpacing;
    public int lineSpacing;
    public int characterSpacing;
    private CharHashtable frameTable;
    private StringBuffer newBuff;
    public long lastTime = System.currentTimeMillis();
    boolean paintCursor = false;
    public int startPosition;

    private TextRenderer() {
        Object img = null;
        Enumeration keys = ResourcesManager.getInstance().getPoolKeys(resourcesPoolId);
        String keyName = "";
        do {
            if (!(keyName = (String)keys.nextElement()).regionMatches(true, 0, "FONT_", 0, 5)) continue;
            this.setCurrentFont(keyName);
        } while (keys.hasMoreElements() && this.currentFont == null);
        this.frameTable = new CharHashtable(languageCharacters.length);
        for (int i = 0; i < languageCharacters.length; ++i) {
            this.frameTable.put(languageCharacters[i], i);
            this.frameTable.put(Character.toUpperCase(languageCharacters[i]), i);
        }
        this.newBuff = new StringBuffer();
    }

    public static void setResourcesPoolId(short resourcesPoolId) {
        TextRenderer.resourcesPoolId = resourcesPoolId;
    }

    public static void setLanguageCharacters(char[] languageCharacters) {
        if (instance != null) {
            throw new RuntimeException("You only can invoke TextRenderer.setResourcesPoolId() before first use of TextRender!");
        }
        TextRenderer.languageCharacters = languageCharacters;
    }

    public static synchronized TextRenderer getInstance() {
        if (resourcesPoolId == -1) {
            throw new RuntimeException("You have to invoke TextRenderer.setResourcesPoolId() before calling TextRenderer for the first time.");
        }
        if (instance == null) {
            instance = new TextRenderer();
        }
        return instance;
    }

    public void setAdditionalSpacing(int xSpacing, int ySpacing) {
        this.xSpacing = xSpacing;
        this.ySpacing = ySpacing;
        this.computeSpacing();
    }

    public int getStringWidth(int charactersCount) {
        return this.characterSpacing * charactersCount;
    }

    public int getStringHeight(int linesCount) {
        return this.lineSpacing * linesCount;
    }

    public SimpleSprite getFont(String name) {
        return (SimpleSprite)ResourcesManager.getInstance().getResource(name, resourcesPoolId);
    }

    public void setCurrentFont(SimpleSprite fontSprite) {
        if (fontSprite != null) {
            this.currentFont = fontSprite;
            this.computeSpacing();
        } else {
            System.out.println("TextRenderer couldn't set font to <reference> : " + fontSprite);
        }
    }

    public SimpleSprite getCurrentFont() {
        return this.currentFont;
    }

    public void setCurrentFont(String name) {
        SimpleSprite fnt = (SimpleSprite)ResourcesManager.getInstance().getResource(name, resourcesPoolId);
        if (fnt == null) {
            throw new RuntimeException("TextRenderer couldn't change font to : " + name);
        }
        this.currentFont = fnt;
        this.computeSpacing();
    }

    public void renderText(Graphics graphics, int x, int y, StringBuffer buff) {
        for (int i = 0; i < buff.length(); ++i) {
            this.currentFont.paint(graphics, x, y, this.frameTable.get(buff.charAt(i)));
            x += this.characterSpacing;
        }
    }

    public void renderEditableText(Graphics graphics, int x, int y, int xEditedText, int yEditedText, StringBuffer buff, StringBuffer editedText, boolean lock, int cursorPosition, boolean password) {
        block8: {
            int i;
            block7: {
                this.startPosition = xEditedText;
                SimpleSprite tempFont = this.getCurrentFont();
                this.setCurrentFont("FONT_NORMAL");
                for (i = 0; i < buff.length(); ++i) {
                    this.currentFont.paint(graphics, x, y, this.frameTable.get(buff.charAt(i)));
                    x += this.characterSpacing;
                }
                this.currentFont = tempFont;
                if (!lock) break block7;
                for (i = 0; i < editedText.length(); ++i) {
                    this.currentFont.paint(graphics, xEditedText, yEditedText, this.frameTable.get(editedText.charAt(i)));
                    xEditedText += this.characterSpacing;
                }
                if ((int)(System.currentTimeMillis() - this.lastTime) > 400) {
                    this.paintCursor = !this.paintCursor;
                    this.lastTime = System.currentTimeMillis();
                }
                if (!this.paintCursor) break block8;
                this.currentFont.paint(graphics, this.startPosition + cursorPosition * this.characterSpacing, yEditedText + 2, this.frameTable.get('_'));
                break block8;
            }
            if (password) {
                for (i = 0; i < editedText.length(); ++i) {
                    this.currentFont.paint(graphics, xEditedText, yEditedText, this.frameTable.get('*'));
                    xEditedText += this.characterSpacing;
                }
            } else {
                for (i = 0; i < editedText.length(); ++i) {
                    this.currentFont.paint(graphics, xEditedText, yEditedText, this.frameTable.get(editedText.charAt(i)));
                    xEditedText += this.characterSpacing;
                }
            }
        }
    }

    public void renderTextVertical(Graphics g, int x, int y, StringBuffer buff, byte direction) {
        int length = buff.length();
        switch (direction) {
            case 1: {
                x = 320 - x - this.characterSpacing;
                for (int i = 0; i < length; ++i) {
                    this.currentFont.paint(g, y, x, this.frameTable.get(buff.charAt(i)), 6);
                    x -= this.characterSpacing;
                }
                break;
            }
            case 0: {
                y = 240 - y - this.characterSpacing - 1;
                for (int i = 0; i < length; ++i) {
                    this.currentFont.paint(g, y, x, this.frameTable.get(buff.charAt(i)), 5);
                    x += this.characterSpacing;
                }
                break;
            }
        }
    }

    public void renderTextCharBreak(Graphics graphics, int x, int y, int maxWidth, int maxHeight, StringBuffer buff) {
        int linesCount;
        int maxCharsInLine = maxWidth / this.characterSpacing;
        if (maxCharsInLine == 0 || linesCount == 0) {
            throw new RuntimeException("TextRenderer cannot render text : " + buff.toString());
        }
        int pos = 0;
        int tx = x;
        int buffLen = buff.length();
        int k = maxCharsInLine;
        for (linesCount = maxHeight / this.lineSpacing; linesCount > 0 && k != 0; --linesCount) {
            int i = 0;
            while (i < k) {
                this.currentFont.paint(graphics, x, y, this.frameTable.get(buff.charAt(pos)));
                x += this.characterSpacing;
                ++i;
                ++pos;
            }
            x = tx;
            y += this.lineSpacing;
            k = buffLen - pos;
            if (k <= maxCharsInLine) continue;
            k = maxCharsInLine;
        }
    }

    public int renderTextWordBreak(Graphics graphics, int x, int y, int maxWidth, int maxHeight, int lineNum, StringBuffer buff, boolean centerText) {
        int linesTotal;
        block24: {
            char c;
            int maxCharsInLine = maxWidth / this.characterSpacing;
            int linesCount = maxHeight / this.lineSpacing;
            if (maxCharsInLine == 0 || linesCount == 0) {
                throw new RuntimeException("TextRenderer cannot render text : " + buff.toString());
            }
            int i = 0;
            int pos = 0;
            int breakPos = 0;
            linesTotal = 1;
            int buffLen = buff.length();
            int wordLen = 0;
            int diff = 0;
            this.newBuff.setLength(0);
            if (buff.charAt(0) == ' ') {
                this.newBuff.append(' ');
                ++pos;
                ++i;
            }
            while (pos < buffLen) {
                c = buff.charAt(pos);
                if (c == ' ') {
                    wordLen = 0;
                    breakPos = pos;
                    if (i != 0 || pos == 0) {
                        this.newBuff.append(' ');
                    } else {
                        --diff;
                        --i;
                    }
                } else if (c == '\n') {
                    this.newBuff.append('\n');
                    wordLen = 0;
                    breakPos = pos + 1;
                    i = -1;
                    ++linesTotal;
                    while (pos + diff - 1 > 0 && this.newBuff.charAt(pos + diff - 1) == ' ') {
                        this.newBuff.deleteCharAt(pos + diff - 1);
                        --diff;
                    }
                } else {
                    this.newBuff.append(c);
                    ++wordLen;
                }
                if (i >= maxCharsInLine) {
                    while (breakPos + diff > 0 && breakPos + diff < this.newBuff.length() && this.newBuff.charAt(breakPos + diff) == ' ') {
                        this.newBuff.deleteCharAt(breakPos + diff);
                        --diff;
                    }
                    if (wordLen >= maxCharsInLine) {
                        this.newBuff.insert(pos + diff, '\n');
                        i = wordLen - maxCharsInLine;
                        wordLen -= maxCharsInLine;
                    } else {
                        this.newBuff.insert(breakPos + diff + 1, '\n');
                        i = wordLen;
                    }
                    breakPos = pos + ++diff + 1;
                    ++linesTotal;
                } else {
                    ++i;
                }
                ++pos;
            }
            if (graphics == null) break block24;
            int tx = x;
            pos = 0;
            buffLen = this.newBuff.length();
            while (lineNum > 0 && pos < buffLen) {
                if (this.newBuff.charAt(pos++) != '\n') continue;
                --lineNum;
            }
            if (centerText) {
                int len = 0;
                while (pos < buffLen && this.newBuff.charAt(pos) != '\n') {
                    ++len;
                    ++pos;
                }
                pos -= len;
                len = this.getStringWidth(len);
                int offx = maxWidth - len >> 1;
                x += offx;
                for (i = pos; i < this.newBuff.length() && linesCount > 0; ++i) {
                    c = this.newBuff.charAt(i);
                    if (c == '\n') {
                        len = 0;
                        for (pos = i + 1; pos < this.newBuff.length() && this.newBuff.charAt(pos) != '\n'; ++pos) {
                            ++len;
                        }
                        len = this.getStringWidth(len);
                        offx = maxWidth - len >> 1;
                        x = tx + offx;
                        y += this.lineSpacing;
                        --linesCount;
                        continue;
                    }
                    this.currentFont.paint(graphics, x, y, this.frameTable.get(c));
                    x += this.characterSpacing;
                }
            } else {
                for (i = pos; i < buffLen && linesCount > 0; ++i) {
                    c = this.newBuff.charAt(i);
                    if (c == '\n') {
                        x = tx;
                        y += this.lineSpacing;
                        --linesCount;
                        continue;
                    }
                    this.currentFont.paint(graphics, x, y, this.frameTable.get(c));
                    x += this.characterSpacing;
                }
            }
        }
        return linesTotal;
    }

    public void renderTextNewlineBreak(Graphics graphics, int x, int y, StringBuffer buff) {
        int tx = x;
        for (int i = 0; i < buff.length(); ++i) {
            char c = buff.charAt(i);
            if (c == '\n') {
                x = tx;
                y += this.lineSpacing;
                continue;
            }
            this.currentFont.paint(graphics, x, y, this.frameTable.get(c));
            x += this.characterSpacing;
        }
    }

    public int getWordBreakLinesCount(int maxWidth, int maxHeight, StringBuffer buff, boolean centerText) {
        return this.renderTextWordBreak(null, 0, 0, maxWidth, maxHeight, -1, buff, centerText);
    }

    public int getLineSpacing() {
        return this.lineSpacing;
    }

    public void destroy() {
        instance = null;
    }

    private void computeSpacing() {
        this.characterSpacing = this.currentFont.frameWidth + this.xSpacing - 1;
        this.lineSpacing = this.currentFont.frameHeight + this.ySpacing;
    }

    static {
        resourcesPoolId = (short)-1;
        languageCharacters = Globals.languageCharacters;
    }
}

