/*
 * Decompiled with CFR 0.152.
 */
package framework.math;

import framework.math.FP;
import framework.math.MathUtils;

public final class Vector2D {
    public int fp_x;
    public int fp_y;

    public Vector2D() {
        this.fp_x = FP.ZERO;
        this.fp_y = FP.ZERO;
    }

    public Vector2D(int fp_x, int fp_y) {
        this.fp_x = fp_x;
        this.fp_y = fp_y;
    }

    public Vector2D(Vector2D v) {
        this(v.fp_x, v.fp_y);
    }

    public final void setTo(Vector2D v) {
        this.fp_x = v.fp_x;
        this.fp_y = v.fp_y;
    }

    public final void setTo(int fp_x, int fp_y) {
        this.fp_x = fp_x;
        this.fp_y = fp_y;
    }

    public final void copyTo(Vector2D v) {
        v.fp_x = this.fp_x;
        v.fp_y = this.fp_y;
    }

    public final Vector2D clone() {
        return new Vector2D(this);
    }

    public final int getLength() {
        return MathUtils.sqrt((this.fp_x * this.fp_x >> FP.SHIFT) + (this.fp_y * this.fp_y >> FP.SHIFT));
    }

    public final int getLengthApprox1() {
        int fp_tmp_y;
        int fp_tmp_x = this.fp_x < 0 ? -this.fp_x : this.fp_x;
        int n = fp_tmp_y = this.fp_y < 0 ? -this.fp_y : this.fp_y;
        if (fp_tmp_x < fp_tmp_y) {
            int fp_t = fp_tmp_x + (fp_tmp_x >> 1);
            return fp_tmp_y - (fp_tmp_y >> 5) - (fp_tmp_y >> 7) + (fp_t >> 2) + (fp_t >> 6);
        }
        int fp_t = fp_tmp_y + (fp_tmp_y >> 1);
        return fp_tmp_x - (fp_tmp_x >> 5) - (fp_tmp_x >> 7) + (fp_t >> 2) + (fp_t >> 6);
    }

    public final int getLengthApprox2() {
        int fp_tmp_y;
        int fp_tmp_x = this.fp_x < 0 ? -this.fp_x : this.fp_x;
        int n = fp_tmp_y = this.fp_y < 0 ? -this.fp_y : this.fp_y;
        if (fp_tmp_x < fp_tmp_y) {
            return (MathUtils.fp_DIST_APPROX_CONST1 * fp_tmp_x >> FP.SHIFT) + (MathUtils.fp_DIST_APPROX_CONST2 * fp_tmp_y >> FP.SHIFT);
        }
        return (MathUtils.fp_DIST_APPROX_CONST2 * fp_tmp_x >> FP.SHIFT) + (MathUtils.fp_DIST_APPROX_CONST1 * fp_tmp_y >> FP.SHIFT);
    }

    public final int getSquaredLength() {
        return (this.fp_x * this.fp_x >> FP.SHIFT) + (this.fp_y * this.fp_y >> FP.SHIFT);
    }

    public final void normalize() {
        int fp_tmp = this.getLength();
        if (fp_tmp != 0) {
            this.fp_x = (this.fp_x << FP.SHIFT) / fp_tmp;
            this.fp_y = (this.fp_y << FP.SHIFT) / fp_tmp;
        } else {
            this.fp_x = 0;
            this.fp_y = 0;
        }
    }

    public final void normalize2() {
        int fp_tmp = this.getLength();
        if (fp_tmp != 0) {
            fp_tmp = (1 << (FP.SHIFT << 1)) / fp_tmp;
            this.fp_x = this.fp_x * fp_tmp >> FP.SHIFT;
            this.fp_y = this.fp_y * fp_tmp >> FP.SHIFT;
        } else {
            this.fp_x = 0;
            this.fp_y = 0;
        }
    }

    public final void normalizeApprox1() {
        int fp_tmp = this.getLengthApprox1();
        if (fp_tmp != 0) {
            this.fp_x = (this.fp_x << FP.SHIFT) / fp_tmp;
            this.fp_y = (this.fp_y << FP.SHIFT) / fp_tmp;
        } else {
            this.fp_x = 0;
            this.fp_y = 0;
        }
    }

    public final void normalizeApprox2() {
        int fp_tmp = this.getLengthApprox2();
        if (fp_tmp != 0) {
            this.fp_x = (this.fp_x << FP.SHIFT) / fp_tmp;
            this.fp_y = (this.fp_y << FP.SHIFT) / fp_tmp;
        } else {
            this.fp_x = 0;
            this.fp_y = 0;
        }
    }

    public final void add(Vector2D v) {
        this.fp_x += v.fp_x;
        this.fp_y += v.fp_y;
    }

    public final void sub(Vector2D v) {
        this.fp_x -= v.fp_x;
        this.fp_y -= v.fp_y;
    }

    public final void mul(int fp_alpha) {
        this.fp_x = this.fp_x * fp_alpha >> FP.SHIFT;
        this.fp_y = this.fp_y * fp_alpha >> FP.SHIFT;
    }

    public final void div(int fp_alpha) {
        this.fp_x = (this.fp_x << FP.SHIFT) / fp_alpha;
        this.fp_y = (this.fp_y << FP.SHIFT) / fp_alpha;
    }

    public final void add(int fp_x, int fp_y) {
        this.fp_x += fp_x;
        this.fp_y += fp_y;
    }

    public final void sub(int fp_x, int fp_y) {
        this.fp_x -= fp_x;
        this.fp_y -= fp_y;
    }

    public final int dotProduct(Vector2D v) {
        return (this.fp_x * v.fp_x >> FP.SHIFT) + (this.fp_y * v.fp_y >> FP.SHIFT);
    }

    public static final void add(Vector2D v1, Vector2D v2, Vector2D result) {
        result.fp_x = v1.fp_x + v2.fp_x;
        result.fp_y = v1.fp_y + v2.fp_y;
    }

    public static final void sub(Vector2D v1, Vector2D v2, Vector2D result) {
        result.fp_x = v1.fp_x - v2.fp_x;
        result.fp_y = v1.fp_y - v2.fp_y;
    }

    public static final void mul(Vector2D v, int fp_alpha, Vector2D result) {
        result.fp_x = fp_alpha * v.fp_x >> FP.SHIFT;
        result.fp_y = fp_alpha * v.fp_y >> FP.SHIFT;
    }

    public static final void div(Vector2D v, int fp_alpha, Vector2D result) {
        result.fp_x = (v.fp_x << FP.SHIFT) / fp_alpha;
        result.fp_y = (v.fp_y << FP.SHIFT) / fp_alpha;
    }

    public static final int dotProduct(Vector2D v1, Vector2D v2) {
        return (v1.fp_x * v2.fp_x >> FP.SHIFT) + (v1.fp_y * v2.fp_y >> FP.SHIFT);
    }

    public final void reverse() {
        this.fp_x = -this.fp_x;
        this.fp_y = -this.fp_y;
    }

    public final String toString() {
        return "[" + FP.toFloat(this.fp_x) + ", " + FP.toFloat(this.fp_y) + "]";
    }
}

