/*
 * Decompiled with CFR 0.152.
 */
package framework.menu;

import framework.Globals;
import framework.graphics.SimpleSprite;
import framework.graphics.TextRenderer;
import framework.menu.IMenuFormListener;
import framework.menu.MenuControl;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import menu.MenuBackground;
import root.RMSSettings;

public final class MenuForm {
    public static final byte KEYS_UPDOWN = 0;
    public static final byte KEYS_LEFTRIGHT = 1;
    public static final byte PIXEL_SPACING = 1;
    public static final byte PERCENTAGE_SPACING = 0;
    public static final byte AUTO_SPACING = -1;
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 4;
    public static final int TOP = 8;
    public static final int MIDDLE = 16;
    public static final int BOTTOM = 32;
    public static final int STATE_CONTROL_IDLE = 0;
    public static final int STATE_CONTROL_FOCUS = 1;
    public static final int STATE_CONTROL_PUSHED = 2;
    public static byte nextId = (byte)-1;
    public MenuControl[] controls;
    public Vector dynamicControls = new Vector();
    public int absoluteX = 0;
    public int absoluteY = 0;
    public IMenuFormListener listener;
    public byte id;
    private int lastAddedControl = -1;
    private int[] columnX;
    private int[] rowY;
    public int focusedID = -1;
    private byte activeControlKeys;
    private TextRenderer renderer;
    private int canvasWidth;
    private int canvasHeight;
    public int keyDelay = 300;
    public int fireDelay = 300;
    private int keyDelayTimer = this.keyDelay;
    private int fireDelayTimer = this.fireDelay;
    private boolean isFormDynamic;
    public int visibleRowCount;
    private int fpRC = 0;
    public boolean blockKeysInHandleInput = false;
    public boolean isUpdateAplicable = false;
    private long lastTime = System.currentTimeMillis();
    private boolean newCharAdded = false;
    private int TIME_GAP = 800;
    private char[] charsNum0 = new char[]{'0'};
    private char[] charsNum1 = new char[]{'1'};
    private char[] charsNum1WithAt = new char[]{'?', '.', '1'};
    private char[] charsNum2 = new char[]{'A', 'B', 'C', '2'};
    private char[] charsNum3 = new char[]{'D', 'E', 'F', '3'};
    private char[] charsNum4 = new char[]{'G', 'H', 'I', '4'};
    private char[] charsNum5 = new char[]{'J', 'K', 'L', '5'};
    private char[] charsNum6 = new char[]{'M', 'N', 'O', '6'};
    private char[] charsNum7 = new char[]{'P', 'Q', 'R', 'S', '7'};
    private char[] charsNum8 = new char[]{'T', 'U', 'V', '8'};
    private char[] charsNum9 = new char[]{'W', 'X', 'Y', 'Z', '9'};
    private int lastKey = -1;
    private int charIndex = 0;
    private char currentChar;
    private boolean blockKeyRepeated = false;
    private int keyReleasedTime = 0;
    private int lastTimeKeyRepeated;
    private boolean keyRepeated = false;
    private int displayType = 4;
    char atSign = (char)63;
    char dotSign = (char)46;
    int atCount = 0;

    private MenuForm(byte ID, int controlCount, int[] rowSpacing, int[] columnSpacing, int canvasWidth, int canvasHeight, byte settingsFlag, byte activeControlKeys, int visibleRowCount, boolean isDynamic) {
        int i = 0;
        int partSum = 0;
        int tempSum = 0;
        int defaultCount = 0;
        int defaultSize = 0;
        this.isFormDynamic = isDynamic;
        this.canvasHeight = canvasHeight;
        this.canvasWidth = canvasWidth;
        this.renderer = TextRenderer.getInstance();
        this.id = ID;
        if (!this.isFormDynamic) {
            this.controls = new MenuControl[controlCount];
        }
        this.rowY = new int[rowSpacing.length];
        this.columnX = new int[columnSpacing.length];
        this.activeControlKeys = activeControlKeys;
        this.visibleRowCount = visibleRowCount;
        for (i = 0; i < rowSpacing.length; ++i) {
            if (settingsFlag == 0 && rowSpacing[i] > 100) {
                throw new RuntimeException("Bad percent: " + rowSpacing[i]);
            }
            if (rowSpacing[i] > 0) {
                this.rowY[i] = settingsFlag == 0 ? canvasHeight * rowSpacing[i] / 100 : rowSpacing[i];
                partSum += this.rowY[i];
                continue;
            }
            ++defaultCount;
        }
        if (defaultCount > 0) {
            defaultSize = (canvasHeight - partSum) / defaultCount;
        }
        partSum = 0;
        for (i = 0; i < rowSpacing.length; ++i) {
            if (rowSpacing[i] > 0) {
                tempSum = this.rowY[i];
                this.rowY[i] = partSum;
                partSum += tempSum;
                continue;
            }
            this.rowY[i] = partSum;
            partSum += defaultSize;
        }
        defaultCount = canvasHeight - partSum;
        int n = this.rowY.length - 1;
        this.rowY[n] = this.rowY[n] + defaultCount;
        partSum = 0;
        defaultCount = 0;
        defaultSize = 0;
        tempSum = 0;
        for (i = 0; i < columnSpacing.length; ++i) {
            if (settingsFlag == 0 && columnSpacing[i] > 100) {
                throw new RuntimeException("Bad percent: " + columnSpacing[i]);
            }
            if (columnSpacing[i] > 0) {
                this.columnX[i] = settingsFlag == 0 ? canvasWidth * columnSpacing[i] / 100 : columnSpacing[i];
                partSum += this.columnX[i];
                continue;
            }
            ++defaultCount;
        }
        if (defaultCount > 0) {
            defaultSize = (canvasWidth - partSum) / defaultCount;
        }
        partSum = 0;
        tempSum = 0;
        for (i = 0; i < columnSpacing.length; ++i) {
            if (columnSpacing[i] > 0) {
                tempSum = this.columnX[i];
                this.columnX[i] = partSum;
                partSum += tempSum;
                continue;
            }
            this.columnX[i] = partSum;
            partSum += defaultSize;
        }
        defaultCount = canvasWidth - partSum;
        int n2 = this.columnX.length - 1;
        this.columnX[n2] = this.columnX[n2] + defaultCount;
    }

    public static MenuForm createMenuForm(int controlCount, int[] rowSpacing, int[] columnsSpacing, int canvasWidth, int canvasHeight, byte settingsFlag, byte activeControlKeys) {
        nextId = (byte)(nextId + 1);
        return new MenuForm(nextId, controlCount, rowSpacing, columnsSpacing, canvasWidth, canvasHeight, settingsFlag, activeControlKeys, 0, false);
    }

    public static MenuForm createMenuForm(int controlCount, int[] rowSpacing, int[] columnsSpacing, int canvasWidth, int canvasHeight, byte settingsFlag, byte activeControlKeys, int visibleRowCount) {
        nextId = (byte)(nextId + 1);
        return new MenuForm(nextId, controlCount, rowSpacing, columnsSpacing, canvasWidth, canvasHeight, settingsFlag, activeControlKeys, visibleRowCount, false);
    }

    public static MenuForm createDynamicMenuForm(int[] rowSpacing, int[] columnsSpacing, int canvasWidth, int canvasHeight, byte settingsFlag, byte activeControlKeys, int visibleRowCount) {
        nextId = (byte)(nextId + 1);
        return new MenuForm(nextId, 0, rowSpacing, columnsSpacing, canvasWidth, canvasHeight, settingsFlag, activeControlKeys, visibleRowCount, true);
    }

    public void CleanDynamicControls() {
        this.dynamicControls.removeAllElements();
        this.lastAddedControl = -1;
    }

    public int createControl(int type, int width, int height, int tabOrder, int row, int column, int cellAlignment, int textAlignment, SimpleSprite images, StringBuffer text, int textPadding, int cellPadding, StringBuffer editableText, boolean onlyNumericKeys, boolean emailValidation, boolean loginInput) {
        int controlId = this.createControl(type, width, height, tabOrder, row, column, cellAlignment, textAlignment, images, text, textPadding, cellPadding);
        this.controls[this.lastAddedControl].tempEditableText = editableText;
        this.controls[this.lastAddedControl].editableText = new StringBuffer(editableText.toString());
        this.controls[this.lastAddedControl].cursorPosition = editableText.length();
        this.controls[this.lastAddedControl].onlyNumericKeys = onlyNumericKeys;
        this.controls[this.lastAddedControl].emailValidation = emailValidation;
        this.controls[this.lastAddedControl].loginInput = loginInput;
        try {
            if (onlyNumericKeys && emailValidation) {
                throw new Exception("Can't create email validation control with only numeric keys enabled");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return controlId;
    }

    public int createControl(int type, int width, int height, int tabOrder, int row, int column, int cellAlignment, int textAlignment, SimpleSprite images, StringBuffer text, int textPadding, int cellPadding) {
        ++this.lastAddedControl;
        if (!this.isFormDynamic && this.lastAddedControl >= this.controls.length) {
            throw new RuntimeException("More controls added the declared!!");
        }
        MenuControl newControl = new MenuControl();
        newControl.type = type;
        newControl.tabOrder = tabOrder;
        newControl.textAlignment = textAlignment;
        newControl.image = images;
        newControl.setText(text);
        newControl.setVisible(true);
        newControl.state = 0;
        newControl.textPadding = textPadding;
        newControl.width = width;
        newControl.height = height;
        newControl.anchor = 0;
        if (this.visibleRowCount != 0 && row >= this.rowY.length) {
            row = this.rowY.length - 1;
        }
        if ((cellAlignment & 8) != 0) {
            newControl.relativeY = this.rowY[row] + cellPadding;
            newControl.anchor |= 0x10;
        } else if ((cellAlignment & 0x10) != 0) {
            newControl.relativeY = row < this.rowY.length - 1 ? this.rowY[row] + (this.rowY[row + 1] - this.rowY[row]) / 2 : this.rowY[row] + (this.canvasHeight - this.rowY[row]) / 2;
            newControl.anchor |= 2;
        } else if ((cellAlignment & 0x20) != 0) {
            newControl.relativeY = row < this.rowY.length - 1 ? this.rowY[row] + (this.rowY[row + 1] - this.rowY[row]) - cellPadding : this.rowY[row] + (this.canvasHeight - this.rowY[row]) - cellPadding;
            newControl.anchor |= 0x20;
        }
        if ((cellAlignment & 1) != 0) {
            newControl.relativeX = this.columnX[column] + cellPadding;
            newControl.anchor |= 4;
        } else if ((cellAlignment & 2) != 0) {
            newControl.relativeX = column < this.columnX.length - 1 ? this.columnX[column] + (this.columnX[column + 1] - this.columnX[column] >> 1) : this.columnX[column] + (this.canvasWidth - this.columnX[column] >> 1);
            newControl.anchor |= 1;
        } else if ((cellAlignment & 4) != 0) {
            newControl.relativeX = column < this.columnX.length - 1 ? this.columnX[column] + (this.columnX[column + 1] - this.columnX[column]) - cellPadding : this.canvasWidth - cellPadding;
            newControl.anchor |= 8;
        }
        if (type != 6 && type != 1 && type != 7 && type != 8 && type != 9) {
            newControl.calculatePositions(this.absoluteX, this.absoluteY, this.renderer);
        }
        if (tabOrder == 0 && this.focusedID < 0) {
            this.focusedID = this.lastAddedControl;
            newControl.state = 1;
        }
        if (this.isFormDynamic) {
            this.dynamicControls.addElement(newControl);
        } else {
            this.controls[this.lastAddedControl] = newControl;
        }
        this.setRendererFonts(this.lastAddedControl, "FONT_NORMAL", "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED_2");
        return this.lastAddedControl;
    }

    public MenuControl getControlByID(int ID) {
        if (ID >= 0 && ID < this.GetControlsLength()) {
            if (this.isFormDynamic) {
                return (MenuControl)this.dynamicControls.elementAt(ID);
            }
            return this.controls[ID];
        }
        if (this.isFormDynamic) {
            if (this.focusedID > 0) {
                --this.focusedID;
                System.out.println("ZADZIALALO AUTOMATYCZNE ZMNIEJSZANIE focusedID W DYNAMICZNYCH KONTROLKACH");
                return this.getControlByID(this.focusedID);
            }
            System.out.println("odwolanie do nie istniejacej kontrolki");
            return null;
        }
        System.out.println("odwolanie do nie istniejacej kontrolki");
        return null;
    }

    public int GetControlsLength() {
        if (this.isFormDynamic) {
            return this.dynamicControls.size();
        }
        return this.controls.length;
    }

    public void update(int deltaTime) {
        this.keyDelayTimer -= deltaTime;
        if (this.keyDelayTimer < 0) {
            this.keyDelayTimer = 0;
        }
        this.fireDelayTimer -= deltaTime;
        if (this.fireDelayTimer < 0) {
            this.fireDelayTimer = 0;
        }
        if (this.blockKeysInHandleInput && this.newCharAdded) {
            if ((int)(System.currentTimeMillis() - this.lastTime) > this.TIME_GAP && this.getControlByID((int)this.focusedID).cursorPosition <= this.getControlByID((int)this.focusedID).editableText.length() - 1) {
                ++this.getControlByID((int)this.focusedID).cursorPosition;
                this.newCharAdded = false;
            }
            this.keyRepeated = false;
        }
        if (this.isUpdateAplicable && this.focusedID >= 0 && this.getControlByID(this.focusedID) != null) {
            if (this.getControlByID((int)this.focusedID).status == 10) {
                if (this.getControlByID(this.focusedID).getType() == 7 || this.getControlByID(this.focusedID).getType() == 8) {
                    if (this.getControlByID((int)this.focusedID).cursorPosition < 1 && this.getControlByID((int)this.focusedID).editableText.length() == 0) {
                        MenuBackground.GetInstance().setSwitchBackroundBackButton(false);
                    } else {
                        MenuBackground.GetInstance().setSwitchBackroundBackButton(true);
                    }
                } else if (this.getControlByID(this.focusedID).getType() == 9) {
                    if (this.getControlByID((int)this.focusedID).cursorPosition < 2 && this.getControlByID((int)this.focusedID).editableText.length() == 1) {
                        MenuBackground.GetInstance().setSwitchBackroundBackButton(false);
                    } else {
                        MenuBackground.GetInstance().setSwitchBackroundBackButton(true);
                    }
                }
            } else {
                MenuBackground.GetInstance().setSwitchBackroundBackButton(false);
            }
        }
    }

    public void handleEdit() {
        if (this.focusedID >= 0) {
            if (this.getControlByID(this.focusedID).getType() == 7 || this.getControlByID(this.focusedID).getType() == 8 || this.getControlByID(this.focusedID).getType() == 9) {
                if (this.getControlByID(this.focusedID).getStatus() == 10) {
                    if (this.getControlByID((int)this.focusedID).emailValidation) {
                        this.validateEmail(this.getControlByID((int)this.focusedID).editableText);
                    } else {
                        this.getControlByID(this.focusedID).setStatus(20);
                    }
                    this.getControlByID((int)this.focusedID).tempEditableText.setLength(0);
                    this.getControlByID((int)this.focusedID).tempEditableText.append((Object)this.getControlByID((int)this.focusedID).editableText);
                } else {
                    this.getControlByID(this.focusedID).setStatus(10);
                    this.blockKeysInHandleInput = true;
                }
            }
            if (this.getControlByID(this.focusedID).getType() == 8) {
                if (this.getControlByID((int)this.focusedID).status == 10) {
                    this.getControlByID((int)this.focusedID).editableText.delete(0, this.getControlByID((int)this.focusedID).editableText.length());
                    this.getControlByID((int)this.focusedID).cursorPosition = 0;
                } else if (Globals.SAVE_PASSWORD) {
                    RMSSettings.saveRecords();
                }
            } else if ((this.getControlByID(this.focusedID).getType() == 7 || this.getControlByID(this.focusedID).getType() == 9) && this.getControlByID((int)this.focusedID).status == 20) {
                RMSSettings.saveRecords();
            }
        }
    }

    public boolean validateEmail(StringBuffer email) {
        char[] array = email.toString().toCharArray();
        if (array[0] == this.atSign || array[0] == this.dotSign) {
            this.switchControlsVisibility(false, true, new StringBuffer("Illegal email start . or @"));
            return false;
        }
        if (array[array.length - 1] == this.atSign || array[array.length - 1] == this.dotSign) {
            this.switchControlsVisibility(false, true, new StringBuffer("Illegal email end . or @"));
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == this.atSign) {
                ++this.atCount;
            }
            if (i <= 2) continue;
            if (array[i - 1] == this.dotSign && array[i] == this.atSign) {
                this.switchControlsVisibility(false, true, new StringBuffer("Illegal sequence .@"));
                return false;
            }
            if (array[i - 1] == this.dotSign && array[i] == this.dotSign) {
                this.switchControlsVisibility(false, true, new StringBuffer("Illegal sequence .."));
                return false;
            }
            if (array[i - 1] != this.atSign || array[i] != this.dotSign) continue;
            this.switchControlsVisibility(false, true, new StringBuffer("Illegal sequence @."));
            return false;
        }
        if (this.atCount != 1) {
            this.switchControlsVisibility(false, true, new StringBuffer("More then one @"));
            return false;
        }
        return true;
    }

    public void handleInput(int keyStates) {
        int index = -1;
        if (!this.blockKeysInHandleInput) {
            if ((keyStates & 0x100) != 0) {
                if (this.fireDelayTimer <= 0) {
                    if (this.focusedID >= 0) {
                        this.getControlByID((int)this.focusedID).state = 2;
                    }
                    if (this.listener != null) {
                        this.listener.notifyKeypressed(this.id, this.focusedID);
                    }
                    this.fireDelayTimer = this.fireDelay;
                }
            } else {
                if (this.activeControlKeys == 0) {
                    if ((keyStates & 0x40) != 0) {
                        if (this.keyDelayTimer <= 0) {
                            index = this.getNextInOrder(this.focusedID, true);
                            this.keyDelayTimer = this.keyDelay;
                        }
                    } else if ((keyStates & 2) != 0 && this.keyDelayTimer <= 0) {
                        index = this.getNextInOrder(this.focusedID, false);
                        this.keyDelayTimer = this.keyDelay;
                    }
                } else if ((keyStates & 4) != 0) {
                    if (this.keyDelayTimer <= 0) {
                        index = this.getNextInOrder(this.focusedID, false);
                        this.keyDelayTimer = this.keyDelay;
                    }
                } else if ((keyStates & 0x20) != 0 && this.keyDelayTimer <= 0) {
                    index = this.getNextInOrder(this.focusedID, true);
                    this.keyDelayTimer = this.keyDelay;
                }
                if (index >= 0) {
                    if (this.focusedID >= 0) {
                        this.getControlByID((int)this.focusedID).state = 0;
                    }
                    this.getControlByID((int)index).state = 1;
                    this.focusedID = index;
                }
            }
        }
    }

    public void setChar(char[] chars, int keyCode) {
        if (this.checkForShowMessageBox()) {
            return;
        }
        this.charIndex = this.lastKey != keyCode ? 0 : ++this.charIndex;
        if (this.charIndex >= chars.length) {
            this.charIndex = 0;
        }
        if ((int)(System.currentTimeMillis() - this.lastTime) > this.TIME_GAP) {
            if (this.lastKey == keyCode) {
                this.charIndex = 0;
            }
        } else if ((this.lastKey != keyCode || this.getControlByID((int)this.focusedID).onlyNumericKeys) && this.getControlByID((int)this.focusedID).cursorPosition <= this.getControlByID((int)this.focusedID).editableText.length() - 1) {
            ++this.getControlByID((int)this.focusedID).cursorPosition;
        }
        this.currentChar = this.getControlByID((int)this.focusedID).onlyNumericKeys ? chars[chars.length - 1] : chars[this.charIndex];
        if ((int)(System.currentTimeMillis() - this.lastTime) > this.TIME_GAP) {
            if (this.getControlByID((int)this.focusedID).cursorPosition > this.getControlByID((int)this.focusedID).editableText.length() - 1) {
                this.getControlByID((int)this.focusedID).editableText.append(this.currentChar);
                this.checkForHideMessageBox();
                this.newCharAdded = true;
            } else {
                this.getControlByID((int)this.focusedID).editableText.setCharAt(this.getControlByID((int)this.focusedID).cursorPosition, this.currentChar);
                this.checkForHideMessageBox();
                this.newCharAdded = true;
            }
        } else if (this.lastKey != keyCode || this.getControlByID((int)this.focusedID).onlyNumericKeys) {
            if (this.getControlByID((int)this.focusedID).cursorPosition > this.getControlByID((int)this.focusedID).editableText.length() - 1) {
                if (this.checkForShowMessageBox()) {
                    return;
                }
                this.getControlByID((int)this.focusedID).editableText.append(this.currentChar);
                this.checkForHideMessageBox();
            } else {
                this.getControlByID((int)this.focusedID).editableText.setCharAt(this.getControlByID((int)this.focusedID).cursorPosition - 1, this.currentChar);
                this.checkForHideMessageBox();
            }
        } else if (this.getControlByID((int)this.focusedID).cursorPosition == 0 && this.getControlByID((int)this.focusedID).editableText.length() == 0) {
            this.getControlByID((int)this.focusedID).editableText.append(this.currentChar);
        } else {
            this.getControlByID((int)this.focusedID).editableText.setCharAt(this.getControlByID((int)this.focusedID).cursorPosition, this.currentChar);
        }
        this.lastTime = System.currentTimeMillis();
        this.lastKey = keyCode;
    }

    public void moveCursorPosition(int keyCode, int offset) {
        if (keyCode == -3) {
            if (this.getControlByID((int)this.focusedID).cursorPosition > offset) {
                this.newCharAdded = false;
                --this.getControlByID((int)this.focusedID).cursorPosition;
            }
        } else if (keyCode == -4 && this.getControlByID((int)this.focusedID).cursorPosition <= this.getControlByID((int)this.focusedID).editableText.length() - 1) {
            this.newCharAdded = false;
            ++this.getControlByID((int)this.focusedID).cursorPosition;
        }
    }

    public void setChar(char c) {
        if (this.checkForShowMessageBox()) {
            return;
        }
        if (this.getControlByID((int)this.focusedID).cursorPosition > this.getControlByID((int)this.focusedID).editableText.length()) {
            this.getControlByID((int)this.focusedID).editableText.append(c);
            this.checkForHideMessageBox();
        } else {
            this.getControlByID((int)this.focusedID).editableText.setCharAt(this.getControlByID((int)this.focusedID).cursorPosition, c);
            this.checkForHideMessageBox();
        }
        this.newCharAdded = true;
        this.blockKeyRepeated = true;
    }

    public void keyReleased(int keyCode) {
        if (this.blockKeysInHandleInput) {
            if (this.checkForShowMessageBox()) {
                return;
            }
            this.keyReleasedTime = (int)(System.currentTimeMillis() - this.lastTime);
            if (keyCode != -7 && keyCode != -8 && keyCode != -3 && keyCode != -4) {
                if (this.keyReleasedTime <= this.TIME_GAP) {
                    if (!this.blockKeyRepeated) {
                        this.newCharAdded = true;
                    }
                } else if (this.keyRepeated && this.lastTimeKeyRepeated <= this.TIME_GAP) {
                    this.newCharAdded = true;
                }
            }
        }
    }

    public void keyRepeated(int keyCode) {
        if (this.blockKeysInHandleInput) {
            this.keyRepeated = true;
            if (!this.blockKeyRepeated) {
                this.newCharAdded = false;
                this.lastTimeKeyRepeated = (int)(System.currentTimeMillis() - this.lastTime);
                if (this.lastTimeKeyRepeated > this.TIME_GAP) {
                    switch (keyCode) {
                        case 48: {
                            this.setChar(this.charsNum0[this.charsNum0.length - 1]);
                            break;
                        }
                        case 49: {
                            this.setChar(this.charsNum1[this.charsNum1.length - 1]);
                            break;
                        }
                        case 50: {
                            this.setChar(this.charsNum2[this.charsNum2.length - 1]);
                            break;
                        }
                        case 51: {
                            this.setChar(this.charsNum3[this.charsNum3.length - 1]);
                            break;
                        }
                        case 52: {
                            this.setChar(this.charsNum4[this.charsNum4.length - 1]);
                            break;
                        }
                        case 53: {
                            this.setChar(this.charsNum5[this.charsNum5.length - 1]);
                            break;
                        }
                        case 54: {
                            this.setChar(this.charsNum6[this.charsNum6.length - 1]);
                            break;
                        }
                        case 55: {
                            this.setChar(this.charsNum7[this.charsNum7.length - 1]);
                            break;
                        }
                        case 56: {
                            this.setChar(this.charsNum8[this.charsNum8.length - 1]);
                            break;
                        }
                        case 57: {
                            this.setChar(this.charsNum9[this.charsNum9.length - 1]);
                            break;
                        }
                        case -8: 
                        case -7: {
                            this.newCharAdded = false;
                            this.checkForShowMessageBox();
                            if (this.getControlByID(this.focusedID).getType() == 9) {
                                this.handleClear(1);
                                break;
                            }
                            this.handleClear(0);
                            break;
                        }
                        case -4: 
                        case -3: {
                            if (this.getControlByID(this.focusedID).getType() == 9) {
                                this.moveCursorPosition(keyCode, 1);
                                break;
                            }
                            this.moveCursorPosition(keyCode, 0);
                        }
                    }
                }
            }
        }
    }

    public void handleClear(int offset) {
        if (this.getControlByID((int)this.focusedID).editableText.length() > offset) {
            if (this.getControlByID((int)this.focusedID).cursorPosition == offset) {
                this.getControlByID((int)this.focusedID).editableText.deleteCharAt(this.getControlByID((int)this.focusedID).cursorPosition);
            } else {
                this.getControlByID((int)this.focusedID).editableText.deleteCharAt(this.getControlByID((int)this.focusedID).cursorPosition - 1);
            }
        }
        if (this.getControlByID((int)this.focusedID).cursorPosition > offset) {
            --this.getControlByID((int)this.focusedID).cursorPosition;
        }
    }

    public boolean handleStopEdit(int offset) {
        if (this.getControlByID((int)this.focusedID).editableText.length() == offset) {
            this.getControlByID((int)this.focusedID).editableText = new StringBuffer(this.getControlByID((int)this.focusedID).tempEditableText.toString());
            this.switchControlsVisibility(true, true, null);
            this.blockKeysInHandleInput = false;
            this.handleEdit();
            return true;
        }
        return false;
    }

    public boolean checkForShowMessageBox() {
        if (this.getControlByID(this.focusedID).getType() == 7) {
            if (this.getControlByID((int)this.focusedID).cursorPosition >= Globals.MAX_LOGIN_CHARACTERS) {
                this.switchControlsVisibility(false, true, Globals.LOGIN_MAX_LENGTH);
                return true;
            }
            if (this.getControlByID((int)this.focusedID).cursorPosition + 1 == Globals.MAX_LOGIN_CHARACTERS) {
                this.switchControlsVisibility(true, true, null);
                return false;
            }
        } else if (this.getControlByID(this.focusedID).getType() == 8) {
            if (this.getControlByID((int)this.focusedID).cursorPosition >= Globals.MAX_PASSWORD_CHARACTERS) {
                this.switchControlsVisibility(false, true, Globals.PASSWORD_MAX_LENGTH);
                return true;
            }
            if (this.getControlByID((int)this.focusedID).cursorPosition + 1 == Globals.MAX_PASSWORD_CHARACTERS) {
                this.switchControlsVisibility(true, true, null);
                return false;
            }
        } else if (this.getControlByID(this.focusedID).getType() == 9) {
            if (this.getControlByID((int)this.focusedID).cursorPosition >= Globals.MAX_PHONE_NUMBER_CHARACTERS) {
                this.switchControlsVisibility(false, true, Globals.PHONE_NUMBER_OK);
                return true;
            }
            if (this.getControlByID((int)this.focusedID).cursorPosition + 1 == Globals.MAX_PHONE_NUMBER_CHARACTERS) {
                this.switchControlsVisibility(true, true, null);
                return false;
            }
        }
        return false;
    }

    public void checkForHideMessageBox() {
        if (this.getControlByID(this.focusedID).getInfoText() != null) {
            if (this.getControlByID(this.focusedID).getType() == 7) {
                if (this.getControlByID((int)this.focusedID).cursorPosition < Globals.MIN_LOGIN_CHARACTERS && this.getControlByID((int)this.focusedID).cursorPosition + 1 == Globals.MIN_LOGIN_CHARACTERS) {
                    this.switchControlsVisibility(true, true, null);
                }
            } else if (this.getControlByID(this.focusedID).getType() == 8 && this.getControlByID((int)this.focusedID).cursorPosition < Globals.MIN_PASSWORD_CHARACTERS && this.getControlByID((int)this.focusedID).cursorPosition + 1 == Globals.MIN_PASSWORD_CHARACTERS) {
                this.switchControlsVisibility(true, true, null);
            }
        }
    }

    public void switchControlsVisibility(boolean allControlsVisible, boolean hideOnlyLowerControls, StringBuffer text) {
        this.getControlByID(this.focusedID).setInfoText(text);
        for (int i = 0; i < this.GetControlsLength(); ++i) {
            if (hideOnlyLowerControls) {
                if (i <= this.focusedID) continue;
                this.getControlByID(i).setVisible(allControlsVisible);
                continue;
            }
            if (i == this.focusedID) continue;
            this.getControlByID(i).setVisible(allControlsVisible);
        }
    }

    public void keyPressed(int keyCode) {
        if (this.blockKeysInHandleInput) {
            this.blockKeyRepeated = false;
            this.keyRepeated = false;
            switch (keyCode) {
                case 48: {
                    this.setChar(this.charsNum0, keyCode);
                    break;
                }
                case 49: {
                    if (this.getControlByID((int)this.focusedID).emailValidation) {
                        this.setChar(this.charsNum1WithAt, keyCode);
                        break;
                    }
                    this.setChar(this.charsNum1, keyCode);
                    break;
                }
                case 50: {
                    this.setChar(this.charsNum2, keyCode);
                    break;
                }
                case 51: {
                    this.setChar(this.charsNum3, keyCode);
                    break;
                }
                case 52: {
                    this.setChar(this.charsNum4, keyCode);
                    break;
                }
                case 53: {
                    this.setChar(this.charsNum5, keyCode);
                    break;
                }
                case 54: {
                    this.setChar(this.charsNum6, keyCode);
                    break;
                }
                case 55: {
                    this.setChar(this.charsNum7, keyCode);
                    break;
                }
                case 56: {
                    this.setChar(this.charsNum8, keyCode);
                    break;
                }
                case 57: {
                    this.setChar(this.charsNum9, keyCode);
                    break;
                }
                case -7: {
                    if (this.getControlByID(this.focusedID).getType() == 9 ? this.handleStopEdit(1) : this.handleStopEdit(0)) break;
                }
                case -8: {
                    this.newCharAdded = false;
                    if (this.getControlByID(this.focusedID).getType() == 9) {
                        this.handleClear(1);
                        break;
                    }
                    this.handleClear(0);
                    break;
                }
                case -4: 
                case -3: {
                    if (this.getControlByID(this.focusedID).getType() == 9) {
                        this.moveCursorPosition(keyCode, 1);
                        break;
                    }
                    this.moveCursorPosition(keyCode, 0);
                    break;
                }
                case -6: 
                case -5: 
                case -2: 
                case -1: {
                    if (this.getControlByID(this.focusedID).getType() == 7) {
                        if (this.getControlByID((int)this.focusedID).editableText.length() >= Globals.MIN_LOGIN_CHARACTERS && this.getControlByID((int)this.focusedID).editableText.length() <= Globals.MAX_LOGIN_CHARACTERS) {
                            this.switchControlsVisibility(true, true, null);
                            this.blockKeysInHandleInput = false;
                            this.handleEdit();
                            break;
                        }
                        if (this.getControlByID((int)this.focusedID).editableText.length() < Globals.MIN_LOGIN_CHARACTERS) {
                            this.switchControlsVisibility(false, true, Globals.LOGIN_MIN_LENGTH);
                            break;
                        }
                        if (this.getControlByID((int)this.focusedID).editableText.length() <= Globals.MAX_LOGIN_CHARACTERS) break;
                        this.switchControlsVisibility(false, true, Globals.LOGIN_MAX_LENGTH);
                        break;
                    }
                    if (this.getControlByID(this.focusedID).getType() == 8) {
                        if (this.getControlByID((int)this.focusedID).editableText.length() >= Globals.MIN_PASSWORD_CHARACTERS && this.getControlByID((int)this.focusedID).editableText.length() <= Globals.MAX_PASSWORD_CHARACTERS) {
                            this.switchControlsVisibility(true, true, null);
                            this.blockKeysInHandleInput = false;
                            this.handleEdit();
                            break;
                        }
                        if (this.getControlByID((int)this.focusedID).editableText.length() < Globals.MIN_PASSWORD_CHARACTERS) {
                            this.switchControlsVisibility(false, true, Globals.PASSWORD_MIN_LENGTH);
                            break;
                        }
                        if (this.getControlByID((int)this.focusedID).editableText.length() <= Globals.MAX_PASSWORD_CHARACTERS) break;
                        this.switchControlsVisibility(false, true, Globals.PASSWORD_MAX_LENGTH);
                        break;
                    }
                    if (this.getControlByID(this.focusedID).getType() != 9) break;
                    this.switchControlsVisibility(true, true, null);
                    this.blockKeysInHandleInput = false;
                    this.handleEdit();
                }
            }
        }
    }

    private int getNextInOrder(int focused, boolean direction) {
        int search = 0;
        int minTab = 100;
        int maxTab = 0;
        int maxID = 0;
        int minID = 0;
        int i = 0;
        search = focused >= 0 && focused < this.GetControlsLength() ? this.getControlByID((int)focused).tabOrder : -1;
        for (i = 0; i < this.GetControlsLength(); ++i) {
            if (this.getControlByID((int)i).tabOrder > maxTab) {
                maxTab = this.getControlByID((int)i).tabOrder;
                maxID = i;
            }
            if (this.getControlByID((int)i).tabOrder != -1 && this.getControlByID((int)i).tabOrder < minTab) {
                minTab = this.getControlByID((int)i).tabOrder;
                minID = i;
            }
            if (direction && this.getControlByID((int)i).tabOrder == search + 1 && search >= 0) {
                return i;
            }
            if (direction || search == 0 || this.getControlByID((int)i).tabOrder != search - 1 || search < 0) continue;
            return i;
        }
        if (this.focusedID < 0 && search < 0) {
            return -1;
        }
        if (this.focusedID < 0 || search < 0) {
            return minID;
        }
        if (!direction && search == 0) {
            if (this.visibleRowCount != 0) {
                return this.focusedID;
            }
            return maxID;
        }
        if (direction && search == maxTab) {
            if (this.visibleRowCount != 0) {
                return this.focusedID;
            }
            return minID;
        }
        return minID;
    }

    public int createControl(int type, int tabOrder, int row, int column, SimpleSprite images, StringBuffer text) {
        return this.createControl(type, 0, 0, tabOrder, row, column, 18, 18, images, text, 0, 0);
    }

    public int createTextBox(int width, int height, int tabOrder, int row, int column, int cellAlignment, int textAlignment, StringBuffer text, int textPadding) {
        int newID = this.createControl(1, width, height, tabOrder, row, column, cellAlignment, textAlignment, null, text, 0, textPadding);
        int lines = 1;
        try {
            lines = this.renderer.getWordBreakLinesCount(width, height, text, (textAlignment & 2) != 0);
        }
        catch (Exception e) {
            System.out.println("TextBox area is to small to render text!" + e.toString());
        }
        if (lines < 1) {
            lines = 1;
        }
        this.getControlByID((int)newID).lineCount = lines;
        this.getControlByID(newID).calculatePositions(this.absoluteX, this.absoluteY, this.renderer);
        return newID;
    }

    public int createEditableControl(int type, int tabOrder, int row, int column, StringBuffer text, StringBuffer editableText) {
        boolean loginInput;
        boolean emailValidation;
        boolean onlyNumericKeys;
        this.isUpdateAplicable = true;
        switch (type) {
            case 7: 
            case 8: {
                onlyNumericKeys = false;
                emailValidation = false;
                loginInput = false;
                break;
            }
            case 10: {
                type = 7;
                onlyNumericKeys = false;
                emailValidation = false;
                loginInput = true;
                break;
            }
            case 11: {
                type = 7;
                onlyNumericKeys = false;
                emailValidation = true;
                loginInput = false;
                break;
            }
            case 9: {
                onlyNumericKeys = true;
                emailValidation = false;
                loginInput = false;
                break;
            }
            default: {
                onlyNumericKeys = false;
                emailValidation = false;
                loginInput = false;
            }
        }
        return this.createControl(type, 0, 0, tabOrder, row, column, 18, 18, null, text, 0, 0, editableText, onlyNumericKeys, emailValidation, loginInput);
    }

    public int createImage(int width, int height, int row, int column, int cellAlignment, SimpleSprite images) {
        return this.createControl(5, width, height, -1, row, column, cellAlignment, 18, images, null, 0, 0);
    }

    public int createScrollBox(int width, int height, int tabOrder, int row, int column, int cellAlignment, int textAlignment, StringBuffer text, int textPadding) {
        int newID = this.createControl(6, width, height, tabOrder, row, column, cellAlignment, textAlignment, null, text, 0, textPadding);
        int lines = 1;
        try {
            lines = this.renderer.getWordBreakLinesCount(width, height, text, (textAlignment & 2) != 0);
        }
        catch (Exception e) {
            System.out.println("ScrollBox area is to small to render text!" + e.toString());
        }
        if (lines < 1) {
            lines = 1;
        }
        this.getControlByID((int)newID).lineCount = lines;
        this.getControlByID((int)newID).visibleLines = height / this.renderer.getLineSpacing();
        this.getControlByID((int)newID).currentLine = 0;
        this.getControlByID(newID).calculatePositions(this.absoluteX, this.absoluteY, this.renderer);
        return newID;
    }

    public void recalculateScrollBox(int id) {
        if (this.getControlByID(id).getType() == 6) {
            int lines = 1;
            try {
                lines = this.renderer.getWordBreakLinesCount(this.getControlByID((int)id).width, this.getControlByID((int)id).height, this.getControlByID(id).getText(), (this.getControlByID((int)id).textAlignment & 2) != 0);
            }
            catch (Exception e) {
                System.out.println("ScrollBox area is to small to render text!" + e.toString());
            }
            if (lines < 1) {
                lines = 1;
            }
            this.getControlByID((int)id).lineCount = lines;
            this.getControlByID((int)id).visibleLines = this.getControlByID((int)id).height / this.renderer.getLineSpacing();
            this.getControlByID((int)id).currentLine = 0;
            this.getControlByID(id).calculatePositions(this.absoluteX, this.absoluteY, this.renderer);
        }
    }

    public void drawMenu(Graphics graphics) {
        int i2 = 0;
        for (int i = 0; i < this.GetControlsLength(); ++i) {
            if (this.getControlByID(i) != null) {
                int tempPosY = -1;
                int controlsCount = this.GetControlsLength();
                if (this.visibleRowCount != 0 && i < controlsCount) {
                    if (this.focusedID < this.fpRC) {
                        this.fpRC = 0;
                    } else if (this.focusedID - this.fpRC >= this.visibleRowCount - 1 && this.fpRC + this.visibleRowCount != controlsCount) {
                        ++this.fpRC;
                    } else if (this.focusedID == this.fpRC && this.fpRC > 0) {
                        --this.fpRC;
                    }
                    if (i < this.fpRC || i >= this.fpRC + this.visibleRowCount) continue;
                    tempPosY = this.getControlByID(i).getTextPozY();
                    this.getControlByID(i).setTextPozY(this.getControlByID(i2).getTextPozY());
                    ++i2;
                }
                this.getControlByID(i).draw(graphics, this.renderer);
                if (tempPosY == -1) continue;
                this.getControlByID(i).setTextPozY(tempPosY);
                continue;
            }
            throw new RuntimeException("More controls declared than added! Added: " + i + ", declared: " + this.controls.length);
        }
    }

    public void setRendererFonts(int controlID, String normal, String highLighted, String highLighted2) {
        if (controlID >= this.GetControlsLength() || controlID < 0 || this.getControlByID(controlID) == null) {
            throw new RuntimeException("There is no control with ID " + controlID);
        }
        this.getControlByID((int)controlID).fontNormal = this.renderer.getFont(normal);
        this.getControlByID((int)controlID).fontHighLighted = this.renderer.getFont(highLighted);
        this.getControlByID((int)controlID).fontHighLighted2 = this.renderer.getFont(highLighted2);
        TextRenderer.getInstance().setCurrentFont(this.getControlByID((int)controlID).fontNormal);
        this.getControlByID(controlID).calculatePositions(this.absoluteX, this.absoluteY, this.renderer);
    }

    public void setDisplayType(int displayType) {
        this.displayType = displayType;
    }

    public int getDisplayType() {
        return this.displayType;
    }

    public void debugDraw(Graphics g) {
        g.setColor(0xFF0000);
        int j = 0;
        for (int i = 0; i < this.columnX.length; ++i) {
            for (j = 0; j < this.rowY.length; ++j) {
                if (i < this.columnX.length - 1 && j < this.rowY.length - 1) {
                    g.drawRect(this.columnX[i], this.rowY[j], this.columnX[i + 1] - this.columnX[i], this.rowY[j + 1] - this.rowY[j]);
                    continue;
                }
                if (i == this.columnX.length - 1 && j < this.rowY.length - 1) {
                    g.drawRect(this.columnX[i], this.rowY[j], 240 - this.columnX[i], this.rowY[j + 1] - this.rowY[j]);
                    continue;
                }
                if (j == this.rowY.length - 1 && i < this.columnX.length - 1) {
                    g.drawRect(this.columnX[i], this.rowY[j], this.columnX[i + 1] - this.columnX[i], 320 - this.rowY[j]);
                    continue;
                }
                g.drawRect(this.columnX[i], this.rowY[j], 240 - this.columnX[i], 320 - this.rowY[j]);
            }
        }
    }
}

