/*
 * Decompiled with CFR 0.152.
 */
package gs.common.datapackets;

import gs.common.datapackets.IDataStringConvertible;
import gs.common.enumerations.PacketType;
import gs.common.enumerations.QueryType;
import gs.common.utils.CollectionUtil;
import gs.common.utils.DataPacketUtil;
import gs.common.utils.ObjectUtil;
import gs.exceptions.PacketConversionException;
import java.util.Vector;

public class QueryDataPacket
implements IDataStringConvertible {
    private static final int NUMPACKETFIELDS = 2;
    private Short queryType;
    private Vector queryParams;

    public QueryDataPacket() {
        this.queryType = QueryType.Invalid;
        this.queryParams = new Vector();
    }

    public QueryDataPacket(Short queryType, Vector params) {
        this.queryType = queryType;
        this.queryParams = params;
    }

    public Short getQueryType() {
        return this.queryType;
    }

    public Vector getParams() {
        return this.queryParams;
    }

    public String toDataString() throws PacketConversionException {
        if (QueryType.Invalid.equals(this.queryType) || this.queryParams == null) {
            throw new PacketConversionException("QueryDatapacket to data string: packet not initialized");
        }
        String result = DataPacketUtil.objectToDataString(this.getPacketType());
        result = result + DataPacketUtil.mainDPSeperator();
        result = result + DataPacketUtil.objectToDataString(this.queryType);
        result = result + DataPacketUtil.mainDPSeperator();
        if (this.queryParams.size() > 0) {
            for (int i = 0; i < this.queryParams.size(); ++i) {
                result = result + DataPacketUtil.objectToDataString(this.queryParams.elementAt(i));
                if (i >= this.queryParams.size() - 1) continue;
                result = result + DataPacketUtil.paramDPSeperator();
            }
        }
        return result;
    }

    public void parseDataString(String dataStr) throws PacketConversionException {
        Vector mainsplit = CollectionUtil.splitString(dataStr, DataPacketUtil.mainDPSeperator());
        try {
            if (!PacketType.Query.equals(ObjectUtil.shortFromString((String)mainsplit.elementAt(0)))) {
                throw new PacketConversionException("parsing QueryDataPacket: invalid packet type");
            }
            this.queryType = ObjectUtil.shortFromString((String)mainsplit.elementAt(1));
            Vector pSplit = CollectionUtil.splitString((String)mainsplit.elementAt(2), DataPacketUtil.paramDPSeperator());
            this.queryParams = DataPacketUtil.parseQueryParams(pSplit, this.queryType);
        }
        catch (Exception e) {
            throw new PacketConversionException("error while parsing QueryDatapacket: " + e.getMessage());
        }
    }

    public Short getPacketType() {
        return PacketType.Query;
    }

    public String toString() {
        return "QueryDataPacket: queryType=" + QueryType.queryTypeToString(this.queryType) + "; " + "queryParams=" + CollectionUtil.vectorToString(this.queryParams);
    }
}

