/*
 * Decompiled with CFR 0.152.
 */
package gs.common.datapackets.subpackets;

import gs.common.BoundedString;
import gs.common.datapackets.IDataStringConvertible;
import gs.common.datapackets.subpackets.PlayerStateInfo;
import gs.common.enumerations.PacketType;
import gs.common.gsid.IGSId;
import gs.common.info.IPlayerInfo;
import gs.common.info.IPlayerStateInfo;
import gs.common.utils.CollectionUtil;
import gs.common.utils.DataPacketUtil;
import gs.common.utils.GSIdUtil;
import gs.exceptions.PacketConversionException;
import java.util.Vector;

public class PlayerInfo
implements IPlayerInfo,
IDataStringConvertible {
    private static final int NUMPACKETFILEDS = 3;
    private IGSId gsId;
    private BoundedString name;
    private IPlayerStateInfo playerStateInfo;

    public PlayerInfo() {
        this.gsId = null;
        this.name = null;
        this.playerStateInfo = null;
    }

    public PlayerInfo(IGSId gsId, BoundedString name, IPlayerStateInfo playerStateInfo) {
        this.gsId = gsId;
        this.name = name;
        this.playerStateInfo = playerStateInfo;
    }

    public PlayerInfo(IPlayerInfo info) {
        this.gsId = info.getId();
        this.name = info.getName();
        this.playerStateInfo = info.getStateInfo();
    }

    public IGSId getId() {
        return this.gsId;
    }

    public BoundedString getName() {
        return this.name;
    }

    public IPlayerStateInfo getStateInfo() {
        return this.playerStateInfo;
    }

    public String toDataString() throws PacketConversionException {
        if (this.gsId == null || this.name == null || this.playerStateInfo == null) {
            throw new PacketConversionException("PlayerInfo to data string: packet not initialized");
        }
        String result = "";
        result = result + DataPacketUtil.objectToDataString(this.gsId);
        result = result + DataPacketUtil.playerInfoSeperator();
        result = result + DataPacketUtil.objectToDataString(this.name);
        result = result + DataPacketUtil.playerInfoSeperator();
        result = result + DataPacketUtil.objectToDataString(this.playerStateInfo);
        return result;
    }

    public void parseDataString(String dataStr) throws PacketConversionException {
        Vector mainSplit = CollectionUtil.splitString(dataStr, DataPacketUtil.playerInfoSeperator());
        if (mainSplit.size() != 3) {
            throw new PacketConversionException("parsing PlayerInfo: invalid packet type");
        }
        try {
            this.gsId = GSIdUtil.parseFromString((String)mainSplit.elementAt(0));
            this.name = new BoundedString((String)mainSplit.elementAt(1));
            PlayerStateInfo stateInfo = new PlayerStateInfo();
            stateInfo.parseDataString((String)mainSplit.elementAt(2));
            this.playerStateInfo = stateInfo;
        }
        catch (Exception e) {
            throw new PacketConversionException("error while parsing PlayerInfo: " + e.getMessage());
        }
    }

    public Short getPacketType() {
        return PacketType.SubPacket;
    }

    public String toString() {
        return "PlayerInfo: id=" + ((Object)this.gsId).toString() + "; " + "name=" + this.name.toString() + "; " + "playerStateInfo=" + this.playerStateInfo.toString();
    }
}

