/*
 * Decompiled with CFR 0.152.
 */
package gs.common.datapackets.subpackets;

import gs.common.BoundedString;
import gs.common.datapackets.IDataStringConvertible;
import gs.common.enumerations.PacketType;
import gs.common.info.IRankingInfo;
import gs.common.utils.CollectionUtil;
import gs.common.utils.DataPacketUtil;
import gs.common.utils.ObjectUtil;
import gs.exceptions.PacketConversionException;
import java.util.Vector;

public class RankingInfo
implements IRankingInfo,
IDataStringConvertible {
    private static final int NUMPACKETFILEDS = 11;
    private BoundedString playerName;
    private Integer score;
    private Integer firstPlaceNo;
    private Integer secondPlaceNo;
    private Integer thirdPlaceNo;
    private Integer fourthPlaceNo;
    private Integer escapeNo;
    private Short gameType;
    private Integer winningStreak;
    private Integer scoreDif;
    private BoundedString additionalInfo;

    public RankingInfo() {
    }

    public RankingInfo(BoundedString playerName, Integer score, Integer firstPlaceNo, Integer secondPlaceNo, Integer thirdPlaceNo, Integer fourthPlaceNo, Integer escapeNo, Short gameType, Integer winningStreak, Integer scoreDif, BoundedString additionalInfo) {
        this.playerName = playerName;
        this.score = score;
        this.firstPlaceNo = firstPlaceNo;
        this.secondPlaceNo = secondPlaceNo;
        this.thirdPlaceNo = thirdPlaceNo;
        this.fourthPlaceNo = fourthPlaceNo;
        this.escapeNo = escapeNo;
        this.gameType = gameType;
        this.winningStreak = winningStreak;
        this.scoreDif = scoreDif;
        this.additionalInfo = additionalInfo;
    }

    public RankingInfo(IRankingInfo other) {
        this.playerName = other.getPlayerName();
        this.score = other.getScore();
        this.firstPlaceNo = other.getFirstPlaceNo();
        this.secondPlaceNo = other.getSecondPlaceNo();
        this.thirdPlaceNo = other.getThirdPlaceNo();
        this.fourthPlaceNo = other.getFourthPlaceNo();
        this.escapeNo = other.getEscapeNo();
        this.gameType = other.getGameType();
        this.winningStreak = other.getWinningStreak();
        this.scoreDif = other.getScoreDif();
        this.additionalInfo = other.getAdditionalInfo();
    }

    public BoundedString getPlayerName() {
        return this.playerName;
    }

    public Integer getScore() {
        return this.score;
    }

    public Integer getFirstPlaceNo() {
        return this.firstPlaceNo;
    }

    public Integer getSecondPlaceNo() {
        return this.secondPlaceNo;
    }

    public Integer getThirdPlaceNo() {
        return this.thirdPlaceNo;
    }

    public Integer getFourthPlaceNo() {
        return this.fourthPlaceNo;
    }

    public Integer getWinningStreak() {
        return this.winningStreak;
    }

    public Short getGameType() {
        return this.gameType;
    }

    public Integer getScoreDif() {
        return this.scoreDif;
    }

    public BoundedString getAdditionalInfo() {
        return this.additionalInfo;
    }

    public String toDataString() throws PacketConversionException {
        String result = "";
        result = result + DataPacketUtil.objectToDataString(this.playerName);
        result = result + DataPacketUtil.rankingInfoSeperator();
        result = result + DataPacketUtil.objectToDataString(this.gameType);
        result = result + DataPacketUtil.rankingInfoSeperator();
        result = result + DataPacketUtil.objectToDataString(this.score);
        result = result + DataPacketUtil.rankingInfoSeperator();
        result = result + DataPacketUtil.objectToDataString(this.firstPlaceNo);
        result = result + DataPacketUtil.rankingInfoSeperator();
        result = result + DataPacketUtil.objectToDataString(this.secondPlaceNo);
        result = result + DataPacketUtil.rankingInfoSeperator();
        result = result + DataPacketUtil.objectToDataString(this.thirdPlaceNo);
        result = result + DataPacketUtil.rankingInfoSeperator();
        result = result + DataPacketUtil.objectToDataString(this.fourthPlaceNo);
        result = result + DataPacketUtil.rankingInfoSeperator();
        result = result + DataPacketUtil.objectToDataString(this.escapeNo);
        result = result + DataPacketUtil.rankingInfoSeperator();
        result = result + DataPacketUtil.objectToDataString(this.winningStreak);
        result = result + DataPacketUtil.rankingInfoSeperator();
        result = result + DataPacketUtil.objectToDataString(this.scoreDif);
        result = result + DataPacketUtil.rankingInfoSeperator();
        result = result + DataPacketUtil.objectToDataString(this.additionalInfo);
        return result;
    }

    public void parseDataString(String dataStr) throws PacketConversionException {
        Vector mainSplit = CollectionUtil.splitString(dataStr, DataPacketUtil.rankingInfoSeperator());
        if (mainSplit.size() != 11) {
            throw new PacketConversionException("parsing RankingInfo: invalid packet type");
        }
        try {
            this.playerName = new BoundedString((String)mainSplit.elementAt(0));
            this.gameType = ObjectUtil.shortFromString((String)mainSplit.elementAt(1));
            this.score = ObjectUtil.integerFromString((String)mainSplit.elementAt(2));
            this.firstPlaceNo = ObjectUtil.integerFromString((String)mainSplit.elementAt(3));
            this.secondPlaceNo = ObjectUtil.integerFromString((String)mainSplit.elementAt(4));
            this.thirdPlaceNo = ObjectUtil.integerFromString((String)mainSplit.elementAt(5));
            this.fourthPlaceNo = ObjectUtil.integerFromString((String)mainSplit.elementAt(6));
            this.escapeNo = ObjectUtil.integerFromString((String)mainSplit.elementAt(7));
            this.winningStreak = ObjectUtil.integerFromString((String)mainSplit.elementAt(8));
            this.scoreDif = ObjectUtil.integerFromString((String)mainSplit.elementAt(9));
            this.additionalInfo = new BoundedString((String)mainSplit.elementAt(10));
        }
        catch (Exception e) {
            throw new PacketConversionException("error while parsing RankingInfo: " + e.getMessage());
        }
    }

    public Short getPacketType() {
        return PacketType.SubPacket;
    }

    public Integer getEscapeNo() {
        return this.escapeNo;
    }

    public String toString() {
        return "RankingInfo: playerName=" + this.playerName.toString() + "; " + "score=" + this.score.toString() + "; " + "firstPlaceNo=" + this.firstPlaceNo.toString() + "; " + "secondPlaceNo=" + this.secondPlaceNo.toString() + "; " + "thirdPlaceNo=" + this.thirdPlaceNo.toString() + "; " + "fourthPlaceNo=" + this.fourthPlaceNo.toString() + "; " + "winningStreak=" + this.winningStreak.toString() + "; " + "scoreDif=" + this.scoreDif.toString() + "; " + "additionalInfo=" + this.additionalInfo.toString();
    }
}

