/*
 * Decompiled with CFR 0.152.
 */
package gs.common.datapackets;

import gs.common.datapackets.IDataStringConvertible;
import gs.common.enumerations.EventType;
import gs.common.enumerations.PacketType;
import gs.common.info.IEventInfo;
import gs.common.utils.CollectionUtil;
import gs.common.utils.DataPacketUtil;
import gs.common.utils.ObjectUtil;
import gs.exceptions.GSException;
import gs.exceptions.PacketConversionException;
import java.util.Vector;

public class EventDataPacket
implements IDataStringConvertible,
IEventInfo {
    private static final int NUMPACKETFILEDS = 2;
    private Short eventType;
    private Vector eventParams;

    public EventDataPacket() {
        this.eventType = EventType.Invalid;
        this.eventParams = null;
    }

    public EventDataPacket(Short eventType, Vector eventParams) {
        this.eventType = eventType;
        this.eventParams = eventParams;
    }

    public Vector getParams() throws GSException {
        return this.eventParams;
    }

    public Short getEventType() throws GSException {
        return this.eventType;
    }

    public String toDataString() throws PacketConversionException {
        if (EventType.Invalid.equals(this.eventType) || this.eventParams == null) {
            throw new PacketConversionException("EventDatapacket to data string: packet not initialized");
        }
        String result = DataPacketUtil.objectToDataString(this.getPacketType());
        result = result + DataPacketUtil.mainDPSeperator();
        result = result + DataPacketUtil.objectToDataString(this.eventType);
        result = result + DataPacketUtil.mainDPSeperator();
        for (int i = 0; i < this.eventParams.size(); ++i) {
            Object o = this.eventParams.elementAt(i);
            result = result + DataPacketUtil.objectToDataString(o);
            if (i >= this.eventParams.size() - 1) continue;
            result = result + DataPacketUtil.paramDPSeperator();
        }
        return result;
    }

    public void parseDataString(String dataStr) throws PacketConversionException {
        Vector mainsplit = CollectionUtil.splitString(dataStr, DataPacketUtil.mainDPSeperator());
        String elem0 = (String)mainsplit.elementAt(0);
        try {
            if (!PacketType.Event.equals(ObjectUtil.shortFromString(elem0)) || mainsplit.size() != 3) {
                throw new PacketConversionException("parsing EventDataPacket: invalid packet type");
            }
            String elem1 = (String)mainsplit.elementAt(1);
            this.eventType = new Short(Short.parseShort(elem1));
            Vector pSplit = CollectionUtil.splitString((String)mainsplit.elementAt(2), DataPacketUtil.paramDPSeperator());
            this.eventParams = DataPacketUtil.parseEventParams(pSplit, this.eventType);
        }
        catch (Exception ex) {
            throw new PacketConversionException("error while parsing EventDataPacket" + ex.getMessage());
        }
    }

    public Short getPacketType() {
        return PacketType.Event;
    }

    public String toString() {
        return "EventDataPacket: eventType=" + EventType.eventTypeToString(this.eventType) + "; " + "eventParams=" + CollectionUtil.vectorToString(this.eventParams);
    }
}

