/*
 * Decompiled with CFR 0.152.
 */
package gs.common.datapackets;

import gs.common.datapackets.IDataStringConvertible;
import gs.common.enumerations.PacketType;
import gs.common.gsid.IGSId;
import gs.common.utils.CollectionUtil;
import gs.common.utils.DataPacketUtil;
import gs.common.utils.GSIdUtil;
import gs.common.utils.ObjectUtil;
import gs.exceptions.PacketConversionException;
import java.util.Vector;

public class GameStateDataPacket
implements IDataStringConvertible {
    private static final int NUMPACKETFIELDS = 2;
    protected IGSId gameId;
    protected String gameStateStr;

    public GameStateDataPacket() {
        this.gameId = null;
        this.gameStateStr = null;
    }

    public GameStateDataPacket(IGSId gameId, String gameStateStr) {
        this.gameId = gameId;
        this.gameStateStr = gameStateStr;
    }

    public String getGameStateString() {
        return this.gameStateStr;
    }

    public IGSId getGameId() {
        return this.gameId;
    }

    public String toDataString() throws PacketConversionException {
        if (this.gameStateStr == null || this.gameId == null) {
            throw new PacketConversionException("GameStateDatapacket to data string: packet not initialized");
        }
        String result = DataPacketUtil.objectToDataString(this.getPacketType());
        result = result + DataPacketUtil.mainDPSeperator();
        result = result + DataPacketUtil.objectToDataString(this.gameId);
        result = result + DataPacketUtil.mainDPSeperator();
        result = result + DataPacketUtil.objectToDataString(this.gameStateStr);
        return result;
    }

    public void parseDataString(String dataStr) throws PacketConversionException {
        Vector mainSplit = CollectionUtil.splitString(dataStr, DataPacketUtil.mainDPSeperator());
        try {
            if (!PacketType.GameState.equals(ObjectUtil.shortFromString((String)mainSplit.elementAt(0))) || mainSplit.size() != 3) {
                throw new PacketConversionException("invalid packet type");
            }
            this.gameId = GSIdUtil.parseFromString((String)mainSplit.elementAt(1));
            this.gameStateStr = (String)mainSplit.elementAt(2);
        }
        catch (Exception ex) {
            throw new PacketConversionException("error while parsing GameStateDataPacket: " + ex.getMessage());
        }
    }

    public Short getPacketType() {
        return PacketType.GameState;
    }

    public String toString() {
        return "GameStateDataPacket: gameId=" + ((Object)this.gameId).toString() + "; " + "GameStateString=" + this.gameStateStr.toString();
    }
}

