/*
 * Decompiled with CFR 0.152.
 */
package gs.common.utils;

import gs.common.BoundedString;
import gs.common.datapackets.EventDataPacket;
import gs.common.datapackets.FinalGameStateDataPacket;
import gs.common.datapackets.GameStateDataPacket;
import gs.common.datapackets.IDataStringConvertible;
import gs.common.datapackets.InfoBoardMessageDataPacket;
import gs.common.datapackets.MessageDataPacket;
import gs.common.datapackets.PulseDataPacket;
import gs.common.datapackets.QueryDataPacket;
import gs.common.datapackets.QueryResponseDataPacket;
import gs.common.datapackets.subpackets.GameInstanceInfo;
import gs.common.datapackets.subpackets.PlayerInfo;
import gs.common.datapackets.subpackets.RankingInfo;
import gs.common.datapackets.subpackets.RoomInfo;
import gs.common.datapackets.subpackets.ScoreInfo;
import gs.common.enumerations.EventType;
import gs.common.enumerations.PacketType;
import gs.common.enumerations.QueryType;
import gs.common.gsid.IGSId;
import gs.common.utils.CollectionUtil;
import gs.common.utils.GSIdUtil;
import gs.common.utils.IQueryParamParser;
import gs.common.utils.ObjectUtil;
import gs.exceptions.GSException;
import gs.exceptions.PacketConversionException;
import java.util.Date;
import java.util.Vector;

public class DataPacketUtil {
    public static IQueryParamParser queryParamParser;

    public static IDataStringConvertible parseDataPacket(String datap) throws PacketConversionException {
        IDataStringConvertible result = null;
        Vector datapArray = CollectionUtil.splitString(datap, DataPacketUtil.mainDPSeperator());
        if (datapArray.size() == 0) {
            throw new PacketConversionException("Incorrect data packet content");
        }
        Short packetType = new Short(Short.parseShort((String)datapArray.elementAt(0)));
        if (PacketType.Message.equals(packetType)) {
            result = new MessageDataPacket();
        } else if (PacketType.Event.equals(packetType)) {
            result = new EventDataPacket();
        } else if (PacketType.GameState.equals(packetType)) {
            result = new GameStateDataPacket();
        } else if (PacketType.FinalGameState.equals(packetType)) {
            result = new FinalGameStateDataPacket();
        } else if (PacketType.Query.equals(packetType)) {
            result = new QueryDataPacket();
        } else if (PacketType.QueryResponse.equals(packetType)) {
            result = new QueryResponseDataPacket();
        } else if (PacketType.Pulse.equals(packetType)) {
            result = new PulseDataPacket();
        } else if (PacketType.InfoBoardMessage.equals(packetType)) {
            result = new InfoBoardMessageDataPacket();
        }
        result.parseDataString(datap);
        return result;
    }

    public static String objectToDataString(Object obj) throws PacketConversionException {
        if (obj instanceof IGSId) {
            return obj.toString();
        }
        if (obj instanceof IDataStringConvertible) {
            return ((IDataStringConvertible)obj).toDataString();
        }
        if (obj instanceof Integer) {
            return obj.toString();
        }
        if (obj instanceof Short) {
            return obj.toString();
        }
        if (obj instanceof BoundedString) {
            return obj.toString();
        }
        if (obj instanceof Boolean) {
            return obj.toString();
        }
        if (obj instanceof String) {
            return obj.toString();
        }
        if (obj instanceof Date) {
            return ObjectUtil.dateToString((Date)obj);
        }
        if (obj instanceof Vector) {
            String result = "";
            int counter = 0;
            for (int i = 0; i < ((Vector)obj).size(); ++i) {
                result = result + DataPacketUtil.objectToDataString(((Vector)obj).elementAt(i));
                if (i != ((Vector)obj).size() - 1) {
                    result = result + DataPacketUtil.listDPSeperator();
                }
                ++counter;
            }
            return result;
        }
        throw new PacketConversionException("object to data string: unsupported object type");
    }

    public static Vector parseQueryParams(Vector paramStrings, Short queryType) throws GSException {
        if (queryParamParser == null) {
            throw new GSException("Query param parser not defined");
        }
        return queryParamParser.parseQueryParams(paramStrings, queryType);
    }

    public static Vector parseQueryResponseParams(Vector paramStrings, Short queryType) throws GSException {
        Vector<Object> result = new Vector<Object>();
        if (QueryType.MeGetState.equals(queryType)) {
            PlayerInfo playerInfo = new PlayerInfo();
            playerInfo.parseDataString((String)paramStrings.elementAt(0));
            result.addElement(playerInfo);
        } else if (QueryType.ServerListRooms.equals(queryType)) {
            Vector rooms = CollectionUtil.splitString((String)paramStrings.elementAt(0), DataPacketUtil.listDPSeperator());
            for (int i = 0; i < rooms.size(); ++i) {
                String roomStr = (String)rooms.elementAt(i);
                if (roomStr.equals("")) continue;
                RoomInfo roomInfo = new RoomInfo();
                roomInfo.parseDataString(roomStr);
                result.addElement(roomInfo);
            }
        } else if (!QueryType.ServerListBuddies.equals(queryType)) {
            if (QueryType.RoomListGames.equals(queryType)) {
                Vector games = CollectionUtil.splitString((String)paramStrings.elementAt(0), DataPacketUtil.listDPSeperator());
                for (int i = 0; i < games.size(); ++i) {
                    String gameStr = (String)games.elementAt(i);
                    if (gameStr.equals("")) continue;
                    GameInstanceInfo gameInfo = new GameInstanceInfo();
                    gameInfo.parseDataString(gameStr);
                    result.addElement(gameInfo);
                }
            } else if (QueryType.RoomEnter.equals(queryType)) {
                PlayerInfo playerInfo = new PlayerInfo();
                playerInfo.parseDataString((String)paramStrings.elementAt(0));
                result.addElement(playerInfo);
            } else if (QueryType.RoomLeave.equals(queryType)) {
                PlayerInfo playerInfo = new PlayerInfo();
                playerInfo.parseDataString((String)paramStrings.elementAt(0));
                result.addElement(playerInfo);
            } else if (QueryType.RoomListPlayers.equals(queryType)) {
                Vector players = CollectionUtil.splitString((String)paramStrings.elementAt(0), DataPacketUtil.listDPSeperator());
                for (int i = 0; i < players.size(); ++i) {
                    PlayerInfo playerInfo = new PlayerInfo();
                    playerInfo.parseDataString((String)players.elementAt(i));
                    result.addElement(playerInfo);
                }
            } else if (QueryType.RoomSwitch.equals(queryType)) {
                PlayerInfo playerInfo = new PlayerInfo();
                playerInfo.parseDataString((String)paramStrings.elementAt(0));
                result.addElement(playerInfo);
            } else if (!(QueryType.BuddyAdd.equals(queryType) || QueryType.BuddyDelete.equals(queryType) || QueryType.BuddyFind.equals(queryType))) {
                if (QueryType.GameAutoJoin.equals(queryType)) {
                    GameInstanceInfo gameInfo = new GameInstanceInfo();
                    gameInfo.parseDataString((String)paramStrings.elementAt(0));
                    Vector playerStrings = CollectionUtil.splitString((String)paramStrings.elementAt(1), DataPacketUtil.listDPSeperator());
                    Vector<PlayerInfo> players = new Vector<PlayerInfo>();
                    for (int i = 0; i < playerStrings.size(); ++i) {
                        String playerStr = (String)playerStrings.elementAt(i);
                        if (playerStr.equals("")) continue;
                        PlayerInfo playerInfo = new PlayerInfo();
                        playerInfo.parseDataString(playerStr);
                        players.addElement(playerInfo);
                    }
                    result.addElement(gameInfo);
                    result.addElement(players);
                } else if (QueryType.GameHost.equals(queryType)) {
                    GameInstanceInfo gameInfo = new GameInstanceInfo();
                    gameInfo.parseDataString((String)paramStrings.elementAt(0));
                    PlayerInfo pInfo = new PlayerInfo();
                    pInfo.parseDataString((String)paramStrings.elementAt(1));
                    result.addElement(gameInfo);
                    result.addElement(pInfo);
                } else if (QueryType.GameJoin.equals(queryType)) {
                    PlayerInfo playerInfo = new PlayerInfo();
                    playerInfo.parseDataString((String)paramStrings.elementAt(0));
                    result.addElement(playerInfo);
                    Vector playerStirngs = CollectionUtil.splitString((String)paramStrings.elementAt(1), DataPacketUtil.listDPSeperator());
                    Vector<PlayerInfo> players = new Vector<PlayerInfo>();
                    for (int i = 0; i < playerStirngs.size(); ++i) {
                        PlayerInfo pinfo = new PlayerInfo();
                        pinfo.parseDataString((String)playerStirngs.elementAt(i));
                        players.addElement(pinfo);
                    }
                    result.addElement(players);
                } else if (!QueryType.GameKickPlayer.equals(queryType)) {
                    if (QueryType.GameLeave.equals(queryType)) {
                        PlayerInfo playerInfo = new PlayerInfo();
                        playerInfo.parseDataString((String)paramStrings.elementAt(0));
                        result.addElement(playerInfo);
                    } else if (QueryType.GameReady.equals(queryType)) {
                        PlayerInfo playerInfo = new PlayerInfo();
                        playerInfo.parseDataString((String)paramStrings.elementAt(0));
                        result.addElement(playerInfo);
                    } else if (!QueryType.GameSetOwner.equals(queryType)) {
                        if (QueryType.MeSetName.equals(queryType)) {
                            PlayerInfo playerInfo = new PlayerInfo();
                            playerInfo.parseDataString((String)paramStrings.elementAt(0));
                            result.addElement(playerInfo);
                        } else if (!QueryType.InvitationSend.equals(queryType)) {
                            if (QueryType.InvitationAccept.equals(queryType)) {
                                PlayerInfo playerInfo = new PlayerInfo();
                                playerInfo.parseDataString((String)paramStrings.elementAt(0));
                                Vector pSplit = CollectionUtil.splitString((String)paramStrings.elementAt(1), DataPacketUtil.listDPSeperator());
                                Vector<PlayerInfo> players = new Vector<PlayerInfo>(pSplit.size());
                                for (int i = 0; i < pSplit.size(); ++i) {
                                    PlayerInfo pInfo = new PlayerInfo();
                                    pInfo.parseDataString((String)pSplit.elementAt(i));
                                    players.addElement(pInfo);
                                }
                                result.addElement(playerInfo);
                                result.addElement(players);
                            } else if (QueryType.Authentication.equals(queryType)) {
                                PlayerInfo playerInfo = new PlayerInfo();
                                playerInfo.parseDataString((String)paramStrings.elementAt(0));
                                result.addElement(playerInfo);
                            } else if (!(QueryType.Registration.equals(queryType) || QueryType.PasswordRecovery.equals(queryType) || QueryType.ChangePassword.equals(queryType))) {
                                if (QueryType.ServerGetRankingFromTo.equals(queryType)) {
                                    Vector rankings = CollectionUtil.splitString((String)paramStrings.elementAt(0), DataPacketUtil.listDPSeperator());
                                    for (int i = 0; i < rankings.size(); ++i) {
                                        String roomStr = (String)rankings.elementAt(i);
                                        if (roomStr.equals("")) continue;
                                        RankingInfo rankingInfo = new RankingInfo();
                                        rankingInfo.parseDataString(roomStr);
                                        result.addElement(rankingInfo);
                                    }
                                } else if (QueryType.ServerGetRankingPlayer.equals(queryType)) {
                                    Integer place;
                                    RankingInfo rankingInfo = new RankingInfo();
                                    rankingInfo.parseDataString((String)paramStrings.elementAt(0));
                                    try {
                                        place = ObjectUtil.integerFromString((String)paramStrings.elementAt(1));
                                    }
                                    catch (Exception ex) {
                                        throw new GSException("Error parsing query response params: " + ex.getMessage());
                                    }
                                    result.addElement(rankingInfo);
                                    result.addElement(place);
                                } else if (QueryType.ServerGetRankingSize.equals(queryType)) {
                                    Integer size;
                                    try {
                                        size = ObjectUtil.integerFromString((String)paramStrings.elementAt(0));
                                    }
                                    catch (Exception ex) {
                                        throw new GSException("Error parsing query response params: " + ex.getMessage());
                                    }
                                    result.addElement(size);
                                } else if (!QueryType.ServerChangeMobileId.equals(queryType)) {
                                    if (QueryType.GameListPlayers.equals(queryType)) {
                                        Vector players = CollectionUtil.splitString((String)paramStrings.elementAt(0), DataPacketUtil.listDPSeperator());
                                        for (int i = 0; i < players.size(); ++i) {
                                            String playerStr = (String)players.elementAt(i);
                                            if (playerStr.equals("")) continue;
                                            PlayerInfo playerInfo = new PlayerInfo();
                                            playerInfo.parseDataString(playerStr);
                                            result.addElement(playerInfo);
                                        }
                                    } else if (!QueryType.ServerGetInfoBoardMessages.equals(queryType)) {
                                        if (QueryType.ServerGetInfoBoardMessageCount.equals(queryType)) {
                                            Integer count;
                                            try {
                                                count = ObjectUtil.integerFromString((String)paramStrings.elementAt(0));
                                                result.addElement(count);
                                            }
                                            catch (Exception ex) {
                                                throw new GSException("Error parsing query response params: " + ex.getMessage());
                                            }
                                            result.addElement(count);
                                        } else if (!(QueryType.ServerDeleteInfoBoardMessage.equals(queryType) || QueryType.ServerAccountActivate.equals(queryType) || QueryType.ServerAccountDeactivate.equals(queryType) || QueryType.ServerTellFriendAboutOMPG.equals(queryType))) {
                                            if (QueryType.ServerGetTime.equals(queryType)) {
                                                try {
                                                    Date serverTime = ObjectUtil.dateFromString((String)paramStrings.elementAt(0));
                                                    result.addElement(serverTime);
                                                }
                                                catch (Exception ex) {
                                                    throw new GSException("Error parsing query response params: " + ex.getMessage());
                                                }
                                            } else if (QueryType.ServerGetTextMessageInfo.equals(queryType)) {
                                                BoundedString msgNumber = new BoundedString((String)paramStrings.elementAt(0));
                                                String msgContents = (String)paramStrings.elementAt(1);
                                                result.addElement(msgNumber);
                                                result.addElement(msgContents);
                                            } else if (QueryType.ServerGetNewAppVersionUrl.equals(queryType)) {
                                                String url = (String)paramStrings.elementAt(0);
                                                result.addElement(url);
                                            } else if (QueryType.ServerAccountIsActive.equals(queryType)) {
                                                try {
                                                    Boolean isActive = ObjectUtil.booleanFromString((String)paramStrings.elementAt(0));
                                                    Date expirationDate = ObjectUtil.dateFromString((String)paramStrings.elementAt(1));
                                                    result.addElement(isActive);
                                                    result.addElement(expirationDate);
                                                }
                                                catch (Exception ex) {
                                                    throw new GSException("Error parsing query response params: " + ex.getMessage());
                                                }
                                            } else if (!QueryType.ServerUserSingleCharged.equals(queryType)) {
                                                throw new GSException("Unrecongnized QueryType: " + queryType);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    public static Vector parseEventParams(Vector paramStrings, Short eventType) throws PacketConversionException {
        Vector<Object> result = new Vector<Object>();
        if (eventType.equals(EventType.RoomPlayerJoined)) {
            PlayerInfo pInfo = new PlayerInfo();
            pInfo.parseDataString((String)paramStrings.elementAt(0));
            result.addElement(pInfo);
        } else if (eventType.equals(EventType.RoomPlayerLeft)) {
            IGSId pId = GSIdUtil.parseFromString((String)paramStrings.elementAt(0));
            result.addElement(pId);
        } else if (eventType.equals(EventType.RoomGameCreated)) {
            GameInstanceInfo gInfo = new GameInstanceInfo();
            gInfo.parseDataString((String)paramStrings.elementAt(0));
            result.addElement(gInfo);
        } else if (eventType.equals(EventType.RoomGameTerminated)) {
            IGSId gId = GSIdUtil.parseFromString((String)paramStrings.elementAt(0));
            result.addElement(gId);
        } else if (eventType.equals(EventType.RoomGameStateChanged)) {
            GameInstanceInfo gInfo = new GameInstanceInfo();
            gInfo.parseDataString((String)paramStrings.elementAt(0));
            result.addElement(gInfo);
        } else if (eventType.equals(EventType.GamePlayerJoined)) {
            PlayerInfo pInfo = new PlayerInfo();
            pInfo.parseDataString((String)paramStrings.elementAt(0));
            result.addElement(pInfo);
        } else if (eventType.equals(EventType.GamePlayerLeft)) {
            IGSId pId = GSIdUtil.parseFromString((String)paramStrings.elementAt(0));
            result.addElement(pId);
        } else if (eventType.equals(EventType.GamePlayerDisconnected)) {
            PlayerInfo pInfo = new PlayerInfo();
            pInfo.parseDataString((String)paramStrings.elementAt(0));
            result.addElement(pInfo);
        } else if (eventType.equals(EventType.GamePlayerReconnected)) {
            PlayerInfo pInfo = new PlayerInfo();
            pInfo.parseDataString((String)paramStrings.elementAt(0));
            result.addElement(pInfo);
        } else if (eventType.equals(EventType.GamePlayerKicked)) {
            IGSId pId = GSIdUtil.parseFromString((String)paramStrings.elementAt(0));
            result.addElement(pId);
        } else if (eventType.equals(EventType.GamePlayerReady)) {
            PlayerInfo pInfo = new PlayerInfo();
            pInfo.parseDataString((String)paramStrings.elementAt(0));
            result.addElement(pInfo);
        } else if (eventType.equals(EventType.GamePlayerStateChanged)) {
            PlayerInfo pInfo = new PlayerInfo();
            pInfo.parseDataString((String)paramStrings.elementAt(0));
            result.addElement(pInfo);
        } else if (eventType.equals(EventType.GameOwnerChanged)) {
            PlayerInfo pInfo = new PlayerInfo();
            pInfo.parseDataString((String)paramStrings.elementAt(0));
            result.addElement(pInfo);
        } else if (!eventType.equals(EventType.GameStarted)) {
            if (eventType.equals(EventType.GameEnded)) {
                ScoreInfo sInfo = new ScoreInfo();
                sInfo.parseDataString((String)paramStrings.elementAt(0));
                result.addElement(sInfo);
            } else if (eventType.equals(EventType.RoomPlayerStateChanged)) {
                PlayerInfo pInfo = new PlayerInfo();
                pInfo.parseDataString((String)paramStrings.elementAt(0));
                result.addElement(pInfo);
            } else if (EventType.InvitationArrived.equals(eventType)) {
                PlayerInfo pInfo = new PlayerInfo();
                pInfo.parseDataString((String)paramStrings.elementAt(0));
                GameInstanceInfo gInfo = new GameInstanceInfo();
                gInfo.parseDataString((String)paramStrings.elementAt(1));
                result.addElement(pInfo);
                result.addElement(gInfo);
            } else if (EventType.InvitationAccepted.equals(eventType)) {
                IGSId playerId = GSIdUtil.parseFromString((String)paramStrings.elementAt(0));
                result.addElement(playerId);
            } else {
                throw new PacketConversionException("DataPacketUtil.parseEventParams: unsuported event type");
            }
        }
        return result;
    }

    public static String mainDPSeperator() {
        return "<m>";
    }

    public static String listDPSeperator() {
        return "<l>";
    }

    public static String paramDPSeperator() {
        return "<p>";
    }

    public static String playerInfoSeperator() {
        return "<s1>";
    }

    public static String playerStateInfoSeperator() {
        return "<s2>";
    }

    public static String roomInfoSeperator() {
        return "<s1>";
    }

    public static String gameInstanceInfoSeperator() {
        return "<s1>";
    }

    public static String scoreInfoSeperator() {
        return "<s3>";
    }

    public static String scoreListSeperator() {
        return "<s4>";
    }

    public static String rankingInfoSeperator() {
        return "<s5>";
    }
}

