/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class Enemy
extends Sprite {
    protected boolean move = true;
    private boolean activeDown = false;
    private int speedX = 1;
    private byte speedY = 1;
    protected byte plaActive = 0;
    private byte nextPla = 0;
    protected boolean isFlair = false;
    protected boolean delete = false;
    private byte cont = 0;
    private byte timer = 0;
    private boolean change = false;
    private byte action = 1;
    private byte oldAction = 1;
    protected byte level = (byte)-1;
    protected boolean typeJump = false;
    public boolean active = false;
    private static final int ACTION_RUN = 1;
    private static final int ACTION_RUN_ALL = 2;
    private static final int ACTION_SEARCH = 3;
    private static final int ACTION_DONW = 4;

    public Enemy(Image img) {
        super(img, img.getWidth() / 2, img.getHeight() / 2);
        int[] sequence = new int[]{2, 2, 3, 3};
        this.setFrameSequence(sequence);
        this.setVisible(true);
        this.defineReferencePixel(img.getWidth() / 2 / 2, img.getHeight() / 2);
        this.setPosition(-60, 0);
        this.changeType();
    }

    public void activeFromEnemy(int posX, int posY) {
        this.setPosition(posX, posY);
        this.isFlair = false;
        this.timer = 0;
        this.move = true;
        this.on();
        this.action = (byte)3;
        this.delete = false;
    }

    public void changeType() {
        if (Interface.level == 1) {
            int[] sequence = new int[]{2, 2, 3, 3};
            this.setFrameSequence(sequence);
            this.speedX = 2;
            this.speedY = (byte)3;
        } else {
            int[] sequence = new int[]{0, 0, 1, 1};
            this.setFrameSequence(sequence);
        }
    }

    public void reset(Stage stage, int idPlataforma, int newAction, boolean activar) {
        this.isFlair = false;
        this.timer = 0;
        if (this.level < stage.getNumCuadros() - 2) {
            this.setPosition(stage.plataforma[idPlataforma].x, stage.plataforma[idPlataforma].y - this.getHeight());
            this.action = (byte)newAction;
        } else {
            this.setPosition(stage.plataforma[idPlataforma].x, -40);
            this.action = (byte)3;
        }
        this.move = true;
        if (activar) {
            this.on();
        } else {
            this.off();
        }
        this.level = (byte)stage.plataforma[idPlataforma].level;
        this.delete = false;
    }

    public void reset(Stage stage) {
        if (!this.isFlair) {
            if (this.action == 4) {
                this.setPosition(this.getX(), Interface.SCREEN_H);
                for (int n = 0; n < stage.plataforma.length; ++n) {
                    if (stage.plataforma[n].x <= 0 || stage.plataforma[n].x >= Interface.SCREEN_W || stage.plataforma[n].y >= this.getY()) continue;
                    Random rand = new Random();
                    int aux = stage.plataforma[n].x + 5 + Math.abs(rand.nextInt() % (stage.plataforma[n].cuadros * 40 - 40));
                    this.setPosition(aux, 0);
                }
            } else {
                this.setPosition(this.getX(), -580);
            }
        } else {
            this.isFlair = false;
        }
        this.timer = 0;
    }

    public void move(Stage stage, int xPlayer, Explosion explo) {
        if (!this.isFlair) {
            if (this.getY() <= Interface.SCREEN_H - this.getHeight()) {
                if (this.move) {
                    for (int n = 0; n < stage.plataforma.length; ++n) {
                        if (this.getX() + this.getWidth() <= stage.plataforma[n].x || this.getX() >= stage.plataforma[n].x + stage.plataforma[n].w || this.getY() + this.getHeight() < stage.plataforma[n].y || this.getY() + this.getHeight() > stage.plataforma[n].y + 5) continue;
                        this.move = false;
                        this.plaActive = (byte)n;
                        this.nextPla = (byte)n;
                        if (this.action != 3) continue;
                        this.speedX = this.getX() < xPlayer ? this.speedX : -this.speedX;
                    }
                    this.move(0, this.speedY);
                } else {
                    if (this.action == 1) {
                        if (this.getX() < stage.plataforma[this.plaActive].x) {
                            this.speedX = Math.abs(this.speedX);
                        } else if (this.getX() + this.getWidth() > stage.plataforma[this.plaActive].x + stage.plataforma[this.plaActive].w) {
                            this.speedX = -1;
                        }
                    } else if (this.plaActive >= 0) {
                        if (!this.activeDown) {
                            if (this.getX() < stage.plataforma[this.plaActive].x || this.getX() + this.getWidth() > stage.plataforma[this.plaActive].x + stage.plataforma[this.plaActive].w) {
                                for (int n = 0; n < stage.plataforma.length; ++n) {
                                    if (n == this.plaActive) continue;
                                    if (this.action == 4) {
                                        if (this.getX() - 5 <= stage.plataforma[n].x || this.getX() + this.getWidth() >= stage.plataforma[n].x + stage.plataforma[n].w) continue;
                                        this.activeDown = true;
                                        this.nextPla = (byte)n;
                                        continue;
                                    }
                                    if (this.getY() + this.getHeight() >= stage.plataforma[n].y || this.getX() - 5 <= stage.plataforma[n].x || this.getX() + this.getWidth() >= stage.plataforma[n].x + stage.plataforma[n].w) continue;
                                    this.activeDown = true;
                                    this.nextPla = (byte)n;
                                }
                                if (!this.activeDown) {
                                    this.speedX = this.speedX < 0 ? Math.abs(this.speedX) : -this.speedX;
                                }
                            }
                        } else if (this.getX() + this.getWidth() < stage.plataforma[this.plaActive].x || this.getX() > stage.plataforma[this.plaActive].x + stage.plataforma[this.plaActive].w) {
                            this.move = true;
                            this.activeDown = false;
                        }
                    }
                    this.move(this.speedX, 0);
                    if (this.typeJump) {
                        if (this.getY() < stage.plataforma[this.plaActive].y - 30) {
                            this.change = true;
                        } else if (this.getY() > stage.plataforma[this.plaActive].y - this.getHeight()) {
                            this.change = false;
                        }
                        if (this.change) {
                            this.move(0, 2);
                        } else {
                            this.move(0, -2);
                        }
                    } else {
                        this.setPosition(this.getX(), stage.plataforma[this.plaActive].y - this.getHeight());
                    }
                }
                if (this.speedX > 0) {
                    super.setTransform(2);
                } else if (this.speedX < 0) {
                    super.setTransform(0);
                }
                super.nextFrame();
            } else {
                this.reset(stage);
            }
        } else if (this.delete) {
            this.move(0, 5);
            if (this.getY() + this.getHeight() > Interface.SCREEN_H) {
                this.isFlair = false;
                this.delete = false;
                this.off();
                this.setPosition(this.getX(), -580);
            }
        } else {
            if (this.timer > 15) {
                this.reset(stage);
            }
            if (!this.move) {
                if (this.getY() > stage.plataforma[this.nextPla].y - this.getHeight()) {
                    this.setPosition(this.getX(), stage.plataforma[this.nextPla].y - this.getHeight());
                }
            } else if (this.getY() > stage.plataforma[this.nextPla].y - this.getHeight()) {
                this.move = false;
            }
            super.nextFrame();
        }
    }

    public void flair() {
        this.isFlair = true;
        super.setTransform(1);
        this.cont = 1;
    }

    public void delete() {
        this.delete = true;
    }

    public void kill() {
        this.off();
        this.setPosition(this.getX(), -580);
        this.delete = true;
    }

    public void draw(Graphics g) {
        super.paint(g);
        if (this.isFlair) {
            this.cont = (byte)(this.cont + 1);
            if (this.cont > 5) {
                this.cont = 0;
                this.timer = (byte)(this.timer + 1);
            }
        }
    }

    public void on() {
        this.active = true;
    }

    public void off() {
        this.active = false;
    }
}

