/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class SuperEnemy
extends Sprite {
    private int sleep = 0;
    private int speedX = 0;
    private int speedY = 0;
    private int plaActive = -1;
    private boolean down = true;
    private boolean jump = true;
    private int incY = 0;
    private int xDestino = 0;
    private byte limitSleep = (byte)50;
    protected byte energy = 0;
    public boolean active = false;
    protected boolean isFlair = false;
    private boolean delete = false;
    private byte cont = 0;
    private byte timer = 0;
    private static final int JUMP_LIMIT = 100;
    private static final int JUMP_SPEED = 5;
    protected Fire fire;

    public SuperEnemy(Image img) {
        super(img, img.getWidth(), img.getHeight());
        int[] sequence = new int[]{0};
        this.setFrameSequence(sequence);
        this.setVisible(true);
        this.defineReferencePixel(img.getHeight() / 2, img.getHeight() / 2);
        this.setPosition(-20, -20);
        Image image = null;
        try {
            image = Image.createImage((String)"/bomba.png");
        }
        catch (IOException e) {
            System.out.println("no se cargo la imagen");
        }
        this.fire = new Fire(image, false);
        this.init();
    }

    public void init() {
        this.limitSleep = (byte)50;
        this.energy = (byte)((Interface.level + 1) / 2 + 6);
        this.off();
        this.setPosition(0, -15);
        this.timer = 0;
        this.isFlair = false;
        this.delete = false;
    }

    public void resetAll() {
        this.limitSleep = (byte)50;
    }

    public void start(Player player) {
        this.xDestino = player.getX();
        this.jump = true;
        this.down = true;
        Random rand = new Random();
        this.setPosition(Math.abs(rand.nextInt() % Interface.SCREEN_W), -15);
        this.sleep = 0;
        this.on();
        this.isFlair = false;
        this.timer = 0;
    }

    public void move(Stage stage, Player player, Explosion explo, Mapa mapa, ControlGroup group) {
        if (this.active) {
            if (!this.isFlair) {
                if (this.getY() <= Interface.SCREEN_H) {
                    if (this.jump) {
                        if (!this.down) {
                            this.move(0, -5);
                            this.incY += 5;
                            if (this.incY >= 100) {
                                this.down = true;
                            }
                        } else {
                            this.move(0, 5);
                            this.incY -= 5;
                            for (int n = 0; n < stage.plataforma.length; ++n) {
                                if (stage.plataforma[n].cuadros <= 0 || this.getX() + this.getWidth() <= stage.plataforma[n].x || this.getX() >= stage.plataforma[n].x + stage.plataforma[n].w || this.getY() + this.getHeight() < stage.plataforma[n].y || this.getY() + this.getHeight() > stage.plataforma[n].y + 5) continue;
                                this.down = false;
                                this.jump = false;
                                this.incY = 0;
                                this.plaActive = n;
                                this.setPosition(this.getX(), stage.plataforma[n].y - this.getHeight());
                                mapa.crash(2, 8);
                                stage.crash(2, 8);
                                group.activeEnemy(stage, player.getX());
                            }
                        }
                        if (this.xDestino < this.getX()) {
                            this.move(-1, 0);
                        } else if (this.xDestino > this.getX()) {
                            this.move(1, 0);
                        }
                    } else if (this.plaActive >= 0) {
                        this.setPosition(this.getX(), stage.plataforma[this.plaActive].y - this.getHeight());
                        ++this.sleep;
                        if (this.sleep == this.limitSleep) {
                            this.fire.startSearch(player, this);
                        } else if (this.sleep > this.limitSleep + 20) {
                            this.jump = true;
                            this.down = false;
                            this.incY = 0;
                            this.sleep = 0;
                            this.xDestino = player.getX();
                            if (this.limitSleep > 20 - Interface.level * 2) {
                                this.limitSleep = (byte)(this.limitSleep - 5);
                            }
                        }
                    }
                } else {
                    this.start(player);
                }
            } else if (this.delete) {
                this.move(0, 5);
                if (this.getY() + this.getHeight() > Interface.SCREEN_H) {
                    this.delete = false;
                    if (this.energy > 0) {
                        this.start(player);
                    } else {
                        this.off();
                    }
                }
            } else if (this.timer > 15) {
                this.isFlair = false;
                this.timer = 0;
            }
        }
        this.fire.compute();
    }

    public void draw(Graphics g) {
        if (this.active) {
            super.paint(g);
            this.fire.draw(g);
            if (this.isFlair) {
                g.setColor(0, 200, 0);
                g.drawArc(this.getX() - this.cont, this.getY() - this.cont, this.getWidth() + this.cont * 2, this.getHeight() + this.cont * 2, 0, 360);
                this.cont = (byte)(this.cont + 1);
                if (this.cont > 5) {
                    this.cont = 0;
                    this.timer = (byte)(this.timer + 1);
                }
            }
        }
    }

    public void drawEnergy(Graphics g) {
        for (int n = 1; n <= 10; ++n) {
            if (n > this.energy) {
                g.setColor(150, 150, 150);
            } else {
                g.setColor(198, 255, 26);
            }
            g.fillRect(Interface.SCREEN_W - 35 + 3 * n, Interface.SCREEN_H - 6, 2, 4);
        }
    }

    public void delete() {
        this.delete = true;
    }

    public boolean getDelete() {
        return this.delete;
    }

    public void flair() {
        this.isFlair = true;
        this.cont = 1;
    }

    public void off() {
        this.active = false;
    }

    public void on() {
        this.active = true;
    }
}

