/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

class Explosion
extends Sprite {
    private Particle particle = new Particle();
    private boolean fillExplo = false;
    public Smoke smoke;
    public static final int[] incX = new int[]{0, 1, 3, 1, 0, -1, -3, -1};
    public static final int[] incY = new int[]{-3, -1, 0, 1, 3, 1, 0, -1};

    public Explosion(Image pic) {
        super(pic, pic.getWidth() / 6, pic.getHeight());
        int[] sequence = new int[]{5, 4, 4, 3, 3, 3, 2, 2, 2, 1, 1, 1, 0, 0, 0, 0, 1, 2, 3, 3, 4, 4, 4, 5, 5, 5, 5};
        super.setFrameSequence(sequence);
        this.defineReferencePixel(pic.getHeight() / 2, pic.getHeight() / 2);
        this.setVisible(false);
        Image img = null;
        try {
            img = Image.createImage((String)"/humo.png");
        }
        catch (IOException e) {
            System.out.println("no se cargo la imagen");
        }
        this.smoke = new Smoke(img);
    }

    public void start(Sprite sp, int intensidad, boolean explo, boolean humo) {
        int posX = sp.getX() + sp.getWidth() / 2;
        int posY = sp.getY() + sp.getHeight() / 2;
        this.particle.start(posX, posY, intensidad);
        if (explo) {
            this.setFrame(0);
            this.setPosition(posX - this.getWidth() / 2, posY - this.getHeight() / 2);
            this.setVisible(true);
        }
        if (humo) {
            this.smoke.start(posX, posY);
        }
    }

    public void move(int incX) {
        this.move(incX, 0);
        this.smoke.move(incX, 0);
    }

    public void draw(Graphics g) {
        if (this.particle.active) {
            this.particle.draw(g, incX, incY);
            if (this.isVisible()) {
                this.paint(g);
                if (this.getFrame() == super.getFrameSequenceLength() - 1) {
                    this.setVisible(false);
                } else {
                    super.nextFrame();
                }
            }
        } else {
            this.smoke.draw(g);
            if (this.isVisible()) {
                this.setVisible(false);
            }
        }
    }
}

