/*
 * Decompiled with CFR 0.152.
 */
package sheet;

class Operand {
    private static final byte EMPTY = 0;
    private static final byte TEXT = 1;
    private static final byte NUMBER = 2;
    private static final byte NAME = 3;
    private byte type;
    private String text;
    private int number;

    Operand(int data) {
        this.number = data;
        this.type = (byte)2;
        this.text = String.valueOf(data);
    }

    Operand(String data) {
        int len = data.length();
        if (len == 0) {
            this.text = "";
            this.type = 0;
        } else if (data.charAt(0) == '\"' && data.charAt(len - 1) == '\"') {
            this.text = data.substring(1, len - 1);
            this.type = 1;
        } else {
            this.text = data;
            try {
                this.number = Integer.parseInt(this.text);
                this.type = (byte)2;
            }
            catch (NumberFormatException e) {
                this.type = (byte)3;
            }
        }
    }

    Operand(String data, boolean canBeNumber) {
        if (data.length() == 0) {
            this.text = data;
            this.type = 0;
        } else {
            this.text = data;
            if (canBeNumber) {
                try {
                    this.number = Integer.parseInt(this.text);
                    this.type = (byte)2;
                }
                catch (NumberFormatException e) {
                    this.type = 1;
                }
            } else {
                this.type = 1;
            }
        }
    }

    static final boolean isNumber(Operand op) {
        return op == null || op.type == 0 || op.type == 2;
    }

    static final boolean isName(Operand op) {
        return op != null && op.type == 3;
    }

    static final int getNumber(Operand op) throws NumberFormatException {
        if (op == null) {
            return 0;
        }
        switch (op.type) {
            case 2: {
                return op.number;
            }
            case 0: {
                return 0;
            }
        }
        throw new NumberFormatException("Not a number: '" + op.text + "'");
    }

    static final String getText(Operand op) throws NumberFormatException {
        if (op == null) {
            return "";
        }
        if (op.type != 3) {
            return op.text;
        }
        throw new NumberFormatException("Not a text: '" + op.text + "'");
    }

    static final String getName(Operand op) throws NumberFormatException {
        if (op == null) {
            throw new NumberFormatException("No data");
        }
        if (op.type == 3) {
            return op.text;
        }
        throw new NumberFormatException("Not a name: '" + op.text + "'");
    }
}

