/*
 * Decompiled with CFR 0.152.
 */
package sheet;

import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.TextBox;
import sheet.Backable;
import sheet.Calculator;
import sheet.CellCalc;
import sheet.CellContainer;
import sheet.Operand;

final class Cell {
    static final String[] colors = new String[]{"White", "Light Gray", "Black"};
    static final int BG_WHITE = 0;
    static final int BG_LGRAY = 1;
    static final int BG_BLACK = 2;
    static final String[] aligns = new String[]{"Default", "Right", "Center", "Left"};
    static final int AL_DEFAULT = 0;
    static final int AL_RIGHT = 1;
    static final int AL_CENTER = 2;
    static final int AL_LEFT = 3;
    private static CellContainer parent;
    private static Calculate calc;
    private byte column;
    private byte row;
    private short colorIdx = 0;
    private short alignIdx = 0;
    private String formula;
    private Operand result;
    private boolean calculated;
    private String errMsg;
    private Image image;

    public Cell(CellContainer cont, byte ccol, byte crow) {
        parent = cont;
        this.column = ccol;
        this.row = crow;
        this.calculated = true;
        this.render();
    }

    public boolean isData() {
        return this.colorIdx != 0 || this.formula != null;
    }

    public byte getRow() {
        return this.row;
    }

    public byte getColumn() {
        return this.column;
    }

    public void setColor(short color) {
        if (this.colorIdx != color) {
            this.colorIdx = color;
            parent.notifyChanged();
            this.render();
        }
    }

    public void setAlign(short align) {
        if (this.alignIdx != align) {
            this.alignIdx = align;
            parent.notifyChanged();
            this.render();
        }
    }

    public void render() {
        if (this.isData()) {
            short cellWidth = parent.getColumnWidth(this.column);
            int cellHeight = parent.getRowHeight(this.row);
            Font font = Font.getFont((int)64, (int)0, (int)8);
            int h = cellHeight - font.getHeight();
            int dx = 1;
            String text = this.errMsg == null ? (this.result == null ? "" : Operand.getText(this.result)) : this.errMsg;
            int slen = font.stringWidth(text);
            if (slen > 0) {
                int wid = cellWidth - 3;
                int ci = this.alignIdx;
                if (slen > wid) {
                    slen = wid;
                }
                if (ci == 0) {
                    ci = this.result != null && Operand.isNumber(this.result) ? 1 : 3;
                }
                switch (ci) {
                    case 1: {
                        dx = wid - slen;
                        break;
                    }
                    case 2: {
                        dx = (wid - slen) / 2;
                        break;
                    }
                    case 3: {
                        dx = 1;
                    }
                }
            }
            this.image = Image.createImage((int)cellWidth, (int)cellHeight);
            Graphics g = this.image.getGraphics();
            g.setColor(0);
            g.setFont(font);
            switch (this.colorIdx) {
                case 1: {
                    int even = 1 - cellWidth % 2;
                    int y = 1;
                    while (y < cellHeight) {
                        g.drawLine(0, y, cellHeight - 1 - y, cellHeight - 1);
                        g.drawLine(cellWidth - 1, y - even, cellWidth - 1 - y + even, 0);
                        y += 2;
                    }
                    int x = 1;
                    while (x <= cellWidth - cellHeight) {
                        g.drawLine(x, 0, x + cellHeight - 1, cellHeight - 1);
                        x += 2;
                    }
                    g.setColor(0xFFFFFF);
                    g.drawString(text, dx + 1, h + 1, 20);
                    g.setColor(0);
                    break;
                }
                case 2: {
                    g.fillRect(0, 0, (int)cellWidth, cellHeight);
                    g.setColor(0xFFFFFF);
                    break;
                }
            }
            g.drawString(text, dx, h, 20);
        } else {
            this.image = null;
        }
    }

    public int paint(Graphics g, int left, int top) {
        if (this.image != null) {
            g.drawImage(this.image, left, top, 20);
        }
        return this.colorIdx == 2 ? 0xFFFFFF : 0;
    }

    public String getName() {
        char col = (char)(65 + this.column);
        return String.valueOf(col) + String.valueOf(this.row + 1);
    }

    public String getDetails() {
        StringBuffer str = new StringBuffer();
        if (this.formula != null) {
            str.append("Formula: ");
            str.append(this.formula);
            str.append("\n");
            if (this.errMsg != null) {
                str.append("Error: ");
                str.append(this.errMsg);
            } else if (this.result != null) {
                str.append("Result: ");
                str.append(Operand.getText(this.result));
            } else {
                str.append("No result");
            }
        }
        return str.toString();
    }

    public void notCalculated() {
        this.result = null;
        this.calculated = false;
    }

    public boolean isCalculated() {
        return this.calculated;
    }

    public void paste(Cell cell) {
        if (cell != null) {
            this.formula = cell.formula;
            this.colorIdx = cell.colorIdx;
            this.alignIdx = cell.alignIdx;
            parent.notifyChanged();
            parent.calculate();
        }
    }

    public boolean calculate() {
        this.calculated = true;
        this.errMsg = null;
        if (this.formula != null) {
            CellCalc parser = new CellCalc(calc);
            char fchar = this.formula.charAt(0);
            if (fchar == '=' && this.formula.length() > 1) {
                try {
                    this.result = parser.calculate(this.formula, (short)1, (short)this.formula.length());
                }
                catch (IllegalArgumentException e) {
                    this.calculated = false;
                    this.result = null;
                    this.errMsg = e.getMessage();
                }
            } else {
                this.result = fchar == '\'' ? new Operand(this.formula.substring(1), false) : new Operand(this.formula, true);
            }
        }
        this.render();
        return this.calculated;
    }

    public void edit(String def_str, final Backable back, final Display disp) {
        int mode = 0;
        if (def_str == null) {
            def_str = this.formula;
        } else if (def_str.length() > 0 && Character.isDigit(def_str.charAt(0))) {
            mode = 2;
        }
        String name = this.getName();
        final Command okCommand = new Command("Ok", 4, 0);
        Command cancelCommand = new Command("Cancel", 3, 0);
        final Command helpCommand = new Command("Help", 5, 0);
        TextBox editor = new TextBox(name, def_str, 50, mode);
        editor.setCommandListener(new CommandListener(){

            public void commandAction(Command cmd, Displayable obj) {
                TextBox me = (TextBox)obj;
                if (cmd == helpCommand) {
                    calc.showHelp((Displayable)me, disp);
                } else {
                    if (cmd == okCommand) {
                        if (Cell.this.formula != me.getString()) {
                            Cell.this.formula = me.getString();
                            if (Cell.this.formula.length() == 0) {
                                Cell.this.formula = null;
                            }
                            parent.notifyChanged();
                        }
                        Cell.this.errMsg = null;
                        parent.calculate();
                    }
                    back.show();
                }
            }
        });
        editor.addCommand(okCommand);
        editor.addCommand(cancelCommand);
        editor.addCommand(helpCommand);
        disp.setCurrent((Displayable)editor);
    }

    public boolean appendChar(char ch, boolean fromStart) {
        int len;
        this.formula = ch == '\b' && this.formula != null ? ((len = this.formula.length()) > 1 ? this.formula.substring(0, len - 1) : null) : (fromStart || this.formula == null ? String.valueOf(ch) : this.formula + ch);
        parent.notifyChanged();
        parent.calculate();
        return this.formula != null && this.formula.length() != 0;
    }

    public byte[] serialize(int version) {
        byte[] data;
        if (this.isData() && version == 1) {
            byte[] formb = this.formula == null ? new byte[]{} : this.formula.getBytes();
            data = new byte[formb.length + 4];
            data[0] = this.column;
            data[1] = this.row;
            data[2] = (byte)this.colorIdx;
            data[3] = (byte)this.alignIdx;
            System.arraycopy(formb, 0, data, 4, formb.length);
        } else {
            data = null;
        }
        return data;
    }

    public static Cell deserialize(byte[] data, CellContainer cont, int version) {
        Cell cell;
        if (version == 1 && data != null) {
            cell = new Cell(cont, data[0], data[1]);
            cell.colorIdx = data[2];
            cell.alignIdx = data[3];
            cell.formula = new String(data, 4, data.length - 4);
            if (cell.formula.length() == 0) {
                cell.formula = null;
            }
            cell.calculated = false;
        } else {
            cell = null;
        }
        return cell;
    }

    static {
        calc = new Calculate();
    }

    private static class Calculate
    implements Calculator {
        private Calculate() {
        }

        public void showHelp(Displayable back, Display disp) {
            Alert scr = new Alert("Formula help", "To enter a formula, start with '=' sign.\nCell reference: A1/a1..Z99/z99\nMath operators: +, -, *, /, ()\nForce textual value: ', or embrace with \"\"\nBuilt-in functions (case-insensitive):\n  abs(x)\n  sum(a, b, ...)\n  str(n)->string\n  num(s)->number", null, null);
            scr.setTimeout(-2);
            disp.setCurrent(scr, back);
        }

        private Operand checkOperand(Operand arg) throws IllegalArgumentException {
            if (Operand.isName(arg)) {
                Cell c = parent.getByName(Operand.getName(arg));
                if (c != null) {
                    if (c.errMsg != null) {
                        throw new IllegalArgumentException("'" + Operand.getName(arg) + "' doesn't have a value");
                    }
                    if (!c.calculated) {
                        throw new IllegalArgumentException();
                    }
                    arg = c.result;
                } else {
                    arg = null;
                }
            }
            return arg;
        }

        public Operand oper(short operation, Operand op1, Operand op2) throws IllegalArgumentException {
            Operand res;
            Operand a = this.checkOperand(op1);
            Operand b = this.checkOperand(op2);
            switch (operation) {
                case 1: {
                    res = new Operand(-Operand.getNumber(a));
                    break;
                }
                case 2: {
                    if (Operand.isNumber(a) && Operand.isNumber(b)) {
                        res = new Operand(Operand.getNumber(a) + Operand.getNumber(b));
                        break;
                    }
                    res = new Operand(Operand.getText(a) + Operand.getText(b), false);
                    break;
                }
                case 3: {
                    res = new Operand(Operand.getNumber(a) - Operand.getNumber(b));
                    break;
                }
                case 4: {
                    res = new Operand(Operand.getNumber(a) * Operand.getNumber(b));
                    break;
                }
                case 5: {
                    res = new Operand(Operand.getNumber(a) / Operand.getNumber(b));
                    break;
                }
                default: {
                    res = a;
                }
            }
            return res;
        }

        public Operand call(String fname, Operand[] args) throws IllegalArgumentException {
            String fnocase = fname.toLowerCase();
            StringBuffer addon = new StringBuffer("()");
            if (fnocase.equals("abs")) {
                if (args.length == 1) {
                    return new Operand(Math.abs(Operand.getNumber(this.checkOperand(args[0]))));
                }
                addon.append(" has 1 argument");
            } else if (fnocase.equals("str")) {
                if (args.length == 1) {
                    return new Operand(Operand.getText(this.checkOperand(args[0])), false);
                }
                addon.append(" has 1 argument");
            } else if (fnocase.equals("num")) {
                if (args.length == 1) {
                    Operand trial = new Operand(Operand.getText(this.checkOperand(args[0])), true);
                    if (Operand.isNumber(trial)) {
                        return trial;
                    }
                    addon.append(": '");
                    addon.append(trial);
                    addon.append("' is not a number");
                } else {
                    addon.append(" has 1 argument");
                }
            } else {
                if (fnocase.equals("sum")) {
                    int sum = 0;
                    int i = 0;
                    while (i < args.length) {
                        sum += Operand.getNumber(this.checkOperand(args[i]));
                        ++i;
                    }
                    return new Operand(sum);
                }
                addon.append(" doesn't exist");
            }
            throw new IllegalArgumentException(fname + addon.toString());
        }
    }
}

