/*
 * Decompiled with CFR 0.152.
 */
package com.george.games.menus;

import com.george.games.Drawable;
import com.george.games.menus.MainMenu;
import com.george.headfall.Main;
import com.george.headfall.Viewport;
import com.george.headfall.res.ResMenu;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class Help
implements Drawable {
    private Image offline = Image.createImage((int)Viewport.WIDTH, (int)Viewport.HEIGHT);
    private int index;
    private Image image;
    private Sprite back;
    private Sprite next;
    private Sprite exit;
    private Vector vecSprites;
    private Sprite pointer = new Sprite(Image.createImage((int)5, (int)5));
    private int selectedIndex;

    public Help(int index) {
        this.pointer.setPosition(-5, -5);
        this.vecSprites = new Vector();
        this.index = index;
        if (index < 0) {
            index = 0;
        }
        if (index > 3) {
            index = 3;
        }
        switch (index) {
            case 0: {
                this.image = ResMenu.HELP0;
                break;
            }
            case 1: {
                this.image = ResMenu.HELP1;
                break;
            }
            case 2: {
                this.image = ResMenu.HELP2;
                break;
            }
            case 3: {
                this.image = ResMenu.HELP3;
            }
        }
        this.back = ResMenu.BACK;
        this.next = ResMenu.NEXT;
        this.exit = ResMenu.EXIT_HELP;
        this.exit.setPosition(200, 15);
        this.exit.setFrame(0);
        this.back.setPosition(10, 265);
        this.back.setFrame(0);
        this.next.setPosition(180, 265);
        this.next.setFrame(0);
        if (index == 0) {
            this.back.setPosition(-100, -100);
        } else if (index == 3) {
            this.next.setPosition(-100, -100);
        }
        this.vecSprites.addElement(this.exit);
        this.vecSprites.addElement(this.next);
        this.vecSprites.addElement(this.back);
    }

    public void cycle() {
    }

    public void draw(Graphics gg) {
        Graphics g = this.offline.getGraphics();
        g.drawImage(this.image, 0, 0, 0);
        this.exit.paint(g);
        this.back.paint(g);
        this.next.paint(g);
        this.drawSelected(g);
        if (Main.container.getWidth() < Main.container.getHeight()) {
            gg.drawImage(this.offline, 0, 0, 0);
        } else {
            gg.drawImage(Image.createImage((Image)this.offline, (int)0, (int)0, (int)Viewport.WIDTH, (int)Viewport.HEIGHT, (int)6), 0, 0, 0);
        }
    }

    public void pointerPressed(int x, int y) {
        this.pointer.setPosition(x, y);
        Sprite sprite = null;
        for (int j = 0; j < this.vecSprites.size(); ++j) {
            sprite = (Sprite)this.vecSprites.elementAt(j);
            if (this.pointer.collidesWith(sprite, true)) {
                sprite.setFrame(1);
                continue;
            }
            sprite.setFrame(0);
        }
        this.pointer.setPosition(-5, -5);
        Main.container.repaint();
    }

    public void pointerReleased(int x, int y) {
        this.pointer.setPosition(x, y);
        if (this.pointer.collidesWith(this.back, false)) {
            Main.setCurrent(new Help(this.index - 1));
        } else if (this.pointer.collidesWith(this.next, false)) {
            Main.setCurrent(new Help(this.index + 1));
        } else if (this.pointer.collidesWith(this.exit, false)) {
            Main.setCurrent(new MainMenu());
        }
        this.resetAll();
        this.pointer.setPosition(-5, -5);
        Main.container.repaint();
    }

    public void pointerDragged(int x, int y) {
        this.pointer.setPosition(x, y);
        Sprite sprite = null;
        for (int j = 0; j < this.vecSprites.size(); ++j) {
            sprite = (Sprite)this.vecSprites.elementAt(j);
            if (this.pointer.collidesWith(sprite, true)) {
                sprite.setFrame(1);
                continue;
            }
            sprite.setFrame(0);
        }
        this.pointer.setPosition(-5, -5);
        Main.container.repaint();
    }

    private void resetAll() {
        Sprite sprite = null;
        for (int j = 0; j < this.vecSprites.size(); ++j) {
            sprite = (Sprite)this.vecSprites.elementAt(j);
            sprite.setFrame(0);
        }
    }

    public void keyPressed(int keyCode) {
        int k = Main.container.getGameAction(keyCode);
        if (k == 6) {
            this.selectedIndex = (this.selectedIndex + 1) % this.vecSprites.size();
        } else if (k == 1) {
            --this.selectedIndex;
            if (this.selectedIndex < 0) {
                this.selectedIndex = this.vecSprites.size() - 1;
            }
        } else if (k == 8) {
            Sprite sp = (Sprite)this.vecSprites.elementAt(this.selectedIndex);
            this.pointerReleased(sp.getX(), sp.getY());
        } else if (k == 2) {
            Main.setCurrent(new Help(this.index - 1));
        } else if (k == 5) {
            Main.setCurrent(new Help(this.index + 1));
        }
        Main.container.repaint();
    }

    public void input(int keyStates) {
    }

    private void drawSelected(Graphics g) {
        if (Main.TOUCH_SUPPORT) {
            return;
        }
        Sprite sp = (Sprite)this.vecSprites.elementAt(this.selectedIndex);
        g.setColor(16253967);
        g.drawRect(sp.getX(), sp.getY(), sp.getWidth() - 2, sp.getHeight() - 2);
        g.drawRect(sp.getX() + 1, sp.getY() + 1, sp.getWidth() - 4, sp.getHeight() - 4);
    }
}

