/*
 * Decompiled with CFR 0.152.
 */
package com.george.headfall;

import com.george.headfall.Main;
import com.george.headfall.Setting;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;

public class SoundsPlayer
implements Runnable {
    private static SoundsPlayer spacePlayer;
    private Player main;
    private Player jump;
    private Player gameover;
    private Player dollar;
    private Player success;
    private Player jewel;
    private Player bottle;
    private Player rock;
    private Player spider;
    private boolean mainRunning;
    private boolean jumpRunning;
    private boolean gameoverrunning;
    private boolean dollarRunning;
    private boolean successRunning;
    private boolean jewelRunning;
    private boolean bottleRunning;
    private boolean rockRunning;
    private boolean spiderRunning;
    private Setting setting;
    private boolean paused;
    private boolean running;
    private Vector vecJumps = new Vector();
    private boolean mainStopped;

    private SoundsPlayer() {
        this.setting = Setting.getInstance();
        if (!this.setting.isSound()) {
            this.paused = true;
        }
        this.create();
    }

    public static SoundsPlayer getInstance() {
        if (spacePlayer == null) {
            spacePlayer = new SoundsPlayer();
        }
        return spacePlayer;
    }

    private Player getNotRunningJump() {
        Player player = null;
        for (int j = 0; j < this.vecJumps.size(); ++j) {
            player = (Player)this.vecJumps.elementAt(j);
            if (player.getState() == 400) continue;
            return player;
        }
        return this.jump;
    }

    private void create() {
        try {
            InputStream in = this.getClass().getResourceAsStream("/audio/main.mid");
            this.main = Manager.createPlayer((InputStream)in, (String)"audio/mid");
            this.main.setLoopCount(50000);
            in = this.getClass().getResourceAsStream("/audio/spider.wav");
            this.spider = Manager.createPlayer((InputStream)in, (String)"audio/wav");
            in = this.getClass().getResourceAsStream("/audio/over.wav");
            this.gameover = Manager.createPlayer((InputStream)in, (String)"audio/wav");
            in = this.getClass().getResourceAsStream("/audio/dollar.wav");
            this.dollar = Manager.createPlayer((InputStream)in, (String)"audio/wav");
            in = this.getClass().getResourceAsStream("/audio/success.wav");
            this.success = Manager.createPlayer((InputStream)in, (String)"audio/wav");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int j = 0;
        while (this.running) {
            boolean isForgeground;
            if (this.paused) {
                try {
                    SoundsPlayer soundsPlayer = this;
                    synchronized (soundsPlayer) {
                        this.wait();
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            if (isForgeground = Main.isForeground()) {
                try {
                    if (!this.mainStopped && this.mainRunning && this.main.getState() != 400) {
                        this.main.start();
                    } else if (!this.mainRunning && this.mainStopped) {
                        this.main.stop();
                    }
                    if (j % 10 == 0 && this.jumpRunning) {
                        Player p = this.getNotRunningJump();
                        p.start();
                        this.jumpRunning = false;
                    }
                    if (this.gameoverrunning) {
                        this.gameover.start();
                        this.gameoverrunning = false;
                    }
                    if (this.dollarRunning) {
                        this.dollar.start();
                        this.dollarRunning = false;
                    }
                    if (this.successRunning) {
                        this.success.start();
                        this.successRunning = false;
                    }
                    if (this.jewelRunning) {
                        this.jewel.start();
                        this.jewelRunning = false;
                    }
                    if (this.bottleRunning) {
                        this.bottle.start();
                        this.bottleRunning = false;
                    }
                    if (this.rockRunning) {
                        this.rock.start();
                        this.rockRunning = false;
                    }
                    if (this.spiderRunning) {
                        this.spider.start();
                        this.spiderRunning = false;
                    }
                }
                catch (MediaException ex) {
                    ex.printStackTrace();
                }
            }
            if (!isForgeground) {
                this.stopAll();
            }
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {}
        }
    }

    public void runMain() {
        this.mainRunning = true;
        this.mainStopped = false;
    }

    public void runjump() {
    }

    public void runGameOver() {
        this.gameoverrunning = true;
    }

    public void runspider() {
        this.spiderRunning = true;
    }

    public void rundollar() {
        this.dollarRunning = true;
    }

    public void runjewel() {
        this.dollarRunning = true;
    }

    public void runSuccess() {
        this.successRunning = true;
    }

    public void runbottle() {
        this.dollarRunning = true;
    }

    public void runrock() {
        this.spiderRunning = true;
    }

    public void stopMain() {
        this.mainStopped = true;
        this.mainRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        this.stopAllEffects();
        this.paused = false;
        SoundsPlayer soundsPlayer = this;
        synchronized (soundsPlayer) {
            this.notify();
        }
    }

    public void pause() {
        this.paused = true;
        this.stopAll();
    }

    private synchronized void stopAllMain() {
        try {
            this.mainRunning = false;
            this.main.stop();
            this.main.realize();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private synchronized void stopAll() {
        try {
            this.main.stop();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void stopAllEffects() {
        this.jumpRunning = false;
        this.gameoverrunning = false;
        this.dollarRunning = false;
        this.successRunning = false;
        this.jewelRunning = false;
        this.bottleRunning = false;
        this.rockRunning = false;
        this.spiderRunning = false;
    }

    public void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        Thread t = new Thread(this);
        t.setPriority(10);
        t.start();
    }
}

