/*
 * Decompiled with CFR 0.152.
 */
package com.inode.democountdown;

import com.inode.democountdown.ICountdownListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Calendar;
import java.util.Date;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class DemoCountdown {
    static final int DEFAULT_LSK = 0;
    static final int DEFAULT_RSK = 0;
    static final int DEFAULT_TIMEOUT = 300000;
    static final String DEFAULT_IMGNAME_BANNER_EN = "/popup_en.png";
    static final String DEFAULT_IMGNAME_BANNER_ES = "/popup_es.png";
    static final String DEFAULT_IMGNAME_RSK_EN = "/rsk_en.png";
    static final String DEFAULT_IMGNAME_RSK_ES = "/rsk_es.png";
    static final String DEFAULT_IMGNAME_LSK_EN = "/lsk_en.png";
    static final String DEFAULT_IMGNAME_LSK_ES = "/lsk_es.png";
    boolean _hasCountdownExpired;
    boolean _isInEnglish;
    int _acceptKey;
    int _cancelKey;
    String _gameURL;
    String _imgNamePopup;
    String _imgNameRSK;
    String _imgNameLSK;
    Image _imgPopup;
    Image _imgRSK;
    Image _imgLSK;
    ICountdownListener _listener;
    MIDlet _midlet;
    Canvas _canvas;

    public DemoCountdown(boolean isInEnglish, String completeGameURL, Canvas canvas, MIDlet midletApp, ICountdownListener listener) {
        this._isInEnglish = !isInEnglish;
        this.setIsInEnglish(isInEnglish);
        this._midlet = midletApp;
        this._canvas = canvas;
        this._listener = listener;
        this._hasCountdownExpired = false;
        this._gameURL = completeGameURL;
        this._acceptKey = 0;
        this._cancelKey = 0;
        Thread sleeper = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(300000L);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
                DemoCountdown.this.timeoutEnded();
            }
        });
        sleeper.start();
    }

    public void paint(Graphics g) {
        if (!this._hasCountdownExpired) {
            return;
        }
        g.setClip(0, 0, this._canvas.getWidth(), this._canvas.getHeight());
        g.setColor(0);
        g.fillRect(0, 0, this._canvas.getWidth(), this._canvas.getHeight());
        if (this._imgPopup != null) {
            g.drawImage(this._imgPopup, this._canvas.getWidth() >> 1, this._canvas.getHeight() >> 1, 3);
        }
        if (this._imgRSK != null) {
            g.drawImage(this._imgRSK, this._canvas.getWidth(), this._canvas.getHeight(), 40);
        }
        if (this._imgLSK != null) {
            g.drawImage(this._imgLSK, 0, this._canvas.getHeight(), 36);
        }
    }

    public void keyPressed(int key) {
        if (!this._hasCountdownExpired) {
            return;
        }
        if (key == this._acceptKey) {
            this.acceptDemo();
        } else if (key == this._cancelKey) {
            this.cancelDemo();
        }
    }

    public void touchended(int x, int y) {
        if (!this._hasCountdownExpired) {
            return;
        }
        if (this.rectContainsPoint(this._canvas.getWidth() - this._imgRSK.getWidth(), this._canvas.getHeight() - this._imgRSK.getHeight(), this._imgRSK.getWidth(), this._imgRSK.getHeight(), x, y)) {
            this.acceptDemo();
        } else if (this.rectContainsPoint(0, this._canvas.getHeight() - this._imgLSK.getHeight(), this._imgLSK.getWidth(), this._imgLSK.getHeight(), x, y)) {
            this.cancelDemo();
        }
    }

    public void setIsInEnglish(boolean isInEnglish) {
        if (this._isInEnglish != isInEnglish) {
            this._isInEnglish = isInEnglish;
            if (this._isInEnglish) {
                this._imgNamePopup = DEFAULT_IMGNAME_BANNER_EN;
                this._imgNameRSK = DEFAULT_IMGNAME_RSK_EN;
                this._imgNameLSK = DEFAULT_IMGNAME_LSK_EN;
            } else {
                this._imgNamePopup = DEFAULT_IMGNAME_BANNER_ES;
                this._imgNameRSK = DEFAULT_IMGNAME_RSK_ES;
                this._imgNameLSK = DEFAULT_IMGNAME_LSK_ES;
            }
            try {
                this._imgPopup = Image.createImage((String)this._imgNamePopup);
                this._imgLSK = Image.createImage((String)this._imgNameLSK);
                this._imgRSK = Image.createImage((String)this._imgNameRSK);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isInEnglish() {
        return this._isInEnglish;
    }

    public void setAcceptKey(int key) {
        this._acceptKey = key;
    }

    public int getAcceptKey() {
        return this._acceptKey;
    }

    public int getCancelKey() {
        return this._cancelKey;
    }

    public void setCancelKey(int key) {
        this._cancelKey = key;
    }

    private void acceptDemo() {
        if (null != this._midlet && null != this._gameURL) {
            try {
                this._midlet.platformRequest(this._gameURL);
            }
            catch (ConnectionNotFoundException cnfe) {
                cnfe.printStackTrace();
            }
        }
        this.cancelDemo();
    }

    private void cancelDemo() {
        if (this._midlet != null) {
            this._midlet.notifyDestroyed();
        }
    }

    private void timeoutEnded() {
        this._hasCountdownExpired = true;
        if (this._listener != null) {
            this._listener.countdownHasEnded();
        }
        this._canvas.repaint();
        this._canvas.serviceRepaints();
    }

    private boolean rectContainsPoint(int rectX, int rectY, int rectW, int rectH, int pointX, int pointY) {
        return pointX > rectX && pointX < rectX + rectW && pointY > rectY && pointY < rectY + rectH;
    }

    class TimeoutRecord {
        private RecordStore _recordStore = null;
        private DataInputStream _dis = null;
        private DataOutputStream _dos = null;
        private ByteArrayOutputStream _baos = null;
        private byte[] _data = null;
        private long _timePlayed = 0L;
        private long _initialTime;
        private boolean _isReadOnly;

        public TimeoutRecord() {
            try {
                this.open(true);
                this._timePlayed = this._dis.readLong();
                long dateHash = this._dis.readLong();
                this._dis.readBoolean();
                this.close();
                if (dateHash != this.getTodaysHash()) {
                    this.reset();
                    this._timePlayed = 0L;
                }
            }
            catch (Exception e) {
                this.close();
                this.reset();
                this._timePlayed = 0L;
            }
            this._initialTime = System.currentTimeMillis();
        }

        private void reset() {
            this.open(false);
            try {
                this._dos.writeLong(0L);
                this._dos.writeLong(0L);
                this._dos.writeBoolean(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.close();
        }

        private void openRecordManager() {
            if (this._recordStore == null) {
                try {
                    this._recordStore = RecordStore.openRecordStore((String)"demo_timeout", (boolean)true);
                }
                catch (RecordStoreException recordStoreException) {
                    // empty catch block
                }
            }
        }

        private byte[] getDataByteArray() {
            byte[] data;
            try {
                data = this._recordStore.getRecord(1);
            }
            catch (RecordStoreException rse) {
                data = null;
            }
            return data;
        }

        private void open(boolean isReadOnly) {
            this.openRecordManager();
            this._isReadOnly = isReadOnly;
            if (this._isReadOnly) {
                this._data = this.getDataByteArray();
                if (this._data != null) {
                    ByteArrayInputStream bais = new ByteArrayInputStream(this._data);
                    this._dis = new DataInputStream(bais);
                }
            } else {
                this._baos = new ByteArrayOutputStream(50);
                this._dos = new DataOutputStream(this._baos);
            }
        }

        private void close() {
            try {
                if (!this._isReadOnly) {
                    try {
                        this._data = this._baos.toByteArray();
                        this._recordStore.setRecord(1, this._data, 0, this._data.length);
                    }
                    catch (InvalidRecordIDException iride) {
                        this._recordStore.addRecord(this._data, 0, this._data.length);
                    }
                    this._dos.close();
                    this._baos.close();
                } else if (this._dis != null) {
                    this._dis.close();
                }
                this._recordStore.closeRecordStore();
                this._data = null;
                this._dos = null;
                this._baos = null;
                this._dis = null;
                this._recordStore = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private long getTodaysHash() {
            long dateHash = 0L;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            int day = calendar.get(5);
            int month = calendar.get(2);
            int year = calendar.get(1);
            dateHash = day + month * 100 + year * 10000;
            return dateHash;
        }

        private long updateLastPlayedDateHash() {
            long dateHash = this.getTodaysHash();
            try {
                this._dos.writeLong(dateHash);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return dateHash;
        }

        private long updateTimePlayed() {
            this._timePlayed += System.currentTimeMillis() - this._initialTime;
            this._initialTime = System.currentTimeMillis();
            this.open(false);
            try {
                this._dos.writeLong(this._timePlayed);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.updateLastPlayedDateHash();
            try {
                this._dos.writeBoolean(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.close();
            return this._timePlayed;
        }

        private void setHasTimeExpiredFlag() {
            this.open(false);
            try {
                this._dos.writeLong(this._timePlayed);
                this._dos.writeLong(this.getTodaysHash());
                this._dos.writeBoolean(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.close();
        }

        public boolean timeHasExpired() {
            boolean timeHasExpired;
            boolean bl = timeHasExpired = 300000L - this.updateTimePlayed() < 0L;
            if (timeHasExpired) {
                this.setHasTimeExpiredFlag();
            }
            return timeHasExpired;
        }
    }
}

