/*
 * Decompiled with CFR 0.152.
 */
package com.inodesoft.game;

import com.inodesoft.game.GameEngine;
import com.inodesoft.game.MainMIDlet;
import com.inodesoft.game.tools.ICAnimation;
import com.inodesoft.game.tools.ICFont;
import com.inodesoft.game.tools.ICFunctions;
import com.inodesoft.game.tools.ICKeyboard;
import com.inodesoft.game.tools.ICMusic;
import com.inodesoft.game.tools.ICResourceManager;
import java.io.UnsupportedEncodingException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MainEngine
extends Canvas {
    private static MainEngine m_instance;
    private final MainMIDlet gm;
    private GameEngine ge = null;
    public ICMusic mm = null;
    private final ICResourceManager resManager;
    private ICAnimation my_spaceship = null;
    private ICAnimation my_inodelogo = null;
    public ICAnimation menu_icons = null;
    public ICAnimation dpad = null;
    public ICAnimation arrows = null;
    private Image bck_image = null;
    public ICFont fnt_menu = null;
    public ICFont fnt_small = null;
    public String[] lang = null;
    public final int LANG_EN;
    public final int LANG_ES;
    public int curr_language = 0;
    private boolean running;
    private long lastProcessTime;
    private long state_time;
    private long pauseTime = 0L;
    private boolean isPaused = false;
    private static int MAX_PROCESS;
    private static int SPLASH_TIME;
    public boolean cheatActivated = false;
    public static boolean soundActivated;
    public byte prev_app_state;
    public byte curr_app_state;
    public byte next_app_state;
    public static final byte STATE_NONE = -1;
    public static final byte STATE_LANGUAGE_SELECT = 0;
    public static final byte STATE_LOADING = 1;
    public static final byte STATE_LOGO = 2;
    public static final byte STATE_SOUND_QUESTION = 3;
    public static final byte STATE_SPLASH = 4;
    public static final byte STATE_MAIN_MENU = 5;
    public static final byte STATE_GAMEPLAY = 6;
    public static final byte STATE_CONFIG_MENU = 7;
    public static final byte STATE_HELP = 8;
    public static final byte STATE_ABOUT = 9;
    public static final byte STATE_EXIT_QUESTION = 10;
    public static final byte STATE_VDPAD_TUTORIAL = 11;
    public byte app_state_process;
    public static final byte STATE_PROCESS_NULL = -1;
    public static final byte STATE_PROCESS_BEGIN = 0;
    public static final byte STATE_PROCESS_UPDATE = 1;
    public static final byte STATE_PROCESS_END = 2;
    public static int sidx_main;
    public static int sidx_ray;
    public static int sidx_exp;
    public static int sidx_shoot;
    public static int sidx_m_end;
    public static int sidx_m_loose;
    public static int sidx_m_vict;
    public static int sidx_opt;
    public static int sidx_bgm;
    public static int sidx_plane;
    public static int sidx_car;
    public static int sidx_helic;
    public static int sidx_jeep;
    public static int sidx_gun;
    public static int sidx_tank;
    String sk_left;
    String sk_right;
    int language_option;
    private int my_spshp_x;
    private int my_spshp_y;
    private int curr_option_menu = 0;
    int help_first_line = 0;
    int about_first_line = 0;
    public static final int DIR_NONE = 0;
    public static final int DIR_LEFT = 1;
    public static final int DIR_RIGHT = 2;
    public static final int DIR_UP = 3;
    public static final int DIR_DOWN = 4;
    public static final int DIR_UL = 5;
    public static final int DIR_UR = 6;
    public static final int DIR_DL = 7;
    public static final int DIR_DR = 8;
    public int pressed_direction = -1;
    public boolean pressed_fire = false;
    public boolean pressed_ray = false;
    public int dpad_height = 0;
    public int touch_zone_w;
    public int touch_zone_h;
    public int but_w;
    public int but_h;

    public MainEngine(MainMIDlet gm) {
        this.LANG_EN = 0;
        this.LANG_ES = 1;
        this.setFullScreenMode(true);
        m_instance = this;
        this.gm = gm;
        this.curr_app_state = (byte)-1;
        this.prev_app_state = (byte)-1;
        this.next_app_state = (byte)-1;
        this.resManager = ICResourceManager.getInstance();
        this.fnt_menu = new ICFont(this.resManager.getResourceAsStream("font_menu.ssf"), new int[][]{{16758016}, {16734014}, {6655231}});
        this.fnt_small = new ICFont(this.resManager.getResourceAsStream("font_big.ssf"), null);
        this.menu_icons = new ICAnimation(this.resManager.getResourceAsStream("menu_sprites.lqa"));
        this.dpad = new ICAnimation(this.resManager.getResourceAsStream("touch.lqa"));
        this.dpad_height = this.dpad.getFrameHeight(0);
        this.touch_zone_w = this.dpad.getSpriteWidth(1);
        this.touch_zone_h = this.dpad.getSpriteHeight(1);
        this.but_w = this.dpad.getSpriteWidth(2);
        this.but_h = this.dpad.getSpriteHeight(2);
        this.arrows = new ICAnimation(this.resManager.getResourceAsStream("arrows.lqa"));
        this.loadLanguage();
        this.mm = new ICMusic();
        sidx_main = this.mm.loadSound("main_theme.mid");
        System.out.println(ICMusic.msn);
        sidx_opt = this.mm.loadSound("option_selection.wav");
        System.out.println(ICMusic.msn);
    }

    public void loadLanguage() {
        int i;
        this.lang = null;
        System.gc();
        if (this.curr_language == 0) {
            this.lang = ICFunctions.loadLang(ICResourceManager.getInstance().getResourceAsStream("texts_en.txt"), 54);
            for (i = 0; i < 54; ++i) {
                try {
                    this.lang[i] = new String(this.lang[i].getBytes(), "UTF-8");
                    continue;
                }
                catch (UnsupportedEncodingException ex) {
                    // empty catch block
                }
            }
        } else if (this.curr_language == 1) {
            this.lang = ICFunctions.loadLang(ICResourceManager.getInstance().getResourceAsStream("texts_es.txt"), 54);
            for (i = 0; i < 54; ++i) {
                try {
                    this.lang[i] = new String(this.lang[i].getBytes(), "UTF-8");
                    continue;
                }
                catch (UnsupportedEncodingException ex) {
                    // empty catch block
                }
            }
        }
        String vendor = this.gm.getAppProperty("MIDlet-Vendor").toUpperCase();
        String midName = this.gm.getAppProperty("MIDlet-Name").toUpperCase();
        String version = this.gm.getAppProperty("MIDlet-Version").toUpperCase();
        String text = this.lang[16];
        text = ICFunctions.replace(text, "$APPNAME$", midName);
        text = ICFunctions.replace(text, "$VERSION$", version);
        this.lang[16] = text = ICFunctions.replace(text, "$VENDOR$", vendor);
    }

    public static MainEngine getInstance() {
        return m_instance;
    }

    void run() {
        this.running = true;
        while (this.running) {
            this.lastProcessTime = System.currentTimeMillis();
            this.process();
            this.repaint();
            this.serviceRepaints();
            long time = System.currentTimeMillis() - this.pauseTime;
            if (!this.isPaused) {
                this.state_time += time - this.lastProcessTime;
            }
            if (time - this.lastProcessTime < (long)MAX_PROCESS) {
                this.sleep(MAX_PROCESS - (int)(time - this.lastProcessTime));
                continue;
            }
            this.sleep(1);
        }
        m_instance = null;
    }

    public void pause() {
        System.out.println("pausing");
        this.isPaused = true;
        this.mm.stopAllSound();
        if (this.ge != null) {
            this.ge.pause();
        }
    }

    public void resume() {
        System.out.println("resuming");
        if (this.ge != null) {
            this.ge.resume();
            this.mm.playSound(sidx_bgm);
        }
        this.mm.playSound(this.mm.actualSound);
        this.isPaused = false;
    }

    protected void hideNotify() {
        this.pause();
    }

    protected void showNotify() {
        this.resume();
    }

    public void changeState(byte newState) {
        this.next_app_state = newState;
        this.app_state_process = (byte)2;
    }

    public void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void process() {
        switch (this.curr_app_state) {
            case -1: {
                this.changeState((byte)2);
                break;
            }
            case 0: {
                this.processLanguageSelect();
                break;
            }
            case 2: {
                this.processLogo();
                break;
            }
            case 1: {
                this.processLoading();
                break;
            }
            case 4: {
                this.processSplash();
                break;
            }
            case 5: {
                this.processMainMenu();
                break;
            }
            case 8: {
                this.processHelp();
                break;
            }
            case 9: {
                this.processAbout();
                break;
            }
            case 10: {
                this.processExitQuestion();
                break;
            }
            case 3: {
                this.processSoundQuestion();
                break;
            }
            case 6: {
                this.processGameplay();
                break;
            }
            case 11: {
                this.processVDPADTutorial();
            }
        }
        this.updateStateProcess();
    }

    private void processVDPADTutorial() {
        if (this.app_state_process != 0) {
            if (this.app_state_process == 1) {
                if (this.state_time > 3999L) {
                    this.changeState((byte)0);
                }
            } else if (this.app_state_process == 2) {
                // empty if block
            }
        }
    }

    private void paintVDPADTutorial(Graphics g) {
        int frame = (int)(this.state_time / 1000L);
        this.clearBackground(g, 0);
        this.dpad.drawFrame(g, frame + 1, 120, 300, 0);
        this.arrows.drawSprite(g, frame, 250, 330, 0);
    }

    private void updateStateProcess() {
        switch (this.app_state_process) {
            case -1: {
                break;
            }
            case 0: {
                this.app_state_process = 1;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (this.next_app_state != -1) {
                    this.prev_app_state = this.curr_app_state;
                    this.curr_app_state = this.next_app_state;
                    this.next_app_state = (byte)-1;
                    this.state_time = 0L;
                    break;
                }
                this.app_state_process = 0;
            }
        }
    }

    public void setSoftkeys(String left, String right) {
        this.sk_left = left;
        this.sk_right = right;
    }

    public void setSoftkeys(int left, int right) {
        this.setSoftkeys(left == -1 ? "" : this.lang[left], right == -1 ? "" : this.lang[right]);
    }

    public void clearSoftkeys() {
        this.setSoftkeys("", "");
    }

    public void paintSoftkeys(Graphics g) {
        if (this.sk_left != null && !this.sk_left.equals("")) {
            this.fnt_small.drawString(g, this.sk_left.toCharArray(), 3, this.getHeight() - 3, 36);
        }
        if (this.sk_right != null && !this.sk_right.equals("")) {
            this.fnt_small.drawString(g, this.sk_right.toCharArray(), this.getWidth() - 3, this.getHeight() - 3, 40);
        }
    }

    protected void paint(Graphics g) {
        if (this.app_state_process != 1) {
            return;
        }
        switch (this.curr_app_state) {
            case -1: {
                break;
            }
            case 0: {
                this.paintLanguageSelect(g);
                break;
            }
            case 2: {
                this.paintLogo(g);
                break;
            }
            case 1: {
                this.paintLoading(g);
                break;
            }
            case 4: {
                this.paintSplash(g);
                break;
            }
            case 5: {
                this.paintMainMenu(g);
                break;
            }
            case 8: {
                this.paintHelp(g);
                break;
            }
            case 9: {
                this.paintAbout(g);
                break;
            }
            case 10: {
                this.paintExitQuestion(g);
                break;
            }
            case 3: {
                this.paintSoundQuestion(g);
                break;
            }
            case 6: {
                this.paintGameplay(g);
                break;
            }
            case 11: {
                this.paintVDPADTutorial(g);
            }
        }
        this.paintSoftkeys(g);
        this.paintDpad(g);
    }

    public void processLanguageSelect() {
        if (this.app_state_process == 0) {
            this.setSoftkeys(-1, 50);
        } else if (this.app_state_process == 1) {
            if (ICKeyboard.getInstance().getHasMoreKeys()) {
                char key = ICKeyboard.getInstance().nextChar();
                if (ICKeyboard.getInstance().getLastEvent() == 0 && key != '\u0007') {
                    if (key == '\u0005') {
                        if (this.language_option > 0) {
                            --this.language_option;
                        }
                    } else if (key == '\u0006') {
                        if (this.language_option < 1) {
                            ++this.language_option;
                        }
                    } else if (key == '\u0002' || key == '5' || key == '\u0001') {
                        if (this.language_option == 0) {
                            this.curr_language = 0;
                        } else if (this.language_option == 1) {
                            this.curr_language = 1;
                        }
                        this.loadLanguage();
                        this.changeState((byte)3);
                    }
                }
            }
        } else if (this.app_state_process == 2) {
            // empty if block
        }
    }

    public void processLoading() {
        if (this.app_state_process == 0 || this.app_state_process == 1 || this.app_state_process == 2) {
            // empty if block
        }
    }

    public void processLogo() {
        if (this.app_state_process == 0) {
            if (this.my_spaceship == null) {
                this.my_spaceship = new ICAnimation(this.resManager.getResourceAsStream("spaceship.lqa"));
            }
            if (this.my_inodelogo == null) {
                this.my_inodelogo = new ICAnimation(this.resManager.getResourceAsStream("logo_inode.lqa"));
            }
            this.my_spshp_x = -this.my_spaceship.getSpriteWidth(0);
            this.my_spshp_y = this.getHeight() >> 1;
            this.clearSoftkeys();
        } else if (this.app_state_process == 1) {
            if (this.state_time > (long)this.my_inodelogo.getAnimTime(0)) {
                this.changeState((byte)11);
            }
            this.my_spshp_x = (int)((long)(-this.my_spaceship.getSpriteWidth(0)) + (long)((this.getWidth() + this.my_spaceship.getSpriteWidth(0) * 2) * 1000 / this.my_inodelogo.getAnimTime(0)) * this.state_time / 1000L);
            if (ICKeyboard.getInstance().getHasMoreKeys()) {
                char key = ICKeyboard.getInstance().nextChar();
                if (ICKeyboard.getInstance().getLastEvent() == 0 && key == '\u0007') {
                    this.gm.notifyDestroyed();
                }
            }
        } else if (this.app_state_process == 2) {
            this.my_spaceship = null;
            this.my_inodelogo = null;
            System.out.println("pasando por end");
        }
    }

    public void processSplash() {
        if (this.app_state_process == 0) {
            this.bck_image = ICResourceManager.loadImage("splash_" + (this.curr_language == 0 ? "en" : "sp") + ".png");
            if (this.mm != null) {
                this.mm.playSound(sidx_main);
            }
            this.clearSoftkeys();
        } else if (this.app_state_process == 1) {
            if (ICKeyboard.getInstance().getHasMoreKeys()) {
                char key = ICKeyboard.getInstance().nextChar();
                if (ICKeyboard.getInstance().getLastEvent() == 0) {
                    if (key == '\u0007') {
                        this.gm.notifyDestroyed();
                    } else {
                        this.changeState((byte)5);
                    }
                }
            }
        } else if (this.app_state_process == 2) {
            // empty if block
        }
    }

    public void processSoundQuestion() {
        if (this.app_state_process == 0) {
            this.setSoftkeys(4, 3);
        } else if (this.app_state_process == 1) {
            if (ICKeyboard.getInstance().getHasMoreKeys()) {
                char key = ICKeyboard.getInstance().nextChar();
                if (ICKeyboard.getInstance().getLastEvent() == 0) {
                    if (key == '\u0007') {
                        this.gm.notifyDestroyed();
                    } else if (key == '\u0000') {
                        soundActivated = false;
                        this.changeState((byte)4);
                    } else if (key == '\u0001' || key == '\u0002') {
                        soundActivated = true;
                        this.changeState((byte)4);
                    }
                }
            }
        } else if (this.app_state_process == 2) {
            // empty if block
        }
    }

    public void processMainMenu() {
        if (this.app_state_process == 0) {
            this.bck_image = ICResourceManager.loadImage("menu_bg_" + (this.curr_language == 0 ? "en" : "es") + ".png");
            this.setSoftkeys(-1, 50);
        } else if (this.app_state_process == 1) {
            if (ICKeyboard.getInstance().getHasMoreKeys()) {
                char key = ICKeyboard.getInstance().nextChar();
                if (ICKeyboard.getInstance().getLastEvent() == 0) {
                    if (key == '\u0005') {
                        if (this.curr_option_menu > 0) {
                            --this.curr_option_menu;
                        }
                    } else if (key == '\u0006') {
                        if (this.curr_option_menu < 4) {
                            ++this.curr_option_menu;
                        }
                    } else if (key == '\u0002' || key == '\u0001' || key == '5') {
                        if (this.mm != null) {
                            this.mm.playSound(sidx_opt);
                        }
                        switch (this.curr_option_menu) {
                            case 0: {
                                this.changeState((byte)6);
                                break;
                            }
                            case 1: {
                                boolean bl = soundActivated = !soundActivated;
                                if (soundActivated) {
                                    this.mm.playSound(sidx_main);
                                    break;
                                }
                                this.mm.stopAllSound();
                                break;
                            }
                            case 2: {
                                this.changeState((byte)8);
                                break;
                            }
                            case 3: {
                                this.changeState((byte)9);
                                break;
                            }
                            case 4: {
                                this.changeState((byte)10);
                            }
                        }
                    }
                }
            }
        } else if (this.app_state_process == 2) {
            // empty if block
        }
    }

    public void processGameplay() {
        if (this.app_state_process == 0) {
            if (this.ge == null) {
                this.ge = new GameEngine(this);
            }
        } else if (this.app_state_process == 1) {
            if (this.ge != null) {
                this.ge.process();
                switch (this.ge.getStatus()) {
                    case 2: {
                        this.changeState((byte)5);
                        break;
                    }
                    case 3: {
                        this.gm.notifyDestroyed();
                    }
                }
            }
        } else if (this.app_state_process == 2) {
            if (this.ge != null) {
                this.ge.destroy();
            }
            this.ge = null;
            System.gc();
        }
    }

    public void processHelp() {
        if (this.app_state_process == 0) {
            this.help_first_line = 0;
            this.setSoftkeys(15, -1);
        } else if (this.app_state_process == 1) {
            if (ICKeyboard.getInstance().getHasMoreKeys()) {
                char key = ICKeyboard.getInstance().nextChar();
                if (ICKeyboard.getInstance().getLastEvent() == 0) {
                    if (key == '\u0007' || key == '\u0000') {
                        this.changeState(this.prev_app_state);
                    } else if (key == '\u0005' || key == '2') {
                        if (this.help_first_line > 0) {
                            --this.help_first_line;
                        }
                    } else if (key == '\u0006' || key == '8') {
                        ++this.help_first_line;
                    }
                }
            }
        } else if (this.app_state_process == 2) {
            // empty if block
        }
    }

    public void processAbout() {
        if (this.app_state_process == 0) {
            this.about_first_line = 0;
            this.setSoftkeys(15, -1);
        } else if (this.app_state_process == 1) {
            if (ICKeyboard.getInstance().getHasMoreKeys()) {
                char key = ICKeyboard.getInstance().nextChar();
                if (ICKeyboard.getInstance().getLastEvent() == 0) {
                    if (key == '\u0007' || key == '\u0000') {
                        this.changeState(this.prev_app_state);
                    } else if (key == '\u0005' || key == '2') {
                        if (this.about_first_line > 0) {
                            --this.about_first_line;
                        }
                    } else if (key == '\u0006' || key == '8') {
                        ++this.about_first_line;
                    }
                }
            }
        } else if (this.app_state_process == 2) {
            // empty if block
        }
    }

    public void processExitQuestion() {
        if (this.app_state_process == 0) {
            this.setSoftkeys(4, 3);
        } else if (this.app_state_process == 1) {
            if (ICKeyboard.getInstance().getHasMoreKeys()) {
                char key = ICKeyboard.getInstance().nextChar();
                if (ICKeyboard.getInstance().getLastEvent() == 0) {
                    if (key == '\u0007' || key == '\u0000') {
                        this.changeState(this.prev_app_state);
                    } else if (key == '\u0002' || key == '5' || key == '\u0001') {
                        this.gm.notifyDestroyed();
                    }
                }
            }
        } else if (this.app_state_process == 2) {
            // empty if block
        }
    }

    public void clearBackground(Graphics g, int color) {
        int oldColor = g.getColor();
        g.setColor(color);
        int cx = g.getClipX();
        int cy = g.getClipY();
        int cw = g.getClipWidth();
        int ch = g.getClipHeight();
        g.setClip(0, 0, this.getWidth(), this.getHeight());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(oldColor);
        g.setClip(cx, cy, cw, ch);
    }

    public void paintLogo(Graphics g) {
        this.clearBackground(g, 0);
        this.my_inodelogo.drawAnimation(g, 0, this.state_time, (this.getWidth() >> 1) - (this.my_inodelogo.getFrameWidth(0) >> 1), (this.getHeight() >> 1) - (this.my_inodelogo.getFrameHeight(0) >> 1), false, 0);
        this.my_spaceship.drawAnimation(g, 0, this.state_time, this.my_spshp_x, this.my_spshp_y, true, 0);
    }

    public void paintLanguageSelect(Graphics g) {
        this.clearBackground(g, 0);
        for (int i = 0; i < 2; ++i) {
            if (this.language_option == i) {
                this.fnt_menu.setCurrentPalette(1);
            } else {
                this.fnt_menu.setCurrentPalette(0);
            }
            this.fnt_menu.drawString(g, this.lang[0 + i].toCharArray(), this.getWidth() >> 1, 200 + i * 30, 17);
        }
    }

    public void paintLoading(Graphics g) {
    }

    public void paintSplash(Graphics g) {
        g.setClip(0, 0, this.getWidth(), this.getHeight());
        if (this.bck_image != null) {
            g.drawImage(this.bck_image, 0, 0, 0);
        }
        this.fnt_menu.setCurrentPalette(2);
        this.fnt_menu.drawString(g, this.lang[5].toCharArray(), this.getWidth() >> 1, this.getHeight() * 3 / 4, 17);
    }

    public void paintSoundQuestion(Graphics g) {
        this.clearBackground(g, 0);
        this.fnt_menu.setCurrentPalette(0);
        this.fnt_menu.drawString(g, this.lang[2].toCharArray(), 0, 0, this.getWidth(), this.getHeight(), 3);
    }

    public void paintMainMenu(Graphics g) {
        int off = 300;
        g.setClip(0, 0, this.getWidth(), this.getHeight());
        if (this.bck_image != null) {
            g.drawImage(this.bck_image, 0, 0, 0);
        }
        for (int i = 0; i < 5; ++i) {
            if (this.curr_option_menu == i) {
                this.fnt_menu.setCurrentPalette(1);
            } else {
                this.fnt_menu.setCurrentPalette(0);
            }
            String text = ICFunctions.replace(this.lang[8 + i], "$SNDSTATE$", soundActivated ? this.lang[22] : this.lang[23]);
            this.fnt_menu.drawString(g, text.toCharArray(), 100, off + i * 17, 0);
        }
        this.menu_icons.drawSprite(g, 0, 70, off + this.curr_option_menu * 17 - 14, 0);
    }

    public void paintGameplay(Graphics g) {
        if (this.ge != null) {
            this.ge.paint(g);
        }
    }

    public void paintHelp(Graphics g) {
        g.drawImage(this.bck_image, 0, 0, 0);
        int rx = 30;
        int ry = 190;
        int rw = 300;
        int rh = 230;
        this.help_first_line = this.fnt_small.drawString(g, this.lang[44].toCharArray(), rx, ry, rw, rh, 3, this.help_first_line, 1, 0xFFFFFF);
    }

    public void paintAbout(Graphics g) {
        g.drawImage(this.bck_image, 0, 0, 0);
        int rx = 30;
        int ry = 190;
        int rw = 300;
        int rh = 230;
        this.about_first_line = this.fnt_small.drawString(g, this.lang[16].toCharArray(), rx, ry, rw, rh, 3, this.about_first_line, 1, 0xFFFFFF);
    }

    public void paintExitQuestion(Graphics g) {
        g.drawImage(this.bck_image, 0, 0, 0);
        this.fnt_menu.drawString(g, this.lang[52].toCharArray(), 0, 0, this.getWidth(), this.getHeight(), 3);
    }

    protected void keyPressed(int keyCode) {
        super.keyPressed(keyCode);
        ICKeyboard.getInstance().keyPressed(keyCode);
    }

    protected void keyReleased(int keyCode) {
        super.keyReleased(keyCode);
        ICKeyboard.getInstance().keyReleased(keyCode);
    }

    public void paintDpad(Graphics g) {
        switch (this.curr_app_state) {
            case 0: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                if (this.pressed_direction != -1) {
                    this.dpad.drawFrame(g, this.pressed_direction, 10, this.getHeight() - this.dpad_height - 40, 0);
                    break;
                }
                this.dpad.drawFrame(g, 0, 10, this.getHeight() - this.dpad_height - 40, 0);
            }
        }
        if (this.curr_app_state == 6) {
            this.dpad.drawSprite(g, this.pressed_fire ? 5 : 3, this.getWidth() - 20 - this.but_w, this.getHeight() - this.dpad_height - 40, 0);
            this.dpad.drawSprite(g, this.pressed_ray ? 4 : 2, this.getWidth() - 40 - this.but_w * 2, this.getHeight() - this.dpad_height - 40, 0);
        }
    }

    protected void pointerDragged(int x, int y) {
        super.pointerDragged(x, y);
    }

    protected void pointerPressed(int x, int y) {
        super.pointerPressed(x, y);
        if (this.curr_app_state == 4) {
            this.keyPressed(49);
        }
        if (x >= this.getWidth() - 40 - this.but_w * 2 && x <= this.getWidth() - 40 - this.but_w && y >= this.getHeight() - this.dpad_height - 40 && y <= this.getHeight() - this.dpad_height - 40 + this.but_h) {
            this.pressed_ray = true;
            this.keyPressed(49);
        } else if (x >= this.getWidth() - 20 - this.but_w && x <= this.getWidth() - 20 && y >= this.getHeight() - this.dpad_height - 40 && y <= this.getHeight() - this.dpad_height - 40 + this.but_h) {
            this.pressed_fire = true;
            this.keyPressed(-5);
        }
        if (x >= 0 && x <= 50 && y >= this.getHeight() - 40) {
            this.keyPressed(-6);
        } else if (x >= this.getWidth() - 50 && y >= this.getHeight() - 40) {
            this.keyPressed(-7);
        }
        if (x >= 0 && x <= 10 + this.dpad_height && y >= this.getHeight() - this.dpad_height - 40 && y <= this.getHeight() - 35) {
            int rx = x - 10 - 19 - (this.touch_zone_w >> 1);
            int ry = y - this.getHeight() + 40 + (this.dpad_height >> 1);
            int row = -1;
            row = ry < -(this.touch_zone_h >> 1) ? 0 : (ry > this.touch_zone_h >> 1 ? 2 : 1);
            if (rx < -(this.touch_zone_w >> 1)) {
                if (row == 0) {
                    this.pressed_direction = 5;
                    this.keyPressed(-1);
                    this.keyPressed(-3);
                } else if (row == 1) {
                    this.pressed_direction = 1;
                    this.keyPressed(-3);
                } else if (row == 2) {
                    this.pressed_direction = 7;
                    this.keyPressed(-2);
                    this.keyPressed(-3);
                }
            } else if (rx > this.touch_zone_w >> 1) {
                if (row == 0) {
                    this.pressed_direction = 6;
                    this.keyPressed(-1);
                    this.keyPressed(-4);
                } else if (row == 1) {
                    this.pressed_direction = 2;
                    this.keyPressed(-4);
                } else if (row == 2) {
                    this.pressed_direction = 8;
                    this.keyPressed(-2);
                    this.keyPressed(-4);
                }
            } else if (row == 0) {
                this.pressed_direction = 3;
                this.keyPressed(-1);
            } else if (row == 1) {
                this.pressed_direction = 0;
            } else if (row == 2) {
                this.pressed_direction = 4;
                this.keyPressed(-2);
            }
        }
    }

    protected void pointerReleased(int x, int y) {
        super.pointerReleased(x, y);
        if (this.curr_app_state == 4) {
            this.keyReleased(49);
        }
        if (this.pressed_fire) {
            this.keyReleased(-5);
        }
        switch (this.pressed_direction) {
            case 1: {
                this.keyReleased(-3);
                break;
            }
            case 2: {
                this.keyReleased(-4);
                break;
            }
            case 3: {
                this.keyReleased(-1);
                break;
            }
            case 4: {
                this.keyReleased(-2);
                break;
            }
            case 5: {
                this.keyReleased(-1);
                this.keyReleased(-3);
                break;
            }
            case 6: {
                this.keyReleased(-1);
                this.keyReleased(-4);
                break;
            }
            case 7: {
                this.keyReleased(-2);
                this.keyReleased(-3);
                break;
            }
            case 8: {
                this.keyReleased(-2);
                this.keyReleased(-4);
            }
        }
        if (x >= 0 && x <= 50 && y >= this.getHeight() - 40) {
            this.keyReleased(-6);
        } else if (x >= this.getWidth() - 50 && y >= this.getHeight() - 40) {
            this.keyReleased(-7);
        }
        this.pressed_direction = -1;
        this.pressed_fire = false;
        this.pressed_ray = false;
    }

    static {
        MAX_PROCESS = 40;
        SPLASH_TIME = 300;
        soundActivated = false;
        sidx_main = -1;
        sidx_ray = -1;
        sidx_exp = -1;
        sidx_shoot = -1;
        sidx_m_end = -1;
        sidx_m_loose = -1;
        sidx_m_vict = -1;
        sidx_opt = -1;
        sidx_bgm = -1;
        sidx_plane = -1;
        sidx_car = -1;
        sidx_helic = -1;
        sidx_jeep = -1;
        sidx_gun = -1;
        sidx_tank = -1;
    }
}

