/*
 * Decompiled with CFR 0.152.
 */
package src.json.me;

import src.json.me.JSONArray;
import src.json.me.JSONException;
import src.json.me.JSONObject;

public class JSONTokener {
    private int a = 0;
    private String b;

    public JSONTokener(String string) {
        this.b = string;
    }

    public void back() {
        if (this.a > 0) {
            --this.a;
        }
    }

    public static int dehexchar(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 55;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 87;
        }
        return -1;
    }

    public boolean more() {
        return this.a < this.b.length();
    }

    public char next() {
        if (this.more()) {
            char c = this.b.charAt(this.a);
            ++this.a;
            return c;
        }
        return '\u0000';
    }

    public char next(char c) {
        char c2 = this.next();
        if (c2 != c) {
            throw this.syntaxError("Expected '" + c + "' and instead saw '" + c2 + "'.");
        }
        return c2;
    }

    public String next(int n) {
        int n2 = this.a;
        int n3 = n2 + n;
        if (n3 >= this.b.length()) {
            throw this.syntaxError("Substring bounds error");
        }
        this.a += n;
        return this.b.substring(n2, n3);
    }

    public char nextClean() {
        char c;
        block4: while (true) {
            if ((c = this.next()) == '/') {
                switch (this.next()) {
                    case '/': {
                        while ((c = this.next()) != '\n' && c != '\r' && c != '\u0000') {
                        }
                        continue block4;
                    }
                    case '*': {
                        while (true) {
                            if ((c = this.next()) == '\u0000') {
                                throw this.syntaxError("Unclosed comment.");
                            }
                            if (c != '*') continue;
                            if (this.next() == '/') continue block4;
                            this.back();
                        }
                    }
                }
                this.back();
                return '/';
            }
            if (c == '#') {
                while ((c = this.next()) != '\n' && c != '\r' && c != '\u0000') {
                }
                continue;
            }
            if (c == '\u0000' || c > ' ') break;
        }
        return c;
    }

    public String nextString(char c) {
        StringBuffer stringBuffer = new StringBuffer();
        block13: while (true) {
            char c2 = this.next();
            switch (c2) {
                case '\u0000': 
                case '\n': 
                case '\r': {
                    throw this.syntaxError("Unterminated string");
                }
                case '\\': {
                    c2 = this.next();
                    switch (c2) {
                        case 'b': {
                            stringBuffer.append('\b');
                            continue block13;
                        }
                        case 't': {
                            stringBuffer.append('\t');
                            continue block13;
                        }
                        case 'n': {
                            stringBuffer.append('\n');
                            continue block13;
                        }
                        case 'f': {
                            stringBuffer.append('\f');
                            continue block13;
                        }
                        case 'r': {
                            stringBuffer.append('\r');
                            continue block13;
                        }
                        case 'u': {
                            stringBuffer.append((char)Integer.parseInt(this.next(4), 16));
                            continue block13;
                        }
                        case 'x': {
                            stringBuffer.append((char)Integer.parseInt(this.next(2), 16));
                            continue block13;
                        }
                    }
                    stringBuffer.append(c2);
                    continue block13;
                }
            }
            if (c2 == c) {
                return stringBuffer.toString();
            }
            stringBuffer.append(c2);
        }
    }

    public String nextTo(char c) {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            char c2;
            if ((c2 = this.next()) == c || c2 == '\u0000' || c2 == '\n' || c2 == '\r') {
                if (c2 != '\u0000') {
                    this.back();
                }
                return stringBuffer.toString().trim();
            }
            stringBuffer.append(c2);
        }
    }

    public String nextTo(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            char c;
            if (string.indexOf(c = this.next()) >= 0 || c == '\u0000' || c == '\n' || c == '\r') {
                if (c != '\u0000') {
                    this.back();
                }
                return stringBuffer.toString().trim();
            }
            stringBuffer.append(c);
        }
    }

    public Object nextValue() {
        char c = this.nextClean();
        switch (c) {
            case '\"': 
            case '\'': {
                return this.nextString(c);
            }
            case '{': {
                this.back();
                return new JSONObject(this);
            }
            case '[': {
                this.back();
                return new JSONArray(this);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        char c2 = c;
        while (c >= ' ' && ",:]}/\\\"[{;=#".indexOf(c) < 0) {
            stringBuffer.append(c);
            c = this.next();
        }
        this.back();
        String string = stringBuffer.toString().trim();
        if (string.equals("")) {
            throw this.syntaxError("Missing value.");
        }
        if (string.toLowerCase().equals("true")) {
            return Boolean.TRUE;
        }
        if (string.toLowerCase().equals("false")) {
            return Boolean.FALSE;
        }
        if (string.toLowerCase().equals("null")) {
            return JSONObject.NULL;
        }
        if (c2 >= '0' && c2 <= '9' || c2 == '.' || c2 == '-' || c2 == '+') {
            if (c2 == '0') {
                if (string.length() > 2 && (string.charAt(1) == 'x' || string.charAt(1) == 'X')) {
                    try {
                        return new Integer(Integer.parseInt(string.substring(2), 16));
                    }
                    catch (Exception exception) {
                    }
                } else {
                    try {
                        return new Integer(Integer.parseInt(string, 8));
                    }
                    catch (Exception exception) {}
                }
            }
            try {
                return Integer.valueOf(string);
            }
            catch (Exception exception) {
                try {
                    return new Long(Long.parseLong(string));
                }
                catch (Exception exception2) {
                    try {
                        return Double.valueOf(string);
                    }
                    catch (Exception exception3) {
                        return string;
                    }
                }
            }
        }
        return string;
    }

    public char skipTo(char c) {
        char c2;
        int n = this.a;
        do {
            if ((c2 = this.next()) != '\u0000') continue;
            this.a = n;
            return c2;
        } while (c2 != c);
        this.back();
        return c2;
    }

    public void skipPast(String string) {
        this.a = this.b.indexOf(string, this.a);
        if (this.a < 0) {
            this.a = this.b.length();
            return;
        }
        this.a += string.length();
    }

    public JSONException syntaxError(String string) {
        return new JSONException(string + this.toString());
    }

    public String toString() {
        return " at character " + this.a + " of " + this.b;
    }
}

