/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.math;

import net.phys2d.math.MathUtil;
import net.phys2d.math.ROVector2f;

public strictfp class Vector2f
implements ROVector2f {
    public float x;
    public float y;

    public Vector2f() {
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public Vector2f(ROVector2f other) {
        this(other.getX(), other.getY());
    }

    public Vector2f(float x, float y) {
        this.x = MathUtil.validateFloat(x);
        this.y = MathUtil.validateFloat(y);
    }

    public void set(ROVector2f other) {
        this.set(other.getX(), other.getY());
    }

    public float dot(ROVector2f other) {
        return MathUtil.validateFloat(this.x * other.getX() + this.y * other.getY());
    }

    public void set(float x, float y) {
        this.x = MathUtil.validateFloat(x);
        this.y = MathUtil.validateFloat(y);
    }

    public Vector2f negate() {
        return new Vector2f(-this.x, -this.y);
    }

    public void add(ROVector2f v) {
        this.x += MathUtil.validateFloat(v.getX());
        this.y += MathUtil.validateFloat(v.getY());
    }

    public void sub(ROVector2f v) {
        this.x -= MathUtil.validateFloat(v.getX());
        this.y -= MathUtil.validateFloat(v.getY());
    }

    public void scale(float a) {
        this.x *= MathUtil.validateFloat(a);
        this.y *= MathUtil.validateFloat(a);
    }

    public void normalise() {
        float l = this.length();
        if (l == 0.0f) {
            return;
        }
        this.x /= l;
        this.y /= l;
    }

    public float lengthSquared() {
        return MathUtil.validateFloat(this.x * this.x + this.y * this.y);
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public void projectOntoUnit(ROVector2f b, Vector2f result) {
        float dp = b.dot(this);
        result.x = MathUtil.validateFloat(dp * b.getX());
        result.y = MathUtil.validateFloat(dp * b.getY());
    }

    public String toString() {
        return "[Vec " + this.x + "," + this.y + " (" + this.length() + ")]";
    }

    public float distance(ROVector2f other) {
        return (float)Math.sqrt(this.distanceSquared(other));
    }

    public float distanceSquared(ROVector2f other) {
        float dx = other.getX() - this.getX();
        float dy = other.getY() - this.getY();
        return dx * dx + dy * dy;
    }

    public boolean equalsDelta(ROVector2f other, float delta) {
        return other.getX() - delta < this.x && other.getX() + delta > this.x && other.getY() - delta < this.y && other.getY() + delta > this.y;
    }
}

