/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw.collide;

import java.util.Vector;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.collide.Intersection;
import net.phys2d.util.Arrays;
import net.phys2d.util.Comparator;

public class IntersectionGatherer {
    public static float MIN_PAIR_DIST = 0.5f;
    public static int MAX_INTERSECTIONS = 50;
    private SortableIntersection[] intersections = new SortableIntersection[MAX_INTERSECTIONS];
    private int noIntersections = 0;
    private Vector2f[] vertsA;
    private Vector2f[] vertsB;

    public IntersectionGatherer(Vector2f[] vertsA, Vector2f[] vertsB) {
        this.vertsA = vertsA;
        this.vertsB = vertsB;
    }

    public void intersect(int a, int b) {
        if (this.noIntersections >= MAX_INTERSECTIONS) {
            return;
        }
        Vector2f startA = this.vertsA[a];
        Vector2f endA = this.vertsA[(a + 1) % this.vertsA.length];
        Vector2f startB = this.vertsB[b];
        Vector2f endB = this.vertsB[(b + 1) % this.vertsB.length];
        float d = (endB.y - startB.y) * (endA.x - startA.x) - (endB.x - startB.x) * (endA.y - startA.y);
        if (d == 0.0f) {
            return;
        }
        float uA = (endB.x - startB.x) * (startA.y - startB.y) - (endB.y - startB.y) * (startA.x - startB.x);
        float uB = (endA.x - startA.x) * (startA.y - startB.y) - (endA.y - startA.y) * (startA.x - startB.x);
        uB /= d;
        if ((uA /= d) < 0.0f || uA > 1.0f || uB < 0.0f || uB > 1.0f) {
            return;
        }
        Vector2f position = new Vector2f(startA.x + uA * (endA.x - startA.x), startA.y + uA * (endA.y - startA.y));
        Vector2f dist = new Vector2f(position);
        dist.sub(startA);
        float distFromVertA = dist.lengthSquared();
        dist = new Vector2f(position);
        dist.sub(startB);
        float distFromVertB = dist.lengthSquared();
        float sA = (startA.x - startB.x) * (endB.y - startB.y) - (endB.x - startB.x) * (startA.y - startB.y);
        this.intersections[this.noIntersections] = sA > 0.0f ? new SortableIntersection(a, b, position, true, distFromVertA, distFromVertB) : new SortableIntersection(a, b, position, false, distFromVertA, distFromVertB);
        ++this.noIntersections;
    }

    public Intersection[] getIntersections() {
        Object[] out = new Intersection[this.noIntersections];
        for (int i = 0; i < this.noIntersections; ++i) {
            out[i] = this.intersections[i];
        }
        Arrays.sort(out, new IntersectionComparator());
        return out;
    }

    public Intersection[][] getIntersectionPairs() {
        if (this.noIntersections < 2) {
            return new Intersection[0][2];
        }
        Arrays.sort(this.intersections, 0, this.noIntersections, new IntersectionComparator());
        Object[] pointers = new Integer[this.noIntersections];
        for (int i = 0; i < this.noIntersections; ++i) {
            pointers[i] = new Integer(i);
        }
        Arrays.sort(pointers, new PointerTableComparator());
        int referenceVertB = this.getReferencePointer((Integer[])pointers);
        this.filterIntersections(referenceVertB, (Integer[])pointers);
        int first = this.intersections[0].isIngoing ? 0 : 1;
        Vector<Intersection[]> outIntersections = new Vector<Intersection[]>();
        int i = first;
        while (i < this.noIntersections + first) {
            SortableIntersection in = this.intersections[i % this.noIntersections];
            SortableIntersection out = this.intersections[(i + 1) % this.noIntersections];
            if (in == null) {
                ++i;
                continue;
            }
            if (out != null && in.isIngoing && !out.isIngoing && !in.position.equalsDelta(out.position, MIN_PAIR_DIST)) {
                Intersection[] pair = new Intersection[]{in, out};
                outIntersections.addElement(pair);
                i += 2;
                continue;
            }
            Intersection[] inArr = new Intersection[]{in};
            outIntersections.addElement(inArr);
            ++i;
        }
        Intersection[][] tmp = new Intersection[outIntersections.size()][];
        for (int i2 = 0; i2 < outIntersections.size(); ++i2) {
            tmp[i2] = (Intersection[])outIntersections.elementAt(i2);
        }
        return tmp;
    }

    private int getReferencePointer(Integer[] pointers) {
        int first = this.intersections[pointers[0].intValue()].isIngoing ? 0 : 1;
        int maxInOutDist = 0;
        int maxInIndex = first + 1 % this.noIntersections;
        int lastInEdgeB = -1;
        for (int i = first; i < this.noIntersections + first; ++i) {
            int k = pointers[i % this.noIntersections];
            SortableIntersection intersection = this.intersections[k];
            if (intersection.isIngoing) {
                lastInEdgeB = intersection.edgeB;
                continue;
            }
            if (lastInEdgeB < 0) continue;
            int inOutDist = (intersection.edgeB - lastInEdgeB + this.vertsB.length) % this.vertsB.length;
            if (inOutDist > maxInOutDist) {
                maxInOutDist = inOutDist;
                maxInIndex = i % this.noIntersections;
            }
            lastInEdgeB = -1;
        }
        return maxInIndex;
    }

    private void filterIntersections(int referencePointer, Integer[] pointers) {
        if (referencePointer >= this.noIntersections && referencePointer < 0) {
            throw new RuntimeException("The reference vertex cannot be correct since B does not have that many vertices.");
        }
        int topOut = -2;
        for (int i = referencePointer; i < this.noIntersections + referencePointer; ++i) {
            int j = i % this.noIntersections;
            int k = pointers[j];
            SortableIntersection intersection = this.intersections[k];
            if (intersection.isIngoing) {
                if ((topOut - 1 + this.noIntersections) % this.noIntersections == k) {
                    topOut = -2;
                    continue;
                }
                this.intersections[k] = null;
                continue;
            }
            if (topOut < 0) {
                topOut = k;
                continue;
            }
            this.intersections[k] = null;
        }
        int noRemoved = 0;
        for (int i = 0; i < this.noIntersections; ++i) {
            if (this.intersections[i] == null) {
                ++noRemoved;
                continue;
            }
            this.intersections[i - noRemoved] = this.intersections[i];
        }
        this.noIntersections -= noRemoved;
    }

    class PointerTableComparator
    implements Comparator {
        PointerTableComparator() {
        }

        public int compare(Object first, Object second) {
            SortableIntersection one = IntersectionGatherer.this.intersections[(Integer)first];
            SortableIntersection other = IntersectionGatherer.this.intersections[(Integer)second];
            if (one.edgeB < other.edgeB) {
                return -1;
            }
            if (one.edgeB == other.edgeB) {
                if (one.distFromVertB < other.distFromVertB) {
                    return -1;
                }
                if (one.distFromVertB == other.distFromVertB && !one.isIngoing) {
                    return -1;
                }
            }
            return 1;
        }
    }

    class IntersectionComparator
    implements Comparator {
        IntersectionComparator() {
        }

        public int compare(Object first, Object second) {
            SortableIntersection one = (SortableIntersection)first;
            SortableIntersection other = (SortableIntersection)second;
            if (one.edgeA < other.edgeA) {
                return -1;
            }
            if (one.edgeA == other.edgeA) {
                if (one.distFromVertA < other.distFromVertA) {
                    return -1;
                }
                if (one.distFromVertA == other.distFromVertA && one.isIngoing) {
                    return -1;
                }
            }
            return 1;
        }
    }

    class SortableIntersection
    extends Intersection {
        public float distFromVertA;
        public float distFromVertB;

        public SortableIntersection(int edgeA, int edgeB, Vector2f position, boolean isIngoing, float distFromVertA, float distFromVertB) {
            super(edgeA, edgeB, position, isIngoing);
            this.distFromVertA = distFromVertA;
            this.distFromVertB = distFromVertB;
        }
    }
}

