/*
 * Decompiled with CFR 0.152.
 */
package com.hardwire.dymix;

import com.hardwire.utils.Matrix2x2;
import com.hardwire.utils.Vector2;
import javax.microedition.lcdui.Graphics;

public class CollisionProxy {
    private int[] boundingBox;
    private Vector2[] data;
    private long denom;
    private long numer;
    private static CollisionProxy dummyProxy;

    public CollisionProxy(Vector2[] pData, boolean pDynamic) {
        this.data = pData;
        if (pDynamic && this.data.length == 2 && this.data[0].x == -this.data[1].x && this.data[0].y == -this.data[1].y) {
            this.data[0].add(512, 512);
        }
        this.denom = 0L;
        this.numer = 0L;
        if (pDynamic && this.data.length > 1) {
            int i = 0;
            int j = this.data.length - 1;
            while (i < this.data.length) {
                long a = this.data[j].crossProductWithShift(this.data[i]);
                a = a < 0L ? -a : a;
                long b = this.data[j].dotProductWithShift(this.data[j]) + this.data[j].dotProductWithShift(this.data[i]) + this.data[i].dotProductWithShift(this.data[i]);
                this.denom += a * b >> 10;
                this.numer += a;
                j = i++;
            }
        }
        this.boundingBox = new int[]{0, 0, 0, 0};
        this.recomputeBoundingBox(pDynamic);
    }

    public void recomputeBoundingBox(boolean pDynamic) {
        if (pDynamic) {
            int max = 0;
            for (int i = 0; i < this.data.length; ++i) {
                int length = this.data[i].length();
                if (max >= length) continue;
                max = length;
            }
            this.boundingBox[2] = this.boundingBox[3] = (max += 2048);
            this.boundingBox[0] = this.boundingBox[1] = -max;
        } else {
            this.boundingBox[3] = 0;
            this.boundingBox[2] = 0;
            this.boundingBox[1] = 0;
            this.boundingBox[0] = 0;
            for (int i = 0; i < this.data.length; ++i) {
                this.boundingBox[0] = this.boundingBox[0] < this.data[i].x ? this.boundingBox[0] : this.data[i].x;
                this.boundingBox[1] = this.boundingBox[1] < this.data[i].y ? this.boundingBox[1] : this.data[i].y;
                this.boundingBox[2] = this.boundingBox[2] > this.data[i].x ? this.boundingBox[2] : this.data[i].x;
                this.boundingBox[3] = this.boundingBox[3] > this.data[i].y ? this.boundingBox[3] : this.data[i].y;
            }
        }
    }

    private CollisionProxy() {
        this.numer = 0L;
        this.denom = 0L;
        this.data = new Vector2[0];
        this.boundingBox = new int[]{0, 0, 0, 0};
    }

    public static CollisionProxy getDummyCollisionProxy() {
        if (dummyProxy == null) {
            dummyProxy = new CollisionProxy();
        }
        return dummyProxy;
    }

    public Vector2[] getData() {
        return this.data;
    }

    public int[] getBoundingBox() {
        return this.boundingBox;
    }

    public long _getDenom() {
        return this.denom;
    }

    public long _getNumer() {
        return this.numer;
    }

    public void draw(Graphics pGraph, Vector2 pWhere, Matrix2x2 pOrientation) {
        int i;
        Vector2[] poly = new Vector2[this.data.length];
        for (i = 0; i < this.data.length; ++i) {
            poly[i] = pOrientation == Matrix2x2.IDENTITY ? new Vector2(this.data[i]).shiftRight() : this.data[i].times(pOrientation).shiftRight(2);
            poly[i].add(pWhere);
        }
        if (poly.length == 1) {
            pGraph.fillRect(poly[0].x, poly[0].y, 2, 2);
        } else {
            i = 0;
            int j = poly.length - 1;
            while (i < poly.length) {
                pGraph.drawLine(poly[j].x, poly[j].y, poly[i].x, poly[i].y);
                j = i++;
            }
        }
    }

    public void draw(Graphics pGraph, int pWhereX, int pWhereY, Matrix2x2 pOrientation) {
        int[] polyX = new int[this.data.length];
        int[] polyY = new int[this.data.length];
        int i = 0;
        while (i < this.data.length) {
            if (pOrientation == Matrix2x2.IDENTITY) {
                polyX[i] = this.data[i].x >> 10;
                polyY[i] = this.data[i].y >> 10;
            } else {
                polyX[i] = this.data[i].x * pOrientation.data[0][0] + this.data[i].y * pOrientation.data[0][1] >> 20;
                polyY[i] = this.data[i].x * pOrientation.data[1][0] + this.data[i].y * pOrientation.data[1][1] >> 20;
            }
            int n = i;
            polyX[n] = polyX[n] + pWhereX;
            int n2 = i++;
            polyY[n2] = polyY[n2] + pWhereY;
        }
        if (polyX.length == 1) {
            pGraph.fillRect(polyX[0], polyY[0], 2, 2);
        } else {
            i = 0;
            int j = polyX.length - 1;
            while (i < polyX.length) {
                pGraph.drawLine(polyX[j], polyY[j], polyX[i], polyY[i]);
                j = i++;
            }
        }
    }
}

