/*
 * Decompiled with CFR 0.152.
 */
package com.hardwire.dymix;

import com.hardwire.dymix.DynamicObject;
import com.hardwire.dymix.ImplicitGrid;
import com.hardwire.dymix.Joint;
import com.hardwire.dymix.PhysicalObject;
import com.hardwire.dymix.PhysicsException;
import com.hardwire.dymix.Spring;
import com.hardwire.dymix.StaticObject;
import com.hardwire.utils.MathUtils;
import com.hardwire.utils.Matrix2x2;
import com.hardwire.utils.Vector2;
import java.util.Vector;

public class DynamicWorld {
    public static final byte BP_UNIFORM_GRID = 0;
    public static final byte BP_BRUTEFORCE = 1;
    public static final byte BP_CUSTOM = 3;
    private byte type;
    private boolean initialised;
    private long sleepLinVelThreshold_squared;
    private int sleepAngVelThreshold_shifted;
    private int sleepMaxCounter;
    private byte[][] staticTiles;
    private StaticObject[] tileObjects;
    private boolean[][] tileObjects_validEdges;
    private boolean[] tileObjects_useAxis;
    private int tileSize;
    private int tileSize_shift;
    private int[] dummyVisibleObjects;
    private long[] visibleObjectsMask;
    private int[] activeArea;
    public ImplicitGrid _bp_grid_dynamic;
    public ImplicitGrid _bp_grid_static;
    public DynamicObject[] _dynamicObjects;
    public int _dynamicObjects_len;
    public StaticObject[] _staticObjects;
    public int _staticObjects_len;
    private Vector objectsToDel;
    public Joint[] _joints;
    public int _joints_len;
    private int jointUpdateIterations;
    public Spring[] _springs;
    public int _springs_len;
    private Vector2 gravity;
    private Vector2[] linVelChange;
    private int[] angVelChange;
    private Vector2 posChange;
    private int posChange_count;
    private static Vector2 n = new Vector2();
    private static int[] t = new int[1];
    private static int[][] supPoints1 = new int[2][2];
    private static int[][] supPoints2 = new int[2][2];
    private static int[] AB = new int[2];
    private static int[] d = new int[128];
    private static int[] s = new int[2];
    private static int[] contact = new int[2];
    private static int[] relOrient = new int[4];
    private static int[][] axes = new int[128][2];
    private static int[] taxes = new int[128];
    private static int[][] intervals = new int[2][2];
    public static final byte _ERROR_COLLISION_PROXY = 0;
    public static final byte _ERROR_MASS = 1;
    public static final byte _ERROR_INERTIA = 2;
    public static final byte _ERROR_NOT_INITED = 3;
    public static final byte _ERROR_WRONG_WT_BOUNDS = 4;
    public static final byte _ERROR_NULL_TILE_OBJECTS = 5;
    public static final byte _ERROR_BODY_NOT_INITED = 6;
    public static final byte _ERROR_DENOM_NULL = 7;
    public static final byte _ERROR_WRONG_BP = 8;
    public static final byte _ERROR_UNSUPPORTED_FEATURE = 9;
    public static final byte _ERROR_WRONG_TILE_OBJECTS = 10;
    public static final byte _ERROR_VECTOR_NULL = 11;
    public static final byte _ERROR_TOO_MANY_OBJECTS = 12;
    public static final byte _ERROR_RAY_FAILED = 13;
    public static final byte _ERROR_OBJECT_BEING_REMOVED = 14;
    public static final byte _ERROR_BODY_NOT_SPAWNED = 15;
    public static final byte _ERROR_BODY_SPAWNED = 16;
    private static final String[] _err_msgs = new String[]{"Wrong collision proxy", "Mass caclulation error", "Inertia calculation error", "World not inited", "Wrong world bounds", "Null tile objects", "Body not inited", "Denom in solveCollision is 0", "Wrong world type", "This feature is not supported in this edition", "Wrong tile objects", "Vector is null", "Too many objects", "Ray test failed, tile size of grid not same", "Can't add object, being removed", "Can't change pos, body not spawned", "Can't recompute AABB, body is spawned"};

    public void init(byte pBPType, int pSleepLinVelThreshold, int pSleepAngVelThreshold_shifted, int pSleepMaxCounter) throws PhysicsException {
        this.cleanUp();
        this.type = pBPType;
        this.sleepLinVelThreshold_squared = pSleepLinVelThreshold == -1 || pSleepLinVelThreshold == 0 ? -1L : (long)pSleepLinVelThreshold * (long)pSleepLinVelThreshold;
        this.sleepAngVelThreshold_shifted = pSleepAngVelThreshold_shifted;
        this.sleepMaxCounter = pSleepMaxCounter;
        this.linVelChange = new Vector2[]{new Vector2(), new Vector2()};
        this.posChange = new Vector2();
        this.angVelChange = new int[2];
        this.gravity = new Vector2();
        this.jointUpdateIterations = 1;
        this.initialised = pBPType == 3;
    }

    public void initUniformGrid(int pTileSizeShift, int pWorldWidth, int pWorldHeight, int pMaxDynamicObjects, int pMaxStaticObjects, int pMaxJoints, int pMaxSprings) throws PhysicsException {
        if (this.type != 0) {
            DynamicWorld._error((byte)8);
        }
        this._bp_grid_dynamic = new ImplicitGrid(pTileSizeShift, pWorldWidth, pWorldHeight, pMaxDynamicObjects);
        this._bp_grid_static = new ImplicitGrid(pTileSizeShift, pWorldWidth, pWorldHeight, pMaxStaticObjects);
        this._dynamicObjects = new DynamicObject[pMaxDynamicObjects];
        this._dynamicObjects_len = 0;
        this._staticObjects = new StaticObject[pMaxStaticObjects];
        this._staticObjects_len = 0;
        this.dummyVisibleObjects = new int[pMaxDynamicObjects + 1];
        for (int i = 1; i <= pMaxDynamicObjects; ++i) {
            this.dummyVisibleObjects[i] = i - 1;
        }
        this.visibleObjectsMask = new long[(pMaxDynamicObjects >> 6) + 1];
        this.objectsToDel = new Vector();
        this._joints = new Joint[pMaxJoints];
        this._joints_len = 0;
        this._springs = new Spring[pMaxSprings];
        this._springs_len = 0;
        this.initialised = true;
    }

    public void initBruteForce(int pMaxDynamicObjects, int pMaxStaticObjects, int pMaxJoints, int pMaxSprings) throws PhysicsException {
        if (this.type != 1) {
            DynamicWorld._error((byte)8);
        }
        this._dynamicObjects = new DynamicObject[pMaxDynamicObjects];
        this._dynamicObjects_len = 0;
        this._staticObjects = new StaticObject[pMaxStaticObjects];
        this._staticObjects_len = 0;
        this.objectsToDel = new Vector();
        this._joints = new Joint[pMaxJoints];
        this._joints_len = 0;
        this._springs = new Spring[pMaxSprings];
        this._springs_len = 0;
        this.initialised = true;
    }

    public void setTiles(int pTileSize, byte[][] pTiles, StaticObject[] pTileObjects, boolean[][] pValidEdges, boolean[] pUseAxisOnThisTile) throws PhysicsException {
        this.tileSize = pTileSize;
        if (pTiles != null) {
            int j;
            int i;
            this.staticTiles = pTiles;
            if (pTileObjects == null || pValidEdges == null || pUseAxisOnThisTile == null) {
                DynamicWorld._error((byte)5);
            }
            this.tileObjects = pTileObjects;
            for (i = 0; i < pTiles.length; ++i) {
                for (j = 0; j < pTiles[0].length; ++j) {
                    if (this.staticTiles[i][j] < this.tileObjects.length) continue;
                    DynamicWorld._error((byte)10);
                }
            }
            this.tileObjects_validEdges = pValidEdges;
            if (this.tileObjects.length != this.tileObjects_validEdges.length) {
                DynamicWorld._error((byte)10);
            }
            for (i = 0; i < this.tileObjects.length; ++i) {
                if (this.tileObjects_validEdges[i] != null && this.tileObjects[i].getCollisionProxy().getData().length != this.tileObjects_validEdges[i].length) {
                    DynamicWorld._error((byte)10);
                }
                if (this.tileObjects_validEdges[i] != null) continue;
                this.tileObjects_validEdges[i] = new boolean[this.tileObjects[i].getCollisionProxy().getData().length];
                for (j = 0; j < this.tileObjects_validEdges[i].length; ++j) {
                    this.tileObjects_validEdges[i][j] = true;
                }
            }
            this.tileObjects_useAxis = pUseAxisOnThisTile;
            if (this.tileObjects_useAxis.length != this.tileObjects.length) {
                DynamicWorld._error((byte)10);
            }
        }
        this.tileSize_shift = 0;
        int tmpSize = this.tileSize;
        while ((tmpSize & 1) == 0) {
            tmpSize >>= 1;
            ++this.tileSize_shift;
        }
        if (tmpSize != 1) {
            this.tileSize_shift = 0;
        }
    }

    public void cleanUp() {
        this._joints = null;
        this._springs = null;
        this._bp_grid_dynamic = null;
        this._bp_grid_static = null;
        this._dynamicObjects = null;
        this._staticObjects = null;
        if (this.objectsToDel != null) {
            this.objectsToDel.removeAllElements();
            this.objectsToDel = null;
        }
        this.dummyVisibleObjects = null;
        this.staticTiles = null;
        this.tileObjects = null;
        this.tileObjects_validEdges = null;
        this.tileObjects_useAxis = null;
        this.activeArea = null;
        System.gc();
    }

    public void setGravity(Vector2 pNew) {
        this.gravity.copy(pNew);
    }

    public void setJointUpdateIterations(int pNew) {
        this.jointUpdateIterations = pNew;
    }

    public void addJoint(Joint pJoint) throws PhysicsException {
        if (!this.initialised) {
            DynamicWorld._error((byte)3);
        }
        if (this._joints_len == this._joints.length) {
            DynamicWorld._error((byte)12);
        }
        this._joints[this._joints_len++] = pJoint;
    }

    public void removeJoint(Joint pJoint) {
        for (int i = 0; i < this._joints_len; ++i) {
            if (this._joints[i] != pJoint) continue;
            this.removeJoint(i);
            break;
        }
    }

    public void removeJoint(int pIndex) {
        --this._joints_len;
        if (pIndex != this._joints_len) {
            this._joints[pIndex] = this._joints[this._joints_len];
        }
        this._joints[this._joints_len] = null;
    }

    public void addSpring(Spring pSpring) throws PhysicsException {
        if (!this.initialised) {
            DynamicWorld._error((byte)3);
        }
        if (this._springs_len == this._springs.length) {
            DynamicWorld._error((byte)12);
        }
        this._springs[this._springs_len++] = pSpring;
    }

    public void removeSpring(Spring pSpring) {
        for (int i = 0; i < this._springs_len; ++i) {
            if (this._springs[i] != pSpring) continue;
            this.removeSpring(i);
            break;
        }
    }

    public void removeSpring(int pIndex) {
        --this._springs_len;
        if (pIndex != this._springs_len) {
            this._springs[pIndex] = this._springs[this._springs_len];
        }
        this._springs[this._springs_len] = null;
    }

    public synchronized void _addObject(PhysicalObject pObj, boolean pDynamic) throws PhysicsException {
        if (!this.initialised) {
            DynamicWorld._error((byte)3);
            return;
        }
        if (this.type == 0 || this.type == 1) {
            int len = this.objectsToDel.size();
            for (int i = 0; i < len; ++i) {
                if (pObj != this.objectsToDel.elementAt(i)) continue;
                DynamicWorld._error((byte)14);
                return;
            }
            if (pDynamic && this._dynamicObjects != null) {
                this._dynamicObjects[this._dynamicObjects_len] = (DynamicObject)pObj;
                this._dynamicObjects[this._dynamicObjects_len]._id = this._dynamicObjects_len;
                if (this.type == 0) {
                    this._bp_grid_dynamic.setObject(this._dynamicObjects_len, pObj.getBoundingBox());
                }
                ++this._dynamicObjects_len;
            }
            if (!pDynamic && this._staticObjects != null) {
                this._staticObjects[this._staticObjects_len] = (StaticObject)pObj;
                this._staticObjects[this._staticObjects_len]._id = this._staticObjects_len;
                if (this.type == 0) {
                    this._bp_grid_static.setObject(this._staticObjects_len, pObj.getBoundingBox());
                }
                ++this._staticObjects_len;
            }
        }
    }

    public void _removeObject(PhysicalObject pObj, boolean pDynamic) throws PhysicsException {
        if (!this.initialised) {
            DynamicWorld._error((byte)3);
            return;
        }
        if (this.type == 0 || this.type == 1) {
            this.objectsToDel.addElement(pObj);
        }
    }

    public void flushRemovedBodies() throws PhysicsException {
        if (this.type == 0 || this.type == 1) {
            int len = this.objectsToDel.size();
            block0: for (int i = 0; i < len; ++i) {
                int l;
                Object obj = this.objectsToDel.elementAt(i);
                boolean found = false;
                for (l = 0; l < this._dynamicObjects_len; ++l) {
                    if (this._dynamicObjects[l] != obj) continue;
                    found = true;
                    if (this.type == 0) {
                        this._bp_grid_dynamic.unsetObject(l, this._dynamicObjects[l].getBoundingBox());
                    }
                    --this._dynamicObjects_len;
                    if (l != this._dynamicObjects_len) {
                        if (this.type == 0) {
                            this._bp_grid_dynamic.unsetObject(this._dynamicObjects_len, this._dynamicObjects[this._dynamicObjects_len].getBoundingBox());
                        }
                        this._dynamicObjects[l] = this._dynamicObjects[this._dynamicObjects_len];
                        if (this.type == 0) {
                            this._bp_grid_dynamic.setObject(l, this._dynamicObjects[l].getBoundingBox());
                        }
                        this._dynamicObjects[l]._id = l;
                    }
                    this._dynamicObjects[this._dynamicObjects_len] = null;
                    break;
                }
                if (found) continue;
                for (l = 0; l < this._staticObjects_len; ++l) {
                    if (this._staticObjects[l] != obj) continue;
                    found = true;
                    if (this.type == 0) {
                        this._bp_grid_static.unsetObject(l, this._staticObjects[l].getBoundingBox());
                    }
                    --this._staticObjects_len;
                    if (l != this._staticObjects_len) {
                        if (this.type == 0) {
                            this._bp_grid_static.unsetObject(this._staticObjects_len, this._staticObjects[this._staticObjects_len].getBoundingBox());
                        }
                        this._staticObjects[l] = this._staticObjects[this._staticObjects_len];
                        if (this.type == 0) {
                            this._bp_grid_static.setObject(l, this._staticObjects[l].getBoundingBox());
                        }
                        this._staticObjects[l]._id = l;
                    }
                    this._staticObjects[this._staticObjects_len] = null;
                    continue block0;
                }
            }
            this.objectsToDel.removeAllElements();
        }
    }

    private boolean objectPairIsActive(PhysicalObject obj1, PhysicalObject obj2) {
        int chunk;
        int id;
        DynamicObject dynObj;
        boolean active = false;
        if (obj1.isDynamic) {
            dynObj = (DynamicObject)obj1;
            id = dynObj._id;
            chunk = id >> 6;
            if (!dynObj.isAsleep() && (this.visibleObjectsMask[chunk] & 1L << id - (chunk << 6)) != 0L) {
                active = true;
            }
        }
        if (!active && obj2.isDynamic) {
            dynObj = (DynamicObject)obj2;
            id = dynObj._id;
            chunk = id >> 6;
            if (!dynObj.isAsleep() && (this.visibleObjectsMask[chunk] & 1L << id - (chunk << 6)) != 0L) {
                active = true;
            }
        }
        return active;
    }

    public void tick() throws PhysicsException {
        int i;
        if (!this.initialised) {
            DynamicWorld._error((byte)3);
            return;
        }
        this.flushRemovedBodies();
        if (this.type == 0) {
            int[] visibleDynamicObjects;
            if (this.activeArea != null) {
                visibleDynamicObjects = this._bp_grid_dynamic.queryAreas(-1, this._dynamicObjects_len, new int[][]{this.activeArea});
            } else {
                visibleDynamicObjects = this.dummyVisibleObjects;
                visibleDynamicObjects[0] = this._dynamicObjects_len;
            }
            for (i = 0; i < this.visibleObjectsMask.length; ++i) {
                this.visibleObjectsMask[i] = 0L;
            }
            for (i = 1; i <= visibleDynamicObjects[0]; ++i) {
                int chunk;
                int id = visibleDynamicObjects[i];
                int n = chunk = id >> 6;
                this.visibleObjectsMask[n] = this.visibleObjectsMask[n] | 1L << id - (chunk << 6);
            }
            for (i = 0; i < this._springs_len; ++i) {
                if (!this.objectPairIsActive(this._springs[i].obj1, this._springs[i].obj2)) continue;
                this._springs[i]._applyForces();
            }
            for (i = 1; i <= visibleDynamicObjects[0]; ++i) {
                DynamicObject obj = this._dynamicObjects[visibleDynamicObjects[i]];
                if (obj.isAsleep()) continue;
                obj.addForceTimesMass(this.gravity);
                obj._updateDynamics();
            }
            for (i = 1; i <= visibleDynamicObjects[0]; ++i) {
                this._applyCollisionTo(this._dynamicObjects[visibleDynamicObjects[i]]);
            }
            for (int l = 0; l < this.jointUpdateIterations; ++l) {
                for (int i2 = 0; i2 < this._joints_len; ++i2) {
                    if (!this.objectPairIsActive(this._joints[i2].obj1, this._joints[i2].obj2)) continue;
                    this._joints[i2]._applyImpulse();
                }
            }
        }
        if (this.type == 1) {
            int i3;
            for (i3 = 0; i3 < this._springs_len; ++i3) {
                this._springs[i3]._applyForces();
            }
            for (i3 = 0; i3 < this._dynamicObjects_len; ++i3) {
                DynamicObject obj = this._dynamicObjects[i3];
                if (this.activeArea != null && !MathUtils.boundingBoxesOverlap(this.activeArea, obj.getBoundingBox()) || obj.isAsleep()) continue;
                obj.addForceTimesMass(this.gravity);
                obj._updateDynamics();
            }
            for (i3 = 0; i3 < this._dynamicObjects_len; ++i3) {
                DynamicObject obj = this._dynamicObjects[i3];
                if (this.activeArea != null && !MathUtils.boundingBoxesOverlap(this.activeArea, obj.getBoundingBox())) continue;
                this._applyCollisionTo(obj);
            }
            for (int l = 0; l < this.jointUpdateIterations; ++l) {
                for (i = 0; i < this._joints_len; ++i) {
                    this._joints[i]._applyImpulse();
                }
            }
        }
    }

    public boolean _applyCollisionTo(DynamicObject pObj) throws PhysicsException {
        boolean collided = false;
        if (this.type == 0) {
            PhysicalObject obj;
            int i;
            int[] neighbours = this._bp_grid_dynamic.queryArea(pObj._id, this._dynamicObjects_len, pObj.getBoundingBox());
            for (i = 1; i <= neighbours[0]; ++i) {
                obj = this._dynamicObjects[neighbours[i]];
                if (pObj.isAsleep() && ((DynamicObject)obj).isAsleep() || !MathUtils.boundingBoxesOverlap(pObj.getBoundingBox(), obj.getBoundingBox()) || !pObj.canCollideWith(obj) || !obj.canCollideWith(pObj)) continue;
                collided = this._applyCollisionBetweenObjects(pObj, obj) ? true : collided;
            }
            if (!pObj.isAsleep()) {
                neighbours = this._bp_grid_static.queryArea(-1, this._staticObjects_len, pObj.getBoundingBox());
                for (i = 1; i <= neighbours[0]; ++i) {
                    obj = this._staticObjects[neighbours[i]];
                    if (!MathUtils.boundingBoxesOverlap(pObj.getBoundingBox(), obj.getBoundingBox()) || !pObj.canCollideWith(obj) || !obj.canCollideWith(pObj)) continue;
                    collided = this._applyCollisionBetweenObjects(pObj, obj) ? true : collided;
                }
            }
        }
        if (this.type == 1) {
            int i;
            for (i = pObj._id + 1; i < this._dynamicObjects_len; ++i) {
                DynamicObject obj = this._dynamicObjects[i];
                if (pObj.isAsleep() && obj.isAsleep() || !MathUtils.boundingBoxesOverlap(pObj.getBoundingBox(), obj.getBoundingBox()) || !pObj.canCollideWith(obj) || !obj.canCollideWith(pObj)) continue;
                collided = this._applyCollisionBetweenObjects(pObj, obj) ? true : collided;
            }
            if (!pObj.isAsleep()) {
                for (i = 0; i < this._staticObjects_len; ++i) {
                    StaticObject obj = this._staticObjects[i];
                    if (!MathUtils.boundingBoxesOverlap(pObj.getBoundingBox(), obj.getBoundingBox()) || !pObj.canCollideWith(obj) || !obj.canCollideWith(pObj)) continue;
                    collided = this._applyCollisionBetweenObjects(pObj, obj) ? true : collided;
                }
            }
        }
        if (this.staticTiles != null && !pObj.isAsleep()) {
            int maxTileY;
            this.posChange.zero();
            this.posChange_count = 0;
            int[] aabb = pObj.getBoundingBox();
            int minTileX = aabb[0] < aabb[2] ? aabb[0] : aabb[2];
            int minTileY = aabb[1] < aabb[3] ? aabb[1] : aabb[3];
            int maxTileX = aabb[0] > aabb[2] ? aabb[0] : aabb[2];
            int n = maxTileY = aabb[1] > aabb[3] ? aabb[1] : aabb[3];
            if (this.tileSize_shift != 0) {
                minTileX >>= this.tileSize_shift;
                minTileY >>= this.tileSize_shift;
                maxTileX >>= this.tileSize_shift;
                maxTileY >>= this.tileSize_shift;
            } else {
                minTileX /= this.tileSize;
                minTileY /= this.tileSize;
                maxTileX /= this.tileSize;
                maxTileY /= this.tileSize;
            }
            int n2 = minTileX < 0 ? 0 : (minTileX = minTileX >= this.staticTiles.length ? this.staticTiles.length - 1 : minTileX);
            int n3 = minTileY < 0 ? 0 : (minTileY = minTileY >= this.staticTiles[0].length ? this.staticTiles[0].length - 1 : minTileY);
            int n4 = maxTileX < 0 ? 0 : (maxTileX = maxTileX >= this.staticTiles.length ? this.staticTiles.length - 1 : maxTileX);
            maxTileY = maxTileY < 0 ? 0 : (maxTileY >= this.staticTiles[0].length ? this.staticTiles[0].length - 1 : maxTileY);
            for (int i = minTileX; i <= maxTileX; ++i) {
                for (int j = minTileY; j <= maxTileY; ++j) {
                    StaticObject obj;
                    if (this.staticTiles[i][j] == -1 || !pObj.canCollideWith(obj = this.tileObjects[this.staticTiles[i][j]]) || !obj.canCollideWith(pObj)) continue;
                    Vector2 pos = obj.getPosition();
                    if (this.tileSize_shift != 0) {
                        pos.x = (i << this.tileSize_shift) + (this.tileSize >> 1);
                        pos.y = (j << this.tileSize_shift) + (this.tileSize >> 1);
                    } else {
                        pos.x = i * this.tileSize + (this.tileSize >> 1);
                        pos.y = j * this.tileSize + (this.tileSize >> 1);
                    }
                    collided = this._applyCollisionBetweenObjects(pObj, obj, this.tileObjects_validEdges[this.staticTiles[i][j]], this.tileObjects_useAxis[this.staticTiles[i][j]]) ? true : collided;
                }
            }
            if (this.posChange_count != 0) {
                this.posChange.divide(this.posChange_count);
                pObj.translatePosition(this.posChange);
            }
        }
        return collided;
    }

    public boolean _applyCollisionBetweenObjects(PhysicalObject pObj1, PhysicalObject pObj2) throws PhysicsException {
        return this._applyCollisionBetweenObjects(pObj1, pObj2, null, true);
    }

    public boolean _isObjectsCollided(PhysicalObject pObj1, PhysicalObject pObj2) throws PhysicsException {
        return this.isobjectsCollided(pObj1, pObj2, null, true);
    }

    private boolean isobjectsCollided(PhysicalObject pObj1, PhysicalObject pObj2, boolean[] pValidEdges, boolean pUseFirstObjectAxis) {
        int[] axis;
        int len;
        Vector2[] poly1 = pObj1.getCollisionProxy().getData();
        Vector2[] poly2 = pObj2.getCollisionProxy().getData();
        if (poly1.length == 1 && poly2.length == 1) {
            return false;
        }
        Matrix2x2 orient2 = pObj2.getOrientation();
        Matrix2x2 orient1 = pObj1.getOrientation();
        DynamicWorld.relOrient[0] = (int)((long)orient1.data[0][0] * (long)orient2.data[0][0] + (long)orient1.data[0][1] * (long)orient2.data[0][1] >> 10);
        DynamicWorld.relOrient[1] = (int)((long)orient1.data[0][0] * (long)orient2.data[1][0] + (long)orient1.data[0][1] * (long)orient2.data[1][1] >> 10);
        DynamicWorld.relOrient[2] = (int)((long)orient1.data[1][0] * (long)orient2.data[0][0] + (long)orient1.data[1][1] * (long)orient2.data[0][1] >> 10);
        DynamicWorld.relOrient[3] = (int)((long)orient1.data[1][0] * (long)orient2.data[1][0] + (long)orient1.data[1][1] * (long)orient2.data[1][1] >> 10);
        Vector2 pos1 = pObj1.getPosition();
        Vector2 pos2 = pObj2.getPosition();
        int relPos_x = (int)((long)(pos1.x - pos2.x) * (long)orient2.data[0][0] + (long)(pos1.y - pos2.y) * (long)orient2.data[1][0] >> 10);
        int relPos_y = (int)((long)(pos1.x - pos2.x) * (long)orient2.data[0][1] + (long)(pos1.y - pos2.y) * (long)orient2.data[1][1] >> 10);
        int axes_count = 0;
        boolean testVelocity = pObj1.isBullet() || pObj2.isBullet();
        int relVel_x = 0;
        int relVel_y = 0;
        if (testVelocity) {
            Vector2 vel1 = pObj1.getLinearVelocity();
            Vector2 vel2 = pObj2.getLinearVelocity();
            relVel_x = (int)((long)(vel1.x - vel2.x) * (long)orient2.data[0][0] + (long)(vel1.y - vel2.y) * (long)orient2.data[1][0] >> 10);
            relVel_y = (int)((long)(vel1.x - vel2.x) * (long)orient2.data[0][1] + (long)(vel1.y - vel2.y) * (long)orient2.data[1][1] >> 10);
        }
        if (testVelocity && relVel_x != 0 && relVel_y != 0) {
            int[] axis2 = axes[axes_count];
            axis2[0] = -relVel_y;
            axis2[1] = relVel_x;
            if (!this.intervalIntersect(poly1, poly2, relPos_x, relPos_y, relVel_x, relVel_y, relOrient, axis2, taxes, axes_count, testVelocity)) {
                return false;
            }
            ++axes_count;
        }
        if (poly1.length > 1) {
            int j;
            int i;
            len = poly1.length;
            if (len == 2) {
                i = 1;
                j = 0;
            } else {
                i = 0;
                j = len - 1;
            }
            while (i < len) {
                axis = axes[axes_count];
                axis[0] = poly1[j].y - poly1[i].y;
                axis[1] = poly1[i].x - poly1[j].x;
                int X = (int)((long)axis[0] * (long)relOrient[0] + (long)axis[1] * (long)relOrient[1] >> 10);
                int Y = (int)((long)axis[0] * (long)relOrient[2] + (long)axis[1] * (long)relOrient[3] >> 10);
                axis[0] = X;
                axis[1] = Y;
                if (!this.intervalIntersect(poly1, poly2, relPos_x, relPos_y, relVel_x, relVel_y, relOrient, axis, taxes, axes_count, testVelocity)) {
                    return false;
                }
                if (pUseFirstObjectAxis) {
                    ++axes_count;
                }
                j = i++;
            }
        }
        if (poly2.length > 1) {
            int j;
            int i;
            len = poly2.length;
            if (len == 2) {
                i = 1;
                j = 0;
            } else {
                i = 0;
                j = len - 1;
            }
            while (i < len) {
                if (pValidEdges == null || pValidEdges[j]) {
                    axis = axes[axes_count];
                    axis[0] = poly2[j].y - poly2[i].y;
                    axis[1] = poly2[i].x - poly2[j].x;
                    if (!this.intervalIntersect(poly1, poly2, relPos_x, relPos_y, relVel_x, relVel_y, relOrient, axis, taxes, axes_count, testVelocity)) {
                        return false;
                    }
                    ++axes_count;
                }
                j = i++;
            }
        }
        if (poly1.length == 2) {
            int[] axis3 = axes[axes_count];
            axis3[0] = poly1[0].y - poly1[1].y;
            axis3[1] = poly1[1].x - poly1[0].x;
            int X = (int)((long)axis3[0] * (long)relOrient[0] + (long)axis3[1] * (long)relOrient[1] >> 10);
            int Y = (int)((long)axis3[0] * (long)relOrient[2] + (long)axis3[1] * (long)relOrient[3] >> 10);
            axis3[0] = X;
            axis3[1] = Y;
            if (!this.intervalIntersect(poly1, poly2, relPos_x, relPos_y, relVel_x, relVel_y, relOrient, axis3, taxes, axes_count, testVelocity)) {
                return false;
            }
            ++axes_count;
        }
        if (poly2.length == 2) {
            int[] axis4 = axes[axes_count];
            axis4[0] = poly2[0].y - poly2[1].y;
            axis4[1] = poly2[1].x - poly2[0].x;
            if (!this.intervalIntersect(poly1, poly2, relPos_x, relPos_y, relVel_x, relVel_y, relOrient, axis4, taxes, axes_count, testVelocity)) {
                return false;
            }
            ++axes_count;
        }
        int len2 = this.getPushVector(axes, taxes, axes_count, n, t, testVelocity);
        n.divideWithShift(len2);
        n.multiplyWithShift(orient2);
        return true;
    }

    private boolean _applyCollisionBetweenObjects(PhysicalObject pObj1, PhysicalObject pObj2, boolean[] pValidEdges, boolean pUseAxis) throws PhysicsException {
        n.zero();
        if (this.checkCollisionBetweenObjects(pObj1, pObj2, pValidEdges, pUseAxis, n, t)) {
            int MTD = t[0];
            boolean collResponse = true;
            if (!pObj1.notifyBeforeCollisionResponse(pObj2, DynamicWorld.n.x, DynamicWorld.n.y, -MTD)) {
                collResponse = false;
            }
            if (!pObj2.notifyBeforeCollisionResponse(pObj1, -DynamicWorld.n.x, -DynamicWorld.n.y, -MTD)) {
                collResponse = false;
            }
            if (!collResponse) {
                return false;
            }
            if (MTD < 0) {
                this.solveOverlap(pObj1, pObj2, DynamicWorld.n.x * -MTD >> 10, DynamicWorld.n.y * -MTD >> 10, pValidEdges != null);
            } else if (MTD != 0 && pObj2.getInvMass_shifted2() == 0) {
                ((DynamicObject)pObj1).translatePosition(pObj1.getLinearVelocity().timesWithShift(MTD - 10));
            }
            int[][] contacts1 = new int[2][];
            int[][] contacts2 = new int[2][];
            int numContacts = this.findContacts(pObj1, pObj2, n, MTD, contacts1, contacts2);
            if (numContacts == 0) {
                return false;
            }
            if (pValidEdges != null && numContacts == 2) {
                numContacts = 1;
                contacts1[0][0] = contacts1[0][0] + contacts1[1][0] >> 1;
                contacts1[0][1] = contacts1[0][1] + contacts1[1][1] >> 1;
                contacts2[0][0] = contacts2[0][0] + contacts2[1][0] >> 1;
                contacts2[0][1] = contacts2[0][1] + contacts2[1][1] >> 1;
            }
            this.linVelChange[0].zero();
            this.angVelChange[0] = 0;
            this.linVelChange[1].zero();
            this.angVelChange[1] = 0;
            for (int l = 0; l < numContacts; ++l) {
                this.solveCollision(pObj1, pObj2, contacts1[l], contacts2[l], n, MTD);
            }
            if (pObj1.getMass_shiftedRight() > 0) {
                DynamicObject obj1 = (DynamicObject)pObj1;
                obj1.getLinearVelocity().add(this.linVelChange[0]);
                obj1.setAngularVelocity_shifted(obj1.getAngularVelocity_shifted() + this.angVelChange[0]);
                if (obj1.isBullet()) {
                    obj1.recomputeBoundingBox();
                }
                if (obj1.isAsleep()) {
                    obj1.wakeUp();
                }
            }
            if (pObj2.getMass_shiftedRight() > 0) {
                DynamicObject obj2 = (DynamicObject)pObj2;
                obj2.getLinearVelocity().add(this.linVelChange[1]);
                obj2.setAngularVelocity_shifted(obj2.getAngularVelocity_shifted() + this.angVelChange[1]);
                if (obj2.isBullet()) {
                    obj2.recomputeBoundingBox();
                }
                if (obj2.isAsleep()) {
                    obj2.wakeUp();
                }
            }
            pObj1.notifyAfterCollisionResponse(pObj2, contacts1, contacts2, numContacts, DynamicWorld.n.x, DynamicWorld.n.y, -MTD);
            pObj2.notifyAfterCollisionResponse(pObj1, contacts2, contacts1, numContacts, -DynamicWorld.n.x, -DynamicWorld.n.y, -MTD);
            return true;
        }
        return false;
    }

    private void solveOverlap(PhysicalObject pObj1, PhysicalObject pObj2, long MTD_x, long MTD_y, boolean pTileHack) throws PhysicsException {
        Vector2 pos;
        DynamicObject dobj;
        long m1 = pObj1.getInvMass_shifted2();
        long m2 = pObj2.getInvMass_shifted2();
        long m = m1 + m2;
        MTD_x = MTD_x * 1034L >> 10;
        MTD_y = MTD_y * 1034L >> 10;
        if (m1 > 0L) {
            int d1_x = (int)(MTD_x * m1 / m);
            int d1_y = (int)(MTD_y * m1 / m);
            if (pTileHack) {
                this.posChange.x += d1_x;
                this.posChange.y += d1_y;
                ++this.posChange_count;
            } else {
                dobj = (DynamicObject)pObj1;
                pos = dobj.getPosition();
                pos.x += d1_x;
                pos.y += d1_y;
                dobj.recomputeBoundingBox();
            }
        }
        if (m2 > 0L) {
            int d2_x = (int)(MTD_x * -m2 / m);
            int d2_y = (int)(MTD_y * -m2 / m);
            dobj = (DynamicObject)pObj2;
            pos = dobj.getPosition();
            pos.x += d2_x;
            pos.y += d2_y;
            dobj.recomputeBoundingBox();
        }
    }

    private void solveCollision(PhysicalObject pObj1, PhysicalObject pObj2, int[] c1, int[] c2, Vector2 n, int time) throws PhysicsException {
        int cross2;
        int cross1;
        Vector2 pos1 = pObj1.getPosition();
        Vector2 pos2 = pObj2.getPosition();
        int q1_x = pos1.x;
        int q1_y = pos1.y;
        int q2_x = pos2.x;
        int q2_y = pos2.y;
        Vector2 linVel1 = pObj1.getLinearVelocity();
        Vector2 linVel2 = pObj2.getLinearVelocity();
        if (time > 0) {
            q1_x = (int)((long)q1_x + ((long)linVel1.x * (long)time >> 10));
            q1_y = (int)((long)q1_y + ((long)linVel1.y * (long)time >> 10));
            if (linVel2 != Vector2.ZERO) {
                q2_x = (int)((long)q2_x + ((long)linVel2.x * (long)time >> 10));
                q2_y = (int)((long)q2_y + ((long)linVel2.y * (long)time >> 10));
            }
        }
        int r1_x = c1[0] - q1_x;
        int r1_y = c1[1] - q1_y;
        int r2_x = c2[0] - q2_x;
        int r2_y = c2[1] - q2_y;
        int angVel1 = pObj1.getAngularVelocity_shifted();
        int relVel_x = linVel1.x + (int)((long)(-r1_y) * (long)angVel1 >> 20);
        int relVel_y = linVel1.y + (int)((long)r1_x * (long)angVel1 >> 20);
        if (linVel2 != Vector2.ZERO) {
            int angVel2 = pObj2.getAngularVelocity_shifted();
            relVel_x -= linVel2.x + (int)((long)(-r2_y) * (long)angVel2 >> 20);
            relVel_y -= linVel2.y + (int)((long)r2_x * (long)angVel2 >> 20);
        }
        if (relVel_x == 0 && relVel_y == 0) {
            return;
        }
        int vDotN = (int)((long)relVel_x * (long)n.x + (long)relVel_y * (long)n.y >> 10);
        if (vDotN > 0) {
            return;
        }
        int inv_m1_shifted2 = pObj1.getInvMass_shifted2();
        int inv_m2_shifted2 = pObj2.getInvMass_shifted2();
        int inv_i1_shifted2 = pObj1.getInvInertia_shifted2();
        int inv_i2_shifted2 = pObj2.getInvInertia_shifted2();
        long denom = 0L;
        if (inv_i1_shifted2 > 0) {
            cross1 = (int)((long)r1_x * (long)n.y - (long)r1_y * (long)n.x >> 10);
            denom += ((long)cross1 * (long)cross1 >> 10) * (long)inv_i1_shifted2 >> 20;
        }
        if (inv_i2_shifted2 > 0) {
            cross2 = (int)((long)r2_x * (long)n.y - (long)r2_y * (long)n.x >> 10);
            denom += ((long)cross2 * (long)cross2 >> 10) * (long)inv_i2_shifted2 >> 20;
        }
        if ((denom += (long)(inv_m1_shifted2 + inv_m2_shifted2 >> 10)) == 0L) {
            DynamicWorld._error((byte)7);
        }
        long jn = -(((long)vDotN * (long)(1024 + (pObj1.getCoefOfRestitution() + pObj2.getCoefOfRestitution() >> 1)) << 10) / denom);
        int J_x = (int)(jn * (long)n.x >> 10);
        int J_y = (int)(jn * (long)n.y >> 10);
        int t_x = 0;
        int t_y = 0;
        int vDotT = 0;
        short CoF1 = pObj1.getCoefOfFriction();
        short CoF2 = pObj2.getCoefOfFriction();
        if (pObj1.getCollisionProxy().getData().length != 1 && pObj2.getCollisionProxy().getData().length != 1 && CoF1 + CoF2 != 0) {
            t_x = -n.y;
            t_y = n.x;
            vDotT = (int)((long)relVel_x * (long)t_x + (long)relVel_y * (long)t_y >> 10);
            if (vDotT == 0) {
                t_y = 0;
                t_x = 0;
            } else if (vDotT > 0) {
                t_x = -t_x;
                t_y = -t_y;
            }
        }
        if (t_x != 0 || t_y != 0) {
            int max;
            long jt;
            denom = 0L;
            if (inv_i1_shifted2 > 0) {
                cross1 = (int)((long)r1_x * (long)t_y - (long)r1_y * (long)t_x >> 10);
                denom += ((long)cross1 * (long)cross1 >> 10) * (long)inv_i1_shifted2 >> 20;
            }
            if (inv_i2_shifted2 > 0) {
                cross2 = (int)((long)r2_x * (long)t_y - (long)r2_y * (long)t_x >> 10);
                denom += ((long)cross2 * (long)cross2 >> 10) * (long)inv_i2_shifted2 >> 20;
            }
            if ((denom += (long)(inv_m1_shifted2 + inv_m2_shifted2 >> 10)) == 0L) {
                DynamicWorld._error((byte)7);
            }
            if (((jt = ((long)(vDotT < 0 ? -vDotT : vDotT) << 20) / denom) < 0L ? -jt : jt) > (long)((max = (int)(jn * (long)(pObj1.getCoefOfFriction() + pObj2.getCoefOfFriction() >> 1) >> 10)) < 0 ? -max : max)) {
                jt = max;
            }
            J_x = (int)((long)J_x + (jt * (long)t_x >> 10));
            J_y = (int)((long)J_y + (jt * (long)t_y >> 10));
        }
        if (inv_m1_shifted2 > 0) {
            this.applyImpulse((DynamicObject)pObj1, J_x, J_y, r1_x, r1_y, 0);
        }
        if (inv_m2_shifted2 > 0) {
            this.applyImpulse((DynamicObject)pObj2, -J_x, -J_y, r2_x, r2_y, 1);
        }
    }

    private void applyImpulse(DynamicObject obj, int J_x, int J_y, int r_x, int r_y, int index) {
        int invMass = obj.getInvMass_shifted2();
        this.linVelChange[index].x = (int)((long)this.linVelChange[index].x + ((long)J_x * (long)invMass >> 30));
        this.linVelChange[index].y = (int)((long)this.linVelChange[index].y + ((long)J_y * (long)invMass >> 30));
        int invInertia = obj.getInvInertia_shifted2();
        int n = index;
        this.angVelChange[n] = this.angVelChange[n] + (invInertia == 0 ? 0 : (int)(((long)r_x * (long)J_y - (long)r_y * (long)J_x >> 10) * (long)invInertia >> 20));
    }

    private int findContacts(PhysicalObject pObj1, PhysicalObject pObj2, Vector2 n, int t, int[][] contacts1, int[][] contacts2) {
        int min2;
        int min1;
        int con_num = 0;
        int supPoints1_count = this.findSupportPoints(n.x, n.y, t, pObj1, supPoints1);
        int supPoints2_count = this.findSupportPoints(-n.x, -n.y, t, pObj2, supPoints2);
        if (supPoints1_count == 1 && supPoints2_count == 1) {
            contacts1[0] = supPoints1[0];
            contacts2[0] = supPoints2[0];
            return 1;
        }
        int perp_x = -n.y;
        int perp_y = n.x;
        int max1 = min1 = (int)((long)supPoints1[0][0] * (long)perp_x + (long)supPoints1[0][1] * (long)perp_y >> 10);
        int max2 = min2 = (int)((long)supPoints2[0][0] * (long)perp_x + (long)supPoints2[0][1] * (long)perp_y >> 10);
        if (supPoints1_count == 2 && (max1 = (int)((long)supPoints1[1][0] * (long)perp_x + (long)supPoints1[1][1] * (long)perp_y >> 10)) < min1) {
            max1 ^= min1;
            min1 ^= max1;
            max1 ^= min1;
            int[] nArray = supPoints1[0];
            nArray[0] = nArray[0] ^ supPoints1[1][0];
            int[] nArray2 = supPoints1[1];
            nArray2[0] = nArray2[0] ^ supPoints1[0][0];
            int[] nArray3 = supPoints1[0];
            nArray3[0] = nArray3[0] ^ supPoints1[1][0];
            int[] nArray4 = supPoints1[0];
            nArray4[1] = nArray4[1] ^ supPoints1[1][1];
            int[] nArray5 = supPoints1[1];
            nArray5[1] = nArray5[1] ^ supPoints1[0][1];
            int[] nArray6 = supPoints1[0];
            nArray6[1] = nArray6[1] ^ supPoints1[1][1];
        }
        if (supPoints2_count == 2 && (max2 = (int)((long)supPoints2[1][0] * (long)perp_x + (long)supPoints2[1][1] * (long)perp_y >> 10)) < min2) {
            max2 ^= min2;
            min2 ^= max2;
            max2 ^= min2;
            int[] nArray = supPoints2[0];
            nArray[0] = nArray[0] ^ supPoints2[1][0];
            int[] nArray7 = supPoints2[1];
            nArray7[0] = nArray7[0] ^ supPoints2[0][0];
            int[] nArray8 = supPoints2[0];
            nArray8[0] = nArray8[0] ^ supPoints2[1][0];
            int[] nArray9 = supPoints2[0];
            nArray9[1] = nArray9[1] ^ supPoints2[1][1];
            int[] nArray10 = supPoints2[1];
            nArray10[1] = nArray10[1] ^ supPoints2[0][1];
            int[] nArray11 = supPoints2[0];
            nArray11[1] = nArray11[1] ^ supPoints2[1][1];
        }
        if (min1 > max2 || min2 > max1) {
            return 0;
        }
        if (min1 == min2) {
            contacts1[con_num] = supPoints1[0];
            contacts2[con_num] = supPoints2[0];
            ++con_num;
        } else if (min1 > min2) {
            contacts1[con_num] = supPoints1[0];
            contacts2[con_num] = this.projectPointToSegment(supPoints1[0], supPoints2[0], supPoints2[1]);
            ++con_num;
        } else {
            contacts1[con_num] = this.projectPointToSegment(supPoints2[0], supPoints1[0], supPoints1[1]);
            contacts2[con_num] = supPoints2[0];
            ++con_num;
        }
        if (max1 != min1 && max2 != min2) {
            if (max1 <= max2) {
                contacts1[con_num] = supPoints1[1];
                contacts2[con_num] = this.projectPointToSegment(supPoints1[1], supPoints2[0], supPoints2[1]);
                ++con_num;
            } else {
                contacts1[con_num] = this.projectPointToSegment(supPoints2[1], supPoints1[0], supPoints1[1]);
                contacts2[con_num] = supPoints2[1];
                ++con_num;
            }
        }
        return con_num;
    }

    private int[] projectPointToSegment(int[] V, int[] A, int[] B) {
        DynamicWorld.AB[0] = B[0] - A[0];
        DynamicWorld.AB[1] = B[1] - A[1];
        int t = (int)(((long)(V[0] - A[0]) * (long)AB[0] + (long)(V[1] - A[1]) * (long)AB[1]) / ((long)AB[0] * (long)AB[0] + (long)AB[1] * (long)AB[1] >> 10));
        if (t < 0) {
            t = 0;
        } else if (t > 1024) {
            t = 1024;
        }
        DynamicWorld.AB[0] = (int)((long)AB[0] * (long)t >> 10) + A[0];
        DynamicWorld.AB[1] = (int)((long)AB[1] * (long)t >> 10) + A[1];
        return AB;
    }

    private int findSupportPoints(int n_x, int n_y, int t, PhysicalObject obj, int[][] points) {
        int dmin;
        Matrix2x2 orient = obj.getOrientation();
        int norm_x = n_x * orient.data[0][0] + n_y * orient.data[1][0] >> 10;
        int norm_y = n_x * orient.data[0][1] + n_y * orient.data[1][1] >> 10;
        Vector2[] poly = obj.getCollisionProxy().getData();
        DynamicWorld.d[0] = dmin = norm_x * poly[0].x + norm_y * poly[0].y >> 10;
        for (int i = 1; i < poly.length; ++i) {
            DynamicWorld.d[i] = norm_x * poly[i].x + norm_y * poly[i].y >> 10;
            if (d[i] >= dmin) continue;
            dmin = d[i];
        }
        int points_count = 0;
        int threshold = 1024;
        boolean sign = false;
        for (int i = 0; i < poly.length; ++i) {
            int maxIndex;
            if (d[i] >= dmin + 1024) continue;
            Vector2 pos = obj.getPosition();
            DynamicWorld.contact[0] = pos.x + (int)((long)poly[i].x * (long)orient.data[0][0] + (long)poly[i].y * (long)orient.data[0][1] >> 10);
            DynamicWorld.contact[1] = pos.y + (int)((long)poly[i].x * (long)orient.data[1][0] + (long)poly[i].y * (long)orient.data[1][1] >> 10);
            if (t > 0) {
                Vector2 vel = obj.getLinearVelocity();
                contact[0] = (int)((long)contact[0] + ((long)vel.x * (long)t >> 10));
                contact[1] = (int)((long)contact[1] + ((long)vel.y * (long)t >> 10));
            }
            int c = -norm_y * contact[0] + norm_x * contact[1] >> 10;
            if (points_count < 2) {
                DynamicWorld.s[points_count] = c;
                points[points_count][0] = contact[0];
                points[points_count][1] = contact[1];
                if (++points_count <= 1) continue;
                sign = s[1] > s[0];
                continue;
            }
            int minIndex = sign ? 0 : 1;
            int n = maxIndex = sign ? 1 : 0;
            if (c < s[minIndex]) {
                DynamicWorld.s[minIndex] = c;
                points[minIndex] = contact;
                continue;
            }
            if (c <= s[maxIndex]) continue;
            DynamicWorld.s[maxIndex] = c;
            points[maxIndex] = contact;
        }
        return points_count;
    }

    private boolean checkCollisionBetweenObjects(PhysicalObject pObj1, PhysicalObject pObj2, boolean[] pValidEdges, boolean pUseFirstObjectAxis, Vector2 n, int[] t) {
        int[] axis;
        int len;
        Vector2[] poly1 = pObj1.getCollisionProxy().getData();
        Vector2[] poly2 = pObj2.getCollisionProxy().getData();
        if (poly1.length == 1 && poly2.length == 1) {
            return false;
        }
        Matrix2x2 orient2 = pObj2.getOrientation();
        Matrix2x2 orient1 = pObj1.getOrientation();
        DynamicWorld.relOrient[0] = (int)((long)orient1.data[0][0] * (long)orient2.data[0][0] + (long)orient1.data[0][1] * (long)orient2.data[0][1] >> 10);
        DynamicWorld.relOrient[1] = (int)((long)orient1.data[0][0] * (long)orient2.data[1][0] + (long)orient1.data[0][1] * (long)orient2.data[1][1] >> 10);
        DynamicWorld.relOrient[2] = (int)((long)orient1.data[1][0] * (long)orient2.data[0][0] + (long)orient1.data[1][1] * (long)orient2.data[0][1] >> 10);
        DynamicWorld.relOrient[3] = (int)((long)orient1.data[1][0] * (long)orient2.data[1][0] + (long)orient1.data[1][1] * (long)orient2.data[1][1] >> 10);
        Vector2 pos1 = pObj1.getPosition();
        Vector2 pos2 = pObj2.getPosition();
        int relPos_x = (int)((long)(pos1.x - pos2.x) * (long)orient2.data[0][0] + (long)(pos1.y - pos2.y) * (long)orient2.data[1][0] >> 10);
        int relPos_y = (int)((long)(pos1.x - pos2.x) * (long)orient2.data[0][1] + (long)(pos1.y - pos2.y) * (long)orient2.data[1][1] >> 10);
        int axes_count = 0;
        boolean testVelocity = pObj1.isBullet() || pObj2.isBullet();
        int relVel_x = 0;
        int relVel_y = 0;
        if (testVelocity) {
            Vector2 vel1 = pObj1.getLinearVelocity();
            Vector2 vel2 = pObj2.getLinearVelocity();
            relVel_x = (int)((long)(vel1.x - vel2.x) * (long)orient2.data[0][0] + (long)(vel1.y - vel2.y) * (long)orient2.data[1][0] >> 10);
            relVel_y = (int)((long)(vel1.x - vel2.x) * (long)orient2.data[0][1] + (long)(vel1.y - vel2.y) * (long)orient2.data[1][1] >> 10);
        }
        if (testVelocity && relVel_x != 0 && relVel_y != 0) {
            int[] axis2 = axes[axes_count];
            axis2[0] = -relVel_y;
            axis2[1] = relVel_x;
            if (!this.intervalIntersect(poly1, poly2, relPos_x, relPos_y, relVel_x, relVel_y, relOrient, axis2, taxes, axes_count, testVelocity)) {
                return false;
            }
            ++axes_count;
        }
        if (poly1.length > 1) {
            int j;
            int i;
            len = poly1.length;
            if (len == 2) {
                i = 1;
                j = 0;
            } else {
                i = 0;
                j = len - 1;
            }
            while (i < len) {
                axis = axes[axes_count];
                axis[0] = poly1[j].y - poly1[i].y;
                axis[1] = poly1[i].x - poly1[j].x;
                int X = (int)((long)axis[0] * (long)relOrient[0] + (long)axis[1] * (long)relOrient[1] >> 10);
                int Y = (int)((long)axis[0] * (long)relOrient[2] + (long)axis[1] * (long)relOrient[3] >> 10);
                axis[0] = X;
                axis[1] = Y;
                if (!this.intervalIntersect(poly1, poly2, relPos_x, relPos_y, relVel_x, relVel_y, relOrient, axis, taxes, axes_count, testVelocity)) {
                    return false;
                }
                if (pUseFirstObjectAxis) {
                    ++axes_count;
                }
                j = i++;
            }
        }
        if (poly2.length > 1) {
            int j;
            int i;
            len = poly2.length;
            if (len == 2) {
                i = 1;
                j = 0;
            } else {
                i = 0;
                j = len - 1;
            }
            while (i < len) {
                if (pValidEdges == null || pValidEdges[j]) {
                    axis = axes[axes_count];
                    axis[0] = poly2[j].y - poly2[i].y;
                    axis[1] = poly2[i].x - poly2[j].x;
                    if (!this.intervalIntersect(poly1, poly2, relPos_x, relPos_y, relVel_x, relVel_y, relOrient, axis, taxes, axes_count, testVelocity)) {
                        return false;
                    }
                    ++axes_count;
                }
                j = i++;
            }
        }
        if (poly1.length == 2) {
            int[] axis3 = axes[axes_count];
            axis3[0] = poly1[0].y - poly1[1].y;
            axis3[1] = poly1[1].x - poly1[0].x;
            int X = (int)((long)axis3[0] * (long)relOrient[0] + (long)axis3[1] * (long)relOrient[1] >> 10);
            int Y = (int)((long)axis3[0] * (long)relOrient[2] + (long)axis3[1] * (long)relOrient[3] >> 10);
            axis3[0] = X;
            axis3[1] = Y;
            if (!this.intervalIntersect(poly1, poly2, relPos_x, relPos_y, relVel_x, relVel_y, relOrient, axis3, taxes, axes_count, testVelocity)) {
                return false;
            }
            ++axes_count;
        }
        if (poly2.length == 2) {
            int[] axis4 = axes[axes_count];
            axis4[0] = poly2[0].y - poly2[1].y;
            axis4[1] = poly2[1].x - poly2[0].x;
            if (!this.intervalIntersect(poly1, poly2, relPos_x, relPos_y, relVel_x, relVel_y, relOrient, axis4, taxes, axes_count, testVelocity)) {
                return false;
            }
            ++axes_count;
        }
        int len2 = this.getPushVector(axes, taxes, axes_count, n, t, testVelocity);
        n.divideWithShift(len2);
        n.multiplyWithShift(orient2);
        return true;
    }

    private boolean intervalIntersect(Vector2[] poly1, Vector2[] poly2, long relPos_x, long relPos_y, int relVel_x, int relVel_y, int[] relOrient, int[] axis, int[] taxes, int axis_index, boolean pTestVelocity) {
        int e = 0;
        int c = 0;
        int d1 = 0;
        int d2 = 0;
        for (int l = 0; l < 2; ++l) {
            int max;
            int axisY;
            int axisX;
            Vector2[] poly;
            if (l == 0) {
                poly = poly1;
                axisX = (int)((long)axis[0] * (long)relOrient[0] + (long)axis[1] * (long)relOrient[2] >> 10);
                axisY = (int)((long)axis[0] * (long)relOrient[1] + (long)axis[1] * (long)relOrient[3] >> 10);
            } else {
                poly = poly2;
                axisX = axis[0];
                axisY = axis[1];
            }
            int min = max = (int)((long)poly[0].x * (long)axisX + (long)poly[0].y * (long)axisY >> 10);
            int len = poly.length;
            for (int i = 1; i < len; ++i) {
                int d = (int)((long)poly[i].x * (long)axisX + (long)poly[i].y * (long)axisY >> 10);
                if (d < min) {
                    min = d;
                    continue;
                }
                if (d <= max) continue;
                max = d;
            }
            if (l == 0) {
                int h = (int)(relPos_x * (long)axis[0] + relPos_y * (long)axis[1] >> 10);
                e = (max += h) - (min += h) >> 1;
                c = max + min >> 1;
            } else {
                d1 = min - e - c;
                d2 = max + e - c;
            }
            if (!pTestVelocity) continue;
            DynamicWorld.intervals[l][0] = min;
            DynamicWorld.intervals[l][1] = max;
        }
        if (d1 <= 0 && d2 >= 0) {
            if ((d1 < 0 ? -d1 : d1) < (d2 < 0 ? -d2 : d2)) {
                axis[0] = -axis[0];
                axis[1] = -axis[1];
                taxes[axis_index] = d1;
            } else {
                taxes[axis_index] = -d2;
            }
            return true;
        }
        if (pTestVelocity) {
            int t2;
            int t1;
            int v = (int)((long)relVel_x * (long)axis[0] + (long)relVel_y * (long)axis[1] >> 10);
            if (v == 0) {
                return false;
            }
            if ((int)(relPos_x * (long)axis[0] + relPos_y * (long)axis[1] >> 10) < 0) {
                axis[0] = -axis[0];
                axis[1] = -axis[1];
            }
            if ((t1 = (int)((-((long)(intervals[0][0] - intervals[1][1])) << 10) / (long)v)) > (t2 = (int)(((long)(intervals[1][0] - intervals[0][1]) << 10) / (long)v))) {
                t1 ^= t2;
                t2 ^= t1;
                t1 ^= t2;
            }
            int n = t1 > 0 ? t1 : (taxes[axis_index] = t2 > 0 ? t2 : 0);
            return taxes[axis_index] != 0 && taxes[axis_index] <= 1024;
        }
        return false;
    }

    private int getPushVector(int[][] axes, int[] taxes, int axes_count, Vector2 n, int[] t, boolean pTestVelocity) {
        int minIndex;
        if (pTestVelocity) {
            minIndex = -1;
            t[0] = 0;
            for (int i = 0; i < axes_count; ++i) {
                if (taxes[i] <= t[0]) continue;
                minIndex = i;
                t[0] = taxes[i];
                n.x = axes[i][0];
                n.y = axes[i][1];
            }
            if (minIndex != -1) {
                return n.length();
            }
        }
        minIndex = -1;
        int minLength = 0;
        for (int i = 0; i < axes_count; ++i) {
            int len = MathUtils.vectorLength(axes[i][0], axes[i][1]);
            taxes[i] = (int)(((long)taxes[i] << 10) / (long)len);
            if (minIndex != -1 && taxes[i] <= t[0]) continue;
            minIndex = i;
            minLength = len;
            t[0] = taxes[i];
            n.x = axes[i][0];
            n.y = axes[i][1];
        }
        return minLength;
    }

    public PhysicalObject testRayIntersect(int pStart_x, int pStart_y, int pEnd_x, int pEnd_y, Vector2 pContact, byte pMask, int[] pArea) throws PhysicsException {
        int t;
        PhysicalObject obj;
        if (pContact == null) {
            DynamicWorld._error((byte)11);
        }
        PhysicalObject minObj = null;
        int minT = Integer.MAX_VALUE;
        int direction_x = pEnd_x - pStart_x;
        int direction_y = pEnd_y - pStart_y;
        if (this.type == 1) {
            int i;
            for (i = 0; i < this._dynamicObjects_len; ++i) {
                obj = this._dynamicObjects[i];
                if ((obj.getRayMask() & pMask) == 0 || pArea != null && !MathUtils.boundingBoxesOverlap(obj.getBoundingBox(), pArea) || (t = obj.testRayIntersect(pStart_x, pStart_y, direction_x, direction_y)) == -1 || t >= minT) continue;
                minT = t;
                minObj = obj;
            }
            for (i = 0; i < this._staticObjects_len; ++i) {
                obj = this._staticObjects[i];
                if ((obj.getRayMask() & pMask) == 0 || pArea != null && !MathUtils.boundingBoxesOverlap(obj.getBoundingBox(), pArea) || (t = obj.testRayIntersect(pStart_x, pStart_y, direction_x, direction_y)) == -1 || t >= minT) continue;
                minT = t;
                minObj = obj;
            }
        }
        if (this.type == 0) {
            int di;
            int shift = this._bp_grid_dynamic.getTileSizeShift();
            if (this.staticTiles != null && shift != this.tileSize_shift) {
                DynamicWorld._error((byte)13);
                return null;
            }
            int i = pStart_x >> shift;
            int j = pStart_y >> shift;
            int iend = pEnd_x >> shift;
            int jend = pEnd_y >> shift;
            int n = pStart_x < pEnd_x ? 1 : (di = pStart_x > pEnd_x ? -1 : 0);
            int dj = pStart_y < pEnd_y ? 1 : (pStart_y > pEnd_y ? -1 : 0);
            int minx = i << shift;
            int maxx = minx + (1 << shift);
            int miny = j << shift;
            int maxy = miny + (1 << shift);
            int absDirX = direction_x < 0 ? -direction_x : direction_x;
            int absDirY = direction_y < 0 ? -direction_y : direction_y;
            int tx = Integer.MAX_VALUE;
            int deltatx = Integer.MAX_VALUE;
            if (absDirX != 0) {
                tx = (int)(((long)(pStart_x > pEnd_x ? pStart_x - minx : maxx - pStart_x) << 20) / (long)absDirX);
                deltatx = (int)(((long)(1 << shift) << 20) / (long)absDirX);
            }
            int ty = Integer.MAX_VALUE;
            int deltaty = Integer.MAX_VALUE;
            if (absDirY != 0) {
                ty = (int)(((long)(pStart_y > pEnd_y ? pStart_y - miny : maxy - pStart_y) << 20) / (long)absDirY);
                deltaty = (int)(((long)(1 << shift) << 20) / (long)absDirY);
            }
            do {
                int l;
                int[] objects = this._bp_grid_dynamic.queryCell(-1, this._dynamicObjects_len, i, j);
                for (l = 1; l <= objects[0]; ++l) {
                    obj = this._dynamicObjects[objects[l]];
                    if ((obj.getRayMask() & pMask) == 0 || (t = obj.testRayIntersect(pStart_x, pStart_y, direction_x, direction_y)) == -1 || t >= minT) continue;
                    minT = t;
                    minObj = obj;
                }
                objects = this._bp_grid_static.queryCell(-1, this._staticObjects_len, i, j);
                for (l = 1; l <= objects[0]; ++l) {
                    obj = this._staticObjects[objects[l]];
                    if ((obj.getRayMask() & pMask) == 0 || (t = obj.testRayIntersect(pStart_x, pStart_y, direction_x, direction_y)) == -1 || t >= minT) continue;
                    minT = t;
                    minObj = obj;
                }
                if (this.staticTiles != null && i >= 0 && j >= 0 && i < this.staticTiles.length && j < this.staticTiles[0].length && this.staticTiles[i][j] != -1) {
                    obj = this.tileObjects[this.staticTiles[i][j]];
                    Vector2 p = obj.getPosition();
                    p.x = (i << this.tileSize_shift) + (this.tileSize >> 1);
                    p.y = (j << this.tileSize_shift) + (this.tileSize >> 1);
                    t = obj.testRayIntersect(pStart_x, pStart_y, direction_x, direction_y);
                    if (t != -1 && t < minT) {
                        minT = t;
                        minObj = obj;
                    }
                }
                if (minT != Integer.MAX_VALUE) break;
                if (tx <= ty) {
                    if (i != iend) {
                        tx = deltatx == Integer.MAX_VALUE ? Integer.MAX_VALUE : (tx += deltatx);
                        i += di;
                        continue;
                    }
                    break;
                }
                if (j == jend) break;
                ty = deltaty == Integer.MAX_VALUE ? Integer.MAX_VALUE : (ty += deltaty);
                j += dj;
            } while (pArea == null || i >= pArea[0] >> shift && i <= pArea[2] >> shift && j >= pArea[1] >> shift && j <= pArea[3] >> shift);
        }
        if (minT < Integer.MAX_VALUE) {
            pContact.x = pStart_x + (int)((long)direction_x * (long)minT >> 10);
            pContact.y = pStart_y + (int)((long)direction_y * (long)minT >> 10);
            return minObj;
        }
        return null;
    }

    public int getUniformGridWidth() {
        return this._bp_grid_dynamic.getWidth();
    }

    public int getUniformGridHeight() {
        return this._bp_grid_dynamic.getWidth();
    }

    public int getTileSize() throws PhysicsException {
        return this.tileSize;
    }

    public int getTileSize_shift() throws PhysicsException {
        return this.tileSize_shift;
    }

    public int getSleepMaxCounter() {
        return this.sleepMaxCounter;
    }

    public long getSleepLinVelThreshold_squared() {
        return this.sleepLinVelThreshold_squared;
    }

    public int getSleepAngVelThreshold_shifted() {
        return this.sleepAngVelThreshold_shifted;
    }

    public byte getType() {
        return this.type;
    }

    public int[] getActiveArea() {
        return this.activeArea;
    }

    public void setActiveArea(int[] pActiveArea) {
        this.activeArea = pActiveArea;
    }

    public static void _error(byte pMessage) throws PhysicsException {
        throw new PhysicsException(_err_msgs[pMessage]);
    }
}

