/*
 * Decompiled with CFR 0.152.
 */
package com.hardwire.utils;

import com.hardwire.utils.MathUtils;

public class Matrix2x2 {
    public int[][] data;
    public static final Matrix2x2 IDENTITY = new Matrix2x2(1024, 0, 0, 1024);

    public Matrix2x2() {
        this.data = new int[][]{{1024, 0}, {0, 1024}};
    }

    public Matrix2x2(int pAngle) {
        this.data = new int[2][2];
        this.computeFromAngle(pAngle);
    }

    public Matrix2x2(int d00, int d01, int d10, int d11) {
        this.data = new int[][]{{d00, d01}, {d10, d11}};
    }

    public void computeFromAngle(int pAngle) {
        pAngle = MathUtils.wrapAngle(pAngle);
        boolean reverseVx = false;
        boolean reverseVy = false;
        if (pAngle > 3294198) {
            reverseVy = true;
            pAngle = 6588397 - pAngle;
        }
        if (pAngle > 1647099) {
            reverseVx = true;
            pAngle = 3294198 - pAngle;
        }
        int index = (pAngle * (MathUtils.Sin.length - 1) << 1) / 3294198;
        int cos = MathUtils.Sin[MathUtils.Sin.length - 1 - index];
        int sin = MathUtils.Sin[index];
        if (reverseVx) {
            cos = -cos;
        }
        if (reverseVy) {
            sin = -sin;
        }
        this.data[0][0] = cos;
        this.data[0][1] = -sin;
        this.data[1][0] = sin;
        this.data[1][1] = cos;
    }

    public Matrix2x2 getTransposed() {
        return new Matrix2x2(this.data[0][0], this.data[1][0], this.data[0][1], this.data[1][1]);
    }

    public Matrix2x2 timesTransposed(Matrix2x2 pOther) {
        Matrix2x2 res = new Matrix2x2();
        res.data[0][0] = this.data[0][0] * pOther.data[0][0] + this.data[0][1] * pOther.data[0][1];
        res.data[1][0] = this.data[1][0] * pOther.data[0][0] + this.data[1][1] * pOther.data[0][1];
        res.data[0][1] = this.data[0][0] * pOther.data[1][0] + this.data[0][1] * pOther.data[1][1];
        res.data[1][1] = this.data[1][0] * pOther.data[1][0] + this.data[1][1] * pOther.data[1][1];
        return res;
    }

    public Matrix2x2 timesTransposedWithShift(Matrix2x2 pOther) {
        Matrix2x2 res = new Matrix2x2();
        res.data[0][0] = (int)((long)this.data[0][0] * (long)pOther.data[0][0] + (long)this.data[0][1] * (long)pOther.data[0][1] >> 10);
        res.data[1][0] = (int)((long)this.data[1][0] * (long)pOther.data[0][0] + (long)this.data[1][1] * (long)pOther.data[0][1] >> 10);
        res.data[0][1] = (int)((long)this.data[0][0] * (long)pOther.data[1][0] + (long)this.data[0][1] * (long)pOther.data[1][1] >> 10);
        res.data[1][1] = (int)((long)this.data[1][0] * (long)pOther.data[1][0] + (long)this.data[1][1] * (long)pOther.data[1][1] >> 10);
        return res;
    }

    public Matrix2x2 times(Matrix2x2 pOther) {
        Matrix2x2 res = new Matrix2x2();
        res.data[0][0] = this.data[0][0] * pOther.data[0][0] + this.data[0][1] * pOther.data[1][0];
        res.data[1][0] = this.data[1][0] * pOther.data[0][0] + this.data[1][1] * pOther.data[1][0];
        res.data[0][1] = this.data[0][0] * pOther.data[0][1] + this.data[0][1] * pOther.data[1][1];
        res.data[1][1] = this.data[1][0] * pOther.data[0][1] + this.data[1][1] * pOther.data[1][1];
        return res;
    }

    public Matrix2x2 timesWithShift(Matrix2x2 pOther) {
        Matrix2x2 res = new Matrix2x2();
        res.data[0][0] = (int)((long)this.data[0][0] * (long)pOther.data[0][0] + (long)this.data[0][1] * (long)pOther.data[1][0] >> 10);
        res.data[1][0] = (int)((long)this.data[1][0] * (long)pOther.data[0][0] + (long)this.data[1][1] * (long)pOther.data[1][0] >> 10);
        res.data[0][1] = (int)((long)this.data[0][0] * (long)pOther.data[0][1] + (long)this.data[0][1] * (long)pOther.data[1][1] >> 10);
        res.data[1][1] = (int)((long)this.data[1][0] * (long)pOther.data[0][1] + (long)this.data[1][1] * (long)pOther.data[1][1] >> 10);
        return res;
    }

    public void shiftRight() {
        this.data[0][0] = this.data[0][0] >> 10;
        this.data[0][1] = this.data[0][1] >> 10;
        this.data[1][0] = this.data[1][0] >> 10;
        this.data[1][1] = this.data[1][1] >> 10;
    }

    public void shiftLeft() {
        this.data[0][0] = this.data[0][0] << 10;
        this.data[0][1] = this.data[0][1] << 10;
        this.data[1][0] = this.data[1][0] << 10;
        this.data[1][1] = this.data[1][1] << 10;
    }

    public void invert() {
        int d00 = this.data[0][0];
        int d01 = this.data[0][1];
        int d10 = this.data[1][0];
        int d11 = this.data[1][1];
        long det = (long)d00 * (long)d11 - (long)d01 * (long)d10 >> 10;
        long det_shifted3 = 0x10000000000L / det;
        this.data[0][0] = (int)(det_shifted3 * (long)d11 >> 20);
        this.data[0][1] = -((int)(det_shifted3 * (long)d01 >> 20));
        this.data[1][0] = -((int)(det_shifted3 * (long)d10 >> 20));
        this.data[1][1] = (int)(det_shifted3 * (long)d00 >> 20);
    }
}

