/*
 * Decompiled with CFR 0.152.
 */
package com.hardwire.utils;

import com.hardwire.utils.MathUtils;
import com.hardwire.utils.Matrix2x2;

public class Vector2 {
    public int x;
    public int y;
    public static final Vector2 ZERO = new Vector2(0, 0);

    public Vector2() {
        this.y = 0;
        this.x = 0;
    }

    public Vector2(int pX, int pY) {
        this.x = pX;
        this.y = pY;
    }

    public Vector2(Vector2 pToCopy) {
        this.x = pToCopy.x;
        this.y = pToCopy.y;
    }

    public Vector2(int pAngle, long pSize, boolean pShiftRight) {
        pAngle = MathUtils.wrapAngle(pAngle);
        boolean reverseVx = false;
        boolean reverseVy = false;
        if (pAngle > 3294198) {
            reverseVy = true;
            pAngle = 6588397 - pAngle;
        }
        if (pAngle > 1647099) {
            reverseVx = true;
            pAngle = 3294198 - pAngle;
        }
        int index = pAngle * (MathUtils.Sin.length - 1) * 2 / 3294198;
        this.x = MathUtils.Sin[MathUtils.Sin.length - 1 - index];
        this.y = MathUtils.Sin[index];
        if (reverseVx) {
            this.x = -this.x;
        }
        if (reverseVy) {
            this.y = -this.y;
        }
        int shiftCount = pShiftRight ? 20 : 10;
        this.x = (int)((long)this.x * pSize >> shiftCount);
        this.y = (int)((long)this.y * pSize >> shiftCount);
    }

    public int getAngle_shifted() {
        if (this.isNull()) {
            return 0;
        }
        int X = this.x < 0 ? -this.x : this.x;
        int Y = this.y < 0 ? -this.y : this.y;
        boolean swapped = false;
        if (X < Y) {
            swapped = true;
            X ^= Y;
            Y ^= X;
            X ^= Y;
        }
        int index = Y * (MathUtils.ArcTan.length - 1) / X;
        int angle_shifted = MathUtils.ArcTan[index] << 10;
        if (swapped) {
            angle_shifted = 1647099 - angle_shifted;
        }
        if (this.x < 0 && this.y < 0) {
            angle_shifted += 3294198;
        } else if (this.x < 0) {
            angle_shifted = 3294198 - angle_shifted;
        } else if (this.y < 0) {
            angle_shifted = 6588397 - angle_shifted;
        }
        return angle_shifted;
    }

    public Vector2 getPerpendicular() {
        return new Vector2(-this.y, this.x);
    }

    public void makePerpendicular() {
        int tmp = this.x;
        this.x = -this.y;
        this.y = tmp;
    }

    public Vector2 getOpposite() {
        return new Vector2(-this.x, -this.y);
    }

    public Vector2 shiftLeft() {
        this.x <<= 10;
        this.y <<= 10;
        return this;
    }

    public Vector2 shiftLeft(int pShiftCount) {
        this.x <<= 10 * pShiftCount;
        this.y <<= 10 * pShiftCount;
        return this;
    }

    public Vector2 shiftRight() {
        this.x >>= 10;
        this.y >>= 10;
        return this;
    }

    public Vector2 shiftRight(int pShiftCount) {
        this.x >>= 10 * pShiftCount;
        this.y >>= 10 * pShiftCount;
        return this;
    }

    public void add(Vector2 pToAdd) {
        this.x += pToAdd.x;
        this.y += pToAdd.y;
    }

    public void add(int pX, int pY) {
        this.x += pX;
        this.y += pY;
    }

    public void subtract(Vector2 pToSub) {
        this.x -= pToSub.x;
        this.y -= pToSub.y;
    }

    public void multiply(int pScalar) {
        this.x *= pScalar;
        this.y *= pScalar;
    }

    public void multiplyWithShift(int pScalar) {
        this.x = (int)((long)this.x * (long)pScalar >> 10);
        this.y = (int)((long)this.y * (long)pScalar >> 10);
    }

    public void multiplyWithShift(int pScalar, int pShiftCount) {
        this.x = (int)((long)this.x * (long)pScalar >> 10 * pShiftCount);
        this.y = (int)((long)this.y * (long)pScalar >> 10 * pShiftCount);
    }

    public void multiply(Matrix2x2 pOther) {
        int X = this.x * pOther.data[0][0] + this.y * pOther.data[0][1];
        int Y = this.x * pOther.data[1][0] + this.y * pOther.data[1][1];
        this.x = X;
        this.y = Y;
    }

    public void multiplyWithShift(Matrix2x2 pOther) {
        int X = (int)((long)this.x * (long)pOther.data[0][0] + (long)this.y * (long)pOther.data[0][1] >> 10);
        int Y = (int)((long)this.x * (long)pOther.data[1][0] + (long)this.y * (long)pOther.data[1][1] >> 10);
        this.x = X;
        this.y = Y;
    }

    public void multiplyTransposed(Matrix2x2 pOther) {
        int X = this.x * pOther.data[0][0] + this.y * pOther.data[1][0];
        int Y = this.x * pOther.data[0][1] + this.y * pOther.data[1][1];
        this.x = X;
        this.y = Y;
    }

    public void multiplyTransposedWithShift(Matrix2x2 pOther) {
        int X = (int)((long)this.x * (long)pOther.data[0][0] + (long)this.y * (long)pOther.data[1][0] >> 10);
        int Y = (int)((long)this.x * (long)pOther.data[0][1] + (long)this.y * (long)pOther.data[1][1] >> 10);
        this.x = X;
        this.y = Y;
    }

    public void divide(int pScalar) {
        this.x /= pScalar;
        this.y /= pScalar;
    }

    public void divideWithShift(int pScalar) {
        this.x = (int)(((long)this.x << 10) / (long)pScalar);
        this.y = (int)(((long)this.y << 10) / (long)pScalar);
    }

    public void divideWithShift(int pScalar, int pShiftCount) {
        this.x = (int)(((long)this.x << 10 * pShiftCount) / (long)pScalar);
        this.y = (int)(((long)this.y << 10 * pShiftCount) / (long)pScalar);
    }

    public Vector2 plus(Vector2 pOther) {
        return new Vector2(this.x + pOther.x, this.y + pOther.y);
    }

    public Vector2 plus(int pX, int pY) {
        return new Vector2(this.x + pX, this.y + pY);
    }

    public Vector2 minus(Vector2 pOther) {
        return new Vector2(this.x - pOther.x, this.y - pOther.y);
    }

    public Vector2 times(int pScalar) {
        return new Vector2(this.x * pScalar, this.y * pScalar);
    }

    public Vector2 timesWithShift(int pScalar) {
        return new Vector2((int)((long)this.x * (long)pScalar >> 10), (int)((long)this.y * (long)pScalar >> 10));
    }

    public Vector2 timesWithShift(int pScalar, int pNumShifts) {
        return new Vector2((int)((long)this.x * (long)pScalar >> 10 * pNumShifts), (int)((long)this.y * (long)pScalar >> 10 * pNumShifts));
    }

    public Vector2 times(Matrix2x2 pOther) {
        return new Vector2(this.x * pOther.data[0][0] + this.y * pOther.data[0][1], this.x * pOther.data[1][0] + this.y * pOther.data[1][1]);
    }

    public Vector2 timesWithShift(Matrix2x2 pOther) {
        return new Vector2((int)((long)this.x * (long)pOther.data[0][0] + (long)this.y * (long)pOther.data[0][1] >> 10), (int)((long)this.x * (long)pOther.data[1][0] + (long)this.y * (long)pOther.data[1][1] >> 10));
    }

    public Vector2 timesTransposed(Matrix2x2 pOther) {
        return new Vector2(this.x * pOther.data[0][0] + this.y * pOther.data[1][0], this.x * pOther.data[0][1] + this.y * pOther.data[1][1]);
    }

    public Vector2 timesTransposedWithShift(Matrix2x2 pOther) {
        return new Vector2((int)((long)this.x * (long)pOther.data[0][0] + (long)this.y * (long)pOther.data[1][0] >> 10), (int)((long)this.x * (long)pOther.data[0][1] + (long)this.y * (long)pOther.data[1][1] >> 10));
    }

    public Vector2 divided(int pScalar) {
        return new Vector2(this.x / pScalar, this.y / pScalar);
    }

    public Vector2 dividedWithShift(int pScalar) {
        return new Vector2((int)(((long)this.x << 10) / (long)pScalar), (int)(((long)this.y << 10) / (long)pScalar));
    }

    public int dotProduct(Vector2 pOther) {
        return this.x * pOther.x + this.y * pOther.y;
    }

    public int dotProductWithShift(Vector2 pOther) {
        return (int)((long)this.x * (long)pOther.x + (long)this.y * (long)pOther.y >> 10);
    }

    public int crossProduct(Vector2 pOther) {
        return this.x * pOther.y - this.y * pOther.x;
    }

    public int crossProductWithShift(Vector2 pOther) {
        return (int)((long)this.x * (long)pOther.y - (long)this.y * (long)pOther.x >> 10);
    }

    public void zero() {
        this.y = 0;
        this.x = 0;
    }

    public boolean isNull() {
        return this.x == 0 && this.y == 0;
    }

    public void copy(Vector2 pOther) {
        this.x = pOther.x;
        this.y = pOther.y;
    }

    public void copyOpposite(Vector2 pOther) {
        this.x = -pOther.x;
        this.y = -pOther.y;
    }

    public void copyPerpendicular(Vector2 pOther) {
        this.x = -pOther.y;
        this.y = pOther.x;
    }

    public void set(int pX, int pY) {
        this.x = pX;
        this.y = pY;
    }

    public int normaliseWithShift() {
        int len = this.length();
        if (len == 1024) {
            return len;
        }
        this.x = (int)(((long)this.x << 10) / (long)len);
        this.y = (int)(((long)this.y << 10) / (long)len);
        return len;
    }

    public int length() {
        int Y;
        int X = this.x < 0 ? -this.x : this.x;
        int n = Y = this.y < 0 ? -this.y : this.y;
        if (X == 0) {
            return Y;
        }
        if (Y == 0) {
            return X;
        }
        if (X < Y) {
            X ^= Y;
            Y ^= X;
            X ^= Y;
        }
        int t = Y + (Y >> 1);
        return X - (X >> 5) - (X >> 7) + (t >> 2) + (t >> 6);
    }

    public long length_squared() {
        return (long)this.x * (long)this.x + (long)this.y * (long)this.y;
    }
}

