/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.controller;

import com.jarbull.efw.controller.IMemoryListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class SoundHandler
implements PlayerListener {
    public static final int SINGLE = 0;
    public static final int MULTI = 1;
    private static final SoundHandler INSTANCE = new SoundHandler();
    private static final Object LOCK = new Object();
    private Hashtable sounds = new Hashtable();
    private Hashtable volumes = new Hashtable();
    private Hashtable types = new Hashtable();
    private int totalSoundCount;
    private int channel = 0;
    private IMemoryListener listener;
    private boolean enabled = true;
    private boolean playing;
    private String activeFile;

    public static SoundHandler getInstance() {
        return INSTANCE;
    }

    private SoundHandler() {
        this.types.put("mid", "audio/midi");
        this.types.put("midi", "audio/midi");
        this.types.put("wav", "audio/x-wav");
        this.types.put("mp3", "audio/mpeg");
        this.types.put("au", "audio/basic");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!enabled) {
            Enumeration soundEnum = this.sounds.keys();
            while (soundEnum.hasMoreElements()) {
                this.stop((String)soundEnum.nextElement());
            }
        }
    }

    public String getActiveFile() {
        return this.activeFile;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public IMemoryListener getListener() {
        return this.listener;
    }

    public void setListener(IMemoryListener listener) {
        this.listener = listener;
    }

    private String getFileExtension(String path) {
        return path.substring(path.lastIndexOf(46) + 1, path.length());
    }

    private String getFileType(String extension) {
        return (String)this.types.get(extension);
    }

    public void load(final String[] paths) {
        this.totalSoundCount += paths.length;
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                for (int i = paths.length - 1; i >= 0; --i) {
                    Object object = LOCK;
                    synchronized (object) {
                        try {
                            Player player = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream(paths[i]), (String)SoundHandler.this.getFileType(SoundHandler.this.getFileExtension(paths[i])));
                            player.realize();
                            player.addPlayerListener((PlayerListener)INSTANCE);
                            SoundHandler.this.sounds.put(paths[i], player);
                            VolumeControl volumeControl = (VolumeControl)player.getControl("VolumeControl");
                            SoundHandler.this.volumes.put(paths[i], volumeControl);
                        }
                        catch (IOException ex) {
                            SoundHandler.this.totalSoundCount--;
                            ex.printStackTrace();
                        }
                        catch (MediaException ex) {
                            SoundHandler.this.totalSoundCount--;
                            ex.printStackTrace();
                        }
                    }
                    try {
                        Thread.sleep(1L);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
                if (SoundHandler.this.listener != null) {
                    SoundHandler.this.listener.onHandlerLoaded();
                }
            }
        });
        thread.start();
    }

    public void load(String path) {
        ++this.totalSoundCount;
        try {
            Player player = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream(path), (String)this.getFileType(this.getFileExtension(path)));
            player.realize();
            player.addPlayerListener((PlayerListener)this);
            this.sounds.put(path, player);
            VolumeControl volumeControl = (VolumeControl)player.getControl("VolumeControl");
            this.volumes.put(path, volumeControl);
        }
        catch (IOException ex) {
            --this.totalSoundCount;
            ex.printStackTrace();
        }
        catch (MediaException ex) {
            --this.totalSoundCount;
            ex.printStackTrace();
        }
    }

    public void clear() {
        Enumeration soundEnum = this.sounds.elements();
        while (soundEnum.hasMoreElements()) {
            Player player = (Player)soundEnum.nextElement();
            player.close();
        }
        this.volumes.clear();
        this.sounds.clear();
        this.totalSoundCount = 0;
        this.playing = false;
    }

    public void clear(String path) {
        if (!this.sounds.containsKey(path)) {
            return;
        }
        Player player = (Player)this.sounds.get(path);
        player.close();
        this.sounds.remove(path);
        this.volumes.remove(path);
        --this.totalSoundCount;
    }

    public boolean isEmpty() {
        return this.sounds.isEmpty();
    }

    public boolean isLoaded() {
        return this.sounds.size() == this.totalSoundCount;
    }

    public int getTotalCount() {
        return this.totalSoundCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLoadedCount() {
        Object object = LOCK;
        synchronized (object) {
            return this.sounds.size();
        }
    }

    public long getDuration(String path) {
        if (!this.sounds.containsKey(path)) {
            return 0L;
        }
        Player player = (Player)this.sounds.get(path);
        return player.getDuration();
    }

    public void setLoopCount(String path, int loopCount) {
        if (!this.sounds.containsKey(path)) {
            return;
        }
        Player player = (Player)this.sounds.get(path);
        player.setLoopCount(loopCount);
    }

    public long getMediaTime(String path) {
        if (!this.sounds.containsKey(path)) {
            return 0L;
        }
        Player player = (Player)this.sounds.get(path);
        return player.getMediaTime();
    }

    public void setMediaTime(String path, long mediaTime) {
        if (!this.sounds.containsKey(path)) {
            return;
        }
        Player player = (Player)this.sounds.get(path);
        try {
            player.setMediaTime(mediaTime);
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int channel) {
        if (channel != 0 && channel != 1) {
            throw new IllegalArgumentException("Channel must be SINGLE or MULTI.");
        }
        this.channel = channel;
    }

    public int getVolume(String path) {
        if (!this.volumes.containsKey(path)) {
            return 0;
        }
        VolumeControl volume = (VolumeControl)this.volumes.get(path);
        return volume.getLevel();
    }

    public void setVolume(String path, int volume) {
        if (!this.volumes.containsKey(path)) {
            return;
        }
        VolumeControl volumeControl = (VolumeControl)this.volumes.get(path);
        volumeControl.setLevel(volume);
    }

    public void setVolume(int volume) {
        Enumeration volumeEnum = this.volumes.elements();
        while (volumeEnum.hasMoreElements()) {
            VolumeControl volumecontrol = (VolumeControl)volumeEnum.nextElement();
            volumecontrol.setLevel(volume);
        }
    }

    public void play(String path) {
        if (!this.enabled) {
            return;
        }
        if (this.channel == 0) {
            Enumeration soundEnum = this.sounds.elements();
            while (soundEnum.hasMoreElements()) {
                Player player = (Player)soundEnum.nextElement();
                if (player.getState() != 400) continue;
                player.deallocate();
                try {
                    player.realize();
                }
                catch (MediaException ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (!this.sounds.containsKey(path)) {
            return;
        }
        Player player = (Player)this.sounds.get(path);
        try {
            player.start();
            this.playing = true;
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
        this.activeFile = path;
    }

    public void pause(String path) {
        if (!this.sounds.containsKey(path)) {
            return;
        }
        Player player = (Player)this.sounds.get(path);
        try {
            player.stop();
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
    }

    public void stop(String path) {
        if (!this.sounds.containsKey(path)) {
            return;
        }
        Player player = (Player)this.sounds.get(path);
        player.deallocate();
        this.playing = false;
        try {
            player.realize();
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
        this.activeFile = null;
    }

    public final void playerUpdate(Player player, String event, Object eventData) {
        try {
            if (event.equals("endOfMedia")) {
                player.deallocate();
                this.playing = false;
                player.realize();
            } else if (event.equals("deviceUnavailable")) {
                player.stop();
            } else if (event.equals("deviceAvailable")) {
                player.start();
            }
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
    }
}

