/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.manager;

import com.jarbull.efw.controller.AnimationHolder;
import com.jarbull.efw.manager.EMidlet;

class InternalProcessor
implements Runnable {
    private EMidlet midlet;
    private boolean running;
    private boolean paused;

    public InternalProcessor(EMidlet midlet) {
        this.midlet = midlet;
        this.running = true;
        this.paused = false;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public void kill() {
        this.running = false;
    }

    public void run() {
        while (this.running) {
            long frameStart = System.currentTimeMillis();
            if (!this.paused) {
                int time = AnimationHolder.getInstance().getLastWorldTime() + this.midlet.userCanvas.tickDuration;
                AnimationHolder.getInstance().animate(time);
                this.midlet.userCanvas.tick();
            }
            try {
                Thread.sleep(Math.max(1L, (long)this.midlet.userCanvas.tickDuration - System.currentTimeMillis() + frameStart));
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }
}

