/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.platform.util;

import com.hardwire.dymix.CollisionProxy;
import com.hardwire.dymix.DynamicWorld;
import com.hardwire.dymix.PhysicsException;
import com.hardwire.utils.MathUtils;
import com.hardwire.utils.Vector2;
import com.jarbull.platform.data.CollisionProxyManager;
import com.jarbull.platform.util.Tile;
import com.jarbull.platform.util.TileLayer;
import javax.microedition.lcdui.Image;

public class Pattern
extends TileLayer {
    private int tileSize;

    public Pattern(DynamicWorld world, Image image, int columns, int rows, int tileSize) {
        super(world, image, columns, rows, tileSize);
        this.tileSize = tileSize;
    }

    public void initialize() {
        boolean[][] validEdges = new boolean[this.tileTypes.length][4];
        boolean[] useAxis = new boolean[this.tileTypes.length];
        for (int i = 0; i < this.tileTypes.length; ++i) {
            try {
                this.tileTypes[i].initBody(this.world, this.tileTypes[i].getCollisionProxy(), 0, 0);
            }
            catch (PhysicsException ex) {
                ex.printStackTrace();
            }
            validEdges[i] = this.tileTypes[i].getValidEdges();
            useAxis[i] = this.tileTypes[i].isUseAxis();
        }
        try {
            this.world.setTiles(this.tileSize << 10, this.tiles, this.tileTypes, validEdges, useAxis);
        }
        catch (PhysicsException ex) {
            ex.printStackTrace();
        }
    }

    public void initCollisProxy(byte[][] map, String tileSetKey) {
        int i;
        int frameNo = 0;
        int[][] modify_tileset_edges = (int[][])CollisionProxyManager.MODIFY_TILESET_EDGES.get(tileSetKey);
        for (i = 0; i < modify_tileset_edges.length; ++i) {
            int[] is = modify_tileset_edges[i];
            for (int j = 0; j < is[1]; ++j) {
                this.modifyTilesetEdge(frameNo, (int[])CollisionProxyManager.POINTS_TILE_EDGES.get(new Integer(is[0])), is[2], this);
                ++frameNo;
            }
        }
        for (i = 0; i < this.getRows(); ++i) {
            for (int j = 0; j < this.getColumns(); ++j) {
                this.setTileValue(j, i, (byte)(map[i][j] - 1));
            }
        }
    }

    private void modifyTilesetEdge(int index, int[] points, int pointsCnt, TileLayer tiledLayer) {
        switch (pointsCnt) {
            case 3: {
                Vector2[] poly = new Vector2[]{new Vector2(points[0], points[1]), new Vector2(points[2], points[3]), new Vector2(points[4], points[5])};
                MathUtils.shiftPoly(poly);
                tiledLayer.setTileType(index, new Tile(new CollisionProxy(poly, false), this.tileSize, new boolean[]{true, true, true}, false));
                break;
            }
            case 4: {
                Vector2[] poly = new Vector2[]{new Vector2(points[0], points[1]), new Vector2(points[2], points[3]), new Vector2(points[4], points[5]), new Vector2(points[6], points[7])};
                MathUtils.shiftPoly(poly);
                tiledLayer.setTileType(index, new Tile(new CollisionProxy(poly, false), this.tileSize, new boolean[]{true, true, true, true}, false));
                break;
            }
            default: {
                Vector2[] poly = new Vector2[]{new Vector2(points[0], points[1]), new Vector2(points[2], points[3]), new Vector2(points[4], points[5]), new Vector2(points[6], points[7])};
                MathUtils.shiftPoly(poly);
                tiledLayer.setTileType(index, new Tile(new CollisionProxy(poly, false), this.tileSize, new boolean[]{true, true, true, true}, false));
            }
        }
    }
}

