/*
 * Decompiled with CFR 0.152.
 */
package com.kiwavi.mobileutils;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;

public class MobileUtils {
    public static int getIntValue(String intstring) {
        int value = -1;
        try {
            value = Integer.parseInt(intstring);
        }
        catch (Exception ex) {
            System.out.println("Integer value is " + ex);
        }
        return value;
    }

    public static String strArrayToString(String[] array, String separator) {
        String outarray = "";
        int i = 0;
        while (i < array.length) {
            outarray = String.valueOf(outarray) + array[i] + separator;
            ++i;
        }
        return outarray;
    }

    public static String intArrayToString(int[] array, String separator) {
        String outarray = "";
        int i = 0;
        while (i < array.length) {
            outarray = String.valueOf(outarray) + array[i] + separator;
            ++i;
        }
        return outarray;
    }

    public static int getNumberValue(String numval) {
        int numbval = 0;
        try {
            numbval = Integer.parseInt(numval);
        }
        catch (Exception ex) {
            return 0;
        }
        return numbval;
    }

    public void getTextLines(String text, Font f, Vector vctLines, int maxlen) {
        text = text.trim();
        try {
            int[] widths = this.getTextWidths(text, f);
            int lastindex = 0;
            int totwid = 0;
            lastindex = 0;
            while (lastindex < widths.length && text.charAt(lastindex) != '\n') {
                if ((totwid += widths[lastindex]) >= maxlen || text.charAt(lastindex) == '\n') break;
                ++lastindex;
            }
            if (totwid < maxlen && text.indexOf(10) < 0) {
                vctLines.addElement(text);
                return;
            }
            int i = 0;
            if (text.charAt(lastindex - 1) != '\n') {
                i = lastindex;
                while (i > 0) {
                    if (text.charAt(i) != ' ' && text.charAt(i) != '\n') {
                        --i;
                        continue;
                    }
                    break;
                }
            } else {
                i = lastindex;
            }
            if (i > 0) {
                vctLines.addElement(text.substring(0, i));
                this.getTextLines(text.substring(i), f, vctLines, maxlen);
            }
            if (i <= 0 && totwid >= maxlen) {
                vctLines.addElement(text.substring(0, lastindex - 1));
                this.getTextLines(text.substring(lastindex - 1), f, vctLines, maxlen);
            }
        }
        catch (Exception ex) {
            System.out.println("Error at getTextLines() " + ex + vctLines.size());
        }
    }

    String getShortString(String text, Font font, int length) {
        int dotsLength = font.stringWidth(".") * 2;
        int accWidth = 0;
        int i = 0;
        int[] widths = this.getTextWidths(text, font);
        i = 0;
        while (i < widths.length) {
            if ((accWidth += widths[i]) >= length + dotsLength) {
                return String.valueOf(text.substring(0, i)) + "..";
            }
            ++i;
        }
        return text;
    }

    int[] getTextWidths(String text, Font font) {
        int[] widths = new int[text.length()];
        int i = 0;
        while (i < widths.length) {
            widths[i] = font.charWidth(text.charAt(i));
            ++i;
        }
        return widths;
    }

    public static Image rotate(Image imgSource, int cx, int cy, double radian, int[] dd) {
        int w1 = imgSource.getWidth();
        int h1 = imgSource.getHeight();
        int[] srcMap = new int[w1 * h1];
        imgSource.getRGB(srcMap, 0, w1, 0, 0, w1, h1);
        int dx = cx;
        int dy = cy;
        double dr = Math.sqrt(dx * dx + dy * dy);
        int wh2 = (int)(2.0 * dr + 1.0);
        int[] destMap = new int[wh2 * wh2];
        int i = 0;
        while (i < w1) {
            int j = 0;
            while (j < h1) {
                int destX = (int)(dr + (double)(i - cx) * Math.cos(radian) + (double)(j - cy) * Math.sin(radian));
                int destY = (int)(dr + (double)(j - cy) * Math.cos(radian) - (double)(i - cx) * Math.sin(radian));
                destMap[wh2 * destY + destX] = srcMap[j * w1 + i];
                destMap[wh2 * destY + destX + 1] = srcMap[j * w1 + i];
                ++j;
            }
            ++i;
        }
        dd[0] = (int)((double)cx - dr);
        dd[1] = (int)((double)cy - dr);
        return Image.createRGBImage((int[])destMap, (int)wh2, (int)wh2, (boolean)true);
    }

    public static Image resizeImage(Image orig, int targetWidth, int targetHeight) {
        int width = orig.getWidth();
        int height = orig.getHeight();
        if (width == targetWidth && height == targetHeight) {
            System.out.println("No Image resizing necessary");
            return orig;
        }
        try {
            int[] rgb = new int[width * height];
            orig.getRGB(rgb, 0, width, 0, 0, width, height);
            int[] outrgb = MobileUtils.reescalaArray(rgb, width, height, targetWidth, targetHeight);
            Image newImage = Image.createRGBImage((int[])outrgb, (int)targetWidth, (int)targetHeight, (boolean)true);
            return newImage;
        }
        catch (Exception ex) {
            return orig;
        }
    }

    private static int[] reescalaArray(int[] ini, int x, int y, int x2, int y2) {
        int[] out = new int[x2 * y2];
        int yy = 0;
        while (yy < y2) {
            int dy = yy * y / y2;
            int xx = 0;
            while (xx < x2) {
                int dx = xx * x / x2;
                out[x2 * yy + xx] = ini[x * dy + dx];
                ++xx;
            }
            ++yy;
        }
        return out;
    }
}

