/*
 * Decompiled with CFR 0.152.
 */
package mynotes;

import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.rms.RecordStore;
import mynotes.MyNotes;

public class ResourceBundle {
    private static RecordStore rs = null;
    public static String[] langCodes;
    public static String[] langNames;
    private static Hashtable resources;
    private static final String DEFAULT_LANG = "en";
    private static String currLangCode;
    private static String currLangName;

    public static void init() {
        try {
            InputStream istream = new Object().getClass().getResourceAsStream("/lang/langlist.lng");
            DataInputStream dos = new DataInputStream(istream);
            int size = dos.readShort();
            langCodes = new String[size];
            langNames = new String[size];
            for (int i = 0; i < size; ++i) {
                ResourceBundle.langCodes[i] = dos.readUTF();
                ResourceBundle.langNames[i] = dos.readUTF();
            }
            istream.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        currLangCode = ResourceBundle.getPreferredLang();
        ResourceBundle.setCurrLang(currLangCode);
    }

    public static String getCurrLangCode() {
        return currLangCode;
    }

    public static String getCurrLangName() {
        return currLangName;
    }

    public static void setCurrLang(String newUiLanguage) {
        for (int i = 0; i < langCodes.length; ++i) {
            if (!langCodes[i].equals(newUiLanguage)) continue;
            currLangCode = newUiLanguage;
            currLangName = langNames[i];
            return;
        }
    }

    private static void loadLang() {
        try {
            resources = new Hashtable();
            InputStream istream = resources.getClass().getResourceAsStream("/lang/" + currLangCode + ".lng");
            DataInputStream dos = new DataInputStream(istream);
            int size = dos.readShort();
            for (int j = 0; j < size; ++j) {
                resources.put(dos.readUTF(), dos.readUTF());
            }
            istream.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static synchronized String getString(String key) {
        String value;
        if (resources == null) {
            ResourceBundle.loadLang();
        }
        if ((value = (String)resources.get(key)) != null) {
            return value;
        }
        return key;
    }

    public static String getPreferredLang() {
        String lang = MyNotes.properties.getStringValue("lang");
        if (lang == null) {
            lang = DEFAULT_LANG;
            ResourceBundle.savePreferredLang(lang);
        }
        return lang;
    }

    public static void savePreferredLang(String langCode) {
        MyNotes.properties.put("lang", langCode, 9);
    }

    static {
        resources = null;
    }
}

