/*
 * Decompiled with CFR 0.152.
 */
package mynotes;

import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import mynotes.ColorScheme;
import mynotes.Commands;
import mynotes.FontsManager;
import mynotes.MyDisplayable;
import mynotes.MyNotes;
import mynotes.ResourceBundle;
import mynotes.TextEditor;

public class TextViewer
extends Canvas
implements MyDisplayable,
CommandListener {
    private int x;
    private int y;
    private int width;
    private int height;
    private int lineHeight;
    private int y0;
    private int textHeight;
    private String[] rows;
    private int[] nlUpperCounter;
    int numOfRows;
    final int SIZE_INC;
    private Graphics g;
    private static int scrollBarWidth = 5;
    private static final int lineSpace = 5;
    int newLineCounter;
    int menuBarHeight;
    int titleBarHeight;
    String title;
    Vector commands;
    private String text;
    MyDisplayable back;
    private boolean isFirstRun;
    TextEditor textEditor = null;
    int listHeight;
    Font font;
    CommandListener listener;
    FontsManager fm = FontsManager.getInstance();

    public TextViewer() {
        this.SIZE_INC = 20;
        this.height = this.getHeight();
        this.width = this.getWidth();
        this.commands = new Vector();
        this.commands.addElement(null);
        this.commands.addElement(null);
        this.setCommandListener(this);
        this.setFullScreenMode(true);
        this.title = "";
    }

    public void init(int x, int y, int width, int height, Graphics graph, String text) {
        int lineEnd;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.g = graph;
        this.width -= scrollBarWidth;
        this.font = this.fm.getFont(2);
        this.lineHeight = this.font.getHeight();
        this.menuBarHeight = this.lineHeight + 2;
        this.titleBarHeight = this.lineHeight + 2;
        this.listHeight = height - this.menuBarHeight - this.titleBarHeight;
        this.g.setFont(this.font);
        this.rows = new String[20];
        this.nlUpperCounter = new int[20];
        this.numOfRows = 0;
        int lineBegin = 0;
        this.newLineCounter = 0;
        do {
            lineEnd = text.indexOf(10, lineBegin);
            int prevNewLineCounter = this.newLineCounter++;
            if (lineEnd == -1) {
                lineEnd = text.length();
            }
            String line = text.substring(lineBegin, lineEnd);
            int prevDelimPos = 0;
            int delimPos = 0;
            int startPos = 0;
            int wordWidth = 0;
            int lineWidth = 0;
            int lineLength = line.length();
            boolean isexit = true;
            this.y0 = 0;
            while (isexit) {
                delimPos = line.indexOf(" ", prevDelimPos + 1);
                if (delimPos <= prevDelimPos) {
                    delimPos = lineLength;
                    isexit = false;
                }
                if (lineWidth + (wordWidth = this.g.getFont().stringWidth(line.substring(prevDelimPos, delimPos))) < this.width) {
                    lineWidth += wordWidth;
                    prevDelimPos = delimPos;
                    continue;
                }
                this.addRow(line.substring(startPos, prevDelimPos), prevNewLineCounter);
                startPos = prevDelimPos + 1;
                if (wordWidth > this.width) {
                    delimPos = prevDelimPos;
                    for (lineWidth = wordWidth; lineWidth > this.width; lineWidth -= wordWidth) {
                        wordWidth = 0;
                        while (wordWidth < this.width) {
                            wordWidth = this.g.getFont().stringWidth(line.substring(startPos, ++delimPos));
                        }
                        wordWidth = this.g.getFont().stringWidth(line.substring(startPos, --delimPos));
                        this.addRow(line.substring(startPos, delimPos), prevNewLineCounter);
                        prevDelimPos = delimPos;
                        startPos = delimPos;
                    }
                    lineWidth = 0;
                    continue;
                }
                prevDelimPos = delimPos;
            }
            this.addRow(line.substring(startPos, lineLength), prevNewLineCounter);
        } while ((lineBegin = lineEnd + 1) < text.length());
        this.textHeight = this.numOfRows * this.lineHeight + 5 * this.newLineCounter;
        this.width += scrollBarWidth;
    }

    public void start(String header, String init, MyDisplayable d, TextEditor editor) {
        this.addCommand(Commands.BACK, 5);
        this.back = d;
        this.isFirstRun = true;
        this.textEditor = editor;
        if (this.textEditor != null) {
            this.addCommand(Commands.EDIT, 8);
        } else {
            this.addCommand(null, 8);
        }
        this.text = init;
        this.setTitle(header);
        this.setFullScreenMode(true);
        this.activate();
    }

    public void setTitle(String aTitle) {
        this.title = aTitle;
    }

    public String getTitle() {
        return this.title;
    }

    private int addRow(String s, int n) {
        if (this.numOfRows == this.rows.length) {
            String[] newRows = new String[this.numOfRows + 20];
            int[] newNlUpperCounter = new int[this.numOfRows + 20];
            System.arraycopy(this.rows, 0, newRows, 0, this.numOfRows);
            System.arraycopy(this.nlUpperCounter, 0, newNlUpperCounter, 0, this.numOfRows);
            this.rows = newRows;
            this.nlUpperCounter = newNlUpperCounter;
        }
        this.rows[this.numOfRows] = s;
        this.nlUpperCounter[this.numOfRows] = n;
        ++this.numOfRows;
        return this.numOfRows;
    }

    void drawTitleBar() {
        this.g.setColor(ColorScheme.CL_TITLEBARBACKGROUND);
        this.g.fillRect(this.x, this.y, this.width, this.titleBarHeight);
        this.g.setColor(ColorScheme.CL_TITLEBARFONT);
        if (this.title != null) {
            this.g.setFont(this.font);
            this.g.drawString(this.title, this.x + 1, this.y + 1, 20);
        }
    }

    void drawMenuBar() {
        Command c;
        this.g.setFont(this.font);
        this.g.setColor(ColorScheme.CL_MENUBARBACKGROUND);
        this.g.fillRect(this.x, this.height - this.menuBarHeight, this.width, this.menuBarHeight);
        this.g.setColor(ColorScheme.CL_MENUBARFONT);
        if (this.commands.size() > 2) {
            this.g.drawString(ResourceBundle.getString("menu"), 3, this.height - this.menuBarHeight + 1, 20);
        }
        if ((c = (Command)this.commands.elementAt(1)) != null) {
            this.g.drawString(c.getLabel(), this.width - 3, this.height - this.menuBarHeight + 1, 24);
        }
        if ((c = (Command)this.commands.elementAt(0)) != null) {
            this.g.drawString(c.getLabel(), this.width / 2, this.height - this.menuBarHeight + 1, 17);
        }
    }

    void drawScrollBar() {
        int visible;
        int sbHeight = 0;
        int sbTop = 0;
        double sbScale = 1.0;
        int n = visible = this.textHeight <= this.listHeight ? this.textHeight : this.listHeight;
        if (this.textHeight <= this.listHeight) {
            sbTop = 0;
            sbHeight = this.listHeight;
            sbScale = 1.0;
        } else {
            int down = this.textHeight - this.y0 - this.listHeight;
            down = down < 0 ? 0 : down;
            sbScale = (double)visible / (double)this.textHeight;
            if (sbScale < 0.1) {
                sbScale = 0.1;
            }
            sbHeight = (int)((double)this.listHeight * sbScale);
            sbTop = (int)((double)(-this.listHeight) * (double)this.y0 / (double)this.textHeight);
        }
        if (sbHeight != this.listHeight) {
            this.g.setColor(ColorScheme.CL_SCROLLBAR);
            this.g.fillRect(this.width - scrollBarWidth, this.y + this.titleBarHeight, scrollBarWidth, this.listHeight);
            this.g.setColor(ColorScheme.CL_SCROLLBOX);
            this.g.fillRect(this.width - scrollBarWidth, this.y + this.titleBarHeight + sbTop, scrollBarWidth, sbHeight);
        }
    }

    void drawText() {
        this.g.setColor(ColorScheme.CL_TEXTBACKGROUND);
        this.g.fillRect(this.x, this.y + this.titleBarHeight, this.width, this.listHeight);
        this.g.setColor(ColorScheme.CL_TEXTFONT);
        int y1 = this.y0;
        this.g.setFont(this.font);
        for (int i = 0; i < this.numOfRows; ++i) {
            int delta = this.titleBarHeight + 5 * this.nlUpperCounter[i];
            if (y1 + delta + this.lineHeight > 0) {
                this.g.drawString(this.rows[i], this.x + 1, this.y + y1 + delta, 20);
            }
            if ((y1 += this.lineHeight) > this.listHeight) break;
        }
    }

    public void addCommand(Command c, int keyType) {
        switch (keyType) {
            case 5: {
                this.commands.setElementAt(c, 1);
                break;
            }
            case 8: {
                this.commands.setElementAt(c, 0);
                break;
            }
            case 2: {
                this.commands.addElement(c);
            }
        }
    }

    public void lineDown() {
        if (this.textHeight > this.listHeight) {
            this.y0 -= this.lineHeight;
            if (this.listHeight - this.y0 > this.textHeight) {
                this.y0 = this.listHeight - this.textHeight;
            }
        }
    }

    public void lineUp() {
        if (this.textHeight > this.listHeight) {
            this.y0 += this.lineHeight;
            if (this.y0 > 0) {
                this.y0 = 0;
            }
        }
    }

    public void pageUp() {
        if (this.textHeight > this.listHeight) {
            this.y0 = this.y0 + this.listHeight - this.lineHeight;
            if (this.y0 > 0) {
                this.y0 = 0;
            }
        }
    }

    public void pageDown() {
        if (this.textHeight > this.listHeight) {
            this.y0 = this.y0 - this.listHeight + this.lineHeight;
            if (this.listHeight - this.y0 > this.textHeight) {
                this.y0 = this.listHeight - this.textHeight;
            }
        }
    }

    public void goBegin() {
        this.y0 = 0;
    }

    public void goEnd() {
        this.y0 = -(this.textHeight - this.listHeight);
        if (this.y0 > 0) {
            this.y0 = 0;
        }
    }

    public String getText() {
        return this.text;
    }

    protected void paint(Graphics g) {
        this.height = this.getHeight();
        this.width = this.getWidth();
        if (this.isFirstRun) {
            this.init(0, 0, this.width, this.height, g, this.text);
            this.isFirstRun = false;
        }
        int gx = g.getClipX();
        int gy = g.getClipY();
        int gw = g.getClipWidth();
        int gh = g.getClipHeight();
        g.setClip(this.x, this.y, this.width, this.height);
        this.drawText();
        this.drawScrollBar();
        this.drawTitleBar();
        this.drawMenuBar();
        g.setClip(gx, gy, gw, gh);
    }

    public void commandAction(Command c, Displayable d) {
        if (c == Commands.BACK) {
            this.back.activate();
        }
        if (c == Commands.EDIT) {
            this.textEditor.start(2, this.getTitle(), this.getText(), this.back, this);
        }
    }

    private void onRightSoftKeyPressed() {
        if (this.listener != null) {
            Command c = (Command)this.commands.elementAt(1);
            this.listener.commandAction(c, (Displayable)this);
        }
    }

    private void onFirePressed() {
        if (this.listener != null) {
            Command c = (Command)this.commands.elementAt(0);
            this.listener.commandAction(c, (Displayable)this);
        }
    }

    protected void keyPressed(int keyCode) {
        int action = 2128506;
        try {
            action = this.getGameAction(keyCode);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (keyCode == 35 || keyCode == -7 || keyCode == -22 || keyCode == 22 || keyCode == -203) {
            this.onRightSoftKeyPressed();
        }
        if (action == 8 || keyCode == 53) {
            this.onFirePressed();
        }
        if (action == 1 || keyCode == 50) {
            this.lineUp();
        }
        if (action == 6 || keyCode == 56) {
            this.lineDown();
        }
        if (action == 2 || keyCode == 51) {
            this.pageUp();
        }
        if (action == 5 || keyCode == 57) {
            this.pageDown();
        }
        if (keyCode == 49) {
            this.goBegin();
        }
        if (keyCode == 55) {
            this.goEnd();
        }
        this.repaint();
    }

    protected void pointerPressed(int x, int y) {
        if (y >= this.y + this.titleBarHeight + this.listHeight && x >= this.x + this.width / 3) {
            if (x > this.x + 2 * this.width / 3) {
                this.onRightSoftKeyPressed();
            } else {
                this.onFirePressed();
            }
        }
    }

    public void setCommandListener(CommandListener listener) {
        this.listener = listener;
    }

    public void activate() {
        MyNotes.display.setCurrent((Displayable)this);
    }
}

