/*
 * Decompiled with CFR 0.152.
 */
package mynotes;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import mynotes.Utils;

public class Note {
    public int id;
    public String text;

    public Note() {
        this.clear();
    }

    public final void clear() {
        this.text = "";
    }

    byte[] toByteArray() {
        byte[] data = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream das = new DataOutputStream(baos);
            das.writeInt(this.id);
            das.writeUTF(this.text);
            data = baos.toByteArray();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (data != null) {
            Utils.encrypt(data);
        }
        return data;
    }

    public boolean fromByteArray(byte[] data) {
        Utils.encrypt(data);
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data, 0, data.length);
            DataInputStream dis = new DataInputStream(bais);
            this.id = dis.readInt();
            this.text = dis.readUTF();
        }
        catch (Exception e) {
            this.clear();
            return false;
        }
        return true;
    }
}

