/*
 * Decompiled with CFR 0.152.
 */
package com.lenin.files.electroid.game;

import com.lenin.files.electroid.Main;
import com.lenin.files.electroid.effects.LightManager;
import com.lenin.files.electroid.effects.Shaker;
import com.lenin.files.electroid.effects.ShockWaveManager;
import com.lenin.files.electroid.effects.Slideable;
import com.lenin.files.electroid.effects.SparkManager;
import com.lenin.files.electroid.game.Ball;
import com.lenin.files.electroid.game.Brick;
import com.lenin.files.electroid.game.BrickGrid;
import com.lenin.files.electroid.game.Levels;
import com.lenin.files.electroid.game.Plate;
import com.lenin.files.electroid.game.Resources;
import com.lenin.files.electroid.sensors.AccelerationProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.midlet.MIDlet;

public class Game
extends LayerManager
implements Slideable {
    public static final int STATE_MENU = 0;
    public static final int STATE_INFO = 1;
    public static final int STATE_HELP = 2;
    public static final int STATE_TRANSITION = 3;
    public static final int STATE_LEVEL = 4;
    public static final int STATE_GAME_OVER = 5;
    public static final int STATE_HIGH_SCORES = 6;
    public static final int EVENT_BRICK_COLLISION = 0;
    public static final int EVENT_BRICK_EXPLOSION = 1;
    public static final int EVENT_PLATE_COLLISION = 2;
    public static final int EVENT_WALL_COLLISION = 3;
    public static final int EVENT_LEVEL_CHANGE = 4;
    public static final int EVENT_BUTTON_PRESSED = 5;
    public static final int EVENT_BALL_OUT = 6;
    public static final int EVENT_BONUS = 7;
    public static final int EVENT_LEVEL_STARTED = 8;
    public static final int EVENT_GAME_OVER = 9;
    private static final int LIVES = 5;
    private static final int WALL_PADDING = 4;
    private final int IN_X;
    private final int OUT_X;
    private int levelNumber;
    private int plateY;
    private int cornerX;
    private int cornerY;
    private int gameWidth;
    private int gameHeight;
    private int pointerX;
    private double aX = 0.0;
    private double vX = 0.0;
    private boolean pointerPressed;
    private boolean menuPressed = false;
    private boolean changeLevel;
    private boolean aiming = true;
    private boolean sensorsEnabled = true;
    private AccelerationProvider accelerationProvider;
    private Resources r;
    private Plate plate;
    private Ball ball;
    private BrickGrid bricks;
    private Sprite leftWall;
    private Sprite rightWall;
    private Sprite topWall;
    private Sprite dashboard;
    private Sprite menuButton;
    private Sprite newGameButton;
    private Shaker shaker;
    private ShockWaveManager shockWaveManager;
    private SparkManager sparkManager;
    private Vector lives;
    private Random rnd = new Random();
    private Font font = Font.getFont((int)0, (int)1, (int)8);
    private final Listener listener;

    public Game(int cornerX, int cornerY, int width, int height, Resources r, Listener listener) {
        this.listener = listener;
        this.gameWidth = width;
        this.gameHeight = height;
        this.r = r;
        this.IN_X = cornerX;
        this.cornerX = this.OUT_X = cornerX + width;
        this.cornerY = cornerY;
        this.createGame();
        this.setViewWindow(0, 0, width, height);
    }

    private void createGame() {
        this.lives = new Vector();
        this.bricks = new BrickGrid(this, this.gameWidth, this.gameHeight, this.r);
        this.plate = new Plate(this.gameWidth, this.r);
        this.plateY = this.gameHeight - this.plate.getHeight() - this.r.dashboard.getHeight() / 2;
        this.plate.setPosition((this.gameWidth - this.plate.getWidth()) / 2, this.plateY);
        this.ball = new Ball(this.r);
        this.topWall = new Sprite(this.r.horizontalWall, this.r.horizontalWall.getWidth(), this.r.horizontalWall.getHeight() / 2);
        this.leftWall = new Sprite(this.r.verticalWall, this.r.verticalWall.getWidth() / 2, this.r.verticalWall.getHeight());
        this.rightWall = new Sprite(this.r.verticalWall, this.r.verticalWall.getWidth() / 2, this.r.verticalWall.getHeight());
        int wallPadding = this.r.scale(4.0);
        this.topWall.defineCollisionRectangle(0, 0, this.gameWidth, this.topWall.getHeight() - wallPadding);
        this.leftWall.defineCollisionRectangle(0, 0, this.leftWall.getWidth() - wallPadding, this.leftWall.getHeight() - wallPadding);
        this.rightWall.defineCollisionRectangle(wallPadding, 0, this.rightWall.getWidth() - wallPadding, this.rightWall.getHeight() - wallPadding);
        this.topWall.setPosition(0, 0);
        this.leftWall.setPosition(this.r.scale(-3.0), 0);
        this.rightWall.setPosition(this.gameWidth + this.r.scale(3.0) - this.rightWall.getWidth(), 0);
        this.dashboard = new Sprite(this.r.dashboard);
        this.dashboard.setPosition(0, this.gameHeight - this.dashboard.getHeight());
        this.menuButton = new Sprite(this.r.menuButton);
        this.menuButton.setPosition(this.r.scale(180.0), this.gameHeight - this.menuButton.getHeight());
        this.newGameButton = new Sprite(this.r.newGameButton);
        this.newGameButton.setPosition(this.r.scale(10.0), this.gameHeight - this.newGameButton.getHeight());
        this.append((Layer)this.plate);
        this.append((Layer)this.topWall);
        this.append((Layer)this.leftWall);
        this.append((Layer)this.rightWall);
        this.append((Layer)this.ball);
        this.pointerPressed = false;
        this.shockWaveManager = new ShockWaveManager();
        this.sparkManager = new SparkManager(24, this.r, this);
        this.shaker = new Shaker();
    }

    public void paint(Graphics g) {
        this.shockWaveManager.paint(g);
        this.paint(g, this.cornerX + this.shaker.magnitudeX, this.cornerY + this.shaker.magnitudeY);
        if (this.lives.isEmpty()) {
            g.drawImage(this.r.gameOver, this.cornerX + this.gameWidth / 2, this.cornerY + this.gameHeight / 2, 3);
        }
        g.setColor(-1);
        g.setFont(this.font);
        g.drawString("" + this.levelNumber, this.cornerX + this.shaker.magnitudeX + this.gameWidth / 2, this.cornerY + this.shaker.magnitudeY + this.gameHeight, 33);
        this.topWall.setFrame(0);
        this.leftWall.setFrame(0);
        this.rightWall.setFrame(0);
    }

    public void update() {
        if (!this.lives.isEmpty()) {
            if (this.aiming) {
                this.aim();
            } else {
                this.ball.move();
                if (this.ball.getY() > this.gameHeight) {
                    this.sparkManager.burst(this.ball.getRefPixelX(), this.gameHeight);
                    int refX = this.cornerX + this.ball.getRefPixelX();
                    int refY = this.cornerY + this.ball.getRefPixelY();
                    this.shockWaveManager.createShockWave(refX, refY, this.r.scale(900.0), 3);
                    this.shockWaveManager.createShockWave(refX, refY, this.r.scale(500.0), 4);
                    this.shockWaveManager.createShockWave(refX, refY, this.r.scale(100.0), 6);
                    this.vibrate(1000);
                    LightManager.pulse(3);
                    Sprite life = (Sprite)this.lives.lastElement();
                    this.lives.removeElement(life);
                    this.remove((Layer)life);
                    if (this.lives.isEmpty()) {
                        this.newGameButton.setVisible(true);
                        this.listener.handleEvent(9);
                    } else {
                        this.placeBall();
                    }
                    this.listener.handleEvent(6);
                }
            }
            this.movePlate();
            this.checkCollisions();
        }
    }

    private void aim() {
        this.ball.setPosition(this.plate.getRefPixelX() - this.ball.getWidth() / 2, this.plate.getTopY() - this.ball.getHeight());
    }

    public void placeBall() {
        this.ball.setVelocityX(0);
        this.ball.setVelocityY(this.r.scale(-4 - this.levelNumber / 3) - 1);
        this.aiming = true;
        this.aim();
    }

    public void checkCollisions() {
        this.checkPlateCollision();
        this.checkWallCollisions();
        this.checkBrickCollisions();
    }

    public void checkPlateCollision() {
        if (this.ball.collidesWith(this.plate, false) && this.ball.getRefPixelY() < this.plate.getRefPixelY()) {
            this.ball.bounceUp();
            this.ball.setVelocityX((int)Math.ceil(this.r.scale(-8.0) * (this.plate.getRefPixelX() - this.ball.getRefPixelX()) / this.plate.getPlateWidth()));
            this.listener.handleEvent(2);
        }
    }

    public void checkWallCollisions() {
        boolean collision = false;
        if (this.ball.collidesWith(this.topWall, false) || this.ball.getY() < 0) {
            this.ball.bounceDown();
            this.topWall.setFrame(1);
            collision = true;
        }
        if (this.ball.collidesWith(this.leftWall, false) || this.ball.getX() < 0) {
            this.ball.bounceRight();
            this.leftWall.setFrame(1);
            collision = true;
        } else if (this.ball.collidesWith(this.rightWall, false) || this.ball.getX() + this.ball.getWidth() > this.gameWidth) {
            this.ball.bounceLeft();
            this.rightWall.setFrame(1);
            collision = true;
        }
        if (collision) {
            this.listener.handleEvent(3);
        }
    }

    public void checkBrickCollisions() {
        Brick brick = this.bricks.collidesWith(this.ball);
        if (brick != null) {
            if (this.ball.getRefPixelY() < brick.getRefPixelY()) {
                this.ball.bounceUp();
            } else {
                this.ball.bounceDown();
            }
            if (this.ball.getRefPixelX() < brick.getX()) {
                this.ball.bounceLeft();
            } else if (this.ball.getRefPixelX() > brick.getX() + brick.getWidth()) {
                this.ball.bounceRight();
            }
            if (brick.getFrame() % 2 == 0) {
                this.remove((Layer)brick);
                this.ball.changeVelocityX(this.rnd.nextInt(2));
                this.sparkManager.burst(brick.getRefPixelX(), brick.getRefPixelY());
                this.listener.handleEvent(1);
                this.vibrate(40);
                LightManager.pulse(2);
                if (this.bricks.isEmpty()) {
                    this.changeLevel = true;
                    this.listener.changeState(4);
                    this.listener.handleEvent(4);
                } else {
                    this.shaker.shake(this.ball.getVelocityX(), this.ball.getVelocityY());
                }
            } else {
                this.listener.handleEvent(0);
            }
        }
    }

    public void pointerPressed(int x, int y) {
        this.setPlateDestination(x);
        if (this.menuButtonHit(x, y)) {
            this.menuPressed = true;
        }
    }

    public void pointerReleased(int x, int y) {
        this.stopMovement();
        if (this.menuPressed && this.menuButtonHit(x, y)) {
            this.rightButtonPressed();
        } else {
            this.menuPressed = false;
            if (this.aiming) {
                this.aiming = false;
            }
        }
        if (this.newGameButton.isVisible() && this.newGameButtonHit(x, y)) {
            this.leftButtonPressed();
        }
    }

    public void pointerDragged(int x, int y) {
        this.setPlateDestination(x);
    }

    public void fire() {
        if (this.aiming) {
            this.aiming = false;
        }
    }

    public void leftButtonPressed() {
        if (this.lives.isEmpty()) {
            this.listener.changeState(4);
            this.newGame();
        }
    }

    public void rightButtonPressed() {
        this.listener.changeState(0);
        this.listener.handleEvent(5);
    }

    public void setPlateDestination(int x) {
        this.pointerPressed = true;
        this.plate.setMoving(x);
        this.pointerX = x;
    }

    public void movePlate() {
        if (this.pointerPressed) {
            int distance = this.plate.getRefPixelX() - this.pointerX;
            if (distance > 0 && this.plate.getLeftX() > 0 || distance < 0 && this.plate.getRightX() < this.gameWidth) {
                distance = (int)((double)distance * 0.94);
            }
            this.plate.setRefPixelPosition(this.pointerX + distance, this.plate.getRefPixelY());
            if (distance == 0) {
                this.stopMovement();
            }
        } else if (this.accelerationProvider != null) {
            this.vX -= (double)this.gameWidth * this.aX * 30.0 / 5000.0;
            if (Math.abs(this.vX) > 1.0) {
                if (this.vX < 0.0 && this.plate.getLeftX() > 0 || this.vX > 0.0 && this.plate.getRightX() < this.gameWidth) {
                    if ((double)this.plate.getLeftX() + this.vX < 0.0) {
                        this.vX = -this.plate.getLeftX();
                    } else if ((double)this.plate.getRightX() + this.vX > (double)this.gameWidth) {
                        this.vX = this.gameWidth - this.plate.getRightX();
                    }
                    this.plate.move((int)this.vX, 0);
                }
                this.vX = 0.0;
            }
        }
    }

    public void movePlateLeft() {
        if (this.plate.getLeftX() > 0) {
            this.plate.moveLeft();
        }
    }

    public void movePlateRight() {
        if (this.plate.getRightX() < this.gameWidth) {
            this.plate.moveRight();
        }
    }

    public void stopMovement() {
        this.pointerPressed = false;
        this.plate.stop();
    }

    public void vibrate(int duration) {
        Display display = Display.getDisplay((MIDlet)Main.getInstance());
        display.vibrate(duration);
    }

    private boolean menuButtonHit(int x, int y) {
        return this.containsPoint(x, y, this.menuButton);
    }

    private boolean newGameButtonHit(int x, int y) {
        return this.containsPoint(x, y, this.newGameButton);
    }

    private boolean containsPoint(int x, int y, Sprite sprite) {
        return x >= sprite.getX() && x <= sprite.getX() + sprite.getWidth() && y >= sprite.getY();
    }

    public void newGame() {
        this.levelNumber = 0;
        this.initDashboard(5);
        this.nextLevel();
    }

    public void nextLevel() {
        this.placeBall();
        ++this.levelNumber;
        this.loadLevel(this.levelNumber);
    }

    public void loadLevel(int number) {
        this.bricks.load(this, Levels.getLevel((number - 1) % 22 + 1));
    }

    public void initDashboard(int balls) {
        if (balls > 0) {
            this.newGameButton.setVisible(false);
        }
        this.insert((Layer)this.dashboard, 0);
        this.insert((Layer)this.menuButton, 0);
        this.insert((Layer)this.newGameButton, 0);
        while (this.lives.size() > 0) {
            Sprite life = (Sprite)this.lives.lastElement();
            this.lives.removeElement(life);
            this.remove((Layer)life);
        }
        int i = 0;
        while (i < balls) {
            Sprite life = new Sprite(this.r.life);
            life.setPosition(this.r.scale(12.0) + i * life.getWidth(), this.gameHeight - this.r.scale(14.0));
            this.lives.addElement(life);
            this.insert((Layer)life, 0);
            ++i;
        }
        if (this.lives.size() > 0) {
            ((Sprite)this.lives.elementAt(0)).setVisible(false);
        }
    }

    public byte[] getSnapshot() {
        ByteArrayOutputStream bout = null;
        try {
            bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            dout.writeInt(this.levelNumber);
            dout.writeInt(this.lives.size());
            dout.writeBoolean(this.aiming);
            dout.writeInt(this.plate.getX());
            dout.writeInt(this.plate.getY());
            dout.writeInt(this.ball.getX());
            dout.writeInt(this.ball.getY());
            dout.writeInt(this.ball.getVelocityX());
            dout.writeInt(this.ball.getVelocityY());
            this.bricks.writeTo(dout);
            byte[] byArray = bout.toByteArray();
            return byArray;
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (bout != null) {
                    bout.close();
                }
            }
            catch (IOException iOException) {}
        }
        return new byte[0];
    }

    public boolean load(byte[] record) {
        if (record == null) {
            return false;
        }
        try {
            DataInputStream din = new DataInputStream(new ByteArrayInputStream(record));
            this.levelNumber = din.readInt();
            this.initDashboard(din.readInt());
            this.aiming = din.readBoolean();
            this.plate.setPosition(din.readInt(), din.readInt());
            this.ball.setPosition(din.readInt(), din.readInt());
            this.ball.setVelocityX(din.readInt());
            this.ball.setVelocityY(din.readInt());
            this.bricks.load(this, this.bricks.readFrom(din));
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean slideIn() {
        boolean sliding;
        int distance = this.cornerX - this.IN_X;
        distance = (int)((double)distance * 0.8);
        this.cornerX = this.IN_X + distance;
        boolean bl = sliding = distance != 0;
        if (!sliding && this.sensorsEnabled) {
            this.accelerationProvider = AccelerationProvider.getProvider(new AccelerationProvider.Listener(){

                public void dataReceived(double ax, double ay, double az) {
                    Game.this.aX = ax;
                }
            });
            this.listener.handleEvent(8);
        }
        return sliding;
    }

    public boolean slideOut() {
        if (this.accelerationProvider != null) {
            this.accelerationProvider.close();
            this.accelerationProvider = null;
        }
        int distance = this.cornerX - this.OUT_X;
        distance = (int)((double)distance * 0.8);
        this.cornerX = this.OUT_X + distance;
        if (distance == 0 && this.changeLevel) {
            this.changeLevel = false;
            this.nextLevel();
        }
        return distance != 0;
    }

    public void enableSensors(boolean value) {
        this.sensorsEnabled = value;
    }

    public static interface Listener {
        public void changeState(int var1);

        public void handleEvent(int var1);
    }
}

