/*
 * Decompiled with CFR 0.152.
 */
package com.lenin.files.electroid.menu;

import com.lenin.files.electroid.ImageHelper;
import com.lenin.files.electroid.menu.MenuItem;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class Menu {
    public static final int POINTER_PRESSED = 0;
    public static final int POINTER_DRAGGED = 1;
    public static final int POINTER_RELEASED = 2;
    private final MenuItem[] items;
    private final Listener listener;

    protected Menu(int capacity, Listener listener) {
        this.items = new MenuItem[capacity];
        this.listener = listener;
    }

    protected final void setItem(int i, MenuItem item) {
        this.items[i] = item;
    }

    protected final MenuItem getItem(int i) {
        return this.items[i];
    }

    protected void paint(Graphics g) {
        int i = 0;
        while (i < this.items.length) {
            this.items[i].paint(g);
            ++i;
        }
    }

    public void selectItem(int selected) {
        int i = 0;
        while (i < this.items.length) {
            this.items[i].setSelected(i == selected);
            ++i;
        }
    }

    private int getSelected() {
        int i = 0;
        while (i < this.items.length) {
            if (this.items[i].isSelected()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void selectNext() {
        this.selectItem((this.getSelected() + 1) % this.items.length);
        if (!this.getItem(this.getSelected()).isVisible()) {
            this.selectNext();
        }
    }

    public void selectPrev() {
        this.selectItem((Math.max(this.getSelected(), 0) - 1 + this.items.length) % this.items.length);
        if (!this.getItem(this.getSelected()).isVisible()) {
            this.selectPrev();
        }
    }

    public void clickSelected() {
        this.listener.itemClicked(this.getSelected());
    }

    public void pointerEvent(int type, int x, int y) {
        int i = 0;
        while (i < this.items.length) {
            if (this.items[i].hits(x, y)) {
                if (type == 2) {
                    this.listener.itemClicked(i);
                    this.items[i].setSelected(false);
                } else {
                    this.selectItem(i);
                }
                return;
            }
            ++i;
        }
        this.selectItem(-1);
    }

    protected Sprite loadSprite(String fileName, int lines, double scaling) {
        Image i = this.loadImage(fileName, lines, scaling);
        return new Sprite(i, i.getWidth(), i.getHeight() / lines);
    }

    protected Image loadImage(String fileName, int lines, double scaling) {
        ImageHelper ih = ImageHelper.getInstance();
        Image i = ih.loadImage(fileName);
        return ImageHelper.scaleImage(i, (int)(scaling * (double)i.getWidth() + 0.5), (int)(scaling * (double)i.getHeight() / (double)lines + 0.5) * lines);
    }

    public static interface Listener {
        public void itemClicked(int var1);
    }
}

