/*
 * Decompiled with CFR 0.152.
 */
package com.lenin.files.electroid.menu;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public class MenuItem {
    protected final Sprite sprite;
    private volatile boolean selected = false;

    public MenuItem(Sprite sprite) {
        this.sprite = sprite;
    }

    public void setSelected(boolean s) {
        this.selected = s;
        this.sprite.setFrame(this.getFrame());
    }

    protected int getFrame() {
        return this.selected ? 1 : 0;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isVisible() {
        return this.sprite.isVisible();
    }

    public void setVisibile(boolean bln) {
        this.sprite.setVisible(bln);
    }

    public int getWidth() {
        return this.sprite.getWidth();
    }

    public int getHeight() {
        return this.sprite.getHeight();
    }

    public int getX() {
        return this.sprite.getX();
    }

    public int getY() {
        return this.sprite.getY();
    }

    public void setCenter(int x, int y) {
        this.sprite.setPosition(x - this.sprite.getWidth() / 2, y - this.sprite.getHeight() / 2);
    }

    public void setHorizontalCenter(int x) {
        this.sprite.setPosition(x - this.sprite.getWidth() / 2, this.sprite.getY());
    }

    public void setVerticalCenter(int y) {
        this.sprite.setPosition(this.sprite.getX(), y - this.sprite.getHeight() / 2);
    }

    public void setPosition(int x, int y) {
        this.sprite.setPosition(x, y);
    }

    public boolean hits(int x, int y) {
        int left = this.sprite.getX();
        int right = left + this.sprite.getWidth();
        int top = this.sprite.getY();
        int bottom = top + this.sprite.getHeight();
        return x > left && x < right && y > top && y < bottom;
    }

    public void paint(Graphics g) {
        this.sprite.paint(g);
    }
}

