/*
 * Decompiled with CFR 0.152.
 */
package com.lenin.files.electroid;

import com.lenin.files.electroid.Main;
import com.lenin.files.electroid.audio.AudioManager;
import com.lenin.files.electroid.effects.ElectricArc;
import com.lenin.files.electroid.effects.LightManager;
import com.lenin.files.electroid.effects.Slideable;
import com.lenin.files.electroid.game.Game;
import com.lenin.files.electroid.game.Resources;
import com.lenin.files.electroid.menu.HelpScreen;
import com.lenin.files.electroid.menu.InfoScreen;
import com.lenin.files.electroid.menu.MainMenu;
import com.lenin.files.electroid.menu.Menu;
import java.util.Random;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class ElectroidCanvas
extends GameCanvas
implements CommandListener {
    public static final int INTERVAL = 30;
    private static final int LEFT_SOFTKEY = -6;
    private static final int RIGHT_SOFTKEY = -7;
    private static final double DEFAULT_WIDTH = 240.0;
    private static final double DEFAULT_HEIGHT = 320.0;
    private boolean pressed = false;
    private float scaling;
    private int gameState;
    private int nextState;
    private int cornerX;
    private int cornerY;
    private int displayWidth;
    private int displayHeight;
    private int gameWidth;
    private int gameHeight;
    private int x = 0;
    private int y = 0;
    private GameThread gameThread;
    private Main main;
    private MainMenu menu;
    private InfoScreen info;
    private HelpScreen help;
    private Game game;
    private Slideable currentView;
    private Slideable targetView;
    private boolean electricity;
    private Resources r;
    private Random rnd = new Random();
    private AudioManager audioManager;
    private Command backCommand;

    public ElectroidCanvas(Main main) {
        super(false);
        this.setFullScreenMode(true);
        this.main = main;
        this.calculateScalingFactor();
        this.audioManager = AudioManager.getInstance();
        this.backCommand = new Command("Back", 2, 0);
        this.addCommand(this.backCommand);
        this.setCommandListener(this);
    }

    private void loadOrCreateGame() {
        this.game = new Game(this.cornerX, this.cornerY, this.gameWidth, this.gameHeight, this.r, new Game.Listener(){

            public void changeState(int state) {
                switch (state) {
                    case 0: {
                        ElectroidCanvas.this.showMenu();
                        break;
                    }
                    case 4: {
                        ElectroidCanvas.this.nextLevel();
                    }
                }
            }

            public void handleEvent(int event) {
                switch (event) {
                    case 6: {
                        AudioManager audioManager = ElectroidCanvas.this.audioManager;
                        ElectroidCanvas.this.r.getClass();
                        audioManager.playSample("/death.mp3");
                        break;
                    }
                    case 7: {
                        AudioManager audioManager = ElectroidCanvas.this.audioManager;
                        ElectroidCanvas.this.r.getClass();
                        audioManager.playSample("/bonus.mp3");
                        break;
                    }
                    case 1: {
                        AudioManager audioManager = ElectroidCanvas.this.audioManager;
                        ElectroidCanvas.this.r.getClass();
                        audioManager.playSample("/explosion.mp3");
                        break;
                    }
                    case 0: {
                        ElectroidCanvas.this.audioManager.playSample(ElectroidCanvas.this.getRndCollisionSample());
                        break;
                    }
                    case 5: {
                        AudioManager audioManager = ElectroidCanvas.this.audioManager;
                        ElectroidCanvas.this.r.getClass();
                        audioManager.playSample("/button.mp3");
                        break;
                    }
                    case 9: {
                        break;
                    }
                    case 4: {
                        AudioManager audioManager = ElectroidCanvas.this.audioManager;
                        ElectroidCanvas.this.r.getClass();
                        audioManager.playSample("/teleport.mp3");
                        break;
                    }
                    case 8: {
                        ElectroidCanvas.this.menu.showResume();
                        break;
                    }
                    case 2: {
                        ElectroidCanvas.this.audioManager.playSample(ElectroidCanvas.this.getRndCollisionSample());
                        break;
                    }
                    case 3: {
                        AudioManager audioManager = ElectroidCanvas.this.audioManager;
                        ElectroidCanvas.this.r.getClass();
                        audioManager.playSample("/wall.mp3");
                    }
                }
            }
        });
        try {
            RecordStore snapshot = RecordStore.openRecordStore((String)"GameSnapshot", (boolean)true);
            if (snapshot.getNumRecords() == 0 || !this.game.load(snapshot.getRecord(this.getRecordId(snapshot)))) {
                this.game.newGame();
            } else {
                this.menu.showResume();
            }
            snapshot.closeRecordStore();
        }
        catch (RecordStoreException e) {
            this.game.newGame();
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
        }
        this.showMenu();
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.backCommand) {
            if (this.gameState == 0) {
                this.main.exit();
            } else {
                this.showMenu();
            }
        }
    }

    public String getRndCollisionSample() {
        switch (this.rnd.nextInt(2)) {
            case 0: {
                this.r.getClass();
                return "/collision.mp3";
            }
            case 1: {
                this.r.getClass();
                return "/collision2.mp3";
            }
            case 2: {
                this.r.getClass();
                return "/collision3.mp3";
            }
        }
        this.r.getClass();
        return "/collision.mp3";
    }

    public void saveGame() {
        if (this.game == null) {
            return;
        }
        try {
            RecordStore snapshot = RecordStore.openRecordStore((String)"GameSnapshot", (boolean)true);
            if (snapshot.getNumRecords() == 0) {
                snapshot.addRecord(null, 0, 0);
            }
            byte[] data = this.game.getSnapshot();
            snapshot.setRecord(this.getRecordId(snapshot), data, 0, data.length);
            snapshot.closeRecordStore();
            System.out.println("state saved succesfully");
        }
        catch (RecordStoreException e) {
            System.out.println("exception occured while saving");
        }
    }

    private int getRecordId(RecordStore store) throws RecordStoreException {
        RecordEnumeration e = store.enumerateRecords(null, null, false);
        try {
            int n = e.nextRecordId();
            return n;
        }
        finally {
            e.destroy();
        }
    }

    private void checkKeys() {
        int keyState = this.getKeyStates();
        if (this.gameState == 4) {
            if ((keyState & 4) != 0) {
                this.game.movePlateLeft();
            } else if ((keyState & 0x20) != 0) {
                this.game.movePlateRight();
            }
        }
    }

    protected void keyPressed(int key) {
        switch (this.gameState) {
            case 0: {
                switch (this.getGameAction(key)) {
                    case 1: {
                        this.menu.selectPrev();
                        break;
                    }
                    case 6: {
                        this.menu.selectNext();
                        break;
                    }
                    case 8: {
                        this.menu.clickSelected();
                    }
                }
                break;
            }
            case 1: {
                switch (this.getGameAction(key)) {
                    case 1: {
                        this.info.selectPrev();
                        break;
                    }
                    case 6: {
                        this.info.selectNext();
                        break;
                    }
                    case 8: {
                        this.info.clickSelected();
                    }
                }
                break;
            }
            case 2: {
                switch (this.getGameAction(key)) {
                    case 1: {
                        this.help.selectPrev();
                        break;
                    }
                    case 6: {
                        this.help.selectNext();
                        break;
                    }
                    case 8: {
                        this.help.clickSelected();
                    }
                }
                break;
            }
            case 4: {
                switch (key) {
                    case -6: {
                        this.game.leftButtonPressed();
                        break;
                    }
                    case -7: {
                        this.game.rightButtonPressed();
                    }
                }
                if (this.getGameAction(key) != 8) break;
                this.game.fire();
            }
        }
    }

    public void update() {
        switch (this.gameState) {
            case 3: {
                if (this.currentView != null && this.currentView.slideOut()) break;
                this.currentView = null;
                if (this.targetView != null && this.targetView.slideIn()) break;
                this.currentView = this.targetView;
                this.targetView = null;
                this.gameState = this.nextState;
                break;
            }
            case 4: {
                this.game.update();
            }
        }
    }

    public void render() {
        Graphics g = this.getGraphics();
        this.paint(g);
        this.flushGraphics();
    }

    public void paint(Graphics g) {
        int anchor = 20;
        g.setColor(-16777216);
        g.fillRect(0, 0, this.displayWidth, this.gameHeight - this.r.background.getHeight() + 1);
        g.drawImage(this.r.background, this.cornerX, this.gameHeight, 36);
        g.drawImage(this.gameState == 0 || this.gameState == 1 || this.gameState == 2 ? this.r.signOn : this.r.signOff, this.cornerX, this.cornerY + (int)((double)(this.scaling * 86.0f) + 0.5), anchor);
        if (this.gameState == 3) {
            g.setClip(this.cornerX, this.cornerY, this.gameWidth, this.gameHeight);
        } else {
            g.setClip(0, 0, this.displayWidth, this.displayHeight);
        }
        try {
            if (this.currentView != null) {
                this.currentView.paint(g);
            }
            if (this.targetView != null) {
                this.targetView.paint(g);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if ((this.gameState == 0 || this.gameState == 1 || this.gameState == 2) && this.pressed) {
            ElectricArc arc = new ElectricArc();
            int a = 2 + this.rnd.nextInt(4);
            while (a > 0) {
                g.setColor(this.rnd.nextInt(255), 255, 255);
                arc.paint(g, this.x, this.y, (int)(this.scaling * 10.0f), (int)(this.scaling * 10.0f));
                --a;
            }
        }
    }

    protected void showNotify() {
        this.r.loadResources();
        if (this.menu == null) {
            this.createMenu();
            this.menu.hideResume();
        }
        if (this.info == null) {
            this.createInfoScreen();
        }
        if (this.help == null) {
            this.createHelpScreen();
        }
        if (this.game == null) {
            this.loadOrCreateGame();
        }
        this.startApp();
    }

    protected void hideNotify() {
        this.pauseApp();
        this.r.freeResources();
        this.audioManager.stopAll();
    }

    protected void sizeChanged(int w, int h) {
        if (h == this.displayHeight && w == this.displayWidth) {
            return;
        }
        this.calculateScalingFactor();
        this.r.freeResources();
        LightManager.allowDimming();
        this.menu = null;
        this.info = null;
        this.help = null;
        this.game = null;
        this.showNotify();
    }

    public void stopApp() {
        this.gameState = 0;
        this.gameThread.requestStop();
        LightManager.allowDimming();
    }

    public void startApp() {
        if (this.gameThread == null) {
            this.gameThread = new GameThread();
        }
        this.gameThread.requestStart();
        LightManager.avoidDimming();
    }

    public void pauseApp() {
        this.gameThread.requestPause();
        LightManager.allowDimming();
    }

    private void calculateScalingFactor() {
        Graphics g = this.getGraphics();
        this.displayWidth = g.getClipWidth();
        this.displayHeight = g.getClipHeight();
        this.scaling = 1.0f;
        if ((double)this.displayWidth != 240.0) {
            this.scaling = (float)((double)this.displayWidth / 240.0);
        }
        this.r = new Resources(this.scaling);
        this.gameWidth = (int)((double)this.scaling * 240.0 + 0.5);
        this.gameHeight = g.getClipHeight();
        this.cornerX = (int)((double)(this.displayWidth / 2 - this.gameWidth / 2) + 0.5);
        this.cornerY = this.displayHeight - this.gameHeight;
    }

    public void pointerPressed(int x, int y) {
        this.x = x;
        this.y = y;
        this.pressed = true;
        switch (this.gameState) {
            case 4: {
                this.game.pointerPressed(x - this.cornerX, y - this.cornerY);
                break;
            }
            case 0: {
                this.menu.pointerEvent(0, x, y);
                this.r.getClass();
                this.audioManager.playSample("/button.mp3");
                break;
            }
            case 1: {
                this.info.pointerEvent(0, x, y);
                this.r.getClass();
                this.audioManager.playSample("/button.mp3");
                break;
            }
            case 2: {
                this.help.pointerEvent(0, x, y);
                this.r.getClass();
                this.audioManager.playSample("/button.mp3");
            }
        }
        if (this.gameState == 0) {
            this.r.getClass();
            this.electricity = this.audioManager.loopSample("/electricity.mp3");
        }
    }

    public void pointerReleased(int x, int y) {
        this.pressed = false;
        if (this.electricity) {
            this.r.getClass();
            this.audioManager.stopPlayer("/electricity.mp3");
            this.electricity = false;
        }
        switch (this.gameState) {
            case 4: {
                this.game.pointerReleased(x - this.cornerX, y - this.cornerY);
                break;
            }
            case 0: {
                this.menu.pointerEvent(2, x, y);
                break;
            }
            case 1: {
                this.info.pointerEvent(2, x, y);
                break;
            }
            case 2: {
                this.help.pointerEvent(2, x, y);
            }
        }
    }

    public void pointerDragged(int x, int y) {
        this.x = x;
        this.y = y;
        switch (this.gameState) {
            case 4: {
                this.game.pointerDragged(x - this.cornerX, y - this.cornerY);
                break;
            }
            case 0: {
                this.menu.pointerEvent(1, x, y);
                break;
            }
            case 1: {
                this.info.pointerEvent(0, x, y);
                break;
            }
            case 2: {
                this.help.pointerEvent(0, x, y);
            }
        }
    }

    private void createMenu() {
        double menuScaling = (float)((double)this.displayHeight / 320.0);
        this.menu = new MainMenu(this.cornerX, this.cornerY, this.gameWidth, this.gameHeight, new Menu.Listener(){

            public void itemClicked(int item) {
                switch (item) {
                    case 0: {
                        ElectroidCanvas.this.resumeGame();
                        break;
                    }
                    case 1: {
                        ElectroidCanvas.this.newGame();
                        break;
                    }
                    case 2: {
                        ElectroidCanvas.this.game.enableSensors(ElectroidCanvas.this.menu.toggleSensors());
                        break;
                    }
                    case 3: {
                        AudioManager.setAudioEnabled(ElectroidCanvas.this.menu.toggleSounds());
                        break;
                    }
                    case 5: {
                        ElectroidCanvas.this.main.exit();
                        break;
                    }
                    case 6: {
                        ElectroidCanvas.this.showInfo();
                        break;
                    }
                    case 4: {
                        ElectroidCanvas.this.showHelp();
                    }
                }
            }
        }, menuScaling);
    }

    private void createInfoScreen() {
        this.info = new InfoScreen(this.cornerX, this.cornerY, this.gameWidth, this.gameHeight, new Menu.Listener(){

            public void itemClicked(int item) {
                switch (item) {
                    case 0: {
                        Main midlet = Main.getInstance();
                        try {
                            if (!midlet.platformRequest("http://leninvengai.blogspot.com")) break;
                            midlet.exit();
                        }
                        catch (ConnectionNotFoundException connectionNotFoundException) {}
                        break;
                    }
                    case 1: {
                        ElectroidCanvas.this.showMenu();
                    }
                }
            }
        }, this.scaling);
    }

    private void createHelpScreen() {
        this.help = new HelpScreen(this.cornerX, this.cornerY, this.gameWidth, this.gameHeight, new Menu.Listener(){

            public void itemClicked(int item) {
                switch (item) {
                    case 0: {
                        Main midlet = Main.getInstance();
                        try {
                            if (!midlet.platformRequest("http://leninvengai.blogspot.com")) break;
                            midlet.exit();
                        }
                        catch (ConnectionNotFoundException connectionNotFoundException) {}
                        break;
                    }
                    case 1: {
                        ElectroidCanvas.this.showMenu();
                    }
                }
            }
        }, this.scaling);
    }

    public void changeView(Slideable targetView) {
        this.targetView = targetView;
        this.gameState = 3;
        this.r.getClass();
        this.audioManager.playSample("/transition.mp3");
    }

    private void resumeGame() {
        this.nextState = 4;
        this.changeView(this.game);
    }

    private void newGame() {
        this.game.newGame();
        this.nextState = 4;
        this.changeView(this.game);
    }

    public void showMenu() {
        this.nextState = 0;
        this.changeView(this.menu);
    }

    public void showInfo() {
        this.nextState = 1;
        this.changeView(this.info);
    }

    public void showHelp() {
        this.nextState = 2;
        this.changeView(this.help);
    }

    public void nextLevel() {
        this.nextState = 4;
        this.changeView(this.game);
    }

    class GameThread
    extends Thread {
        private boolean pause = true;
        private boolean stop = false;
        private boolean started = false;

        GameThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestStart() {
            this.pause = false;
            if (!this.started) {
                this.start();
                this.started = true;
            } else {
                GameThread gameThread = this;
                synchronized (gameThread) {
                    this.notify();
                }
            }
        }

        public void requestPause() {
            this.pause = true;
        }

        public void requestStop() {
            this.stop = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long time = 0L;
            while (!this.stop) {
                try {
                    if (this.pause) {
                        GameThread gameThread = this;
                        synchronized (gameThread) {
                            this.wait();
                            continue;
                        }
                    }
                    time = System.currentTimeMillis();
                    ElectroidCanvas.this.checkKeys();
                    ElectroidCanvas.this.update();
                    ElectroidCanvas.this.render();
                    time = 30L - (System.currentTimeMillis() - time);
                    Thread.sleep(time < 0L ? 0L : time);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

