/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.Category;
import JabpLite.JabpLite;
import JabpLite.Utilities;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;

public class CategoryForm
extends Form {
    Category c;
    JabpLite parent;
    TextField tfName;
    TextField tfDescription;
    TextField tfOpen;
    ChoiceGroup cgDRCR;

    public CategoryForm(JabpLite jabpLite, Category category, String string) {
        super(string + " Category");
        this.parent = jabpLite;
        this.c = category;
        if (string.equals("Show") || string.equals("Delete")) {
            this.append("Name: " + this.c.name + "\n");
            this.append("Desc: " + this.c.description + "\n");
            String string2 = " DR";
            if (this.c.open >= 0) {
                string2 = " CR";
            }
            this.append("Opening Bal: " + Utilities.numberToString(Math.abs(this.c.open), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed) + string2 + "\n");
            string2 = " DR";
            if (this.c.current >= 0) {
                string2 = " CR";
            }
            this.append("Current Bal: " + Utilities.numberToString(Math.abs(this.c.current), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed) + string2);
            return;
        }
        this.tfName = new TextField("Name", this.c.name, 30, 0);
        this.append((Item)this.tfName);
        this.tfDescription = new TextField("Description", this.c.description, 64, 0);
        this.append((Item)this.tfDescription);
        int n = 2;
        if (!this.parent.numericEntry) {
            n = 0;
        }
        this.tfOpen = new TextField("Opening Balance", "", 20, n);
        String string3 = "";
        if (this.c.open != 0) {
            string3 = Utilities.numberToString(Math.abs(this.c.open), this.parent.numericEntry, this.parent.isEuropeanNumberFormat, false);
        }
        this.tfOpen.setString(string3);
        this.append((Item)this.tfOpen);
        int n2 = 4;
        if (this.parent.oldStyleChoice) {
            n2 = 1;
        }
        this.cgDRCR = new ChoiceGroup("DR/CR", n2);
        this.cgDRCR.append("Debit", null);
        this.cgDRCR.append("Credit", null);
        if (this.c.open < 0) {
            this.cgDRCR.setSelectedIndex(0, true);
        } else {
            this.cgDRCR.setSelectedIndex(1, true);
        }
        this.append((Item)this.cgDRCR);
    }

    Category update() {
        this.c.name = this.tfName.getString();
        this.c.description = this.tfDescription.getString();
        int n = this.c.open;
        this.c.open = Utilities.stringToNumber(this.tfOpen.getString(), n, this.parent.numericEntry, this.parent.isEuropeanNumberFormat);
        if (this.cgDRCR.getSelectedIndex() == 0) {
            this.c.open = -this.c.open;
        }
        this.c.current += this.c.open - n;
        return this.c;
    }
}

