/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.JabpLite;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class PreferenceStore {
    RecordStore rs;
    JabpLite parent;

    public PreferenceStore(JabpLite jabpLite) {
        this.parent = jabpLite;
        try {
            this.rs = RecordStore.openRecordStore((String)"Preferences", (boolean)true, (int)1, (boolean)true);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ps1");
        }
    }

    void closePreferenceStore() {
        if (this.rs != null) {
            try {
                this.rs.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                System.err.println((Object)((Object)recordStoreException) + " ps2");
            }
        }
    }

    int getNumPreferences() {
        if (this.rs == null) {
            if (this.parent.isAndroid) {
                this.parent.largeSize = true;
                this.parent.heightAdjustment = 30;
                this.parent.createFormsInBackground = false;
            }
            return 0;
        }
        try {
            return this.rs.getNumRecords();
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ps3");
            return 0;
        }
    }

    byte[] toByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeUTF(this.parent.homeCurrency);
            dataOutputStream.writeBoolean(this.parent.mediumSize);
            dataOutputStream.writeInt(this.parent.fontAdjustment);
            dataOutputStream.writeInt(this.parent.widthAdjustment);
            dataOutputStream.writeInt(this.parent.colorHeading);
            dataOutputStream.writeInt(this.parent.colorCursor);
            dataOutputStream.writeInt(this.parent.colorBackground);
            dataOutputStream.writeBoolean(this.parent.passwordMode);
            dataOutputStream.writeUTF(this.parent.password);
            dataOutputStream.writeInt(this.parent.dateFormat);
            dataOutputStream.writeInt(this.parent.heightAdjustment);
            dataOutputStream.writeBoolean(this.parent.numericEntry);
            dataOutputStream.writeBoolean(this.parent.reuseForm);
            dataOutputStream.writeBoolean(this.parent.quickStart);
            dataOutputStream.writeUTF(this.parent.lastAccount);
            dataOutputStream.writeBoolean(this.parent.createFormsInBackground);
            dataOutputStream.writeBoolean(this.parent.showFullCanvas);
            dataOutputStream.writeBoolean(false);
            dataOutputStream.writeBoolean(this.parent.changedKeys);
            dataOutputStream.writeBoolean(this.parent.runningTotal);
            dataOutputStream.writeBoolean(this.parent.isEuropeanNumberFormat);
            dataOutputStream.writeBoolean(this.parent.isGroupingUsed);
            dataOutputStream.writeBoolean(this.parent.syncMode);
            dataOutputStream.writeBoolean(this.parent.showBalanceType);
            dataOutputStream.writeBoolean(this.parent.passwordWhenBackground);
            dataOutputStream.writeBoolean(this.parent.oldStyleChoice);
            dataOutputStream.writeInt(this.parent.holdingDecimalPlaces);
            dataOutputStream.writeInt(this.parent.priceDecimalPlaces);
            dataOutputStream.writeInt(this.parent.accountColumnsPortrait);
            dataOutputStream.writeInt(this.parent.accountColumnsLandscape);
            dataOutputStream.writeInt(this.parent.colorFont);
            dataOutputStream.writeInt(this.parent.colorMessage);
            dataOutputStream.writeBoolean(this.parent.preferCategoryInTransactionView);
            dataOutputStream.writeBoolean(this.parent.showMenuAccountView);
            dataOutputStream.writeBoolean(this.parent.showMenuInvestmentView);
            dataOutputStream.writeBoolean(this.parent.showMenuTransactionView);
            dataOutputStream.writeBoolean(this.parent.largeSize);
            dataOutputStream.writeInt(this.parent.matchDescriptionNumber);
            dataOutputStream.writeInt(this.parent.lineSpacing);
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    void fromByteArray(byte[] byArray) {
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            this.parent.homeCurrency = dataInputStream.readUTF();
            this.parent.mediumSize = dataInputStream.readBoolean();
            this.parent.fontAdjustment = dataInputStream.readInt();
            this.parent.widthAdjustment = dataInputStream.readInt();
            this.parent.colorHeading = dataInputStream.readInt();
            this.parent.colorCursor = dataInputStream.readInt();
            this.parent.colorBackground = dataInputStream.readInt();
            this.parent.passwordMode = dataInputStream.readBoolean();
            this.parent.password = dataInputStream.readUTF();
            this.parent.dateFormat = dataInputStream.readInt();
            this.parent.heightAdjustment = dataInputStream.readInt();
            this.parent.numericEntry = dataInputStream.readBoolean();
            this.parent.reuseForm = dataInputStream.readBoolean();
            this.parent.quickStart = dataInputStream.readBoolean();
            this.parent.lastAccount = dataInputStream.readUTF();
            this.parent.createFormsInBackground = dataInputStream.readBoolean();
            this.parent.showFullCanvas = dataInputStream.readBoolean();
            dataInputStream.readBoolean();
            this.parent.changedKeys = dataInputStream.readBoolean();
            this.parent.runningTotal = dataInputStream.readBoolean();
            this.parent.isEuropeanNumberFormat = dataInputStream.readBoolean();
            this.parent.isGroupingUsed = dataInputStream.readBoolean();
            this.parent.syncMode = dataInputStream.readBoolean();
            this.parent.showBalanceType = dataInputStream.readBoolean();
            this.parent.passwordWhenBackground = dataInputStream.readBoolean();
            this.parent.oldStyleChoice = dataInputStream.readBoolean();
            this.parent.holdingDecimalPlaces = dataInputStream.readInt();
            this.parent.priceDecimalPlaces = dataInputStream.readInt();
            this.parent.accountColumnsPortrait = dataInputStream.readInt();
            this.parent.accountColumnsLandscape = dataInputStream.readInt();
            this.parent.colorFont = dataInputStream.readInt();
            this.parent.colorMessage = dataInputStream.readInt();
            this.parent.preferCategoryInTransactionView = dataInputStream.readBoolean();
            this.parent.showMenuAccountView = dataInputStream.readBoolean();
            this.parent.showMenuInvestmentView = dataInputStream.readBoolean();
            this.parent.showMenuTransactionView = dataInputStream.readBoolean();
            this.parent.largeSize = dataInputStream.readBoolean();
            this.parent.matchDescriptionNumber = dataInputStream.readInt();
            this.parent.lineSpacing = dataInputStream.readInt();
            dataInputStream.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException + " ps4a");
        }
    }

    void getPasswordOnly(byte[] byArray) {
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            this.parent.homeCurrency = dataInputStream.readUTF();
            dataInputStream.readBoolean();
            dataInputStream.readInt();
            dataInputStream.readInt();
            dataInputStream.readInt();
            dataInputStream.readInt();
            dataInputStream.readInt();
            this.parent.passwordMode = dataInputStream.readBoolean();
            this.parent.password = dataInputStream.readUTF();
            dataInputStream.readInt();
            dataInputStream.readInt();
            dataInputStream.readBoolean();
            dataInputStream.readBoolean();
            dataInputStream.readBoolean();
            dataInputStream.readUTF();
            dataInputStream.readBoolean();
            dataInputStream.readBoolean();
            dataInputStream.readBoolean();
            dataInputStream.readBoolean();
            dataInputStream.readBoolean();
            dataInputStream.readBoolean();
            dataInputStream.readBoolean();
            dataInputStream.readBoolean();
            dataInputStream.readBoolean();
            dataInputStream.readBoolean();
            dataInputStream.readBoolean();
            this.parent.holdingDecimalPlaces = dataInputStream.readInt();
            this.parent.priceDecimalPlaces = dataInputStream.readInt();
        }
        catch (IOException iOException) {
            System.err.println(iOException + " ps4a");
        }
    }

    void getPreferences() {
        try {
            if (this.rs.getNumRecords() == 0) {
                return;
            }
            byte[] byArray = this.rs.getRecord(1);
            this.fromByteArray(byArray);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ps4");
        }
    }

    void savePreferences() {
        if (this.rs != null) {
            try {
                byte[] byArray = this.toByteArray();
                if (this.rs.getNumRecords() > 0) {
                    this.rs.setRecord(1, byArray, 0, byArray.length);
                } else {
                    this.rs.addRecord(byArray, 0, byArray.length);
                }
            }
            catch (RecordStoreException recordStoreException) {
                System.err.println((Object)((Object)recordStoreException) + " ps7");
            }
        }
    }

    int getSize() {
        try {
            return this.rs.getSize();
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ps9");
            return 0;
        }
    }
}

