/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.Account;
import JabpLite.AccountStore;
import JabpLite.Category;
import JabpLite.CategoryStore;
import JabpLite.JabpLite;
import JabpLite.Regular;
import JabpLite.Split;
import JabpLite.SplitStore;
import JabpLite.Utilities;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;

public class RegularForm2
extends Form {
    JabpLite parent;
    TextField tfDescription;
    TextField tfReference;
    TextField tfAmount;
    ChoiceGroup cgDRCR;
    ChoiceGroup cgAccount;
    ChoiceGroup cgCategory;
    ChoiceGroup cgTransfer;

    public RegularForm2(JabpLite jabpLite) {
        super("Regular Transaction");
        this.parent = jabpLite;
    }

    void build(Regular regular) {
        this.tfDescription = new TextField("Description", regular.description, 64, 0);
        this.tfDescription.setString(regular.description);
        this.append((Item)this.tfDescription);
        int n = 2;
        if (!this.parent.numericEntry) {
            n = 0;
        }
        this.tfAmount = new TextField("Amount", "", 64, n);
        String string = "";
        if (regular.amount != 0) {
            string = Utilities.numberToString(Math.abs(regular.amount), this.parent.numericEntry, this.parent.isEuropeanNumberFormat, false);
        }
        this.tfAmount.setString(string);
        this.append((Item)this.tfAmount);
        int n2 = 4;
        if (this.parent.oldStyleChoice) {
            n2 = 1;
        }
        this.cgDRCR = new ChoiceGroup("DR/CR", n2);
        this.cgDRCR.append("Debit", null);
        this.cgDRCR.append("Credit", null);
        if (regular.amount < 0) {
            this.cgDRCR.setSelectedIndex(0, true);
        } else {
            this.cgDRCR.setSelectedIndex(1, true);
        }
        this.append((Item)this.cgDRCR);
        this.tfReference = new TextField("Reference", "", 64, 0);
        this.tfReference.setString(regular.reference);
        this.append((Item)this.tfReference);
        this.cgTransfer = new ChoiceGroup("Transfer", n2);
        this.cgTransfer.append("No", null);
        this.cgTransfer.append("Yes", null);
        if (regular.transferFlag) {
            this.cgTransfer.setSelectedIndex(1, true);
            this.cgAccount = new ChoiceGroup("Transfer Account", n2);
            AccountStore accountStore = new AccountStore(this.parent);
            int n3 = accountStore.getNumAccounts();
            for (int i = 0; i < n3; ++i) {
                Account account = accountStore.getAccountFromIndex(i);
                this.cgAccount.append(account.name, null);
                if (!account.name.equals(regular.transferAccount)) continue;
                this.cgAccount.setSelectedIndex(i, true);
            }
            this.append((Item)this.cgAccount);
            accountStore.closeAccountStore();
            accountStore = null;
            return;
        }
        this.cgTransfer.setSelectedIndex(0, true);
        this.append((Item)this.cgTransfer);
        this.cgCategory = regular.category.equals("") || regular.splitFlag ? new ChoiceGroup("Category", 2) : new ChoiceGroup("Category", n2);
        CategoryStore categoryStore = new CategoryStore(this.parent);
        int n4 = categoryStore.getNumCategories();
        for (int i = 0; i < n4; ++i) {
            Category category = categoryStore.getCategoryFromIndex(i);
            this.cgCategory.append(category.name, null);
            if (regular.splitFlag) {
                for (int j = 0; j < regular.ss.size(); ++j) {
                    Split split = regular.ss.getSplit(j);
                    if (!category.name.equals(split.category)) continue;
                    this.cgCategory.setSelectedIndex(i, true);
                }
                continue;
            }
            if (!category.name.equals(regular.category)) continue;
            this.cgCategory.setSelectedIndex(i, true);
        }
        this.append((Item)this.cgCategory);
        categoryStore.closeCategoryStore();
        categoryStore = null;
    }

    int checkAmount() {
        return Utilities.stringToNumber(this.tfAmount.getString(), 0, this.parent.numericEntry, this.parent.isEuropeanNumberFormat);
    }

    void show(Regular regular, String string) {
        this.setTitle(string + " Regular");
        this.append("Desc: " + regular.description + "\n");
        String string2 = " DR";
        if (regular.amount >= 0) {
            string2 = " CR";
        }
        this.append("Amount: " + Utilities.numberToString(Math.abs(regular.amount), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed) + string2 + "\n");
        this.append("Ref: " + regular.reference + "\n");
        string2 = regular.transferFlag ? "Yes (" + regular.transferAccount + ")" : "No";
        this.append("Transfer: " + string2 + "\n");
        if (regular.transferFlag) {
            return;
        }
        if (regular.splitFlag) {
            for (int i = 0; i < regular.ss.size(); ++i) {
                Split split = regular.ss.getSplit(i);
                this.append("Category: " + split.category + "\n");
            }
        } else {
            this.append("Category: " + regular.category);
        }
    }

    Regular update() {
        Split split;
        int n;
        Regular regular = new Regular();
        regular.description = this.tfDescription.getString();
        regular.amount = Utilities.stringToNumber(this.tfAmount.getString(), 0, this.parent.numericEntry, this.parent.isEuropeanNumberFormat);
        if (this.cgDRCR.getSelectedIndex() == 0) {
            regular.amount = -regular.amount;
        }
        regular.reference = this.tfReference.getString();
        if (this.cgTransfer.getSelectedIndex() == 0) {
            regular.transferFlag = false;
        } else {
            regular.transferFlag = true;
            if (this.cgAccount != null) {
                regular.transferAccount = this.cgAccount.getString(this.cgAccount.getSelectedIndex());
            }
        }
        if (regular.transferFlag) {
            return regular;
        }
        SplitStore splitStore = new SplitStore();
        for (n = 0; n < this.cgCategory.size(); ++n) {
            if (!this.cgCategory.isSelected(n)) continue;
            split = new Split();
            split.category = this.cgCategory.getString(n);
            splitStore.addSplit(split);
            this.cgCategory.setSelectedIndex(n, false);
        }
        if (splitStore.size() == 0) {
            splitStore = null;
            return regular;
        }
        if (splitStore.size() == 1) {
            regular.splitFlag = false;
            regular.category = splitStore.getSplit((int)0).category;
            splitStore = null;
            regular.ss = null;
        } else {
            regular.splitFlag = true;
            if (regular.ss != null) {
                for (n = 0; n < splitStore.size(); ++n) {
                    split = splitStore.getSplit(n);
                    for (int i = 0; i < regular.ss.size(); ++i) {
                        if (!split.category.equals(regular.ss.getSplit((int)i).category)) continue;
                        split.amount = regular.ss.getSplit((int)i).amount;
                        break;
                    }
                    splitStore.setSplit(split, n);
                }
            }
            regular.ss = splitStore;
        }
        return regular;
    }
}

